// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpCloudVagrant20220930BoxData BoxData is the data around the box to be downloaded, including the download
// URL, checksum information, and size if available.
//
// swagger:model hashicorp.cloud.vagrant_20220930.BoxData
type HashicorpCloudVagrant20220930BoxData struct {

	// The checksum for the box data.
	Checksum string `json:"checksum,omitempty"`

	// The algorithm type for the provided checksum.
	ChecksumType *HashicorpCloudVagrant20220930ChecksumType `json:"checksum_type,omitempty"`

	// The date the record was created.
	// Read Only: true
	// Format: date-time
	CreatedAt strfmt.DateTime `json:"created_at,omitempty"`

	// The download URL for this box data.
	DownloadURL string `json:"download_url,omitempty"`

	// The size of the box file, if available.
	// Read Only: true
	Size string `json:"size,omitempty"`

	// The date that the record was last updated.
	// Read Only: true
	// Format: date-time
	UpdatedAt strfmt.DateTime `json:"updated_at,omitempty"`
}

// Validate validates this hashicorp cloud vagrant 20220930 box data
func (m *HashicorpCloudVagrant20220930BoxData) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateChecksumType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudVagrant20220930BoxData) validateChecksumType(formats strfmt.Registry) error {
	if swag.IsZero(m.ChecksumType) { // not required
		return nil
	}

	if m.ChecksumType != nil {
		if err := m.ChecksumType.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("checksum_type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("checksum_type")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930BoxData) validateCreatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.CreatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("created_at", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930BoxData) validateUpdatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("updated_at", "body", "date-time", m.UpdatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this hashicorp cloud vagrant 20220930 box data based on the context it is used
func (m *HashicorpCloudVagrant20220930BoxData) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateChecksumType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreatedAt(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUpdatedAt(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudVagrant20220930BoxData) contextValidateChecksumType(ctx context.Context, formats strfmt.Registry) error {

	if m.ChecksumType != nil {

		if swag.IsZero(m.ChecksumType) { // not required
			return nil
		}

		if err := m.ChecksumType.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("checksum_type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("checksum_type")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930BoxData) contextValidateCreatedAt(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "created_at", "body", strfmt.DateTime(m.CreatedAt)); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930BoxData) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "size", "body", string(m.Size)); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930BoxData) contextValidateUpdatedAt(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "updated_at", "body", strfmt.DateTime(m.UpdatedAt)); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudVagrant20220930BoxData) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudVagrant20220930BoxData) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudVagrant20220930BoxData
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
