// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-packer-service/stable/2023-01-01/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// PackerServiceDeleteVersionReader is a Reader for the PackerServiceDeleteVersion structure.
type PackerServiceDeleteVersionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PackerServiceDeleteVersionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPackerServiceDeleteVersionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPackerServiceDeleteVersionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPackerServiceDeleteVersionOK creates a PackerServiceDeleteVersionOK with default headers values
func NewPackerServiceDeleteVersionOK() *PackerServiceDeleteVersionOK {
	return &PackerServiceDeleteVersionOK{}
}

/*
PackerServiceDeleteVersionOK describes a response with status code 200, with default header values.

A successful response.
*/
type PackerServiceDeleteVersionOK struct {
	Payload models.HashicorpCloudPacker20230101DeleteVersionResponse
}

// IsSuccess returns true when this packer service delete version o k response has a 2xx status code
func (o *PackerServiceDeleteVersionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this packer service delete version o k response has a 3xx status code
func (o *PackerServiceDeleteVersionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this packer service delete version o k response has a 4xx status code
func (o *PackerServiceDeleteVersionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this packer service delete version o k response has a 5xx status code
func (o *PackerServiceDeleteVersionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this packer service delete version o k response a status code equal to that given
func (o *PackerServiceDeleteVersionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the packer service delete version o k response
func (o *PackerServiceDeleteVersionOK) Code() int {
	return 200
}

func (o *PackerServiceDeleteVersionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}][%d] packerServiceDeleteVersionOK %s", 200, payload)
}

func (o *PackerServiceDeleteVersionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}][%d] packerServiceDeleteVersionOK %s", 200, payload)
}

func (o *PackerServiceDeleteVersionOK) GetPayload() models.HashicorpCloudPacker20230101DeleteVersionResponse {
	return o.Payload
}

func (o *PackerServiceDeleteVersionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPackerServiceDeleteVersionDefault creates a PackerServiceDeleteVersionDefault with default headers values
func NewPackerServiceDeleteVersionDefault(code int) *PackerServiceDeleteVersionDefault {
	return &PackerServiceDeleteVersionDefault{
		_statusCode: code,
	}
}

/*
PackerServiceDeleteVersionDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type PackerServiceDeleteVersionDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this packer service delete version default response has a 2xx status code
func (o *PackerServiceDeleteVersionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this packer service delete version default response has a 3xx status code
func (o *PackerServiceDeleteVersionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this packer service delete version default response has a 4xx status code
func (o *PackerServiceDeleteVersionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this packer service delete version default response has a 5xx status code
func (o *PackerServiceDeleteVersionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this packer service delete version default response a status code equal to that given
func (o *PackerServiceDeleteVersionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the packer service delete version default response
func (o *PackerServiceDeleteVersionDefault) Code() int {
	return o._statusCode
}

func (o *PackerServiceDeleteVersionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}][%d] PackerService_DeleteVersion default %s", o._statusCode, payload)
}

func (o *PackerServiceDeleteVersionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}][%d] PackerService_DeleteVersion default %s", o._statusCode, payload)
}

func (o *PackerServiceDeleteVersionDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *PackerServiceDeleteVersionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
