// Code generated by go-swagger; DO NOT EDIT.

package log_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-log-service/preview/2021-03-30/models"
)

// NewLogServiceStoreParams creates a new LogServiceStoreParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewLogServiceStoreParams() *LogServiceStoreParams {
	return &LogServiceStoreParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewLogServiceStoreParamsWithTimeout creates a new LogServiceStoreParams object
// with the ability to set a timeout on a request.
func NewLogServiceStoreParamsWithTimeout(timeout time.Duration) *LogServiceStoreParams {
	return &LogServiceStoreParams{
		timeout: timeout,
	}
}

// NewLogServiceStoreParamsWithContext creates a new LogServiceStoreParams object
// with the ability to set a context for a request.
func NewLogServiceStoreParamsWithContext(ctx context.Context) *LogServiceStoreParams {
	return &LogServiceStoreParams{
		Context: ctx,
	}
}

// NewLogServiceStoreParamsWithHTTPClient creates a new LogServiceStoreParams object
// with the ability to set a custom HTTPClient for a request.
func NewLogServiceStoreParamsWithHTTPClient(client *http.Client) *LogServiceStoreParams {
	return &LogServiceStoreParams{
		HTTPClient: client,
	}
}

/*
LogServiceStoreParams contains all the parameters to send to the API endpoint

	for the log service store operation.

	Typically these are written to a http.Request.
*/
type LogServiceStoreParams struct {

	// Body.
	Body *models.LogService20210330StoreRequest

	/* StreamOrganizationID.

	   organization_id is the UUID of the HCP organization this stream belongs to.
	*/
	StreamOrganizationID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the log service store params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LogServiceStoreParams) WithDefaults() *LogServiceStoreParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the log service store params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LogServiceStoreParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the log service store params
func (o *LogServiceStoreParams) WithTimeout(timeout time.Duration) *LogServiceStoreParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the log service store params
func (o *LogServiceStoreParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the log service store params
func (o *LogServiceStoreParams) WithContext(ctx context.Context) *LogServiceStoreParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the log service store params
func (o *LogServiceStoreParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the log service store params
func (o *LogServiceStoreParams) WithHTTPClient(client *http.Client) *LogServiceStoreParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the log service store params
func (o *LogServiceStoreParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the log service store params
func (o *LogServiceStoreParams) WithBody(body *models.LogService20210330StoreRequest) *LogServiceStoreParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the log service store params
func (o *LogServiceStoreParams) SetBody(body *models.LogService20210330StoreRequest) {
	o.Body = body
}

// WithStreamOrganizationID adds the streamOrganizationID to the log service store params
func (o *LogServiceStoreParams) WithStreamOrganizationID(streamOrganizationID string) *LogServiceStoreParams {
	o.SetStreamOrganizationID(streamOrganizationID)
	return o
}

// SetStreamOrganizationID adds the streamOrganizationId to the log service store params
func (o *LogServiceStoreParams) SetStreamOrganizationID(streamOrganizationID string) {
	o.StreamOrganizationID = streamOrganizationID
}

// WriteToRequest writes these params to a swagger request
func (o *LogServiceStoreParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param stream.organization_id
	if err := r.SetPathParam("stream.organization_id", o.StreamOrganizationID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
