// Code generated by go-swagger; DO NOT EDIT.

package groups_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// GroupsServiceCountOrganizationGroupsReader is a Reader for the GroupsServiceCountOrganizationGroups structure.
type GroupsServiceCountOrganizationGroupsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GroupsServiceCountOrganizationGroupsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGroupsServiceCountOrganizationGroupsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGroupsServiceCountOrganizationGroupsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGroupsServiceCountOrganizationGroupsOK creates a GroupsServiceCountOrganizationGroupsOK with default headers values
func NewGroupsServiceCountOrganizationGroupsOK() *GroupsServiceCountOrganizationGroupsOK {
	return &GroupsServiceCountOrganizationGroupsOK{}
}

/*
GroupsServiceCountOrganizationGroupsOK describes a response with status code 200, with default header values.

A successful response.
*/
type GroupsServiceCountOrganizationGroupsOK struct {
	Payload *models.HashicorpCloudIamCountOrganizationGroupsResponse
}

// IsSuccess returns true when this groups service count organization groups o k response has a 2xx status code
func (o *GroupsServiceCountOrganizationGroupsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this groups service count organization groups o k response has a 3xx status code
func (o *GroupsServiceCountOrganizationGroupsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this groups service count organization groups o k response has a 4xx status code
func (o *GroupsServiceCountOrganizationGroupsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this groups service count organization groups o k response has a 5xx status code
func (o *GroupsServiceCountOrganizationGroupsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this groups service count organization groups o k response a status code equal to that given
func (o *GroupsServiceCountOrganizationGroupsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the groups service count organization groups o k response
func (o *GroupsServiceCountOrganizationGroupsOK) Code() int {
	return 200
}

func (o *GroupsServiceCountOrganizationGroupsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/iam/{parent_resource_name}/groups/count][%d] groupsServiceCountOrganizationGroupsOK %s", 200, payload)
}

func (o *GroupsServiceCountOrganizationGroupsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/iam/{parent_resource_name}/groups/count][%d] groupsServiceCountOrganizationGroupsOK %s", 200, payload)
}

func (o *GroupsServiceCountOrganizationGroupsOK) GetPayload() *models.HashicorpCloudIamCountOrganizationGroupsResponse {
	return o.Payload
}

func (o *GroupsServiceCountOrganizationGroupsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudIamCountOrganizationGroupsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGroupsServiceCountOrganizationGroupsDefault creates a GroupsServiceCountOrganizationGroupsDefault with default headers values
func NewGroupsServiceCountOrganizationGroupsDefault(code int) *GroupsServiceCountOrganizationGroupsDefault {
	return &GroupsServiceCountOrganizationGroupsDefault{
		_statusCode: code,
	}
}

/*
GroupsServiceCountOrganizationGroupsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GroupsServiceCountOrganizationGroupsDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this groups service count organization groups default response has a 2xx status code
func (o *GroupsServiceCountOrganizationGroupsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this groups service count organization groups default response has a 3xx status code
func (o *GroupsServiceCountOrganizationGroupsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this groups service count organization groups default response has a 4xx status code
func (o *GroupsServiceCountOrganizationGroupsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this groups service count organization groups default response has a 5xx status code
func (o *GroupsServiceCountOrganizationGroupsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this groups service count organization groups default response a status code equal to that given
func (o *GroupsServiceCountOrganizationGroupsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the groups service count organization groups default response
func (o *GroupsServiceCountOrganizationGroupsDefault) Code() int {
	return o._statusCode
}

func (o *GroupsServiceCountOrganizationGroupsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/iam/{parent_resource_name}/groups/count][%d] GroupsService_CountOrganizationGroups default %s", o._statusCode, payload)
}

func (o *GroupsServiceCountOrganizationGroupsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/iam/{parent_resource_name}/groups/count][%d] GroupsService_CountOrganizationGroups default %s", o._statusCode, payload)
}

func (o *GroupsServiceCountOrganizationGroupsDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *GroupsServiceCountOrganizationGroupsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
