// Code generated by go-swagger; DO NOT EDIT.

package groups_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// GroupsServiceCountMembersForGroupsReader is a Reader for the GroupsServiceCountMembersForGroups structure.
type GroupsServiceCountMembersForGroupsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GroupsServiceCountMembersForGroupsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGroupsServiceCountMembersForGroupsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGroupsServiceCountMembersForGroupsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGroupsServiceCountMembersForGroupsOK creates a GroupsServiceCountMembersForGroupsOK with default headers values
func NewGroupsServiceCountMembersForGroupsOK() *GroupsServiceCountMembersForGroupsOK {
	return &GroupsServiceCountMembersForGroupsOK{}
}

/*
GroupsServiceCountMembersForGroupsOK describes a response with status code 200, with default header values.

A successful response.
*/
type GroupsServiceCountMembersForGroupsOK struct {
	Payload *models.HashicorpCloudIamCountMembersForGroupsResponse
}

// IsSuccess returns true when this groups service count members for groups o k response has a 2xx status code
func (o *GroupsServiceCountMembersForGroupsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this groups service count members for groups o k response has a 3xx status code
func (o *GroupsServiceCountMembersForGroupsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this groups service count members for groups o k response has a 4xx status code
func (o *GroupsServiceCountMembersForGroupsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this groups service count members for groups o k response has a 5xx status code
func (o *GroupsServiceCountMembersForGroupsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this groups service count members for groups o k response a status code equal to that given
func (o *GroupsServiceCountMembersForGroupsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the groups service count members for groups o k response
func (o *GroupsServiceCountMembersForGroupsOK) Code() int {
	return 200
}

func (o *GroupsServiceCountMembersForGroupsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/iam/{parent_resource_name}/groups/count-members-for-groups][%d] groupsServiceCountMembersForGroupsOK %s", 200, payload)
}

func (o *GroupsServiceCountMembersForGroupsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/iam/{parent_resource_name}/groups/count-members-for-groups][%d] groupsServiceCountMembersForGroupsOK %s", 200, payload)
}

func (o *GroupsServiceCountMembersForGroupsOK) GetPayload() *models.HashicorpCloudIamCountMembersForGroupsResponse {
	return o.Payload
}

func (o *GroupsServiceCountMembersForGroupsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudIamCountMembersForGroupsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGroupsServiceCountMembersForGroupsDefault creates a GroupsServiceCountMembersForGroupsDefault with default headers values
func NewGroupsServiceCountMembersForGroupsDefault(code int) *GroupsServiceCountMembersForGroupsDefault {
	return &GroupsServiceCountMembersForGroupsDefault{
		_statusCode: code,
	}
}

/*
GroupsServiceCountMembersForGroupsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GroupsServiceCountMembersForGroupsDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this groups service count members for groups default response has a 2xx status code
func (o *GroupsServiceCountMembersForGroupsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this groups service count members for groups default response has a 3xx status code
func (o *GroupsServiceCountMembersForGroupsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this groups service count members for groups default response has a 4xx status code
func (o *GroupsServiceCountMembersForGroupsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this groups service count members for groups default response has a 5xx status code
func (o *GroupsServiceCountMembersForGroupsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this groups service count members for groups default response a status code equal to that given
func (o *GroupsServiceCountMembersForGroupsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the groups service count members for groups default response
func (o *GroupsServiceCountMembersForGroupsDefault) Code() int {
	return o._statusCode
}

func (o *GroupsServiceCountMembersForGroupsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/iam/{parent_resource_name}/groups/count-members-for-groups][%d] GroupsService_CountMembersForGroups default %s", o._statusCode, payload)
}

func (o *GroupsServiceCountMembersForGroupsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/iam/{parent_resource_name}/groups/count-members-for-groups][%d] GroupsService_CountMembersForGroups default %s", o._statusCode, payload)
}

func (o *GroupsServiceCountMembersForGroupsDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *GroupsServiceCountMembersForGroupsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
