// Code generated by go-swagger; DO NOT EDIT.

package boundary_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-boundary-service/stable/2021-12-21/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// BoundaryServiceMaintenanceWindowGetReader is a Reader for the BoundaryServiceMaintenanceWindowGet structure.
type BoundaryServiceMaintenanceWindowGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *BoundaryServiceMaintenanceWindowGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewBoundaryServiceMaintenanceWindowGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewBoundaryServiceMaintenanceWindowGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewBoundaryServiceMaintenanceWindowGetOK creates a BoundaryServiceMaintenanceWindowGetOK with default headers values
func NewBoundaryServiceMaintenanceWindowGetOK() *BoundaryServiceMaintenanceWindowGetOK {
	return &BoundaryServiceMaintenanceWindowGetOK{}
}

/*
BoundaryServiceMaintenanceWindowGetOK describes a response with status code 200, with default header values.

A successful response.
*/
type BoundaryServiceMaintenanceWindowGetOK struct {
	Payload *models.HashicorpCloudBoundary20211221MaintenanceWindowGetResponse
}

// IsSuccess returns true when this boundary service maintenance window get o k response has a 2xx status code
func (o *BoundaryServiceMaintenanceWindowGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this boundary service maintenance window get o k response has a 3xx status code
func (o *BoundaryServiceMaintenanceWindowGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this boundary service maintenance window get o k response has a 4xx status code
func (o *BoundaryServiceMaintenanceWindowGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this boundary service maintenance window get o k response has a 5xx status code
func (o *BoundaryServiceMaintenanceWindowGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this boundary service maintenance window get o k response a status code equal to that given
func (o *BoundaryServiceMaintenanceWindowGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the boundary service maintenance window get o k response
func (o *BoundaryServiceMaintenanceWindowGetOK) Code() int {
	return 200
}

func (o *BoundaryServiceMaintenanceWindowGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/maintenance-window][%d] boundaryServiceMaintenanceWindowGetOK %s", 200, payload)
}

func (o *BoundaryServiceMaintenanceWindowGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/maintenance-window][%d] boundaryServiceMaintenanceWindowGetOK %s", 200, payload)
}

func (o *BoundaryServiceMaintenanceWindowGetOK) GetPayload() *models.HashicorpCloudBoundary20211221MaintenanceWindowGetResponse {
	return o.Payload
}

func (o *BoundaryServiceMaintenanceWindowGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudBoundary20211221MaintenanceWindowGetResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBoundaryServiceMaintenanceWindowGetDefault creates a BoundaryServiceMaintenanceWindowGetDefault with default headers values
func NewBoundaryServiceMaintenanceWindowGetDefault(code int) *BoundaryServiceMaintenanceWindowGetDefault {
	return &BoundaryServiceMaintenanceWindowGetDefault{
		_statusCode: code,
	}
}

/*
BoundaryServiceMaintenanceWindowGetDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type BoundaryServiceMaintenanceWindowGetDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// IsSuccess returns true when this boundary service maintenance window get default response has a 2xx status code
func (o *BoundaryServiceMaintenanceWindowGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this boundary service maintenance window get default response has a 3xx status code
func (o *BoundaryServiceMaintenanceWindowGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this boundary service maintenance window get default response has a 4xx status code
func (o *BoundaryServiceMaintenanceWindowGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this boundary service maintenance window get default response has a 5xx status code
func (o *BoundaryServiceMaintenanceWindowGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this boundary service maintenance window get default response a status code equal to that given
func (o *BoundaryServiceMaintenanceWindowGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the boundary service maintenance window get default response
func (o *BoundaryServiceMaintenanceWindowGetDefault) Code() int {
	return o._statusCode
}

func (o *BoundaryServiceMaintenanceWindowGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/maintenance-window][%d] BoundaryService_MaintenanceWindowGet default %s", o._statusCode, payload)
}

func (o *BoundaryServiceMaintenanceWindowGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/maintenance-window][%d] BoundaryService_MaintenanceWindowGet default %s", o._statusCode, payload)
}

func (o *BoundaryServiceMaintenanceWindowGetDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *BoundaryServiceMaintenanceWindowGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
