// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Billing20201105Statement Statement describes the usage that accrued during a specific billing period
//
// swagger:model billing_20201105Statement
type Billing20201105Statement struct {

	// billing_period_end is the end time of the period that was considered for
	// this usage calculation.
	// Format: date-time
	BillingPeriodEnd strfmt.DateTime `json:"billing_period_end,omitempty"`

	// billing_period_start is the start time of the period that was considered
	// for this usage calculation.
	// Format: date-time
	BillingPeriodStart strfmt.DateTime `json:"billing_period_start,omitempty"`

	// id is the id associated with the statement.
	ID string `json:"id,omitempty"`

	// last_updated_at is the last time this statement gets updated.
	// This shows the last usage time that is included in this statement.
	// Format: date-time
	LastUpdatedAt strfmt.DateTime `json:"last_updated_at,omitempty"`

	// non_usage_charges has information about each resource that is part of the statement but non usage charge type.
	NonUsageCharges []*Billing20201105StatementResource `json:"non_usage_charges"`

	// resources has information about each resource that is part of the statement.
	Resources []*Billing20201105StatementResource `json:"resources"`

	// state indicates the life cycle step that the Statement is currently in.
	State *Billing20201105StatementState `json:"state,omitempty"`

	// statement_metadata contains metadata for the statement.
	StatementMetadata *StatementStatementMetadata `json:"statement_metadata,omitempty"`

	// total is the cost produced within this billing period minus any
	// discount that is granted because of a positive account balance. This
	// should be considered an estimate because not all information required to
	// issue an invoice might have been taken into consideration (e.g. billing
	// address country and tax might not be reflected in this value).
	Total string `json:"total,omitempty"`
}

// Validate validates this billing 20201105 statement
func (m *Billing20201105Statement) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBillingPeriodEnd(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBillingPeriodStart(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastUpdatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNonUsageCharges(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateResources(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatementMetadata(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Billing20201105Statement) validateBillingPeriodEnd(formats strfmt.Registry) error {
	if swag.IsZero(m.BillingPeriodEnd) { // not required
		return nil
	}

	if err := validate.FormatOf("billing_period_end", "body", "date-time", m.BillingPeriodEnd.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Billing20201105Statement) validateBillingPeriodStart(formats strfmt.Registry) error {
	if swag.IsZero(m.BillingPeriodStart) { // not required
		return nil
	}

	if err := validate.FormatOf("billing_period_start", "body", "date-time", m.BillingPeriodStart.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Billing20201105Statement) validateLastUpdatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.LastUpdatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("last_updated_at", "body", "date-time", m.LastUpdatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Billing20201105Statement) validateNonUsageCharges(formats strfmt.Registry) error {
	if swag.IsZero(m.NonUsageCharges) { // not required
		return nil
	}

	for i := 0; i < len(m.NonUsageCharges); i++ {
		if swag.IsZero(m.NonUsageCharges[i]) { // not required
			continue
		}

		if m.NonUsageCharges[i] != nil {
			if err := m.NonUsageCharges[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("non_usage_charges" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("non_usage_charges" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Billing20201105Statement) validateResources(formats strfmt.Registry) error {
	if swag.IsZero(m.Resources) { // not required
		return nil
	}

	for i := 0; i < len(m.Resources); i++ {
		if swag.IsZero(m.Resources[i]) { // not required
			continue
		}

		if m.Resources[i] != nil {
			if err := m.Resources[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("resources" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("resources" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Billing20201105Statement) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	if m.State != nil {
		if err := m.State.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

func (m *Billing20201105Statement) validateStatementMetadata(formats strfmt.Registry) error {
	if swag.IsZero(m.StatementMetadata) { // not required
		return nil
	}

	if m.StatementMetadata != nil {
		if err := m.StatementMetadata.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statement_metadata")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("statement_metadata")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this billing 20201105 statement based on the context it is used
func (m *Billing20201105Statement) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNonUsageCharges(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateResources(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatementMetadata(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Billing20201105Statement) contextValidateNonUsageCharges(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.NonUsageCharges); i++ {

		if m.NonUsageCharges[i] != nil {

			if swag.IsZero(m.NonUsageCharges[i]) { // not required
				return nil
			}

			if err := m.NonUsageCharges[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("non_usage_charges" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("non_usage_charges" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Billing20201105Statement) contextValidateResources(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Resources); i++ {

		if m.Resources[i] != nil {

			if swag.IsZero(m.Resources[i]) { // not required
				return nil
			}

			if err := m.Resources[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("resources" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("resources" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Billing20201105Statement) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if m.State != nil {

		if swag.IsZero(m.State) { // not required
			return nil
		}

		if err := m.State.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

func (m *Billing20201105Statement) contextValidateStatementMetadata(ctx context.Context, formats strfmt.Registry) error {

	if m.StatementMetadata != nil {

		if swag.IsZero(m.StatementMetadata) { // not required
			return nil
		}

		if err := m.StatementMetadata.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statement_metadata")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("statement_metadata")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Billing20201105Statement) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Billing20201105Statement) UnmarshalBinary(b []byte) error {
	var res Billing20201105Statement
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
