// Code generated by go-swagger; DO NOT EDIT.

package statement_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new statement service API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for statement service API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	StatementServiceGetRunningStatement(params *StatementServiceGetRunningStatementParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StatementServiceGetRunningStatementOK, error)

	StatementServiceGetStatement(params *StatementServiceGetStatementParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StatementServiceGetStatementOK, error)

	StatementServiceGetStatementCSV(params *StatementServiceGetStatementCSVParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StatementServiceGetStatementCSVOK, error)

	StatementServiceListStatements(params *StatementServiceListStatementsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StatementServiceListStatementsOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
StatementServiceGetRunningStatement gets running statement returns a billing account s running statement
*/
func (a *Client) StatementServiceGetRunningStatement(params *StatementServiceGetRunningStatementParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StatementServiceGetRunningStatementOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStatementServiceGetRunningStatementParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "StatementService_GetRunningStatement",
		Method:             "GET",
		PathPattern:        "/billing/2020-11-05/organizations/{organization_id}/accounts/{billing_account_id}/running-statement",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &StatementServiceGetRunningStatementReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StatementServiceGetRunningStatementOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StatementServiceGetRunningStatementDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
StatementServiceGetStatement gets statement returns a billing account s monthly statement by ID
*/
func (a *Client) StatementServiceGetStatement(params *StatementServiceGetStatementParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StatementServiceGetStatementOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStatementServiceGetStatementParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "StatementService_GetStatement",
		Method:             "GET",
		PathPattern:        "/billing/2020-11-05/organizations/{organization_id}/accounts/{billing_account_id}/statements/{statement_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &StatementServiceGetStatementReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StatementServiceGetStatementOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StatementServiceGetStatementDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
StatementServiceGetStatementCSV statement service get statement c s v API
*/
func (a *Client) StatementServiceGetStatementCSV(params *StatementServiceGetStatementCSVParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StatementServiceGetStatementCSVOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStatementServiceGetStatementCSVParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "StatementService_GetStatementCSV",
		Method:             "GET",
		PathPattern:        "/billing/2020-11-05/organizations/{organization_id}/accounts/{billing_account_id}/statements/{statement_id}/csv",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &StatementServiceGetStatementCSVReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StatementServiceGetStatementCSVOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StatementServiceGetStatementCSVDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
StatementServiceListStatements lists statements returns a billing account s current and historical monthly statements
*/
func (a *Client) StatementServiceListStatements(params *StatementServiceListStatementsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StatementServiceListStatementsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStatementServiceListStatementsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "StatementService_ListStatements",
		Method:             "GET",
		PathPattern:        "/billing/2020-11-05/organizations/{organization_id}/accounts/{billing_account_id}/statements",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &StatementServiceListStatementsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StatementServiceListStatementsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StatementServiceListStatementsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
