// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// NewUpdateGcpIntegrationParams creates a new UpdateGcpIntegrationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdateGcpIntegrationParams() *UpdateGcpIntegrationParams {
	return &UpdateGcpIntegrationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateGcpIntegrationParamsWithTimeout creates a new UpdateGcpIntegrationParams object
// with the ability to set a timeout on a request.
func NewUpdateGcpIntegrationParamsWithTimeout(timeout time.Duration) *UpdateGcpIntegrationParams {
	return &UpdateGcpIntegrationParams{
		timeout: timeout,
	}
}

// NewUpdateGcpIntegrationParamsWithContext creates a new UpdateGcpIntegrationParams object
// with the ability to set a context for a request.
func NewUpdateGcpIntegrationParamsWithContext(ctx context.Context) *UpdateGcpIntegrationParams {
	return &UpdateGcpIntegrationParams{
		Context: ctx,
	}
}

// NewUpdateGcpIntegrationParamsWithHTTPClient creates a new UpdateGcpIntegrationParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpdateGcpIntegrationParamsWithHTTPClient(client *http.Client) *UpdateGcpIntegrationParams {
	return &UpdateGcpIntegrationParams{
		HTTPClient: client,
	}
}

/*
UpdateGcpIntegrationParams contains all the parameters to send to the API endpoint

	for the update gcp integration operation.

	Typically these are written to a http.Request.
*/
type UpdateGcpIntegrationParams struct {

	// Body.
	Body *models.SecretServiceUpdateGcpIntegrationBody

	// Name.
	Name string

	// OrganizationID.
	OrganizationID string

	// ProjectID.
	ProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update gcp integration params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateGcpIntegrationParams) WithDefaults() *UpdateGcpIntegrationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update gcp integration params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateGcpIntegrationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update gcp integration params
func (o *UpdateGcpIntegrationParams) WithTimeout(timeout time.Duration) *UpdateGcpIntegrationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update gcp integration params
func (o *UpdateGcpIntegrationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update gcp integration params
func (o *UpdateGcpIntegrationParams) WithContext(ctx context.Context) *UpdateGcpIntegrationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update gcp integration params
func (o *UpdateGcpIntegrationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update gcp integration params
func (o *UpdateGcpIntegrationParams) WithHTTPClient(client *http.Client) *UpdateGcpIntegrationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update gcp integration params
func (o *UpdateGcpIntegrationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the update gcp integration params
func (o *UpdateGcpIntegrationParams) WithBody(body *models.SecretServiceUpdateGcpIntegrationBody) *UpdateGcpIntegrationParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the update gcp integration params
func (o *UpdateGcpIntegrationParams) SetBody(body *models.SecretServiceUpdateGcpIntegrationBody) {
	o.Body = body
}

// WithName adds the name to the update gcp integration params
func (o *UpdateGcpIntegrationParams) WithName(name string) *UpdateGcpIntegrationParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the update gcp integration params
func (o *UpdateGcpIntegrationParams) SetName(name string) {
	o.Name = name
}

// WithOrganizationID adds the organizationID to the update gcp integration params
func (o *UpdateGcpIntegrationParams) WithOrganizationID(organizationID string) *UpdateGcpIntegrationParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the update gcp integration params
func (o *UpdateGcpIntegrationParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WithProjectID adds the projectID to the update gcp integration params
func (o *UpdateGcpIntegrationParams) WithProjectID(projectID string) *UpdateGcpIntegrationParams {
	o.SetProjectID(projectID)
	return o
}

// SetProjectID adds the projectId to the update gcp integration params
func (o *UpdateGcpIntegrationParams) SetProjectID(projectID string) {
	o.ProjectID = projectID
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateGcpIntegrationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	// path param project_id
	if err := r.SetPathParam("project_id", o.ProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
