// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// GetRotatingSecretStateReader is a Reader for the GetRotatingSecretState structure.
type GetRotatingSecretStateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetRotatingSecretStateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetRotatingSecretStateOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetRotatingSecretStateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetRotatingSecretStateOK creates a GetRotatingSecretStateOK with default headers values
func NewGetRotatingSecretStateOK() *GetRotatingSecretStateOK {
	return &GetRotatingSecretStateOK{}
}

/*
GetRotatingSecretStateOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetRotatingSecretStateOK struct {
	Payload *models.Secrets20231128GetRotatingSecretStateResponse
}

// IsSuccess returns true when this get rotating secret state o k response has a 2xx status code
func (o *GetRotatingSecretStateOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get rotating secret state o k response has a 3xx status code
func (o *GetRotatingSecretStateOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get rotating secret state o k response has a 4xx status code
func (o *GetRotatingSecretStateOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get rotating secret state o k response has a 5xx status code
func (o *GetRotatingSecretStateOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get rotating secret state o k response a status code equal to that given
func (o *GetRotatingSecretStateOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get rotating secret state o k response
func (o *GetRotatingSecretStateOK) Code() int {
	return 200
}

func (o *GetRotatingSecretStateOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/{name}/rotation-state][%d] getRotatingSecretStateOK %s", 200, payload)
}

func (o *GetRotatingSecretStateOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/{name}/rotation-state][%d] getRotatingSecretStateOK %s", 200, payload)
}

func (o *GetRotatingSecretStateOK) GetPayload() *models.Secrets20231128GetRotatingSecretStateResponse {
	return o.Payload
}

func (o *GetRotatingSecretStateOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128GetRotatingSecretStateResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetRotatingSecretStateDefault creates a GetRotatingSecretStateDefault with default headers values
func NewGetRotatingSecretStateDefault(code int) *GetRotatingSecretStateDefault {
	return &GetRotatingSecretStateDefault{
		_statusCode: code,
	}
}

/*
GetRotatingSecretStateDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetRotatingSecretStateDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this get rotating secret state default response has a 2xx status code
func (o *GetRotatingSecretStateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get rotating secret state default response has a 3xx status code
func (o *GetRotatingSecretStateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get rotating secret state default response has a 4xx status code
func (o *GetRotatingSecretStateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get rotating secret state default response has a 5xx status code
func (o *GetRotatingSecretStateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get rotating secret state default response a status code equal to that given
func (o *GetRotatingSecretStateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get rotating secret state default response
func (o *GetRotatingSecretStateDefault) Code() int {
	return o._statusCode
}

func (o *GetRotatingSecretStateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/{name}/rotation-state][%d] GetRotatingSecretState default %s", o._statusCode, payload)
}

func (o *GetRotatingSecretStateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/{name}/rotation-state][%d] GetRotatingSecretState default %s", o._statusCode, payload)
}

func (o *GetRotatingSecretStateDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *GetRotatingSecretStateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
