// Code generated by go-swagger; DO NOT EDIT.

package integration_subscription_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new integration subscription service API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for integration subscription service API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	CreateIntegrationSubscription(params *CreateIntegrationSubscriptionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateIntegrationSubscriptionOK, error)

	DeleteIntegrationSubscription(params *DeleteIntegrationSubscriptionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteIntegrationSubscriptionOK, error)

	GetIntegrationSubscriptionByID(params *GetIntegrationSubscriptionByIDParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetIntegrationSubscriptionByIDOK, error)

	GetIntegrationSubscriptionByName(params *GetIntegrationSubscriptionByNameParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetIntegrationSubscriptionByNameOK, error)

	UpdateIntegrationSubscription(params *UpdateIntegrationSubscriptionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateIntegrationSubscriptionOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
CreateIntegrationSubscription create integration subscription API
*/
func (a *Client) CreateIntegrationSubscription(params *CreateIntegrationSubscriptionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateIntegrationSubscriptionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateIntegrationSubscriptionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateIntegrationSubscription",
		Method:             "POST",
		PathPattern:        "/2023-05-01/vault-radar/projects/{location.project_id}/integrations/subscriptions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateIntegrationSubscriptionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateIntegrationSubscriptionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateIntegrationSubscriptionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DeleteIntegrationSubscription delete integration subscription API
*/
func (a *Client) DeleteIntegrationSubscription(params *DeleteIntegrationSubscriptionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteIntegrationSubscriptionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteIntegrationSubscriptionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteIntegrationSubscription",
		Method:             "DELETE",
		PathPattern:        "/2023-05-01/vault-radar/projects/{location.project_id}/integrations/subscriptions/{id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &DeleteIntegrationSubscriptionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteIntegrationSubscriptionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DeleteIntegrationSubscriptionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetIntegrationSubscriptionByID get integration subscription by ID API
*/
func (a *Client) GetIntegrationSubscriptionByID(params *GetIntegrationSubscriptionByIDParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetIntegrationSubscriptionByIDOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetIntegrationSubscriptionByIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetIntegrationSubscriptionByID",
		Method:             "GET",
		PathPattern:        "/2023-05-01/vault-radar/projects/{location.project_id}/integrations/subscriptions/{id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetIntegrationSubscriptionByIDReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetIntegrationSubscriptionByIDOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetIntegrationSubscriptionByIDDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetIntegrationSubscriptionByName get integration subscription by name API
*/
func (a *Client) GetIntegrationSubscriptionByName(params *GetIntegrationSubscriptionByNameParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetIntegrationSubscriptionByNameOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetIntegrationSubscriptionByNameParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetIntegrationSubscriptionByName",
		Method:             "POST",
		PathPattern:        "/2023-05-01/vault-radar/projects/{location.project_id}/integrations/subscriptions/search-by-name",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetIntegrationSubscriptionByNameReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetIntegrationSubscriptionByNameOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetIntegrationSubscriptionByNameDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UpdateIntegrationSubscription update integration subscription API
*/
func (a *Client) UpdateIntegrationSubscription(params *UpdateIntegrationSubscriptionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateIntegrationSubscriptionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateIntegrationSubscriptionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateIntegrationSubscription",
		Method:             "PUT",
		PathPattern:        "/2023-05-01/vault-radar/projects/{location.project_id}/integrations/subscriptions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UpdateIntegrationSubscriptionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateIntegrationSubscriptionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdateIntegrationSubscriptionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
