// Code generated by go-swagger; DO NOT EDIT.

package data_source_registration_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewOffboardDataSourceParams creates a new OffboardDataSourceParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewOffboardDataSourceParams() *OffboardDataSourceParams {
	return &OffboardDataSourceParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewOffboardDataSourceParamsWithTimeout creates a new OffboardDataSourceParams object
// with the ability to set a timeout on a request.
func NewOffboardDataSourceParamsWithTimeout(timeout time.Duration) *OffboardDataSourceParams {
	return &OffboardDataSourceParams{
		timeout: timeout,
	}
}

// NewOffboardDataSourceParamsWithContext creates a new OffboardDataSourceParams object
// with the ability to set a context for a request.
func NewOffboardDataSourceParamsWithContext(ctx context.Context) *OffboardDataSourceParams {
	return &OffboardDataSourceParams{
		Context: ctx,
	}
}

// NewOffboardDataSourceParamsWithHTTPClient creates a new OffboardDataSourceParams object
// with the ability to set a custom HTTPClient for a request.
func NewOffboardDataSourceParamsWithHTTPClient(client *http.Client) *OffboardDataSourceParams {
	return &OffboardDataSourceParams{
		HTTPClient: client,
	}
}

/*
OffboardDataSourceParams contains all the parameters to send to the API endpoint

	for the offboard data source operation.

	Typically these are written to a http.Request.
*/
type OffboardDataSourceParams struct {

	// Body.
	Body OffboardDataSourceBody

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the offboard data source params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *OffboardDataSourceParams) WithDefaults() *OffboardDataSourceParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the offboard data source params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *OffboardDataSourceParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the offboard data source params
func (o *OffboardDataSourceParams) WithTimeout(timeout time.Duration) *OffboardDataSourceParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the offboard data source params
func (o *OffboardDataSourceParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the offboard data source params
func (o *OffboardDataSourceParams) WithContext(ctx context.Context) *OffboardDataSourceParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the offboard data source params
func (o *OffboardDataSourceParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the offboard data source params
func (o *OffboardDataSourceParams) WithHTTPClient(client *http.Client) *OffboardDataSourceParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the offboard data source params
func (o *OffboardDataSourceParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the offboard data source params
func (o *OffboardDataSourceParams) WithBody(body OffboardDataSourceBody) *OffboardDataSourceParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the offboard data source params
func (o *OffboardDataSourceParams) SetBody(body OffboardDataSourceBody) {
	o.Body = body
}

// WithLocationProjectID adds the locationProjectID to the offboard data source params
func (o *OffboardDataSourceParams) WithLocationProjectID(locationProjectID string) *OffboardDataSourceParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the offboard data source params
func (o *OffboardDataSourceParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *OffboardDataSourceParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if err := r.SetBodyParam(o.Body); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
