// Code generated by go-swagger; DO NOT EDIT.

package vault_link_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-link-service/preview/2022-11-07/models"
)

// EnableDRReader is a Reader for the EnableDR structure.
type EnableDRReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *EnableDRReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewEnableDROK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewEnableDRDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewEnableDROK creates a EnableDROK with default headers values
func NewEnableDROK() *EnableDROK {
	return &EnableDROK{}
}

/*
EnableDROK describes a response with status code 200, with default header values.

A successful response.
*/
type EnableDROK struct {
	Payload models.HashicorpCloudVaultLink20221107APIResponse
}

// IsSuccess returns true when this enable d r o k response has a 2xx status code
func (o *EnableDROK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this enable d r o k response has a 3xx status code
func (o *EnableDROK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this enable d r o k response has a 4xx status code
func (o *EnableDROK) IsClientError() bool {
	return false
}

// IsServerError returns true when this enable d r o k response has a 5xx status code
func (o *EnableDROK) IsServerError() bool {
	return false
}

// IsCode returns true when this enable d r o k response a status code equal to that given
func (o *EnableDROK) IsCode(code int) bool {
	return code == 200
}

func (o *EnableDROK) Error() string {
	return fmt.Sprintf("[POST /vault-link/2022-11-07/organizations/{location.organization_id}/projects/{location.project_id}/{cluster_id}/enable-dr][%d] enableDROK  %+v", 200, o.Payload)
}

func (o *EnableDROK) String() string {
	return fmt.Sprintf("[POST /vault-link/2022-11-07/organizations/{location.organization_id}/projects/{location.project_id}/{cluster_id}/enable-dr][%d] enableDROK  %+v", 200, o.Payload)
}

func (o *EnableDROK) GetPayload() models.HashicorpCloudVaultLink20221107APIResponse {
	return o.Payload
}

func (o *EnableDROK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewEnableDRDefault creates a EnableDRDefault with default headers values
func NewEnableDRDefault(code int) *EnableDRDefault {
	return &EnableDRDefault{
		_statusCode: code,
	}
}

/*
EnableDRDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type EnableDRDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// Code gets the status code for the enable d r default response
func (o *EnableDRDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this enable d r default response has a 2xx status code
func (o *EnableDRDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this enable d r default response has a 3xx status code
func (o *EnableDRDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this enable d r default response has a 4xx status code
func (o *EnableDRDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this enable d r default response has a 5xx status code
func (o *EnableDRDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this enable d r default response a status code equal to that given
func (o *EnableDRDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *EnableDRDefault) Error() string {
	return fmt.Sprintf("[POST /vault-link/2022-11-07/organizations/{location.organization_id}/projects/{location.project_id}/{cluster_id}/enable-dr][%d] EnableDR default  %+v", o._statusCode, o.Payload)
}

func (o *EnableDRDefault) String() string {
	return fmt.Sprintf("[POST /vault-link/2022-11-07/organizations/{location.organization_id}/projects/{location.project_id}/{cluster_id}/enable-dr][%d] EnableDR default  %+v", o._statusCode, o.Payload)
}

func (o *EnableDRDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *EnableDRDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
EnableDRBody enable d r body
swagger:model EnableDRBody
*/
type EnableDRBody struct {

	// location
	Location *EnableDRParamsBodyLocation `json:"location,omitempty"`
}

// Validate validates this enable d r body
func (o *EnableDRBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EnableDRBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this enable d r body based on the context it is used
func (o *EnableDRBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EnableDRBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {
		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EnableDRBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EnableDRBody) UnmarshalBinary(b []byte) error {
	var res EnableDRBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EnableDRParamsBodyLocation Location represents a target for an operation in HCP.
swagger:model EnableDRParamsBodyLocation
*/
type EnableDRParamsBodyLocation struct {

	// region is the region that the resource is located in. It is
	// optional if the object being referenced is a global object.
	Region *cloud.HashicorpCloudLocationRegion `json:"region,omitempty"`
}

// Validate validates this enable d r params body location
func (o *EnableDRParamsBodyLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EnableDRParamsBodyLocation) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(o.Region) { // not required
		return nil
	}

	if o.Region != nil {
		if err := o.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this enable d r params body location based on the context it is used
func (o *EnableDRParamsBodyLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EnableDRParamsBodyLocation) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if o.Region != nil {
		if err := o.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EnableDRParamsBodyLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EnableDRParamsBodyLocation) UnmarshalBinary(b []byte) error {
	var res EnableDRParamsBodyLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
