// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSearchParams creates a new SearchParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSearchParams() *SearchParams {
	return &SearchParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSearchParamsWithTimeout creates a new SearchParams object
// with the ability to set a timeout on a request.
func NewSearchParamsWithTimeout(timeout time.Duration) *SearchParams {
	return &SearchParams{
		timeout: timeout,
	}
}

// NewSearchParamsWithContext creates a new SearchParams object
// with the ability to set a context for a request.
func NewSearchParamsWithContext(ctx context.Context) *SearchParams {
	return &SearchParams{
		Context: ctx,
	}
}

// NewSearchParamsWithHTTPClient creates a new SearchParams object
// with the ability to set a custom HTTPClient for a request.
func NewSearchParamsWithHTTPClient(client *http.Client) *SearchParams {
	return &SearchParams{
		HTTPClient: client,
	}
}

/*
SearchParams contains all the parameters to send to the API endpoint

	for the search operation.

	Typically these are written to a http.Request.
*/
type SearchParams struct {

	/* Architectures.

	   Architecture to filter by, if provided.
	*/
	Architectures []string

	/* PaginationNextPageToken.

	     Specifies a page token to use to retrieve the next page. Set this to the
	`next_page_token` returned by previous list requests to get the next page of
	results. If set, `previous_page_token` must not be set.
	*/
	PaginationNextPageToken *string

	/* PaginationPageSize.

	     The max number of results per page that should be returned. If the number
	of available results is larger than `page_size`, a `next_page_token` is
	returned which can be used to get the next page of results in subsequent
	requests. A value of zero will cause `page_size` to be defaulted.

	     Format: int64
	*/
	PaginationPageSize *int64

	/* PaginationPreviousPageToken.

	     Specifies a page token to use to retrieve the previous page. Set this to
	the `previous_page_token` returned by previous list requests to get the
	previous page of results. If set, `next_page_token` must not be set.
	*/
	PaginationPreviousPageToken *string

	/* Providers.

	   Provider to filter by, if provided.
	*/
	Providers []string

	/* Q.

	   The terms to search by.
	*/
	Q *string

	/* SortOrderBy.

	     Specifies the list of per field ordering that should be used for sorting.
	The order matters as rows are sorted in order by fields and when the field
	matches, the next field is used to tie break the ordering.
	The per field default ordering is ascending.

	The fields should be immutabile, unique, and orderable. If the field is
	not unique, more than one sort fields should be passed.

	Example: oder_by=name,age desc,created_at asc
	In that case, 'name' will get the default 'ascending' order.
	*/
	SortOrderBy []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the search params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SearchParams) WithDefaults() *SearchParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the search params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SearchParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the search params
func (o *SearchParams) WithTimeout(timeout time.Duration) *SearchParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the search params
func (o *SearchParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the search params
func (o *SearchParams) WithContext(ctx context.Context) *SearchParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the search params
func (o *SearchParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the search params
func (o *SearchParams) WithHTTPClient(client *http.Client) *SearchParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the search params
func (o *SearchParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithArchitectures adds the architectures to the search params
func (o *SearchParams) WithArchitectures(architectures []string) *SearchParams {
	o.SetArchitectures(architectures)
	return o
}

// SetArchitectures adds the architectures to the search params
func (o *SearchParams) SetArchitectures(architectures []string) {
	o.Architectures = architectures
}

// WithPaginationNextPageToken adds the paginationNextPageToken to the search params
func (o *SearchParams) WithPaginationNextPageToken(paginationNextPageToken *string) *SearchParams {
	o.SetPaginationNextPageToken(paginationNextPageToken)
	return o
}

// SetPaginationNextPageToken adds the paginationNextPageToken to the search params
func (o *SearchParams) SetPaginationNextPageToken(paginationNextPageToken *string) {
	o.PaginationNextPageToken = paginationNextPageToken
}

// WithPaginationPageSize adds the paginationPageSize to the search params
func (o *SearchParams) WithPaginationPageSize(paginationPageSize *int64) *SearchParams {
	o.SetPaginationPageSize(paginationPageSize)
	return o
}

// SetPaginationPageSize adds the paginationPageSize to the search params
func (o *SearchParams) SetPaginationPageSize(paginationPageSize *int64) {
	o.PaginationPageSize = paginationPageSize
}

// WithPaginationPreviousPageToken adds the paginationPreviousPageToken to the search params
func (o *SearchParams) WithPaginationPreviousPageToken(paginationPreviousPageToken *string) *SearchParams {
	o.SetPaginationPreviousPageToken(paginationPreviousPageToken)
	return o
}

// SetPaginationPreviousPageToken adds the paginationPreviousPageToken to the search params
func (o *SearchParams) SetPaginationPreviousPageToken(paginationPreviousPageToken *string) {
	o.PaginationPreviousPageToken = paginationPreviousPageToken
}

// WithProviders adds the providers to the search params
func (o *SearchParams) WithProviders(providers []string) *SearchParams {
	o.SetProviders(providers)
	return o
}

// SetProviders adds the providers to the search params
func (o *SearchParams) SetProviders(providers []string) {
	o.Providers = providers
}

// WithQ adds the q to the search params
func (o *SearchParams) WithQ(q *string) *SearchParams {
	o.SetQ(q)
	return o
}

// SetQ adds the q to the search params
func (o *SearchParams) SetQ(q *string) {
	o.Q = q
}

// WithSortOrderBy adds the sortOrderBy to the search params
func (o *SearchParams) WithSortOrderBy(sortOrderBy []string) *SearchParams {
	o.SetSortOrderBy(sortOrderBy)
	return o
}

// SetSortOrderBy adds the sortOrderBy to the search params
func (o *SearchParams) SetSortOrderBy(sortOrderBy []string) {
	o.SortOrderBy = sortOrderBy
}

// WriteToRequest writes these params to a swagger request
func (o *SearchParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Architectures != nil {

		// binding items for architectures
		joinedArchitectures := o.bindParamArchitectures(reg)

		// query array param architectures
		if err := r.SetQueryParam("architectures", joinedArchitectures...); err != nil {
			return err
		}
	}

	if o.PaginationNextPageToken != nil {

		// query param pagination.next_page_token
		var qrPaginationNextPageToken string

		if o.PaginationNextPageToken != nil {
			qrPaginationNextPageToken = *o.PaginationNextPageToken
		}
		qPaginationNextPageToken := qrPaginationNextPageToken
		if qPaginationNextPageToken != "" {

			if err := r.SetQueryParam("pagination.next_page_token", qPaginationNextPageToken); err != nil {
				return err
			}
		}
	}

	if o.PaginationPageSize != nil {

		// query param pagination.page_size
		var qrPaginationPageSize int64

		if o.PaginationPageSize != nil {
			qrPaginationPageSize = *o.PaginationPageSize
		}
		qPaginationPageSize := swag.FormatInt64(qrPaginationPageSize)
		if qPaginationPageSize != "" {

			if err := r.SetQueryParam("pagination.page_size", qPaginationPageSize); err != nil {
				return err
			}
		}
	}

	if o.PaginationPreviousPageToken != nil {

		// query param pagination.previous_page_token
		var qrPaginationPreviousPageToken string

		if o.PaginationPreviousPageToken != nil {
			qrPaginationPreviousPageToken = *o.PaginationPreviousPageToken
		}
		qPaginationPreviousPageToken := qrPaginationPreviousPageToken
		if qPaginationPreviousPageToken != "" {

			if err := r.SetQueryParam("pagination.previous_page_token", qPaginationPreviousPageToken); err != nil {
				return err
			}
		}
	}

	if o.Providers != nil {

		// binding items for providers
		joinedProviders := o.bindParamProviders(reg)

		// query array param providers
		if err := r.SetQueryParam("providers", joinedProviders...); err != nil {
			return err
		}
	}

	if o.Q != nil {

		// query param q
		var qrQ string

		if o.Q != nil {
			qrQ = *o.Q
		}
		qQ := qrQ
		if qQ != "" {

			if err := r.SetQueryParam("q", qQ); err != nil {
				return err
			}
		}
	}

	if o.SortOrderBy != nil {

		// binding items for sort.order_by
		joinedSortOrderBy := o.bindParamSortOrderBy(reg)

		// query array param sort.order_by
		if err := r.SetQueryParam("sort.order_by", joinedSortOrderBy...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSearch binds the parameter architectures
func (o *SearchParams) bindParamArchitectures(formats strfmt.Registry) []string {
	architecturesIR := o.Architectures

	var architecturesIC []string
	for _, architecturesIIR := range architecturesIR { // explode []string

		architecturesIIV := architecturesIIR // string as string
		architecturesIC = append(architecturesIC, architecturesIIV)
	}

	// items.CollectionFormat: "multi"
	architecturesIS := swag.JoinByFormat(architecturesIC, "multi")

	return architecturesIS
}

// bindParamSearch binds the parameter providers
func (o *SearchParams) bindParamProviders(formats strfmt.Registry) []string {
	providersIR := o.Providers

	var providersIC []string
	for _, providersIIR := range providersIR { // explode []string

		providersIIV := providersIIR // string as string
		providersIC = append(providersIC, providersIIV)
	}

	// items.CollectionFormat: "multi"
	providersIS := swag.JoinByFormat(providersIC, "multi")

	return providersIS
}

// bindParamSearch binds the parameter sort.order_by
func (o *SearchParams) bindParamSortOrderBy(formats strfmt.Registry) []string {
	sortOrderByIR := o.SortOrderBy

	var sortOrderByIC []string
	for _, sortOrderByIIR := range sortOrderByIR { // explode []string

		sortOrderByIIV := sortOrderByIIR // string as string
		sortOrderByIC = append(sortOrderByIC, sortOrderByIIV)
	}

	// items.CollectionFormat: "multi"
	sortOrderByIS := swag.JoinByFormat(sortOrderByIC, "multi")

	return sortOrderByIS
}
