// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewDeleteProviderParams creates a new DeleteProviderParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeleteProviderParams() *DeleteProviderParams {
	return &DeleteProviderParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeleteProviderParamsWithTimeout creates a new DeleteProviderParams object
// with the ability to set a timeout on a request.
func NewDeleteProviderParamsWithTimeout(timeout time.Duration) *DeleteProviderParams {
	return &DeleteProviderParams{
		timeout: timeout,
	}
}

// NewDeleteProviderParamsWithContext creates a new DeleteProviderParams object
// with the ability to set a context for a request.
func NewDeleteProviderParamsWithContext(ctx context.Context) *DeleteProviderParams {
	return &DeleteProviderParams{
		Context: ctx,
	}
}

// NewDeleteProviderParamsWithHTTPClient creates a new DeleteProviderParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeleteProviderParamsWithHTTPClient(client *http.Client) *DeleteProviderParams {
	return &DeleteProviderParams{
		HTTPClient: client,
	}
}

/*
DeleteProviderParams contains all the parameters to send to the API endpoint

	for the delete provider operation.

	Typically these are written to a http.Request.
*/
type DeleteProviderParams struct {

	/* Box.

	     The name segment of the Box. As an example, this field would represent the
	"vagrant" in "hashicorp/vagrant".
	*/
	Box string

	/* Provider.

	   The name of the Provider.
	*/
	Provider string

	/* Registry.

	     The Registry segment of the Box. As an example, this field would represent
	the "hashicorp" in "hashicorp/vagrant".
	*/
	Registry string

	/* Version.

	   The name of the Version for the Provider.
	*/
	Version string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete provider params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteProviderParams) WithDefaults() *DeleteProviderParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete provider params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteProviderParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete provider params
func (o *DeleteProviderParams) WithTimeout(timeout time.Duration) *DeleteProviderParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete provider params
func (o *DeleteProviderParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete provider params
func (o *DeleteProviderParams) WithContext(ctx context.Context) *DeleteProviderParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete provider params
func (o *DeleteProviderParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete provider params
func (o *DeleteProviderParams) WithHTTPClient(client *http.Client) *DeleteProviderParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete provider params
func (o *DeleteProviderParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBox adds the box to the delete provider params
func (o *DeleteProviderParams) WithBox(box string) *DeleteProviderParams {
	o.SetBox(box)
	return o
}

// SetBox adds the box to the delete provider params
func (o *DeleteProviderParams) SetBox(box string) {
	o.Box = box
}

// WithProvider adds the provider to the delete provider params
func (o *DeleteProviderParams) WithProvider(provider string) *DeleteProviderParams {
	o.SetProvider(provider)
	return o
}

// SetProvider adds the provider to the delete provider params
func (o *DeleteProviderParams) SetProvider(provider string) {
	o.Provider = provider
}

// WithRegistry adds the registry to the delete provider params
func (o *DeleteProviderParams) WithRegistry(registry string) *DeleteProviderParams {
	o.SetRegistry(registry)
	return o
}

// SetRegistry adds the registry to the delete provider params
func (o *DeleteProviderParams) SetRegistry(registry string) {
	o.Registry = registry
}

// WithVersion adds the version to the delete provider params
func (o *DeleteProviderParams) WithVersion(version string) *DeleteProviderParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the delete provider params
func (o *DeleteProviderParams) SetVersion(version string) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *DeleteProviderParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param box
	if err := r.SetPathParam("box", o.Box); err != nil {
		return err
	}

	// path param provider
	if err := r.SetPathParam("provider", o.Provider); err != nil {
		return err
	}

	// path param registry
	if err := r.SetPathParam("registry", o.Registry); err != nil {
		return err
	}

	// path param version
	if err := r.SetPathParam("version", o.Version); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
