// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// HashicorpCloudNetwork20200907TGWAttachment TGWAttachment represents HVN's Transit Gateway Attachment
//
// swagger:model hashicorp.cloud.network_20200907.TGWAttachment
type HashicorpCloudNetwork20200907TGWAttachment struct {

	// cidrs is a list of CIDRs this TGW attachment is associated with
	Cidrs []string `json:"cidrs"`

	// created_at is a timestamp when TGW Attachment was originally created
	//
	// Output only.
	// Read Only: true
	// Format: date-time
	CreatedAt strfmt.DateTime `json:"created_at,omitempty"`

	// ExpiresAt is the timestamp after which TGW Attachment will be considered
	// Expired if it doesn't transition into Accepted or Active state before that
	//
	// Output only.
	// Read Only: true
	// Format: date-time
	ExpiresAt strfmt.DateTime `json:"expires_at,omitempty"`

	// HVN is a link to the HVN the TGW Attachment belongs to.
	//
	// Output only.
	// Read Only: true
	Hvn *cloud.HashicorpCloudLocationLink `json:"hvn,omitempty"`

	// id is the user set, slug identifier for the TGW Attachment. It is unique
	// within a given project but not globally unique. For a globally unique
	// identifier, refer to the internal_id.
	ID string `json:"id,omitempty"`

	// location is a location of the TGW Attachment
	Location *cloud.HashicorpCloudLocationLocation `json:"location,omitempty"`

	// provider_data is a provider specific data for this TGW Attachment
	ProviderData *HashicorpCloudNetwork20200907TGWAttachmentProviderData `json:"provider_data,omitempty"`

	// provider_tgw_attachment_id is the id of this TGW Attachment in the cloud provider
	ProviderTgwAttachmentID string `json:"provider_tgw_attachment_id,omitempty"`

	// state is the state of this TGW Attachment
	//
	// Output only.
	// Read Only: true
	State HashicorpCloudNetwork20200907TGWAttachmentState `json:"state,omitempty"`

	// updated_at is a timestamp when TGW Attachment was last updated.
	//
	// Output only.
	// Read Only: true
	// Format: date-time
	UpdatedAt strfmt.DateTime `json:"updated_at,omitempty"`
}

// Validate validates this hashicorp cloud network 20200907 t g w attachment
func (m *HashicorpCloudNetwork20200907TGWAttachment) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExpiresAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHvn(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProviderData(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudNetwork20200907TGWAttachment) validateCreatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.CreatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("created_at", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudNetwork20200907TGWAttachment) validateExpiresAt(formats strfmt.Registry) error {
	if swag.IsZero(m.ExpiresAt) { // not required
		return nil
	}

	if err := validate.FormatOf("expires_at", "body", "date-time", m.ExpiresAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudNetwork20200907TGWAttachment) validateHvn(formats strfmt.Registry) error {
	if swag.IsZero(m.Hvn) { // not required
		return nil
	}

	if m.Hvn != nil {
		if err := m.Hvn.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hvn")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("hvn")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudNetwork20200907TGWAttachment) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(m.Location) { // not required
		return nil
	}

	if m.Location != nil {
		if err := m.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudNetwork20200907TGWAttachment) validateProviderData(formats strfmt.Registry) error {
	if swag.IsZero(m.ProviderData) { // not required
		return nil
	}

	if m.ProviderData != nil {
		if err := m.ProviderData.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provider_data")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("provider_data")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudNetwork20200907TGWAttachment) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	if err := m.State.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("state")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("state")
		}
		return err
	}

	return nil
}

func (m *HashicorpCloudNetwork20200907TGWAttachment) validateUpdatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("updated_at", "body", "date-time", m.UpdatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this hashicorp cloud network 20200907 t g w attachment based on the context it is used
func (m *HashicorpCloudNetwork20200907TGWAttachment) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCreatedAt(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExpiresAt(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHvn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProviderData(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUpdatedAt(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudNetwork20200907TGWAttachment) contextValidateCreatedAt(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "created_at", "body", strfmt.DateTime(m.CreatedAt)); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudNetwork20200907TGWAttachment) contextValidateExpiresAt(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "expires_at", "body", strfmt.DateTime(m.ExpiresAt)); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudNetwork20200907TGWAttachment) contextValidateHvn(ctx context.Context, formats strfmt.Registry) error {

	if m.Hvn != nil {

		if swag.IsZero(m.Hvn) { // not required
			return nil
		}

		if err := m.Hvn.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hvn")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("hvn")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudNetwork20200907TGWAttachment) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if m.Location != nil {

		if swag.IsZero(m.Location) { // not required
			return nil
		}

		if err := m.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudNetwork20200907TGWAttachment) contextValidateProviderData(ctx context.Context, formats strfmt.Registry) error {

	if m.ProviderData != nil {

		if swag.IsZero(m.ProviderData) { // not required
			return nil
		}

		if err := m.ProviderData.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provider_data")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("provider_data")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudNetwork20200907TGWAttachment) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if swag.IsZero(m.State) { // not required
		return nil
	}

	if err := m.State.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("state")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("state")
		}
		return err
	}

	return nil
}

func (m *HashicorpCloudNetwork20200907TGWAttachment) contextValidateUpdatedAt(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "updated_at", "body", strfmt.DateTime(m.UpdatedAt)); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudNetwork20200907TGWAttachment) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudNetwork20200907TGWAttachment) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudNetwork20200907TGWAttachment
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
