// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// HashicorpCloudNetwork20200907HVNRoute HVNRoute represents an HVN Route
//
// swagger:model hashicorp.cloud.network_20200907.HVNRoute
type HashicorpCloudNetwork20200907HVNRoute struct {

	// azure route
	AzureRoute *HashicorpCloudNetwork20200907AzureRoute `json:"azure_route,omitempty"`

	// created_at is a timestamp when HVN Route was originally created
	// Format: date-time
	CreatedAt strfmt.DateTime `json:"created_at,omitempty"`

	// destination is a destination CIDR for this HVN Route
	Destination string `json:"destination,omitempty"`

	// HVN is a link to the HVN the Route belongs to
	Hvn *cloud.HashicorpCloudLocationLink `json:"hvn,omitempty"`

	// id is the user set, slug identifier for the HVN Route. It is unique
	// within a given HVN but not globally unique.
	ID string `json:"id,omitempty"`

	// state is the state of this HVN Route
	State *HashicorpCloudNetwork20200907HVNRouteState `json:"state,omitempty"`

	// target is a target for this HVN Route
	Target *HashicorpCloudNetwork20200907HVNRouteTarget `json:"target,omitempty"`
}

// Validate validates this hashicorp cloud network 20200907 h v n route
func (m *HashicorpCloudNetwork20200907HVNRoute) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAzureRoute(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHvn(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTarget(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudNetwork20200907HVNRoute) validateAzureRoute(formats strfmt.Registry) error {
	if swag.IsZero(m.AzureRoute) { // not required
		return nil
	}

	if m.AzureRoute != nil {
		if err := m.AzureRoute.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("azure_route")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("azure_route")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudNetwork20200907HVNRoute) validateCreatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.CreatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("created_at", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudNetwork20200907HVNRoute) validateHvn(formats strfmt.Registry) error {
	if swag.IsZero(m.Hvn) { // not required
		return nil
	}

	if m.Hvn != nil {
		if err := m.Hvn.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hvn")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("hvn")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudNetwork20200907HVNRoute) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	if m.State != nil {
		if err := m.State.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudNetwork20200907HVNRoute) validateTarget(formats strfmt.Registry) error {
	if swag.IsZero(m.Target) { // not required
		return nil
	}

	if m.Target != nil {
		if err := m.Target.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("target")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("target")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud network 20200907 h v n route based on the context it is used
func (m *HashicorpCloudNetwork20200907HVNRoute) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAzureRoute(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHvn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTarget(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudNetwork20200907HVNRoute) contextValidateAzureRoute(ctx context.Context, formats strfmt.Registry) error {

	if m.AzureRoute != nil {

		if swag.IsZero(m.AzureRoute) { // not required
			return nil
		}

		if err := m.AzureRoute.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("azure_route")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("azure_route")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudNetwork20200907HVNRoute) contextValidateHvn(ctx context.Context, formats strfmt.Registry) error {

	if m.Hvn != nil {

		if swag.IsZero(m.Hvn) { // not required
			return nil
		}

		if err := m.Hvn.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hvn")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("hvn")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudNetwork20200907HVNRoute) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if m.State != nil {

		if swag.IsZero(m.State) { // not required
			return nil
		}

		if err := m.State.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudNetwork20200907HVNRoute) contextValidateTarget(ctx context.Context, formats strfmt.Registry) error {

	if m.Target != nil {

		if swag.IsZero(m.Target) { // not required
			return nil
		}

		if err := m.Target.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("target")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("target")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudNetwork20200907HVNRoute) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudNetwork20200907HVNRoute) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudNetwork20200907HVNRoute
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
