// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// LogService20210330TestDestinationRequest TestDestinationRequest represents a request to test a streaming destination config record.
//
// swagger:model log_service_20210330TestDestinationRequest
type LogService20210330TestDestinationRequest struct {

	// cloudwatch logs provider
	CloudwatchLogsProvider *LogService20210330StreamingCloudwatchLogsProvider `json:"cloudwatch_logs_provider,omitempty"`

	// datadog provider
	DatadogProvider *LogService20210330StreamingDatadogProvider `json:"datadog_provider,omitempty"`

	// id is an optional field that identifies an existing destination
	ID string `json:"id,omitempty"`

	// mask is an optional field specifying the fields to replace on the existing destination.
	// If id is empty, mask must be empty. If the id is not empty, mask is required.
	Mask *ProtobufFieldMask `json:"mask,omitempty"`

	// organization id
	OrganizationID string `json:"organization_id,omitempty"`

	// splunk cloud provider
	SplunkCloudProvider *LogService20210330StreamingSplunkCloudProvider `json:"splunk_cloud_provider,omitempty"`
}

// Validate validates this log service 20210330 test destination request
func (m *LogService20210330TestDestinationRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCloudwatchLogsProvider(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDatadogProvider(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMask(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSplunkCloudProvider(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogService20210330TestDestinationRequest) validateCloudwatchLogsProvider(formats strfmt.Registry) error {
	if swag.IsZero(m.CloudwatchLogsProvider) { // not required
		return nil
	}

	if m.CloudwatchLogsProvider != nil {
		if err := m.CloudwatchLogsProvider.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloudwatch_logs_provider")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cloudwatch_logs_provider")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330TestDestinationRequest) validateDatadogProvider(formats strfmt.Registry) error {
	if swag.IsZero(m.DatadogProvider) { // not required
		return nil
	}

	if m.DatadogProvider != nil {
		if err := m.DatadogProvider.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("datadog_provider")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("datadog_provider")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330TestDestinationRequest) validateMask(formats strfmt.Registry) error {
	if swag.IsZero(m.Mask) { // not required
		return nil
	}

	if m.Mask != nil {
		if err := m.Mask.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("mask")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("mask")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330TestDestinationRequest) validateSplunkCloudProvider(formats strfmt.Registry) error {
	if swag.IsZero(m.SplunkCloudProvider) { // not required
		return nil
	}

	if m.SplunkCloudProvider != nil {
		if err := m.SplunkCloudProvider.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("splunk_cloud_provider")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("splunk_cloud_provider")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this log service 20210330 test destination request based on the context it is used
func (m *LogService20210330TestDestinationRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCloudwatchLogsProvider(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDatadogProvider(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMask(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSplunkCloudProvider(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogService20210330TestDestinationRequest) contextValidateCloudwatchLogsProvider(ctx context.Context, formats strfmt.Registry) error {

	if m.CloudwatchLogsProvider != nil {

		if swag.IsZero(m.CloudwatchLogsProvider) { // not required
			return nil
		}

		if err := m.CloudwatchLogsProvider.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloudwatch_logs_provider")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cloudwatch_logs_provider")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330TestDestinationRequest) contextValidateDatadogProvider(ctx context.Context, formats strfmt.Registry) error {

	if m.DatadogProvider != nil {

		if swag.IsZero(m.DatadogProvider) { // not required
			return nil
		}

		if err := m.DatadogProvider.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("datadog_provider")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("datadog_provider")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330TestDestinationRequest) contextValidateMask(ctx context.Context, formats strfmt.Registry) error {

	if m.Mask != nil {

		if swag.IsZero(m.Mask) { // not required
			return nil
		}

		if err := m.Mask.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("mask")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("mask")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330TestDestinationRequest) contextValidateSplunkCloudProvider(ctx context.Context, formats strfmt.Registry) error {

	if m.SplunkCloudProvider != nil {

		if swag.IsZero(m.SplunkCloudProvider) { // not required
			return nil
		}

		if err := m.SplunkCloudProvider.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("splunk_cloud_provider")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("splunk_cloud_provider")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LogService20210330TestDestinationRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LogService20210330TestDestinationRequest) UnmarshalBinary(b []byte) error {
	var res LogService20210330TestDestinationRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
