// Code generated by go-swagger; DO NOT EDIT.

package service_principals_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ServicePrincipalsServiceCreateServicePrincipalReader is a Reader for the ServicePrincipalsServiceCreateServicePrincipal structure.
type ServicePrincipalsServiceCreateServicePrincipalReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ServicePrincipalsServiceCreateServicePrincipalReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewServicePrincipalsServiceCreateServicePrincipalOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewServicePrincipalsServiceCreateServicePrincipalDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewServicePrincipalsServiceCreateServicePrincipalOK creates a ServicePrincipalsServiceCreateServicePrincipalOK with default headers values
func NewServicePrincipalsServiceCreateServicePrincipalOK() *ServicePrincipalsServiceCreateServicePrincipalOK {
	return &ServicePrincipalsServiceCreateServicePrincipalOK{}
}

/*
ServicePrincipalsServiceCreateServicePrincipalOK describes a response with status code 200, with default header values.

A successful response.
*/
type ServicePrincipalsServiceCreateServicePrincipalOK struct {
	Payload *models.HashicorpCloudIamCreateServicePrincipalResponse
}

// IsSuccess returns true when this service principals service create service principal o k response has a 2xx status code
func (o *ServicePrincipalsServiceCreateServicePrincipalOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this service principals service create service principal o k response has a 3xx status code
func (o *ServicePrincipalsServiceCreateServicePrincipalOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this service principals service create service principal o k response has a 4xx status code
func (o *ServicePrincipalsServiceCreateServicePrincipalOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this service principals service create service principal o k response has a 5xx status code
func (o *ServicePrincipalsServiceCreateServicePrincipalOK) IsServerError() bool {
	return false
}

// IsCode returns true when this service principals service create service principal o k response a status code equal to that given
func (o *ServicePrincipalsServiceCreateServicePrincipalOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the service principals service create service principal o k response
func (o *ServicePrincipalsServiceCreateServicePrincipalOK) Code() int {
	return 200
}

func (o *ServicePrincipalsServiceCreateServicePrincipalOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /2019-12-10/iam/{parent_resource_name}/service-principals][%d] servicePrincipalsServiceCreateServicePrincipalOK %s", 200, payload)
}

func (o *ServicePrincipalsServiceCreateServicePrincipalOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /2019-12-10/iam/{parent_resource_name}/service-principals][%d] servicePrincipalsServiceCreateServicePrincipalOK %s", 200, payload)
}

func (o *ServicePrincipalsServiceCreateServicePrincipalOK) GetPayload() *models.HashicorpCloudIamCreateServicePrincipalResponse {
	return o.Payload
}

func (o *ServicePrincipalsServiceCreateServicePrincipalOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudIamCreateServicePrincipalResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewServicePrincipalsServiceCreateServicePrincipalDefault creates a ServicePrincipalsServiceCreateServicePrincipalDefault with default headers values
func NewServicePrincipalsServiceCreateServicePrincipalDefault(code int) *ServicePrincipalsServiceCreateServicePrincipalDefault {
	return &ServicePrincipalsServiceCreateServicePrincipalDefault{
		_statusCode: code,
	}
}

/*
ServicePrincipalsServiceCreateServicePrincipalDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ServicePrincipalsServiceCreateServicePrincipalDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this service principals service create service principal default response has a 2xx status code
func (o *ServicePrincipalsServiceCreateServicePrincipalDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this service principals service create service principal default response has a 3xx status code
func (o *ServicePrincipalsServiceCreateServicePrincipalDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this service principals service create service principal default response has a 4xx status code
func (o *ServicePrincipalsServiceCreateServicePrincipalDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this service principals service create service principal default response has a 5xx status code
func (o *ServicePrincipalsServiceCreateServicePrincipalDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this service principals service create service principal default response a status code equal to that given
func (o *ServicePrincipalsServiceCreateServicePrincipalDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the service principals service create service principal default response
func (o *ServicePrincipalsServiceCreateServicePrincipalDefault) Code() int {
	return o._statusCode
}

func (o *ServicePrincipalsServiceCreateServicePrincipalDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /2019-12-10/iam/{parent_resource_name}/service-principals][%d] ServicePrincipalsService_CreateServicePrincipal default %s", o._statusCode, payload)
}

func (o *ServicePrincipalsServiceCreateServicePrincipalDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /2019-12-10/iam/{parent_resource_name}/service-principals][%d] ServicePrincipalsService_CreateServicePrincipal default %s", o._statusCode, payload)
}

func (o *ServicePrincipalsServiceCreateServicePrincipalDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ServicePrincipalsServiceCreateServicePrincipalDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ServicePrincipalsServiceCreateServicePrincipalBody CreateServicePrincipalRequest is the request message used when creating a
// service principal.
swagger:model ServicePrincipalsServiceCreateServicePrincipalBody
*/
type ServicePrincipalsServiceCreateServicePrincipalBody struct {

	// name is the customer-chosen name for this service principal.
	Name string `json:"name,omitempty"`
}

// Validate validates this service principals service create service principal body
func (o *ServicePrincipalsServiceCreateServicePrincipalBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this service principals service create service principal body based on context it is used
func (o *ServicePrincipalsServiceCreateServicePrincipalBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ServicePrincipalsServiceCreateServicePrincipalBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ServicePrincipalsServiceCreateServicePrincipalBody) UnmarshalBinary(b []byte) error {
	var res ServicePrincipalsServiceCreateServicePrincipalBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
