// Code generated by go-swagger; DO NOT EDIT.

package service_principals_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ServicePrincipalsServiceCreateOrganizationServicePrincipalReader is a Reader for the ServicePrincipalsServiceCreateOrganizationServicePrincipal structure.
type ServicePrincipalsServiceCreateOrganizationServicePrincipalReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewServicePrincipalsServiceCreateOrganizationServicePrincipalOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewServicePrincipalsServiceCreateOrganizationServicePrincipalDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewServicePrincipalsServiceCreateOrganizationServicePrincipalOK creates a ServicePrincipalsServiceCreateOrganizationServicePrincipalOK with default headers values
func NewServicePrincipalsServiceCreateOrganizationServicePrincipalOK() *ServicePrincipalsServiceCreateOrganizationServicePrincipalOK {
	return &ServicePrincipalsServiceCreateOrganizationServicePrincipalOK{}
}

/*
ServicePrincipalsServiceCreateOrganizationServicePrincipalOK describes a response with status code 200, with default header values.

A successful response.
*/
type ServicePrincipalsServiceCreateOrganizationServicePrincipalOK struct {
	Payload *models.HashicorpCloudIamCreateOrganizationServicePrincipalResponse
}

// IsSuccess returns true when this service principals service create organization service principal o k response has a 2xx status code
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this service principals service create organization service principal o k response has a 3xx status code
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this service principals service create organization service principal o k response has a 4xx status code
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this service principals service create organization service principal o k response has a 5xx status code
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalOK) IsServerError() bool {
	return false
}

// IsCode returns true when this service principals service create organization service principal o k response a status code equal to that given
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the service principals service create organization service principal o k response
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalOK) Code() int {
	return 200
}

func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/organizations/{organization_id}/service-principals][%d] servicePrincipalsServiceCreateOrganizationServicePrincipalOK %s", 200, payload)
}

func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/organizations/{organization_id}/service-principals][%d] servicePrincipalsServiceCreateOrganizationServicePrincipalOK %s", 200, payload)
}

func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalOK) GetPayload() *models.HashicorpCloudIamCreateOrganizationServicePrincipalResponse {
	return o.Payload
}

func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudIamCreateOrganizationServicePrincipalResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewServicePrincipalsServiceCreateOrganizationServicePrincipalDefault creates a ServicePrincipalsServiceCreateOrganizationServicePrincipalDefault with default headers values
func NewServicePrincipalsServiceCreateOrganizationServicePrincipalDefault(code int) *ServicePrincipalsServiceCreateOrganizationServicePrincipalDefault {
	return &ServicePrincipalsServiceCreateOrganizationServicePrincipalDefault{
		_statusCode: code,
	}
}

/*
ServicePrincipalsServiceCreateOrganizationServicePrincipalDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ServicePrincipalsServiceCreateOrganizationServicePrincipalDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this service principals service create organization service principal default response has a 2xx status code
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this service principals service create organization service principal default response has a 3xx status code
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this service principals service create organization service principal default response has a 4xx status code
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this service principals service create organization service principal default response has a 5xx status code
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this service principals service create organization service principal default response a status code equal to that given
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the service principals service create organization service principal default response
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalDefault) Code() int {
	return o._statusCode
}

func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/organizations/{organization_id}/service-principals][%d] ServicePrincipalsService_CreateOrganizationServicePrincipal default %s", o._statusCode, payload)
}

func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/organizations/{organization_id}/service-principals][%d] ServicePrincipalsService_CreateOrganizationServicePrincipal default %s", o._statusCode, payload)
}

func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ServicePrincipalsServiceCreateOrganizationServicePrincipalBody CreateOrganizationServicePrincipalRequest is the request message used when creating a
// service principal on organization level.
swagger:model ServicePrincipalsServiceCreateOrganizationServicePrincipalBody
*/
type ServicePrincipalsServiceCreateOrganizationServicePrincipalBody struct {

	// name is the customer-chosen name for this service principal.
	Name string `json:"name,omitempty"`
}

// Validate validates this service principals service create organization service principal body
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this service principals service create organization service principal body based on context it is used
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ServicePrincipalsServiceCreateOrganizationServicePrincipalBody) UnmarshalBinary(b []byte) error {
	var res ServicePrincipalsServiceCreateOrganizationServicePrincipalBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
