// Code generated by go-swagger; DO NOT EDIT.

package service_instances

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewGetServiceInstanceParams creates a new GetServiceInstanceParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetServiceInstanceParams() *GetServiceInstanceParams {
	return &GetServiceInstanceParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetServiceInstanceParamsWithTimeout creates a new GetServiceInstanceParams object
// with the ability to set a timeout on a request.
func NewGetServiceInstanceParamsWithTimeout(timeout time.Duration) *GetServiceInstanceParams {
	return &GetServiceInstanceParams{
		timeout: timeout,
	}
}

// NewGetServiceInstanceParamsWithContext creates a new GetServiceInstanceParams object
// with the ability to set a context for a request.
func NewGetServiceInstanceParamsWithContext(ctx context.Context) *GetServiceInstanceParams {
	return &GetServiceInstanceParams{
		Context: ctx,
	}
}

// NewGetServiceInstanceParamsWithHTTPClient creates a new GetServiceInstanceParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetServiceInstanceParamsWithHTTPClient(client *http.Client) *GetServiceInstanceParams {
	return &GetServiceInstanceParams{
		HTTPClient: client,
	}
}

/*
GetServiceInstanceParams contains all the parameters to send to the API endpoint

	for the get service instance operation.

	Typically these are written to a http.Request.
*/
type GetServiceInstanceParams struct {

	/* ClusterResourceName.

	   Cluster resource name will be of the form `consul/project/<project_id>/cluster/<cluster_id>`
	*/
	ClusterResourceName string

	/* InstanceID.

	   Unique identifier for the service instance.
	*/
	InstanceID string

	/* Namespace.

	   Namespace where the service is deployed.
	*/
	Namespace *string

	/* Node.

	   Name of the node on which the service instance resides.
	*/
	Node string

	/* Partition.

	   Partition where the service is deployed.
	*/
	Partition *string

	/* ServiceName.

	   Name of the service.
	*/
	ServiceName string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get service instance params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetServiceInstanceParams) WithDefaults() *GetServiceInstanceParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get service instance params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetServiceInstanceParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get service instance params
func (o *GetServiceInstanceParams) WithTimeout(timeout time.Duration) *GetServiceInstanceParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get service instance params
func (o *GetServiceInstanceParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get service instance params
func (o *GetServiceInstanceParams) WithContext(ctx context.Context) *GetServiceInstanceParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get service instance params
func (o *GetServiceInstanceParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get service instance params
func (o *GetServiceInstanceParams) WithHTTPClient(client *http.Client) *GetServiceInstanceParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get service instance params
func (o *GetServiceInstanceParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterResourceName adds the clusterResourceName to the get service instance params
func (o *GetServiceInstanceParams) WithClusterResourceName(clusterResourceName string) *GetServiceInstanceParams {
	o.SetClusterResourceName(clusterResourceName)
	return o
}

// SetClusterResourceName adds the clusterResourceName to the get service instance params
func (o *GetServiceInstanceParams) SetClusterResourceName(clusterResourceName string) {
	o.ClusterResourceName = clusterResourceName
}

// WithInstanceID adds the instanceID to the get service instance params
func (o *GetServiceInstanceParams) WithInstanceID(instanceID string) *GetServiceInstanceParams {
	o.SetInstanceID(instanceID)
	return o
}

// SetInstanceID adds the instanceId to the get service instance params
func (o *GetServiceInstanceParams) SetInstanceID(instanceID string) {
	o.InstanceID = instanceID
}

// WithNamespace adds the namespace to the get service instance params
func (o *GetServiceInstanceParams) WithNamespace(namespace *string) *GetServiceInstanceParams {
	o.SetNamespace(namespace)
	return o
}

// SetNamespace adds the namespace to the get service instance params
func (o *GetServiceInstanceParams) SetNamespace(namespace *string) {
	o.Namespace = namespace
}

// WithNode adds the node to the get service instance params
func (o *GetServiceInstanceParams) WithNode(node string) *GetServiceInstanceParams {
	o.SetNode(node)
	return o
}

// SetNode adds the node to the get service instance params
func (o *GetServiceInstanceParams) SetNode(node string) {
	o.Node = node
}

// WithPartition adds the partition to the get service instance params
func (o *GetServiceInstanceParams) WithPartition(partition *string) *GetServiceInstanceParams {
	o.SetPartition(partition)
	return o
}

// SetPartition adds the partition to the get service instance params
func (o *GetServiceInstanceParams) SetPartition(partition *string) {
	o.Partition = partition
}

// WithServiceName adds the serviceName to the get service instance params
func (o *GetServiceInstanceParams) WithServiceName(serviceName string) *GetServiceInstanceParams {
	o.SetServiceName(serviceName)
	return o
}

// SetServiceName adds the serviceName to the get service instance params
func (o *GetServiceInstanceParams) SetServiceName(serviceName string) {
	o.ServiceName = serviceName
}

// WriteToRequest writes these params to a swagger request
func (o *GetServiceInstanceParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_resource_name
	if err := r.SetPathParam("cluster_resource_name", o.ClusterResourceName); err != nil {
		return err
	}

	// path param instance_id
	if err := r.SetPathParam("instance_id", o.InstanceID); err != nil {
		return err
	}

	if o.Namespace != nil {

		// query param namespace
		var qrNamespace string

		if o.Namespace != nil {
			qrNamespace = *o.Namespace
		}
		qNamespace := qrNamespace
		if qNamespace != "" {

			if err := r.SetQueryParam("namespace", qNamespace); err != nil {
				return err
			}
		}
	}

	// path param node
	if err := r.SetPathParam("node", o.Node); err != nil {
		return err
	}

	if o.Partition != nil {

		// query param partition
		var qrPartition string

		if o.Partition != nil {
			qrPartition = *o.Partition
		}
		qPartition := qrPartition
		if qPartition != "" {

			if err := r.SetQueryParam("partition", qPartition); err != nil {
				return err
			}
		}
	}

	// path param service_name
	if err := r.SetPathParam("service_name", o.ServiceName); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
