// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// Billing20201105PackageOption PackageOption represents a selection of a PackageItem as part of a Package.
//
// swagger:model billing_20201105PackageOption
type Billing20201105PackageOption struct {

	// dependencies defines a dependency between this PackageOption and another
	// Option a different item.
	//
	// Dependencies are optional, and when they are not set it means that the
	// option could be used with any other combination of items/options.
	//
	// When they are set, all dependencies have to be met for this PackageOption to be active.
	//
	// Example scenario 1:
	// - Item 1 has 2 Options: 1.1 and 1.2
	// - Item 2 has also 2 Options: 2.1 and 2.2, and item 2 is of type SELECTION
	// - Option 2.1 has a dependency on 1.1
	// - Option 2.2 has a dependency on 1.2
	// - If a user select 1.1, then 2.1 can be selected
	// - If a user select 1.2, then 2.2 can be selected
	//
	// Example scenario 2:
	// - Item 1 has 2 Options: 1.1 and 1.2
	// - Item 2 has also 2 Options: 2.1 and 2.2, and item 2 is of type COST
	// - Option 2.1 has a dependency on 1.1
	// - Option 2.2 has a dependency on 1.2
	// - If a user select 1.1, then 2.1 will be automatically be selected
	// - If a user select 1.2, then 2.2 will be automatically be selected
	//
	//   In this scenario Item 1 could represent cluster size and Item 2 could
	//   represent the mumber of clients. Selecting medium (1.2) affects the
	//   price of the number of clients (2.2).
	//
	// Example scenario 3:
	// - Item 1 has 2 Options: 1.1 and 1.2
	// - Item 2 has also 2 Options: 2.1 and 2.2, and item 2 is of type SELECTION
	// - Option 2.1 has no dependencies
	// - Option 2.2 has no dependencies
	// - Either options 2.1 and 2.2 can be selected by the user, regardless
	//   of the item 1 option value.
	Dependencies []*PackageOptionDependency `json:"dependencies"`

	// key is the unique identifier of the Option for a given Item.
	Key string `json:"key,omitempty"`

	// unit is the type of measurement that is used to calculate the quantity used of this product.
	Unit *Billing20201105Unit `json:"unit,omitempty"`

	// unit_display_key contains an human label for the product unit.
	// It will be present if the unit type is set to UNIT, as a way
	// to clarify what the customer is going to be charged for.
	UnitDisplayKey string `json:"unit_display_key,omitempty"`

	// unit_price is the price of a single unit of the product in USD.
	UnitPrice string `json:"unit_price,omitempty"`
}

// Validate validates this billing 20201105 package option
func (m *Billing20201105PackageOption) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDependencies(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUnit(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Billing20201105PackageOption) validateDependencies(formats strfmt.Registry) error {
	if swag.IsZero(m.Dependencies) { // not required
		return nil
	}

	for i := 0; i < len(m.Dependencies); i++ {
		if swag.IsZero(m.Dependencies[i]) { // not required
			continue
		}

		if m.Dependencies[i] != nil {
			if err := m.Dependencies[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("dependencies" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("dependencies" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Billing20201105PackageOption) validateUnit(formats strfmt.Registry) error {
	if swag.IsZero(m.Unit) { // not required
		return nil
	}

	if m.Unit != nil {
		if err := m.Unit.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("unit")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("unit")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this billing 20201105 package option based on the context it is used
func (m *Billing20201105PackageOption) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDependencies(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUnit(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Billing20201105PackageOption) contextValidateDependencies(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Dependencies); i++ {

		if m.Dependencies[i] != nil {

			if swag.IsZero(m.Dependencies[i]) { // not required
				return nil
			}

			if err := m.Dependencies[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("dependencies" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("dependencies" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Billing20201105PackageOption) contextValidateUnit(ctx context.Context, formats strfmt.Registry) error {

	if m.Unit != nil {

		if swag.IsZero(m.Unit) { // not required
			return nil
		}

		if err := m.Unit.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("unit")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("unit")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Billing20201105PackageOption) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Billing20201105PackageOption) UnmarshalBinary(b []byte) error {
	var res Billing20201105PackageOption
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
