// Code generated by go-swagger; DO NOT EDIT.

package billing_account_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewBillingAccountServiceGetByProjectParams creates a new BillingAccountServiceGetByProjectParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewBillingAccountServiceGetByProjectParams() *BillingAccountServiceGetByProjectParams {
	return &BillingAccountServiceGetByProjectParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewBillingAccountServiceGetByProjectParamsWithTimeout creates a new BillingAccountServiceGetByProjectParams object
// with the ability to set a timeout on a request.
func NewBillingAccountServiceGetByProjectParamsWithTimeout(timeout time.Duration) *BillingAccountServiceGetByProjectParams {
	return &BillingAccountServiceGetByProjectParams{
		timeout: timeout,
	}
}

// NewBillingAccountServiceGetByProjectParamsWithContext creates a new BillingAccountServiceGetByProjectParams object
// with the ability to set a context for a request.
func NewBillingAccountServiceGetByProjectParamsWithContext(ctx context.Context) *BillingAccountServiceGetByProjectParams {
	return &BillingAccountServiceGetByProjectParams{
		Context: ctx,
	}
}

// NewBillingAccountServiceGetByProjectParamsWithHTTPClient creates a new BillingAccountServiceGetByProjectParams object
// with the ability to set a custom HTTPClient for a request.
func NewBillingAccountServiceGetByProjectParamsWithHTTPClient(client *http.Client) *BillingAccountServiceGetByProjectParams {
	return &BillingAccountServiceGetByProjectParams{
		HTTPClient: client,
	}
}

/*
BillingAccountServiceGetByProjectParams contains all the parameters to send to the API endpoint

	for the billing account service get by project operation.

	Typically these are written to a http.Request.
*/
type BillingAccountServiceGetByProjectParams struct {

	/* OrganizationID.

	   organization_id is the ID of the organization to which the project belongs.
	*/
	OrganizationID string

	/* ProjectID.

	     project_id is the project ID for which the Billing Account is being
	retrieved.
	*/
	ProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the billing account service get by project params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BillingAccountServiceGetByProjectParams) WithDefaults() *BillingAccountServiceGetByProjectParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the billing account service get by project params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BillingAccountServiceGetByProjectParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the billing account service get by project params
func (o *BillingAccountServiceGetByProjectParams) WithTimeout(timeout time.Duration) *BillingAccountServiceGetByProjectParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the billing account service get by project params
func (o *BillingAccountServiceGetByProjectParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the billing account service get by project params
func (o *BillingAccountServiceGetByProjectParams) WithContext(ctx context.Context) *BillingAccountServiceGetByProjectParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the billing account service get by project params
func (o *BillingAccountServiceGetByProjectParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the billing account service get by project params
func (o *BillingAccountServiceGetByProjectParams) WithHTTPClient(client *http.Client) *BillingAccountServiceGetByProjectParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the billing account service get by project params
func (o *BillingAccountServiceGetByProjectParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithOrganizationID adds the organizationID to the billing account service get by project params
func (o *BillingAccountServiceGetByProjectParams) WithOrganizationID(organizationID string) *BillingAccountServiceGetByProjectParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the billing account service get by project params
func (o *BillingAccountServiceGetByProjectParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WithProjectID adds the projectID to the billing account service get by project params
func (o *BillingAccountServiceGetByProjectParams) WithProjectID(projectID string) *BillingAccountServiceGetByProjectParams {
	o.SetProjectID(projectID)
	return o
}

// SetProjectID adds the projectId to the billing account service get by project params
func (o *BillingAccountServiceGetByProjectParams) SetProjectID(projectID string) {
	o.ProjectID = projectID
}

// WriteToRequest writes these params to a swagger request
func (o *BillingAccountServiceGetByProjectParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	// path param project_id
	if err := r.SetPathParam("project_id", o.ProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
