// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"encoding/json"
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// HostScanAgentConfiguration Agent configuration for host scan agent settings. This model is polymorphic, presenting different configuration options based on selected agent vendor.
type HostScanAgentConfiguration interface {

	// Vendor to use for the host scan agent.
	GetVendorType() VendorTypeEnum
}

type hostscanagentconfiguration struct {
	JsonData   []byte
	VendorType VendorTypeEnum `mandatory:"false" json:"vendorType,omitempty"`
	Vendor     string         `json:"vendor"`
}

// UnmarshalJSON unmarshals json
func (m *hostscanagentconfiguration) UnmarshalJSON(data []byte) error {
	m.JsonData = data
	type Unmarshalerhostscanagentconfiguration hostscanagentconfiguration
	s := struct {
		Model Unmarshalerhostscanagentconfiguration
	}{}
	err := json.Unmarshal(data, &s.Model)
	if err != nil {
		return err
	}
	m.VendorType = s.Model.VendorType
	m.Vendor = s.Model.Vendor

	return err
}

// UnmarshalPolymorphicJSON unmarshals polymorphic json
func (m *hostscanagentconfiguration) UnmarshalPolymorphicJSON(data []byte) (interface{}, error) {

	if data == nil || string(data) == "null" {
		return nil, nil
	}

	var err error
	switch m.Vendor {
	case "QUALYS":
		mm := HostScanAgentConfigurationQualys{}
		err = json.Unmarshal(data, &mm)
		return mm, err
	case "OCI":
		mm := HostScanAgentConfigurationOci{}
		err = json.Unmarshal(data, &mm)
		return mm, err
	default:
		common.Logf("Received unsupported enum value for HostScanAgentConfiguration: %s.", m.Vendor)
		return *m, nil
	}
}

// GetVendorType returns VendorType
func (m hostscanagentconfiguration) GetVendorType() VendorTypeEnum {
	return m.VendorType
}

func (m hostscanagentconfiguration) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m hostscanagentconfiguration) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if _, ok := GetMappingVendorTypeEnum(string(m.VendorType)); !ok && m.VendorType != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for VendorType: %s. Supported values are: %s.", m.VendorType, strings.Join(GetVendorTypeEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
