//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/authorization/armauthorization/v3"
	"net/http"
	"net/url"
	"regexp"
)

// AccessReviewInstanceMyDecisionsServer is a fake server for instances of the armauthorization.AccessReviewInstanceMyDecisionsClient type.
type AccessReviewInstanceMyDecisionsServer struct {
	// GetByID is the fake for method AccessReviewInstanceMyDecisionsClient.GetByID
	// HTTP status codes to indicate success: http.StatusOK
	GetByID func(ctx context.Context, scheduleDefinitionID string, id string, decisionID string, options *armauthorization.AccessReviewInstanceMyDecisionsClientGetByIDOptions) (resp azfake.Responder[armauthorization.AccessReviewInstanceMyDecisionsClientGetByIDResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method AccessReviewInstanceMyDecisionsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(scheduleDefinitionID string, id string, options *armauthorization.AccessReviewInstanceMyDecisionsClientListOptions) (resp azfake.PagerResponder[armauthorization.AccessReviewInstanceMyDecisionsClientListResponse])

	// Patch is the fake for method AccessReviewInstanceMyDecisionsClient.Patch
	// HTTP status codes to indicate success: http.StatusOK
	Patch func(ctx context.Context, scheduleDefinitionID string, id string, decisionID string, properties armauthorization.AccessReviewDecisionProperties, options *armauthorization.AccessReviewInstanceMyDecisionsClientPatchOptions) (resp azfake.Responder[armauthorization.AccessReviewInstanceMyDecisionsClientPatchResponse], errResp azfake.ErrorResponder)
}

// NewAccessReviewInstanceMyDecisionsServerTransport creates a new instance of AccessReviewInstanceMyDecisionsServerTransport with the provided implementation.
// The returned AccessReviewInstanceMyDecisionsServerTransport instance is connected to an instance of armauthorization.AccessReviewInstanceMyDecisionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAccessReviewInstanceMyDecisionsServerTransport(srv *AccessReviewInstanceMyDecisionsServer) *AccessReviewInstanceMyDecisionsServerTransport {
	return &AccessReviewInstanceMyDecisionsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armauthorization.AccessReviewInstanceMyDecisionsClientListResponse]](),
	}
}

// AccessReviewInstanceMyDecisionsServerTransport connects instances of armauthorization.AccessReviewInstanceMyDecisionsClient to instances of AccessReviewInstanceMyDecisionsServer.
// Don't use this type directly, use NewAccessReviewInstanceMyDecisionsServerTransport instead.
type AccessReviewInstanceMyDecisionsServerTransport struct {
	srv          *AccessReviewInstanceMyDecisionsServer
	newListPager *tracker[azfake.PagerResponder[armauthorization.AccessReviewInstanceMyDecisionsClientListResponse]]
}

// Do implements the policy.Transporter interface for AccessReviewInstanceMyDecisionsServerTransport.
func (a *AccessReviewInstanceMyDecisionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AccessReviewInstanceMyDecisionsClient.GetByID":
		resp, err = a.dispatchGetByID(req)
	case "AccessReviewInstanceMyDecisionsClient.NewListPager":
		resp, err = a.dispatchNewListPager(req)
	case "AccessReviewInstanceMyDecisionsClient.Patch":
		resp, err = a.dispatchPatch(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AccessReviewInstanceMyDecisionsServerTransport) dispatchGetByID(req *http.Request) (*http.Response, error) {
	if a.srv.GetByID == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByID not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Authorization/accessReviewScheduleDefinitions/(?P<scheduleDefinitionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<id>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/decisions/(?P<decisionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scheduleDefinitionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scheduleDefinitionId")])
	if err != nil {
		return nil, err
	}
	idParam, err := url.PathUnescape(matches[regex.SubexpIndex("id")])
	if err != nil {
		return nil, err
	}
	decisionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("decisionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.GetByID(req.Context(), scheduleDefinitionIDParam, idParam, decisionIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AccessReviewDecision, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AccessReviewInstanceMyDecisionsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := a.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/providers/Microsoft\.Authorization/accessReviewScheduleDefinitions/(?P<scheduleDefinitionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<id>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/decisions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		scheduleDefinitionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scheduleDefinitionId")])
		if err != nil {
			return nil, err
		}
		idParam, err := url.PathUnescape(matches[regex.SubexpIndex("id")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armauthorization.AccessReviewInstanceMyDecisionsClientListOptions
		if filterParam != nil {
			options = &armauthorization.AccessReviewInstanceMyDecisionsClientListOptions{
				Filter: filterParam,
			}
		}
		resp := a.srv.NewListPager(scheduleDefinitionIDParam, idParam, options)
		newListPager = &resp
		a.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armauthorization.AccessReviewInstanceMyDecisionsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		a.newListPager.remove(req)
	}
	return resp, nil
}

func (a *AccessReviewInstanceMyDecisionsServerTransport) dispatchPatch(req *http.Request) (*http.Response, error) {
	if a.srv.Patch == nil {
		return nil, &nonRetriableError{errors.New("fake for method Patch not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Authorization/accessReviewScheduleDefinitions/(?P<scheduleDefinitionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances/(?P<id>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/decisions/(?P<decisionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armauthorization.AccessReviewDecisionProperties](req)
	if err != nil {
		return nil, err
	}
	scheduleDefinitionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scheduleDefinitionId")])
	if err != nil {
		return nil, err
	}
	idParam, err := url.PathUnescape(matches[regex.SubexpIndex("id")])
	if err != nil {
		return nil, err
	}
	decisionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("decisionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Patch(req.Context(), scheduleDefinitionIDParam, idParam, decisionIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AccessReviewDecision, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
