// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalize

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateBatchInferenceJob = "CreateBatchInferenceJob"

// CreateBatchInferenceJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateBatchInferenceJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBatchInferenceJob for more information on using the CreateBatchInferenceJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateBatchInferenceJobRequest method.
//	req, resp := client.CreateBatchInferenceJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateBatchInferenceJob
func (c *Personalize) CreateBatchInferenceJobRequest(input *CreateBatchInferenceJobInput) (req *request.Request, output *CreateBatchInferenceJobOutput) {
	op := &request.Operation{
		Name:       opCreateBatchInferenceJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBatchInferenceJobInput{}
	}

	output = &CreateBatchInferenceJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBatchInferenceJob API operation for Amazon Personalize.
//
// Generates batch recommendations based on a list of items or users stored
// in Amazon S3 and exports the recommendations to an Amazon S3 bucket.
//
// To generate batch recommendations, specify the ARN of a solution version
// and an Amazon S3 URI for the input and output data. For user personalization,
// popular items, and personalized ranking solutions, the batch inference job
// generates a list of recommended items for each user ID in the input file.
// For related items solutions, the job generates a list of recommended items
// for each item ID in the input file.
//
// For more information, see Creating a batch inference job (https://docs.aws.amazon.com/personalize/latest/dg/getting-batch-recommendations.html).
//
// If you use the Similar-Items recipe, Amazon Personalize can add descriptive
// themes to batch recommendations. To generate themes, set the job's mode to
// THEME_GENERATION and specify the name of the field that contains item names
// in the input data.
//
// For more information about generating themes, see Batch recommendations with
// themes from Content Generator (https://docs.aws.amazon.com/personalize/latest/dg/themed-batch-recommendations.html).
//
// You can't get batch recommendations with the Trending-Now or Next-Best-Action
// recipes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation CreateBatchInferenceJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceAlreadyExistsException
//     The specified resource already exists.
//
//   - LimitExceededException
//     The limit on the number of requests per second has been exceeded.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
//   - TooManyTagsException
//     You have exceeded the maximum number of tags you can apply to this resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateBatchInferenceJob
func (c *Personalize) CreateBatchInferenceJob(input *CreateBatchInferenceJobInput) (*CreateBatchInferenceJobOutput, error) {
	req, out := c.CreateBatchInferenceJobRequest(input)
	return out, req.Send()
}

// CreateBatchInferenceJobWithContext is the same as CreateBatchInferenceJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBatchInferenceJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) CreateBatchInferenceJobWithContext(ctx aws.Context, input *CreateBatchInferenceJobInput, opts ...request.Option) (*CreateBatchInferenceJobOutput, error) {
	req, out := c.CreateBatchInferenceJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBatchSegmentJob = "CreateBatchSegmentJob"

// CreateBatchSegmentJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateBatchSegmentJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBatchSegmentJob for more information on using the CreateBatchSegmentJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateBatchSegmentJobRequest method.
//	req, resp := client.CreateBatchSegmentJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateBatchSegmentJob
func (c *Personalize) CreateBatchSegmentJobRequest(input *CreateBatchSegmentJobInput) (req *request.Request, output *CreateBatchSegmentJobOutput) {
	op := &request.Operation{
		Name:       opCreateBatchSegmentJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBatchSegmentJobInput{}
	}

	output = &CreateBatchSegmentJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBatchSegmentJob API operation for Amazon Personalize.
//
// Creates a batch segment job. The operation can handle up to 50 million records
// and the input file must be in JSON format. For more information, see Getting
// batch recommendations and user segments (https://docs.aws.amazon.com/personalize/latest/dg/recommendations-batch.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation CreateBatchSegmentJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceAlreadyExistsException
//     The specified resource already exists.
//
//   - LimitExceededException
//     The limit on the number of requests per second has been exceeded.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
//   - TooManyTagsException
//     You have exceeded the maximum number of tags you can apply to this resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateBatchSegmentJob
func (c *Personalize) CreateBatchSegmentJob(input *CreateBatchSegmentJobInput) (*CreateBatchSegmentJobOutput, error) {
	req, out := c.CreateBatchSegmentJobRequest(input)
	return out, req.Send()
}

// CreateBatchSegmentJobWithContext is the same as CreateBatchSegmentJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBatchSegmentJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) CreateBatchSegmentJobWithContext(ctx aws.Context, input *CreateBatchSegmentJobInput, opts ...request.Option) (*CreateBatchSegmentJobOutput, error) {
	req, out := c.CreateBatchSegmentJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCampaign = "CreateCampaign"

// CreateCampaignRequest generates a "aws/request.Request" representing the
// client's request for the CreateCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCampaign for more information on using the CreateCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCampaignRequest method.
//	req, resp := client.CreateCampaignRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateCampaign
func (c *Personalize) CreateCampaignRequest(input *CreateCampaignInput) (req *request.Request, output *CreateCampaignOutput) {
	op := &request.Operation{
		Name:       opCreateCampaign,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCampaignInput{}
	}

	output = &CreateCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCampaign API operation for Amazon Personalize.
//
// Creates a campaign that deploys a solution version. When a client calls the
// GetRecommendations (https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html)
// and GetPersonalizedRanking (https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetPersonalizedRanking.html)
// APIs, a campaign is specified in the request.
//
// # Minimum Provisioned TPS and Auto-Scaling
//
// A high minProvisionedTPS will increase your cost. We recommend starting with
// 1 for minProvisionedTPS (the default). Track your usage using Amazon CloudWatch
// metrics, and increase the minProvisionedTPS as necessary.
//
// When you create an Amazon Personalize campaign, you can specify the minimum
// provisioned transactions per second (minProvisionedTPS) for the campaign.
// This is the baseline transaction throughput for the campaign provisioned
// by Amazon Personalize. It sets the minimum billing charge for the campaign
// while it is active. A transaction is a single GetRecommendations or GetPersonalizedRanking
// request. The default minProvisionedTPS is 1.
//
// If your TPS increases beyond the minProvisionedTPS, Amazon Personalize auto-scales
// the provisioned capacity up and down, but never below minProvisionedTPS.
// There's a short time delay while the capacity is increased that might cause
// loss of transactions. When your traffic reduces, capacity returns to the
// minProvisionedTPS.
//
// You are charged for the the minimum provisioned TPS or, if your requests
// exceed the minProvisionedTPS, the actual TPS. The actual TPS is the total
// number of recommendation requests you make. We recommend starting with a
// low minProvisionedTPS, track your usage using Amazon CloudWatch metrics,
// and then increase the minProvisionedTPS as necessary.
//
// For more information about campaign costs, see Amazon Personalize pricing
// (https://aws.amazon.com/personalize/pricing/).
//
// # Status
//
// A campaign can be in one of the following states:
//
//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
//
//   - DELETE PENDING > DELETE IN_PROGRESS
//
// To get the campaign status, call DescribeCampaign (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html).
//
// Wait until the status of the campaign is ACTIVE before asking the campaign
// for recommendations.
//
// Related APIs
//
//   - ListCampaigns (https://docs.aws.amazon.com/personalize/latest/dg/API_ListCampaigns.html)
//
//   - DescribeCampaign (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html)
//
//   - UpdateCampaign (https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateCampaign.html)
//
//   - DeleteCampaign (https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteCampaign.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation CreateCampaign for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - ResourceAlreadyExistsException
//     The specified resource already exists.
//
//   - LimitExceededException
//     The limit on the number of requests per second has been exceeded.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
//   - TooManyTagsException
//     You have exceeded the maximum number of tags you can apply to this resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateCampaign
func (c *Personalize) CreateCampaign(input *CreateCampaignInput) (*CreateCampaignOutput, error) {
	req, out := c.CreateCampaignRequest(input)
	return out, req.Send()
}

// CreateCampaignWithContext is the same as CreateCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) CreateCampaignWithContext(ctx aws.Context, input *CreateCampaignInput, opts ...request.Option) (*CreateCampaignOutput, error) {
	req, out := c.CreateCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataset = "CreateDataset"

// CreateDatasetRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataset for more information on using the CreateDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDatasetRequest method.
//	req, resp := client.CreateDatasetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateDataset
func (c *Personalize) CreateDatasetRequest(input *CreateDatasetInput) (req *request.Request, output *CreateDatasetOutput) {
	op := &request.Operation{
		Name:       opCreateDataset,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDatasetInput{}
	}

	output = &CreateDatasetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataset API operation for Amazon Personalize.
//
// Creates an empty dataset and adds it to the specified dataset group. Use
// CreateDatasetImportJob (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html)
// to import your training data to a dataset.
//
// There are 5 types of datasets:
//
//   - Item interactions
//
//   - Items
//
//   - Users
//
//   - Action interactions
//
//   - Actions
//
// Each dataset type has an associated schema with required field types. Only
// the Item interactions dataset is required in order to train a model (also
// referred to as creating a solution).
//
// A dataset can be in one of the following states:
//
//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
//
//   - DELETE PENDING > DELETE IN_PROGRESS
//
// To get the status of the dataset, call DescribeDataset (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataset.html).
//
// Related APIs
//
//   - CreateDatasetGroup (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html)
//
//   - ListDatasets (https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasets.html)
//
//   - DescribeDataset (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataset.html)
//
//   - DeleteDataset (https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteDataset.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation CreateDataset for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - ResourceAlreadyExistsException
//     The specified resource already exists.
//
//   - LimitExceededException
//     The limit on the number of requests per second has been exceeded.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
//   - TooManyTagsException
//     You have exceeded the maximum number of tags you can apply to this resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateDataset
func (c *Personalize) CreateDataset(input *CreateDatasetInput) (*CreateDatasetOutput, error) {
	req, out := c.CreateDatasetRequest(input)
	return out, req.Send()
}

// CreateDatasetWithContext is the same as CreateDataset with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) CreateDatasetWithContext(ctx aws.Context, input *CreateDatasetInput, opts ...request.Option) (*CreateDatasetOutput, error) {
	req, out := c.CreateDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDatasetExportJob = "CreateDatasetExportJob"

// CreateDatasetExportJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateDatasetExportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDatasetExportJob for more information on using the CreateDatasetExportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDatasetExportJobRequest method.
//	req, resp := client.CreateDatasetExportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateDatasetExportJob
func (c *Personalize) CreateDatasetExportJobRequest(input *CreateDatasetExportJobInput) (req *request.Request, output *CreateDatasetExportJobOutput) {
	op := &request.Operation{
		Name:       opCreateDatasetExportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDatasetExportJobInput{}
	}

	output = &CreateDatasetExportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDatasetExportJob API operation for Amazon Personalize.
//
// Creates a job that exports data from your dataset to an Amazon S3 bucket.
// To allow Amazon Personalize to export the training data, you must specify
// an service-linked IAM role that gives Amazon Personalize PutObject permissions
// for your Amazon S3 bucket. For information, see Exporting a dataset (https://docs.aws.amazon.com/personalize/latest/dg/export-data.html)
// in the Amazon Personalize developer guide.
//
// # Status
//
// A dataset export job can be in one of the following states:
//
//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
//
// To get the status of the export job, call DescribeDatasetExportJob (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetExportJob.html),
// and specify the Amazon Resource Name (ARN) of the dataset export job. The
// dataset export is complete when the status shows as ACTIVE. If the status
// shows as CREATE FAILED, the response includes a failureReason key, which
// describes why the job failed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation CreateDatasetExportJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - ResourceAlreadyExistsException
//     The specified resource already exists.
//
//   - LimitExceededException
//     The limit on the number of requests per second has been exceeded.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
//   - TooManyTagsException
//     You have exceeded the maximum number of tags you can apply to this resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateDatasetExportJob
func (c *Personalize) CreateDatasetExportJob(input *CreateDatasetExportJobInput) (*CreateDatasetExportJobOutput, error) {
	req, out := c.CreateDatasetExportJobRequest(input)
	return out, req.Send()
}

// CreateDatasetExportJobWithContext is the same as CreateDatasetExportJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDatasetExportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) CreateDatasetExportJobWithContext(ctx aws.Context, input *CreateDatasetExportJobInput, opts ...request.Option) (*CreateDatasetExportJobOutput, error) {
	req, out := c.CreateDatasetExportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDatasetGroup = "CreateDatasetGroup"

// CreateDatasetGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateDatasetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDatasetGroup for more information on using the CreateDatasetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDatasetGroupRequest method.
//	req, resp := client.CreateDatasetGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateDatasetGroup
func (c *Personalize) CreateDatasetGroupRequest(input *CreateDatasetGroupInput) (req *request.Request, output *CreateDatasetGroupOutput) {
	op := &request.Operation{
		Name:       opCreateDatasetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDatasetGroupInput{}
	}

	output = &CreateDatasetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDatasetGroup API operation for Amazon Personalize.
//
// Creates an empty dataset group. A dataset group is a container for Amazon
// Personalize resources. A dataset group can contain at most three datasets,
// one for each type of dataset:
//
//   - Item interactions
//
//   - Items
//
//   - Users
//
//   - Actions
//
//   - Action interactions
//
// A dataset group can be a Domain dataset group, where you specify a domain
// and use pre-configured resources like recommenders, or a Custom dataset group,
// where you use custom resources, such as a solution with a solution version,
// that you deploy with a campaign. If you start with a Domain dataset group,
// you can still add custom resources such as solutions and solution versions
// trained with recipes for custom use cases and deployed with campaigns.
//
// A dataset group can be in one of the following states:
//
//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
//
//   - DELETE PENDING
//
// To get the status of the dataset group, call DescribeDatasetGroup (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetGroup.html).
// If the status shows as CREATE FAILED, the response includes a failureReason
// key, which describes why the creation failed.
//
// You must wait until the status of the dataset group is ACTIVE before adding
// a dataset to the group.
//
// You can specify an Key Management Service (KMS) key to encrypt the datasets
// in the group. If you specify a KMS key, you must also include an Identity
// and Access Management (IAM) role that has permission to access the key.
//
// APIs that require a dataset group ARN in the request
//
//   - CreateDataset (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html)
//
//   - CreateEventTracker (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html)
//
//   - CreateSolution (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html)
//
// Related APIs
//
//   - ListDatasetGroups (https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasetGroups.html)
//
//   - DescribeDatasetGroup (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetGroup.html)
//
//   - DeleteDatasetGroup (https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteDatasetGroup.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation CreateDatasetGroup for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceAlreadyExistsException
//     The specified resource already exists.
//
//   - LimitExceededException
//     The limit on the number of requests per second has been exceeded.
//
//   - TooManyTagsException
//     You have exceeded the maximum number of tags you can apply to this resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateDatasetGroup
func (c *Personalize) CreateDatasetGroup(input *CreateDatasetGroupInput) (*CreateDatasetGroupOutput, error) {
	req, out := c.CreateDatasetGroupRequest(input)
	return out, req.Send()
}

// CreateDatasetGroupWithContext is the same as CreateDatasetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDatasetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) CreateDatasetGroupWithContext(ctx aws.Context, input *CreateDatasetGroupInput, opts ...request.Option) (*CreateDatasetGroupOutput, error) {
	req, out := c.CreateDatasetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDatasetImportJob = "CreateDatasetImportJob"

// CreateDatasetImportJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateDatasetImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDatasetImportJob for more information on using the CreateDatasetImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDatasetImportJobRequest method.
//	req, resp := client.CreateDatasetImportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateDatasetImportJob
func (c *Personalize) CreateDatasetImportJobRequest(input *CreateDatasetImportJobInput) (req *request.Request, output *CreateDatasetImportJobOutput) {
	op := &request.Operation{
		Name:       opCreateDatasetImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDatasetImportJobInput{}
	}

	output = &CreateDatasetImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDatasetImportJob API operation for Amazon Personalize.
//
// Creates a job that imports training data from your data source (an Amazon
// S3 bucket) to an Amazon Personalize dataset. To allow Amazon Personalize
// to import the training data, you must specify an IAM service role that has
// permission to read from the data source, as Amazon Personalize makes a copy
// of your data and processes it internally. For information on granting access
// to your Amazon S3 bucket, see Giving Amazon Personalize Access to Amazon
// S3 Resources (https://docs.aws.amazon.com/personalize/latest/dg/granting-personalize-s3-access.html).
//
// If you already created a recommender or deployed a custom solution version
// with a campaign, how new bulk records influence recommendations depends on
// the domain use case or recipe that you use. For more information, see How
// new data influences real-time recommendations (https://docs.aws.amazon.com/personalize/latest/dg/how-new-data-influences-recommendations.html).
//
// By default, a dataset import job replaces any existing data in the dataset
// that you imported in bulk. To add new records without replacing existing
// data, specify INCREMENTAL for the import mode in the CreateDatasetImportJob
// operation.
//
// # Status
//
// A dataset import job can be in one of the following states:
//
//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
//
// To get the status of the import job, call DescribeDatasetImportJob (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetImportJob.html),
// providing the Amazon Resource Name (ARN) of the dataset import job. The dataset
// import is complete when the status shows as ACTIVE. If the status shows as
// CREATE FAILED, the response includes a failureReason key, which describes
// why the job failed.
//
// Importing takes time. You must wait until the status shows as ACTIVE before
// training a model using the dataset.
//
// Related APIs
//
//   - ListDatasetImportJobs (https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasetImportJobs.html)
//
//   - DescribeDatasetImportJob (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetImportJob.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation CreateDatasetImportJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - ResourceAlreadyExistsException
//     The specified resource already exists.
//
//   - LimitExceededException
//     The limit on the number of requests per second has been exceeded.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
//   - TooManyTagsException
//     You have exceeded the maximum number of tags you can apply to this resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateDatasetImportJob
func (c *Personalize) CreateDatasetImportJob(input *CreateDatasetImportJobInput) (*CreateDatasetImportJobOutput, error) {
	req, out := c.CreateDatasetImportJobRequest(input)
	return out, req.Send()
}

// CreateDatasetImportJobWithContext is the same as CreateDatasetImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDatasetImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) CreateDatasetImportJobWithContext(ctx aws.Context, input *CreateDatasetImportJobInput, opts ...request.Option) (*CreateDatasetImportJobOutput, error) {
	req, out := c.CreateDatasetImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEventTracker = "CreateEventTracker"

// CreateEventTrackerRequest generates a "aws/request.Request" representing the
// client's request for the CreateEventTracker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEventTracker for more information on using the CreateEventTracker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEventTrackerRequest method.
//	req, resp := client.CreateEventTrackerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateEventTracker
func (c *Personalize) CreateEventTrackerRequest(input *CreateEventTrackerInput) (req *request.Request, output *CreateEventTrackerOutput) {
	op := &request.Operation{
		Name:       opCreateEventTracker,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEventTrackerInput{}
	}

	output = &CreateEventTrackerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEventTracker API operation for Amazon Personalize.
//
// Creates an event tracker that you use when adding event data to a specified
// dataset group using the PutEvents (https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html)
// API.
//
// Only one event tracker can be associated with a dataset group. You will get
// an error if you call CreateEventTracker using the same dataset group as an
// existing event tracker.
//
// When you create an event tracker, the response includes a tracking ID, which
// you pass as a parameter when you use the PutEvents (https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html)
// operation. Amazon Personalize then appends the event data to the Item interactions
// dataset of the dataset group you specify in your event tracker.
//
// The event tracker can be in one of the following states:
//
//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
//
//   - DELETE PENDING > DELETE IN_PROGRESS
//
// To get the status of the event tracker, call DescribeEventTracker (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeEventTracker.html).
//
// The event tracker must be in the ACTIVE state before using the tracking ID.
//
// Related APIs
//
//   - ListEventTrackers (https://docs.aws.amazon.com/personalize/latest/dg/API_ListEventTrackers.html)
//
//   - DescribeEventTracker (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeEventTracker.html)
//
//   - DeleteEventTracker (https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteEventTracker.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation CreateEventTracker for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceAlreadyExistsException
//     The specified resource already exists.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - LimitExceededException
//     The limit on the number of requests per second has been exceeded.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
//   - TooManyTagsException
//     You have exceeded the maximum number of tags you can apply to this resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateEventTracker
func (c *Personalize) CreateEventTracker(input *CreateEventTrackerInput) (*CreateEventTrackerOutput, error) {
	req, out := c.CreateEventTrackerRequest(input)
	return out, req.Send()
}

// CreateEventTrackerWithContext is the same as CreateEventTracker with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEventTracker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) CreateEventTrackerWithContext(ctx aws.Context, input *CreateEventTrackerInput, opts ...request.Option) (*CreateEventTrackerOutput, error) {
	req, out := c.CreateEventTrackerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFilter = "CreateFilter"

// CreateFilterRequest generates a "aws/request.Request" representing the
// client's request for the CreateFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFilter for more information on using the CreateFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFilterRequest method.
//	req, resp := client.CreateFilterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateFilter
func (c *Personalize) CreateFilterRequest(input *CreateFilterInput) (req *request.Request, output *CreateFilterOutput) {
	op := &request.Operation{
		Name:       opCreateFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFilterInput{}
	}

	output = &CreateFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFilter API operation for Amazon Personalize.
//
// Creates a recommendation filter. For more information, see Filtering recommendations
// and user segments (https://docs.aws.amazon.com/personalize/latest/dg/filter.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation CreateFilter for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceAlreadyExistsException
//     The specified resource already exists.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - LimitExceededException
//     The limit on the number of requests per second has been exceeded.
//
//   - TooManyTagsException
//     You have exceeded the maximum number of tags you can apply to this resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateFilter
func (c *Personalize) CreateFilter(input *CreateFilterInput) (*CreateFilterOutput, error) {
	req, out := c.CreateFilterRequest(input)
	return out, req.Send()
}

// CreateFilterWithContext is the same as CreateFilter with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) CreateFilterWithContext(ctx aws.Context, input *CreateFilterInput, opts ...request.Option) (*CreateFilterOutput, error) {
	req, out := c.CreateFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMetricAttribution = "CreateMetricAttribution"

// CreateMetricAttributionRequest generates a "aws/request.Request" representing the
// client's request for the CreateMetricAttribution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMetricAttribution for more information on using the CreateMetricAttribution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMetricAttributionRequest method.
//	req, resp := client.CreateMetricAttributionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateMetricAttribution
func (c *Personalize) CreateMetricAttributionRequest(input *CreateMetricAttributionInput) (req *request.Request, output *CreateMetricAttributionOutput) {
	op := &request.Operation{
		Name:       opCreateMetricAttribution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateMetricAttributionInput{}
	}

	output = &CreateMetricAttributionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMetricAttribution API operation for Amazon Personalize.
//
// Creates a metric attribution. A metric attribution creates reports on the
// data that you import into Amazon Personalize. Depending on how you imported
// the data, you can view reports in Amazon CloudWatch or Amazon S3. For more
// information, see Measuring impact of recommendations (https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation CreateMetricAttribution for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - ResourceAlreadyExistsException
//     The specified resource already exists.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
//   - LimitExceededException
//     The limit on the number of requests per second has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateMetricAttribution
func (c *Personalize) CreateMetricAttribution(input *CreateMetricAttributionInput) (*CreateMetricAttributionOutput, error) {
	req, out := c.CreateMetricAttributionRequest(input)
	return out, req.Send()
}

// CreateMetricAttributionWithContext is the same as CreateMetricAttribution with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMetricAttribution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) CreateMetricAttributionWithContext(ctx aws.Context, input *CreateMetricAttributionInput, opts ...request.Option) (*CreateMetricAttributionOutput, error) {
	req, out := c.CreateMetricAttributionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRecommender = "CreateRecommender"

// CreateRecommenderRequest generates a "aws/request.Request" representing the
// client's request for the CreateRecommender operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRecommender for more information on using the CreateRecommender
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRecommenderRequest method.
//	req, resp := client.CreateRecommenderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateRecommender
func (c *Personalize) CreateRecommenderRequest(input *CreateRecommenderInput) (req *request.Request, output *CreateRecommenderOutput) {
	op := &request.Operation{
		Name:       opCreateRecommender,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRecommenderInput{}
	}

	output = &CreateRecommenderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRecommender API operation for Amazon Personalize.
//
// Creates a recommender with the recipe (a Domain dataset group use case) you
// specify. You create recommenders for a Domain dataset group and specify the
// recommender's Amazon Resource Name (ARN) when you make a GetRecommendations
// (https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html)
// request.
//
// # Minimum recommendation requests per second
//
// A high minRecommendationRequestsPerSecond will increase your bill. We recommend
// starting with 1 for minRecommendationRequestsPerSecond (the default). Track
// your usage using Amazon CloudWatch metrics, and increase the minRecommendationRequestsPerSecond
// as necessary.
//
// When you create a recommender, you can configure the recommender's minimum
// recommendation requests per second. The minimum recommendation requests per
// second (minRecommendationRequestsPerSecond) specifies the baseline recommendation
// request throughput provisioned by Amazon Personalize. The default minRecommendationRequestsPerSecond
// is 1. A recommendation request is a single GetRecommendations operation.
// Request throughput is measured in requests per second and Amazon Personalize
// uses your requests per second to derive your requests per hour and the price
// of your recommender usage.
//
// If your requests per second increases beyond minRecommendationRequestsPerSecond,
// Amazon Personalize auto-scales the provisioned capacity up and down, but
// never below minRecommendationRequestsPerSecond. There's a short time delay
// while the capacity is increased that might cause loss of requests.
//
// Your bill is the greater of either the minimum requests per hour (based on
// minRecommendationRequestsPerSecond) or the actual number of requests. The
// actual request throughput used is calculated as the average requests/second
// within a one-hour window. We recommend starting with the default minRecommendationRequestsPerSecond,
// track your usage using Amazon CloudWatch metrics, and then increase the minRecommendationRequestsPerSecond
// as necessary.
//
// # Status
//
// A recommender can be in one of the following states:
//
//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
//
//   - STOP PENDING > STOP IN_PROGRESS > INACTIVE > START PENDING > START IN_PROGRESS
//     > ACTIVE
//
//   - DELETE PENDING > DELETE IN_PROGRESS
//
// To get the recommender status, call DescribeRecommender (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html).
//
// Wait until the status of the recommender is ACTIVE before asking the recommender
// for recommendations.
//
// Related APIs
//
//   - ListRecommenders (https://docs.aws.amazon.com/personalize/latest/dg/API_ListRecommenders.html)
//
//   - DescribeRecommender (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html)
//
//   - UpdateRecommender (https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateRecommender.html)
//
//   - DeleteRecommender (https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteRecommender.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation CreateRecommender for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceAlreadyExistsException
//     The specified resource already exists.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - LimitExceededException
//     The limit on the number of requests per second has been exceeded.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
//   - TooManyTagsException
//     You have exceeded the maximum number of tags you can apply to this resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateRecommender
func (c *Personalize) CreateRecommender(input *CreateRecommenderInput) (*CreateRecommenderOutput, error) {
	req, out := c.CreateRecommenderRequest(input)
	return out, req.Send()
}

// CreateRecommenderWithContext is the same as CreateRecommender with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRecommender for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) CreateRecommenderWithContext(ctx aws.Context, input *CreateRecommenderInput, opts ...request.Option) (*CreateRecommenderOutput, error) {
	req, out := c.CreateRecommenderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSchema = "CreateSchema"

// CreateSchemaRequest generates a "aws/request.Request" representing the
// client's request for the CreateSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSchema for more information on using the CreateSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSchemaRequest method.
//	req, resp := client.CreateSchemaRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateSchema
func (c *Personalize) CreateSchemaRequest(input *CreateSchemaInput) (req *request.Request, output *CreateSchemaOutput) {
	op := &request.Operation{
		Name:       opCreateSchema,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSchemaInput{}
	}

	output = &CreateSchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSchema API operation for Amazon Personalize.
//
// Creates an Amazon Personalize schema from the specified schema string. The
// schema you create must be in Avro JSON format.
//
// Amazon Personalize recognizes three schema variants. Each schema is associated
// with a dataset type and has a set of required field and keywords. If you
// are creating a schema for a dataset in a Domain dataset group, you provide
// the domain of the Domain dataset group. You specify a schema when you call
// CreateDataset (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
//
// Related APIs
//
//   - ListSchemas (https://docs.aws.amazon.com/personalize/latest/dg/API_ListSchemas.html)
//
//   - DescribeSchema (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSchema.html)
//
//   - DeleteSchema (https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSchema.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation CreateSchema for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceAlreadyExistsException
//     The specified resource already exists.
//
//   - LimitExceededException
//     The limit on the number of requests per second has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateSchema
func (c *Personalize) CreateSchema(input *CreateSchemaInput) (*CreateSchemaOutput, error) {
	req, out := c.CreateSchemaRequest(input)
	return out, req.Send()
}

// CreateSchemaWithContext is the same as CreateSchema with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) CreateSchemaWithContext(ctx aws.Context, input *CreateSchemaInput, opts ...request.Option) (*CreateSchemaOutput, error) {
	req, out := c.CreateSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSolution = "CreateSolution"

// CreateSolutionRequest generates a "aws/request.Request" representing the
// client's request for the CreateSolution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSolution for more information on using the CreateSolution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSolutionRequest method.
//	req, resp := client.CreateSolutionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateSolution
func (c *Personalize) CreateSolutionRequest(input *CreateSolutionInput) (req *request.Request, output *CreateSolutionOutput) {
	op := &request.Operation{
		Name:       opCreateSolution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSolutionInput{}
	}

	output = &CreateSolutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSolution API operation for Amazon Personalize.
//
// Creates the configuration for training a model. A trained model is known
// as a solution version. After the configuration is created, you train the
// model (create a solution version) by calling the CreateSolutionVersion (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolutionVersion.html)
// operation. Every time you call CreateSolutionVersion, a new version of the
// solution is created.
//
// After creating a solution version, you check its accuracy by calling GetSolutionMetrics
// (https://docs.aws.amazon.com/personalize/latest/dg/API_GetSolutionMetrics.html).
// When you are satisfied with the version, you deploy it using CreateCampaign
// (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html).
// The campaign provides recommendations to a client through the GetRecommendations
// (https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html)
// API.
//
// To train a model, Amazon Personalize requires training data and a recipe.
// The training data comes from the dataset group that you provide in the request.
// A recipe specifies the training algorithm and a feature transformation. You
// can specify one of the predefined recipes provided by Amazon Personalize.
//
// Amazon Personalize doesn't support configuring the hpoObjective for solution
// hyperparameter optimization at this time.
//
// # Status
//
// A solution can be in one of the following states:
//
//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
//
//   - DELETE PENDING > DELETE IN_PROGRESS
//
// To get the status of the solution, call DescribeSolution (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html).
// Wait until the status shows as ACTIVE before calling CreateSolutionVersion.
//
// Related APIs
//
//   - ListSolutions (https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutions.html)
//
//   - CreateSolutionVersion (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolutionVersion.html)
//
//   - DescribeSolution (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html)
//
//   - DeleteSolution (https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSolution.html)
//
//   - ListSolutionVersions (https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html)
//
//   - DescribeSolutionVersion (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation CreateSolution for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceAlreadyExistsException
//     The specified resource already exists.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - LimitExceededException
//     The limit on the number of requests per second has been exceeded.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
//   - TooManyTagsException
//     You have exceeded the maximum number of tags you can apply to this resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateSolution
func (c *Personalize) CreateSolution(input *CreateSolutionInput) (*CreateSolutionOutput, error) {
	req, out := c.CreateSolutionRequest(input)
	return out, req.Send()
}

// CreateSolutionWithContext is the same as CreateSolution with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSolution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) CreateSolutionWithContext(ctx aws.Context, input *CreateSolutionInput, opts ...request.Option) (*CreateSolutionOutput, error) {
	req, out := c.CreateSolutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSolutionVersion = "CreateSolutionVersion"

// CreateSolutionVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateSolutionVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSolutionVersion for more information on using the CreateSolutionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSolutionVersionRequest method.
//	req, resp := client.CreateSolutionVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateSolutionVersion
func (c *Personalize) CreateSolutionVersionRequest(input *CreateSolutionVersionInput) (req *request.Request, output *CreateSolutionVersionOutput) {
	op := &request.Operation{
		Name:       opCreateSolutionVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSolutionVersionInput{}
	}

	output = &CreateSolutionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSolutionVersion API operation for Amazon Personalize.
//
// Trains or retrains an active solution in a Custom dataset group. A solution
// is created using the CreateSolution (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html)
// operation and must be in the ACTIVE state before calling CreateSolutionVersion.
// A new version of the solution is created every time you call this operation.
//
// # Status
//
// A solution version can be in one of the following states:
//
//   - CREATE PENDING
//
//   - CREATE IN_PROGRESS
//
//   - ACTIVE
//
//   - CREATE FAILED
//
//   - CREATE STOPPING
//
//   - CREATE STOPPED
//
// To get the status of the version, call DescribeSolutionVersion (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html).
// Wait until the status shows as ACTIVE before calling CreateCampaign.
//
// If the status shows as CREATE FAILED, the response includes a failureReason
// key, which describes why the job failed.
//
// Related APIs
//
//   - ListSolutionVersions (https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html)
//
//   - DescribeSolutionVersion (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html)
//
//   - ListSolutions (https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutions.html)
//
//   - CreateSolution (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html)
//
//   - DescribeSolution (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html)
//
//   - DeleteSolution (https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSolution.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation CreateSolutionVersion for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - LimitExceededException
//     The limit on the number of requests per second has been exceeded.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
//   - TooManyTagsException
//     You have exceeded the maximum number of tags you can apply to this resource.
//
//   - ResourceAlreadyExistsException
//     The specified resource already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateSolutionVersion
func (c *Personalize) CreateSolutionVersion(input *CreateSolutionVersionInput) (*CreateSolutionVersionOutput, error) {
	req, out := c.CreateSolutionVersionRequest(input)
	return out, req.Send()
}

// CreateSolutionVersionWithContext is the same as CreateSolutionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSolutionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) CreateSolutionVersionWithContext(ctx aws.Context, input *CreateSolutionVersionInput, opts ...request.Option) (*CreateSolutionVersionOutput, error) {
	req, out := c.CreateSolutionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCampaign = "DeleteCampaign"

// DeleteCampaignRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCampaign for more information on using the DeleteCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCampaignRequest method.
//	req, resp := client.DeleteCampaignRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteCampaign
func (c *Personalize) DeleteCampaignRequest(input *DeleteCampaignInput) (req *request.Request, output *DeleteCampaignOutput) {
	op := &request.Operation{
		Name:       opDeleteCampaign,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCampaignInput{}
	}

	output = &DeleteCampaignOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCampaign API operation for Amazon Personalize.
//
// Removes a campaign by deleting the solution deployment. The solution that
// the campaign is based on is not deleted and can be redeployed when needed.
// A deleted campaign can no longer be specified in a GetRecommendations (https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html)
// request. For information on creating campaigns, see CreateCampaign (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DeleteCampaign for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteCampaign
func (c *Personalize) DeleteCampaign(input *DeleteCampaignInput) (*DeleteCampaignOutput, error) {
	req, out := c.DeleteCampaignRequest(input)
	return out, req.Send()
}

// DeleteCampaignWithContext is the same as DeleteCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DeleteCampaignWithContext(ctx aws.Context, input *DeleteCampaignInput, opts ...request.Option) (*DeleteCampaignOutput, error) {
	req, out := c.DeleteCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataset = "DeleteDataset"

// DeleteDatasetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataset for more information on using the DeleteDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDatasetRequest method.
//	req, resp := client.DeleteDatasetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteDataset
func (c *Personalize) DeleteDatasetRequest(input *DeleteDatasetInput) (req *request.Request, output *DeleteDatasetOutput) {
	op := &request.Operation{
		Name:       opDeleteDataset,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDatasetInput{}
	}

	output = &DeleteDatasetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDataset API operation for Amazon Personalize.
//
// Deletes a dataset. You can't delete a dataset if an associated DatasetImportJob
// or SolutionVersion is in the CREATE PENDING or IN PROGRESS state. For more
// information on datasets, see CreateDataset (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DeleteDataset for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteDataset
func (c *Personalize) DeleteDataset(input *DeleteDatasetInput) (*DeleteDatasetOutput, error) {
	req, out := c.DeleteDatasetRequest(input)
	return out, req.Send()
}

// DeleteDatasetWithContext is the same as DeleteDataset with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DeleteDatasetWithContext(ctx aws.Context, input *DeleteDatasetInput, opts ...request.Option) (*DeleteDatasetOutput, error) {
	req, out := c.DeleteDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDatasetGroup = "DeleteDatasetGroup"

// DeleteDatasetGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDatasetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDatasetGroup for more information on using the DeleteDatasetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDatasetGroupRequest method.
//	req, resp := client.DeleteDatasetGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteDatasetGroup
func (c *Personalize) DeleteDatasetGroupRequest(input *DeleteDatasetGroupInput) (req *request.Request, output *DeleteDatasetGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteDatasetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDatasetGroupInput{}
	}

	output = &DeleteDatasetGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDatasetGroup API operation for Amazon Personalize.
//
// Deletes a dataset group. Before you delete a dataset group, you must delete
// the following:
//
//   - All associated event trackers.
//
//   - All associated solutions.
//
//   - All datasets in the dataset group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DeleteDatasetGroup for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteDatasetGroup
func (c *Personalize) DeleteDatasetGroup(input *DeleteDatasetGroupInput) (*DeleteDatasetGroupOutput, error) {
	req, out := c.DeleteDatasetGroupRequest(input)
	return out, req.Send()
}

// DeleteDatasetGroupWithContext is the same as DeleteDatasetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDatasetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DeleteDatasetGroupWithContext(ctx aws.Context, input *DeleteDatasetGroupInput, opts ...request.Option) (*DeleteDatasetGroupOutput, error) {
	req, out := c.DeleteDatasetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEventTracker = "DeleteEventTracker"

// DeleteEventTrackerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEventTracker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEventTracker for more information on using the DeleteEventTracker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEventTrackerRequest method.
//	req, resp := client.DeleteEventTrackerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteEventTracker
func (c *Personalize) DeleteEventTrackerRequest(input *DeleteEventTrackerInput) (req *request.Request, output *DeleteEventTrackerOutput) {
	op := &request.Operation{
		Name:       opDeleteEventTracker,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEventTrackerInput{}
	}

	output = &DeleteEventTrackerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEventTracker API operation for Amazon Personalize.
//
// Deletes the event tracker. Does not delete the dataset from the dataset group.
// For more information on event trackers, see CreateEventTracker (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DeleteEventTracker for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteEventTracker
func (c *Personalize) DeleteEventTracker(input *DeleteEventTrackerInput) (*DeleteEventTrackerOutput, error) {
	req, out := c.DeleteEventTrackerRequest(input)
	return out, req.Send()
}

// DeleteEventTrackerWithContext is the same as DeleteEventTracker with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEventTracker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DeleteEventTrackerWithContext(ctx aws.Context, input *DeleteEventTrackerInput, opts ...request.Option) (*DeleteEventTrackerOutput, error) {
	req, out := c.DeleteEventTrackerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFilter = "DeleteFilter"

// DeleteFilterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFilter for more information on using the DeleteFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFilterRequest method.
//	req, resp := client.DeleteFilterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteFilter
func (c *Personalize) DeleteFilterRequest(input *DeleteFilterInput) (req *request.Request, output *DeleteFilterOutput) {
	op := &request.Operation{
		Name:       opDeleteFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFilterInput{}
	}

	output = &DeleteFilterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFilter API operation for Amazon Personalize.
//
// Deletes a filter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DeleteFilter for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteFilter
func (c *Personalize) DeleteFilter(input *DeleteFilterInput) (*DeleteFilterOutput, error) {
	req, out := c.DeleteFilterRequest(input)
	return out, req.Send()
}

// DeleteFilterWithContext is the same as DeleteFilter with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DeleteFilterWithContext(ctx aws.Context, input *DeleteFilterInput, opts ...request.Option) (*DeleteFilterOutput, error) {
	req, out := c.DeleteFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMetricAttribution = "DeleteMetricAttribution"

// DeleteMetricAttributionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMetricAttribution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMetricAttribution for more information on using the DeleteMetricAttribution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMetricAttributionRequest method.
//	req, resp := client.DeleteMetricAttributionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteMetricAttribution
func (c *Personalize) DeleteMetricAttributionRequest(input *DeleteMetricAttributionInput) (req *request.Request, output *DeleteMetricAttributionOutput) {
	op := &request.Operation{
		Name:       opDeleteMetricAttribution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMetricAttributionInput{}
	}

	output = &DeleteMetricAttributionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMetricAttribution API operation for Amazon Personalize.
//
// Deletes a metric attribution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DeleteMetricAttribution for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteMetricAttribution
func (c *Personalize) DeleteMetricAttribution(input *DeleteMetricAttributionInput) (*DeleteMetricAttributionOutput, error) {
	req, out := c.DeleteMetricAttributionRequest(input)
	return out, req.Send()
}

// DeleteMetricAttributionWithContext is the same as DeleteMetricAttribution with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMetricAttribution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DeleteMetricAttributionWithContext(ctx aws.Context, input *DeleteMetricAttributionInput, opts ...request.Option) (*DeleteMetricAttributionOutput, error) {
	req, out := c.DeleteMetricAttributionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRecommender = "DeleteRecommender"

// DeleteRecommenderRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRecommender operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRecommender for more information on using the DeleteRecommender
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRecommenderRequest method.
//	req, resp := client.DeleteRecommenderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteRecommender
func (c *Personalize) DeleteRecommenderRequest(input *DeleteRecommenderInput) (req *request.Request, output *DeleteRecommenderOutput) {
	op := &request.Operation{
		Name:       opDeleteRecommender,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRecommenderInput{}
	}

	output = &DeleteRecommenderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRecommender API operation for Amazon Personalize.
//
// Deactivates and removes a recommender. A deleted recommender can no longer
// be specified in a GetRecommendations (https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html)
// request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DeleteRecommender for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteRecommender
func (c *Personalize) DeleteRecommender(input *DeleteRecommenderInput) (*DeleteRecommenderOutput, error) {
	req, out := c.DeleteRecommenderRequest(input)
	return out, req.Send()
}

// DeleteRecommenderWithContext is the same as DeleteRecommender with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRecommender for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DeleteRecommenderWithContext(ctx aws.Context, input *DeleteRecommenderInput, opts ...request.Option) (*DeleteRecommenderOutput, error) {
	req, out := c.DeleteRecommenderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSchema = "DeleteSchema"

// DeleteSchemaRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSchema for more information on using the DeleteSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSchemaRequest method.
//	req, resp := client.DeleteSchemaRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteSchema
func (c *Personalize) DeleteSchemaRequest(input *DeleteSchemaInput) (req *request.Request, output *DeleteSchemaOutput) {
	op := &request.Operation{
		Name:       opDeleteSchema,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSchemaInput{}
	}

	output = &DeleteSchemaOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSchema API operation for Amazon Personalize.
//
// Deletes a schema. Before deleting a schema, you must delete all datasets
// referencing the schema. For more information on schemas, see CreateSchema
// (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DeleteSchema for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteSchema
func (c *Personalize) DeleteSchema(input *DeleteSchemaInput) (*DeleteSchemaOutput, error) {
	req, out := c.DeleteSchemaRequest(input)
	return out, req.Send()
}

// DeleteSchemaWithContext is the same as DeleteSchema with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DeleteSchemaWithContext(ctx aws.Context, input *DeleteSchemaInput, opts ...request.Option) (*DeleteSchemaOutput, error) {
	req, out := c.DeleteSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSolution = "DeleteSolution"

// DeleteSolutionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSolution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSolution for more information on using the DeleteSolution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSolutionRequest method.
//	req, resp := client.DeleteSolutionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteSolution
func (c *Personalize) DeleteSolutionRequest(input *DeleteSolutionInput) (req *request.Request, output *DeleteSolutionOutput) {
	op := &request.Operation{
		Name:       opDeleteSolution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSolutionInput{}
	}

	output = &DeleteSolutionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSolution API operation for Amazon Personalize.
//
// Deletes all versions of a solution and the Solution object itself. Before
// deleting a solution, you must delete all campaigns based on the solution.
// To determine what campaigns are using the solution, call ListCampaigns (https://docs.aws.amazon.com/personalize/latest/dg/API_ListCampaigns.html)
// and supply the Amazon Resource Name (ARN) of the solution. You can't delete
// a solution if an associated SolutionVersion is in the CREATE PENDING or IN
// PROGRESS state. For more information on solutions, see CreateSolution (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DeleteSolution for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteSolution
func (c *Personalize) DeleteSolution(input *DeleteSolutionInput) (*DeleteSolutionOutput, error) {
	req, out := c.DeleteSolutionRequest(input)
	return out, req.Send()
}

// DeleteSolutionWithContext is the same as DeleteSolution with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSolution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DeleteSolutionWithContext(ctx aws.Context, input *DeleteSolutionInput, opts ...request.Option) (*DeleteSolutionOutput, error) {
	req, out := c.DeleteSolutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAlgorithm = "DescribeAlgorithm"

// DescribeAlgorithmRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAlgorithm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAlgorithm for more information on using the DescribeAlgorithm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAlgorithmRequest method.
//	req, resp := client.DescribeAlgorithmRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeAlgorithm
func (c *Personalize) DescribeAlgorithmRequest(input *DescribeAlgorithmInput) (req *request.Request, output *DescribeAlgorithmOutput) {
	op := &request.Operation{
		Name:       opDescribeAlgorithm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAlgorithmInput{}
	}

	output = &DescribeAlgorithmOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAlgorithm API operation for Amazon Personalize.
//
// Describes the given algorithm.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DescribeAlgorithm for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeAlgorithm
func (c *Personalize) DescribeAlgorithm(input *DescribeAlgorithmInput) (*DescribeAlgorithmOutput, error) {
	req, out := c.DescribeAlgorithmRequest(input)
	return out, req.Send()
}

// DescribeAlgorithmWithContext is the same as DescribeAlgorithm with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAlgorithm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DescribeAlgorithmWithContext(ctx aws.Context, input *DescribeAlgorithmInput, opts ...request.Option) (*DescribeAlgorithmOutput, error) {
	req, out := c.DescribeAlgorithmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBatchInferenceJob = "DescribeBatchInferenceJob"

// DescribeBatchInferenceJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBatchInferenceJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBatchInferenceJob for more information on using the DescribeBatchInferenceJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeBatchInferenceJobRequest method.
//	req, resp := client.DescribeBatchInferenceJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeBatchInferenceJob
func (c *Personalize) DescribeBatchInferenceJobRequest(input *DescribeBatchInferenceJobInput) (req *request.Request, output *DescribeBatchInferenceJobOutput) {
	op := &request.Operation{
		Name:       opDescribeBatchInferenceJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeBatchInferenceJobInput{}
	}

	output = &DescribeBatchInferenceJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBatchInferenceJob API operation for Amazon Personalize.
//
// Gets the properties of a batch inference job including name, Amazon Resource
// Name (ARN), status, input and output configurations, and the ARN of the solution
// version used to generate the recommendations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DescribeBatchInferenceJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeBatchInferenceJob
func (c *Personalize) DescribeBatchInferenceJob(input *DescribeBatchInferenceJobInput) (*DescribeBatchInferenceJobOutput, error) {
	req, out := c.DescribeBatchInferenceJobRequest(input)
	return out, req.Send()
}

// DescribeBatchInferenceJobWithContext is the same as DescribeBatchInferenceJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBatchInferenceJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DescribeBatchInferenceJobWithContext(ctx aws.Context, input *DescribeBatchInferenceJobInput, opts ...request.Option) (*DescribeBatchInferenceJobOutput, error) {
	req, out := c.DescribeBatchInferenceJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBatchSegmentJob = "DescribeBatchSegmentJob"

// DescribeBatchSegmentJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBatchSegmentJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBatchSegmentJob for more information on using the DescribeBatchSegmentJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeBatchSegmentJobRequest method.
//	req, resp := client.DescribeBatchSegmentJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeBatchSegmentJob
func (c *Personalize) DescribeBatchSegmentJobRequest(input *DescribeBatchSegmentJobInput) (req *request.Request, output *DescribeBatchSegmentJobOutput) {
	op := &request.Operation{
		Name:       opDescribeBatchSegmentJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeBatchSegmentJobInput{}
	}

	output = &DescribeBatchSegmentJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBatchSegmentJob API operation for Amazon Personalize.
//
// Gets the properties of a batch segment job including name, Amazon Resource
// Name (ARN), status, input and output configurations, and the ARN of the solution
// version used to generate segments.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DescribeBatchSegmentJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeBatchSegmentJob
func (c *Personalize) DescribeBatchSegmentJob(input *DescribeBatchSegmentJobInput) (*DescribeBatchSegmentJobOutput, error) {
	req, out := c.DescribeBatchSegmentJobRequest(input)
	return out, req.Send()
}

// DescribeBatchSegmentJobWithContext is the same as DescribeBatchSegmentJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBatchSegmentJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DescribeBatchSegmentJobWithContext(ctx aws.Context, input *DescribeBatchSegmentJobInput, opts ...request.Option) (*DescribeBatchSegmentJobOutput, error) {
	req, out := c.DescribeBatchSegmentJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCampaign = "DescribeCampaign"

// DescribeCampaignRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCampaign for more information on using the DescribeCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeCampaignRequest method.
//	req, resp := client.DescribeCampaignRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeCampaign
func (c *Personalize) DescribeCampaignRequest(input *DescribeCampaignInput) (req *request.Request, output *DescribeCampaignOutput) {
	op := &request.Operation{
		Name:       opDescribeCampaign,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCampaignInput{}
	}

	output = &DescribeCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCampaign API operation for Amazon Personalize.
//
// Describes the given campaign, including its status.
//
// A campaign can be in one of the following states:
//
//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
//
//   - DELETE PENDING > DELETE IN_PROGRESS
//
// When the status is CREATE FAILED, the response includes the failureReason
// key, which describes why.
//
// For more information on campaigns, see CreateCampaign (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DescribeCampaign for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeCampaign
func (c *Personalize) DescribeCampaign(input *DescribeCampaignInput) (*DescribeCampaignOutput, error) {
	req, out := c.DescribeCampaignRequest(input)
	return out, req.Send()
}

// DescribeCampaignWithContext is the same as DescribeCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DescribeCampaignWithContext(ctx aws.Context, input *DescribeCampaignInput, opts ...request.Option) (*DescribeCampaignOutput, error) {
	req, out := c.DescribeCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataset = "DescribeDataset"

// DescribeDatasetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataset for more information on using the DescribeDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDatasetRequest method.
//	req, resp := client.DescribeDatasetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeDataset
func (c *Personalize) DescribeDatasetRequest(input *DescribeDatasetInput) (req *request.Request, output *DescribeDatasetOutput) {
	op := &request.Operation{
		Name:       opDescribeDataset,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDatasetInput{}
	}

	output = &DescribeDatasetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataset API operation for Amazon Personalize.
//
// Describes the given dataset. For more information on datasets, see CreateDataset
// (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DescribeDataset for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeDataset
func (c *Personalize) DescribeDataset(input *DescribeDatasetInput) (*DescribeDatasetOutput, error) {
	req, out := c.DescribeDatasetRequest(input)
	return out, req.Send()
}

// DescribeDatasetWithContext is the same as DescribeDataset with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DescribeDatasetWithContext(ctx aws.Context, input *DescribeDatasetInput, opts ...request.Option) (*DescribeDatasetOutput, error) {
	req, out := c.DescribeDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDatasetExportJob = "DescribeDatasetExportJob"

// DescribeDatasetExportJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDatasetExportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDatasetExportJob for more information on using the DescribeDatasetExportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDatasetExportJobRequest method.
//	req, resp := client.DescribeDatasetExportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeDatasetExportJob
func (c *Personalize) DescribeDatasetExportJobRequest(input *DescribeDatasetExportJobInput) (req *request.Request, output *DescribeDatasetExportJobOutput) {
	op := &request.Operation{
		Name:       opDescribeDatasetExportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDatasetExportJobInput{}
	}

	output = &DescribeDatasetExportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDatasetExportJob API operation for Amazon Personalize.
//
// Describes the dataset export job created by CreateDatasetExportJob (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetExportJob.html),
// including the export job status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DescribeDatasetExportJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeDatasetExportJob
func (c *Personalize) DescribeDatasetExportJob(input *DescribeDatasetExportJobInput) (*DescribeDatasetExportJobOutput, error) {
	req, out := c.DescribeDatasetExportJobRequest(input)
	return out, req.Send()
}

// DescribeDatasetExportJobWithContext is the same as DescribeDatasetExportJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDatasetExportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DescribeDatasetExportJobWithContext(ctx aws.Context, input *DescribeDatasetExportJobInput, opts ...request.Option) (*DescribeDatasetExportJobOutput, error) {
	req, out := c.DescribeDatasetExportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDatasetGroup = "DescribeDatasetGroup"

// DescribeDatasetGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDatasetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDatasetGroup for more information on using the DescribeDatasetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDatasetGroupRequest method.
//	req, resp := client.DescribeDatasetGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeDatasetGroup
func (c *Personalize) DescribeDatasetGroupRequest(input *DescribeDatasetGroupInput) (req *request.Request, output *DescribeDatasetGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeDatasetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDatasetGroupInput{}
	}

	output = &DescribeDatasetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDatasetGroup API operation for Amazon Personalize.
//
// Describes the given dataset group. For more information on dataset groups,
// see CreateDatasetGroup (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DescribeDatasetGroup for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeDatasetGroup
func (c *Personalize) DescribeDatasetGroup(input *DescribeDatasetGroupInput) (*DescribeDatasetGroupOutput, error) {
	req, out := c.DescribeDatasetGroupRequest(input)
	return out, req.Send()
}

// DescribeDatasetGroupWithContext is the same as DescribeDatasetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDatasetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DescribeDatasetGroupWithContext(ctx aws.Context, input *DescribeDatasetGroupInput, opts ...request.Option) (*DescribeDatasetGroupOutput, error) {
	req, out := c.DescribeDatasetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDatasetImportJob = "DescribeDatasetImportJob"

// DescribeDatasetImportJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDatasetImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDatasetImportJob for more information on using the DescribeDatasetImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDatasetImportJobRequest method.
//	req, resp := client.DescribeDatasetImportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeDatasetImportJob
func (c *Personalize) DescribeDatasetImportJobRequest(input *DescribeDatasetImportJobInput) (req *request.Request, output *DescribeDatasetImportJobOutput) {
	op := &request.Operation{
		Name:       opDescribeDatasetImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDatasetImportJobInput{}
	}

	output = &DescribeDatasetImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDatasetImportJob API operation for Amazon Personalize.
//
// Describes the dataset import job created by CreateDatasetImportJob (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html),
// including the import job status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DescribeDatasetImportJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeDatasetImportJob
func (c *Personalize) DescribeDatasetImportJob(input *DescribeDatasetImportJobInput) (*DescribeDatasetImportJobOutput, error) {
	req, out := c.DescribeDatasetImportJobRequest(input)
	return out, req.Send()
}

// DescribeDatasetImportJobWithContext is the same as DescribeDatasetImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDatasetImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DescribeDatasetImportJobWithContext(ctx aws.Context, input *DescribeDatasetImportJobInput, opts ...request.Option) (*DescribeDatasetImportJobOutput, error) {
	req, out := c.DescribeDatasetImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEventTracker = "DescribeEventTracker"

// DescribeEventTrackerRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventTracker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEventTracker for more information on using the DescribeEventTracker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEventTrackerRequest method.
//	req, resp := client.DescribeEventTrackerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeEventTracker
func (c *Personalize) DescribeEventTrackerRequest(input *DescribeEventTrackerInput) (req *request.Request, output *DescribeEventTrackerOutput) {
	op := &request.Operation{
		Name:       opDescribeEventTracker,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEventTrackerInput{}
	}

	output = &DescribeEventTrackerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventTracker API operation for Amazon Personalize.
//
// Describes an event tracker. The response includes the trackingId and status
// of the event tracker. For more information on event trackers, see CreateEventTracker
// (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DescribeEventTracker for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeEventTracker
func (c *Personalize) DescribeEventTracker(input *DescribeEventTrackerInput) (*DescribeEventTrackerOutput, error) {
	req, out := c.DescribeEventTrackerRequest(input)
	return out, req.Send()
}

// DescribeEventTrackerWithContext is the same as DescribeEventTracker with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEventTracker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DescribeEventTrackerWithContext(ctx aws.Context, input *DescribeEventTrackerInput, opts ...request.Option) (*DescribeEventTrackerOutput, error) {
	req, out := c.DescribeEventTrackerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFeatureTransformation = "DescribeFeatureTransformation"

// DescribeFeatureTransformationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFeatureTransformation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFeatureTransformation for more information on using the DescribeFeatureTransformation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFeatureTransformationRequest method.
//	req, resp := client.DescribeFeatureTransformationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeFeatureTransformation
func (c *Personalize) DescribeFeatureTransformationRequest(input *DescribeFeatureTransformationInput) (req *request.Request, output *DescribeFeatureTransformationOutput) {
	op := &request.Operation{
		Name:       opDescribeFeatureTransformation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFeatureTransformationInput{}
	}

	output = &DescribeFeatureTransformationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFeatureTransformation API operation for Amazon Personalize.
//
// Describes the given feature transformation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DescribeFeatureTransformation for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeFeatureTransformation
func (c *Personalize) DescribeFeatureTransformation(input *DescribeFeatureTransformationInput) (*DescribeFeatureTransformationOutput, error) {
	req, out := c.DescribeFeatureTransformationRequest(input)
	return out, req.Send()
}

// DescribeFeatureTransformationWithContext is the same as DescribeFeatureTransformation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFeatureTransformation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DescribeFeatureTransformationWithContext(ctx aws.Context, input *DescribeFeatureTransformationInput, opts ...request.Option) (*DescribeFeatureTransformationOutput, error) {
	req, out := c.DescribeFeatureTransformationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFilter = "DescribeFilter"

// DescribeFilterRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFilter for more information on using the DescribeFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFilterRequest method.
//	req, resp := client.DescribeFilterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeFilter
func (c *Personalize) DescribeFilterRequest(input *DescribeFilterInput) (req *request.Request, output *DescribeFilterOutput) {
	op := &request.Operation{
		Name:       opDescribeFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFilterInput{}
	}

	output = &DescribeFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFilter API operation for Amazon Personalize.
//
// Describes a filter's properties.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DescribeFilter for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeFilter
func (c *Personalize) DescribeFilter(input *DescribeFilterInput) (*DescribeFilterOutput, error) {
	req, out := c.DescribeFilterRequest(input)
	return out, req.Send()
}

// DescribeFilterWithContext is the same as DescribeFilter with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DescribeFilterWithContext(ctx aws.Context, input *DescribeFilterInput, opts ...request.Option) (*DescribeFilterOutput, error) {
	req, out := c.DescribeFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMetricAttribution = "DescribeMetricAttribution"

// DescribeMetricAttributionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMetricAttribution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMetricAttribution for more information on using the DescribeMetricAttribution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeMetricAttributionRequest method.
//	req, resp := client.DescribeMetricAttributionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeMetricAttribution
func (c *Personalize) DescribeMetricAttributionRequest(input *DescribeMetricAttributionInput) (req *request.Request, output *DescribeMetricAttributionOutput) {
	op := &request.Operation{
		Name:       opDescribeMetricAttribution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMetricAttributionInput{}
	}

	output = &DescribeMetricAttributionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMetricAttribution API operation for Amazon Personalize.
//
// Describes a metric attribution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DescribeMetricAttribution for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeMetricAttribution
func (c *Personalize) DescribeMetricAttribution(input *DescribeMetricAttributionInput) (*DescribeMetricAttributionOutput, error) {
	req, out := c.DescribeMetricAttributionRequest(input)
	return out, req.Send()
}

// DescribeMetricAttributionWithContext is the same as DescribeMetricAttribution with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMetricAttribution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DescribeMetricAttributionWithContext(ctx aws.Context, input *DescribeMetricAttributionInput, opts ...request.Option) (*DescribeMetricAttributionOutput, error) {
	req, out := c.DescribeMetricAttributionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRecipe = "DescribeRecipe"

// DescribeRecipeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRecipe operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRecipe for more information on using the DescribeRecipe
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeRecipeRequest method.
//	req, resp := client.DescribeRecipeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeRecipe
func (c *Personalize) DescribeRecipeRequest(input *DescribeRecipeInput) (req *request.Request, output *DescribeRecipeOutput) {
	op := &request.Operation{
		Name:       opDescribeRecipe,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRecipeInput{}
	}

	output = &DescribeRecipeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRecipe API operation for Amazon Personalize.
//
// Describes a recipe.
//
// A recipe contains three items:
//
//   - An algorithm that trains a model.
//
//   - Hyperparameters that govern the training.
//
//   - Feature transformation information for modifying the input data before
//     training.
//
// Amazon Personalize provides a set of predefined recipes. You specify a recipe
// when you create a solution with the CreateSolution (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html)
// API. CreateSolution trains a model by using the algorithm in the specified
// recipe and a training dataset. The solution, when deployed as a campaign,
// can provide recommendations using the GetRecommendations (https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html)
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DescribeRecipe for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeRecipe
func (c *Personalize) DescribeRecipe(input *DescribeRecipeInput) (*DescribeRecipeOutput, error) {
	req, out := c.DescribeRecipeRequest(input)
	return out, req.Send()
}

// DescribeRecipeWithContext is the same as DescribeRecipe with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRecipe for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DescribeRecipeWithContext(ctx aws.Context, input *DescribeRecipeInput, opts ...request.Option) (*DescribeRecipeOutput, error) {
	req, out := c.DescribeRecipeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRecommender = "DescribeRecommender"

// DescribeRecommenderRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRecommender operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRecommender for more information on using the DescribeRecommender
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeRecommenderRequest method.
//	req, resp := client.DescribeRecommenderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeRecommender
func (c *Personalize) DescribeRecommenderRequest(input *DescribeRecommenderInput) (req *request.Request, output *DescribeRecommenderOutput) {
	op := &request.Operation{
		Name:       opDescribeRecommender,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRecommenderInput{}
	}

	output = &DescribeRecommenderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRecommender API operation for Amazon Personalize.
//
// Describes the given recommender, including its status.
//
// A recommender can be in one of the following states:
//
//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
//
//   - STOP PENDING > STOP IN_PROGRESS > INACTIVE > START PENDING > START IN_PROGRESS
//     > ACTIVE
//
//   - DELETE PENDING > DELETE IN_PROGRESS
//
// When the status is CREATE FAILED, the response includes the failureReason
// key, which describes why.
//
// The modelMetrics key is null when the recommender is being created or deleted.
//
// For more information on recommenders, see CreateRecommender (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateRecommender.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DescribeRecommender for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeRecommender
func (c *Personalize) DescribeRecommender(input *DescribeRecommenderInput) (*DescribeRecommenderOutput, error) {
	req, out := c.DescribeRecommenderRequest(input)
	return out, req.Send()
}

// DescribeRecommenderWithContext is the same as DescribeRecommender with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRecommender for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DescribeRecommenderWithContext(ctx aws.Context, input *DescribeRecommenderInput, opts ...request.Option) (*DescribeRecommenderOutput, error) {
	req, out := c.DescribeRecommenderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSchema = "DescribeSchema"

// DescribeSchemaRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSchema for more information on using the DescribeSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSchemaRequest method.
//	req, resp := client.DescribeSchemaRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeSchema
func (c *Personalize) DescribeSchemaRequest(input *DescribeSchemaInput) (req *request.Request, output *DescribeSchemaOutput) {
	op := &request.Operation{
		Name:       opDescribeSchema,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSchemaInput{}
	}

	output = &DescribeSchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSchema API operation for Amazon Personalize.
//
// Describes a schema. For more information on schemas, see CreateSchema (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DescribeSchema for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeSchema
func (c *Personalize) DescribeSchema(input *DescribeSchemaInput) (*DescribeSchemaOutput, error) {
	req, out := c.DescribeSchemaRequest(input)
	return out, req.Send()
}

// DescribeSchemaWithContext is the same as DescribeSchema with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DescribeSchemaWithContext(ctx aws.Context, input *DescribeSchemaInput, opts ...request.Option) (*DescribeSchemaOutput, error) {
	req, out := c.DescribeSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSolution = "DescribeSolution"

// DescribeSolutionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSolution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSolution for more information on using the DescribeSolution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSolutionRequest method.
//	req, resp := client.DescribeSolutionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeSolution
func (c *Personalize) DescribeSolutionRequest(input *DescribeSolutionInput) (req *request.Request, output *DescribeSolutionOutput) {
	op := &request.Operation{
		Name:       opDescribeSolution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSolutionInput{}
	}

	output = &DescribeSolutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSolution API operation for Amazon Personalize.
//
// Describes a solution. For more information on solutions, see CreateSolution
// (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DescribeSolution for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeSolution
func (c *Personalize) DescribeSolution(input *DescribeSolutionInput) (*DescribeSolutionOutput, error) {
	req, out := c.DescribeSolutionRequest(input)
	return out, req.Send()
}

// DescribeSolutionWithContext is the same as DescribeSolution with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSolution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DescribeSolutionWithContext(ctx aws.Context, input *DescribeSolutionInput, opts ...request.Option) (*DescribeSolutionOutput, error) {
	req, out := c.DescribeSolutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSolutionVersion = "DescribeSolutionVersion"

// DescribeSolutionVersionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSolutionVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSolutionVersion for more information on using the DescribeSolutionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSolutionVersionRequest method.
//	req, resp := client.DescribeSolutionVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeSolutionVersion
func (c *Personalize) DescribeSolutionVersionRequest(input *DescribeSolutionVersionInput) (req *request.Request, output *DescribeSolutionVersionOutput) {
	op := &request.Operation{
		Name:       opDescribeSolutionVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSolutionVersionInput{}
	}

	output = &DescribeSolutionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSolutionVersion API operation for Amazon Personalize.
//
// Describes a specific version of a solution. For more information on solutions,
// see CreateSolution (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation DescribeSolutionVersion for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeSolutionVersion
func (c *Personalize) DescribeSolutionVersion(input *DescribeSolutionVersionInput) (*DescribeSolutionVersionOutput, error) {
	req, out := c.DescribeSolutionVersionRequest(input)
	return out, req.Send()
}

// DescribeSolutionVersionWithContext is the same as DescribeSolutionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSolutionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) DescribeSolutionVersionWithContext(ctx aws.Context, input *DescribeSolutionVersionInput, opts ...request.Option) (*DescribeSolutionVersionOutput, error) {
	req, out := c.DescribeSolutionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSolutionMetrics = "GetSolutionMetrics"

// GetSolutionMetricsRequest generates a "aws/request.Request" representing the
// client's request for the GetSolutionMetrics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSolutionMetrics for more information on using the GetSolutionMetrics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSolutionMetricsRequest method.
//	req, resp := client.GetSolutionMetricsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/GetSolutionMetrics
func (c *Personalize) GetSolutionMetricsRequest(input *GetSolutionMetricsInput) (req *request.Request, output *GetSolutionMetricsOutput) {
	op := &request.Operation{
		Name:       opGetSolutionMetrics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSolutionMetricsInput{}
	}

	output = &GetSolutionMetricsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSolutionMetrics API operation for Amazon Personalize.
//
// Gets the metrics for the specified solution version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation GetSolutionMetrics for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/GetSolutionMetrics
func (c *Personalize) GetSolutionMetrics(input *GetSolutionMetricsInput) (*GetSolutionMetricsOutput, error) {
	req, out := c.GetSolutionMetricsRequest(input)
	return out, req.Send()
}

// GetSolutionMetricsWithContext is the same as GetSolutionMetrics with the addition of
// the ability to pass a context and additional request options.
//
// See GetSolutionMetrics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) GetSolutionMetricsWithContext(ctx aws.Context, input *GetSolutionMetricsInput, opts ...request.Option) (*GetSolutionMetricsOutput, error) {
	req, out := c.GetSolutionMetricsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBatchInferenceJobs = "ListBatchInferenceJobs"

// ListBatchInferenceJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListBatchInferenceJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBatchInferenceJobs for more information on using the ListBatchInferenceJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBatchInferenceJobsRequest method.
//	req, resp := client.ListBatchInferenceJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListBatchInferenceJobs
func (c *Personalize) ListBatchInferenceJobsRequest(input *ListBatchInferenceJobsInput) (req *request.Request, output *ListBatchInferenceJobsOutput) {
	op := &request.Operation{
		Name:       opListBatchInferenceJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBatchInferenceJobsInput{}
	}

	output = &ListBatchInferenceJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBatchInferenceJobs API operation for Amazon Personalize.
//
// Gets a list of the batch inference jobs that have been performed off of a
// solution version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation ListBatchInferenceJobs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - InvalidNextTokenException
//     The token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListBatchInferenceJobs
func (c *Personalize) ListBatchInferenceJobs(input *ListBatchInferenceJobsInput) (*ListBatchInferenceJobsOutput, error) {
	req, out := c.ListBatchInferenceJobsRequest(input)
	return out, req.Send()
}

// ListBatchInferenceJobsWithContext is the same as ListBatchInferenceJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListBatchInferenceJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListBatchInferenceJobsWithContext(ctx aws.Context, input *ListBatchInferenceJobsInput, opts ...request.Option) (*ListBatchInferenceJobsOutput, error) {
	req, out := c.ListBatchInferenceJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBatchInferenceJobsPages iterates over the pages of a ListBatchInferenceJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBatchInferenceJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBatchInferenceJobs operation.
//	pageNum := 0
//	err := client.ListBatchInferenceJobsPages(params,
//	    func(page *personalize.ListBatchInferenceJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Personalize) ListBatchInferenceJobsPages(input *ListBatchInferenceJobsInput, fn func(*ListBatchInferenceJobsOutput, bool) bool) error {
	return c.ListBatchInferenceJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBatchInferenceJobsPagesWithContext same as ListBatchInferenceJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListBatchInferenceJobsPagesWithContext(ctx aws.Context, input *ListBatchInferenceJobsInput, fn func(*ListBatchInferenceJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBatchInferenceJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBatchInferenceJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBatchInferenceJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBatchSegmentJobs = "ListBatchSegmentJobs"

// ListBatchSegmentJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListBatchSegmentJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBatchSegmentJobs for more information on using the ListBatchSegmentJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBatchSegmentJobsRequest method.
//	req, resp := client.ListBatchSegmentJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListBatchSegmentJobs
func (c *Personalize) ListBatchSegmentJobsRequest(input *ListBatchSegmentJobsInput) (req *request.Request, output *ListBatchSegmentJobsOutput) {
	op := &request.Operation{
		Name:       opListBatchSegmentJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBatchSegmentJobsInput{}
	}

	output = &ListBatchSegmentJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBatchSegmentJobs API operation for Amazon Personalize.
//
// Gets a list of the batch segment jobs that have been performed off of a solution
// version that you specify.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation ListBatchSegmentJobs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - InvalidNextTokenException
//     The token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListBatchSegmentJobs
func (c *Personalize) ListBatchSegmentJobs(input *ListBatchSegmentJobsInput) (*ListBatchSegmentJobsOutput, error) {
	req, out := c.ListBatchSegmentJobsRequest(input)
	return out, req.Send()
}

// ListBatchSegmentJobsWithContext is the same as ListBatchSegmentJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListBatchSegmentJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListBatchSegmentJobsWithContext(ctx aws.Context, input *ListBatchSegmentJobsInput, opts ...request.Option) (*ListBatchSegmentJobsOutput, error) {
	req, out := c.ListBatchSegmentJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBatchSegmentJobsPages iterates over the pages of a ListBatchSegmentJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBatchSegmentJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBatchSegmentJobs operation.
//	pageNum := 0
//	err := client.ListBatchSegmentJobsPages(params,
//	    func(page *personalize.ListBatchSegmentJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Personalize) ListBatchSegmentJobsPages(input *ListBatchSegmentJobsInput, fn func(*ListBatchSegmentJobsOutput, bool) bool) error {
	return c.ListBatchSegmentJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBatchSegmentJobsPagesWithContext same as ListBatchSegmentJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListBatchSegmentJobsPagesWithContext(ctx aws.Context, input *ListBatchSegmentJobsInput, fn func(*ListBatchSegmentJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBatchSegmentJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBatchSegmentJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBatchSegmentJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCampaigns = "ListCampaigns"

// ListCampaignsRequest generates a "aws/request.Request" representing the
// client's request for the ListCampaigns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCampaigns for more information on using the ListCampaigns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCampaignsRequest method.
//	req, resp := client.ListCampaignsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListCampaigns
func (c *Personalize) ListCampaignsRequest(input *ListCampaignsInput) (req *request.Request, output *ListCampaignsOutput) {
	op := &request.Operation{
		Name:       opListCampaigns,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCampaignsInput{}
	}

	output = &ListCampaignsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCampaigns API operation for Amazon Personalize.
//
// Returns a list of campaigns that use the given solution. When a solution
// is not specified, all the campaigns associated with the account are listed.
// The response provides the properties for each campaign, including the Amazon
// Resource Name (ARN). For more information on campaigns, see CreateCampaign
// (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation ListCampaigns for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - InvalidNextTokenException
//     The token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListCampaigns
func (c *Personalize) ListCampaigns(input *ListCampaignsInput) (*ListCampaignsOutput, error) {
	req, out := c.ListCampaignsRequest(input)
	return out, req.Send()
}

// ListCampaignsWithContext is the same as ListCampaigns with the addition of
// the ability to pass a context and additional request options.
//
// See ListCampaigns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListCampaignsWithContext(ctx aws.Context, input *ListCampaignsInput, opts ...request.Option) (*ListCampaignsOutput, error) {
	req, out := c.ListCampaignsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCampaignsPages iterates over the pages of a ListCampaigns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCampaigns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCampaigns operation.
//	pageNum := 0
//	err := client.ListCampaignsPages(params,
//	    func(page *personalize.ListCampaignsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Personalize) ListCampaignsPages(input *ListCampaignsInput, fn func(*ListCampaignsOutput, bool) bool) error {
	return c.ListCampaignsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCampaignsPagesWithContext same as ListCampaignsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListCampaignsPagesWithContext(ctx aws.Context, input *ListCampaignsInput, fn func(*ListCampaignsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCampaignsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCampaignsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCampaignsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDatasetExportJobs = "ListDatasetExportJobs"

// ListDatasetExportJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListDatasetExportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDatasetExportJobs for more information on using the ListDatasetExportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDatasetExportJobsRequest method.
//	req, resp := client.ListDatasetExportJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasetExportJobs
func (c *Personalize) ListDatasetExportJobsRequest(input *ListDatasetExportJobsInput) (req *request.Request, output *ListDatasetExportJobsOutput) {
	op := &request.Operation{
		Name:       opListDatasetExportJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatasetExportJobsInput{}
	}

	output = &ListDatasetExportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDatasetExportJobs API operation for Amazon Personalize.
//
// Returns a list of dataset export jobs that use the given dataset. When a
// dataset is not specified, all the dataset export jobs associated with the
// account are listed. The response provides the properties for each dataset
// export job, including the Amazon Resource Name (ARN). For more information
// on dataset export jobs, see CreateDatasetExportJob (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetExportJob.html).
// For more information on datasets, see CreateDataset (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation ListDatasetExportJobs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - InvalidNextTokenException
//     The token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasetExportJobs
func (c *Personalize) ListDatasetExportJobs(input *ListDatasetExportJobsInput) (*ListDatasetExportJobsOutput, error) {
	req, out := c.ListDatasetExportJobsRequest(input)
	return out, req.Send()
}

// ListDatasetExportJobsWithContext is the same as ListDatasetExportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListDatasetExportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListDatasetExportJobsWithContext(ctx aws.Context, input *ListDatasetExportJobsInput, opts ...request.Option) (*ListDatasetExportJobsOutput, error) {
	req, out := c.ListDatasetExportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDatasetExportJobsPages iterates over the pages of a ListDatasetExportJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDatasetExportJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDatasetExportJobs operation.
//	pageNum := 0
//	err := client.ListDatasetExportJobsPages(params,
//	    func(page *personalize.ListDatasetExportJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Personalize) ListDatasetExportJobsPages(input *ListDatasetExportJobsInput, fn func(*ListDatasetExportJobsOutput, bool) bool) error {
	return c.ListDatasetExportJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDatasetExportJobsPagesWithContext same as ListDatasetExportJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListDatasetExportJobsPagesWithContext(ctx aws.Context, input *ListDatasetExportJobsInput, fn func(*ListDatasetExportJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDatasetExportJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDatasetExportJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDatasetExportJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDatasetGroups = "ListDatasetGroups"

// ListDatasetGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListDatasetGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDatasetGroups for more information on using the ListDatasetGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDatasetGroupsRequest method.
//	req, resp := client.ListDatasetGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasetGroups
func (c *Personalize) ListDatasetGroupsRequest(input *ListDatasetGroupsInput) (req *request.Request, output *ListDatasetGroupsOutput) {
	op := &request.Operation{
		Name:       opListDatasetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatasetGroupsInput{}
	}

	output = &ListDatasetGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDatasetGroups API operation for Amazon Personalize.
//
// Returns a list of dataset groups. The response provides the properties for
// each dataset group, including the Amazon Resource Name (ARN). For more information
// on dataset groups, see CreateDatasetGroup (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation ListDatasetGroups for usage and error information.
//
// Returned Error Types:
//   - InvalidNextTokenException
//     The token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasetGroups
func (c *Personalize) ListDatasetGroups(input *ListDatasetGroupsInput) (*ListDatasetGroupsOutput, error) {
	req, out := c.ListDatasetGroupsRequest(input)
	return out, req.Send()
}

// ListDatasetGroupsWithContext is the same as ListDatasetGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListDatasetGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListDatasetGroupsWithContext(ctx aws.Context, input *ListDatasetGroupsInput, opts ...request.Option) (*ListDatasetGroupsOutput, error) {
	req, out := c.ListDatasetGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDatasetGroupsPages iterates over the pages of a ListDatasetGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDatasetGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDatasetGroups operation.
//	pageNum := 0
//	err := client.ListDatasetGroupsPages(params,
//	    func(page *personalize.ListDatasetGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Personalize) ListDatasetGroupsPages(input *ListDatasetGroupsInput, fn func(*ListDatasetGroupsOutput, bool) bool) error {
	return c.ListDatasetGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDatasetGroupsPagesWithContext same as ListDatasetGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListDatasetGroupsPagesWithContext(ctx aws.Context, input *ListDatasetGroupsInput, fn func(*ListDatasetGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDatasetGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDatasetGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDatasetGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDatasetImportJobs = "ListDatasetImportJobs"

// ListDatasetImportJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListDatasetImportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDatasetImportJobs for more information on using the ListDatasetImportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDatasetImportJobsRequest method.
//	req, resp := client.ListDatasetImportJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasetImportJobs
func (c *Personalize) ListDatasetImportJobsRequest(input *ListDatasetImportJobsInput) (req *request.Request, output *ListDatasetImportJobsOutput) {
	op := &request.Operation{
		Name:       opListDatasetImportJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatasetImportJobsInput{}
	}

	output = &ListDatasetImportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDatasetImportJobs API operation for Amazon Personalize.
//
// Returns a list of dataset import jobs that use the given dataset. When a
// dataset is not specified, all the dataset import jobs associated with the
// account are listed. The response provides the properties for each dataset
// import job, including the Amazon Resource Name (ARN). For more information
// on dataset import jobs, see CreateDatasetImportJob (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html).
// For more information on datasets, see CreateDataset (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation ListDatasetImportJobs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - InvalidNextTokenException
//     The token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasetImportJobs
func (c *Personalize) ListDatasetImportJobs(input *ListDatasetImportJobsInput) (*ListDatasetImportJobsOutput, error) {
	req, out := c.ListDatasetImportJobsRequest(input)
	return out, req.Send()
}

// ListDatasetImportJobsWithContext is the same as ListDatasetImportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListDatasetImportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListDatasetImportJobsWithContext(ctx aws.Context, input *ListDatasetImportJobsInput, opts ...request.Option) (*ListDatasetImportJobsOutput, error) {
	req, out := c.ListDatasetImportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDatasetImportJobsPages iterates over the pages of a ListDatasetImportJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDatasetImportJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDatasetImportJobs operation.
//	pageNum := 0
//	err := client.ListDatasetImportJobsPages(params,
//	    func(page *personalize.ListDatasetImportJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Personalize) ListDatasetImportJobsPages(input *ListDatasetImportJobsInput, fn func(*ListDatasetImportJobsOutput, bool) bool) error {
	return c.ListDatasetImportJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDatasetImportJobsPagesWithContext same as ListDatasetImportJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListDatasetImportJobsPagesWithContext(ctx aws.Context, input *ListDatasetImportJobsInput, fn func(*ListDatasetImportJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDatasetImportJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDatasetImportJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDatasetImportJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDatasets = "ListDatasets"

// ListDatasetsRequest generates a "aws/request.Request" representing the
// client's request for the ListDatasets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDatasets for more information on using the ListDatasets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDatasetsRequest method.
//	req, resp := client.ListDatasetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasets
func (c *Personalize) ListDatasetsRequest(input *ListDatasetsInput) (req *request.Request, output *ListDatasetsOutput) {
	op := &request.Operation{
		Name:       opListDatasets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatasetsInput{}
	}

	output = &ListDatasetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDatasets API operation for Amazon Personalize.
//
// Returns the list of datasets contained in the given dataset group. The response
// provides the properties for each dataset, including the Amazon Resource Name
// (ARN). For more information on datasets, see CreateDataset (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation ListDatasets for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - InvalidNextTokenException
//     The token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasets
func (c *Personalize) ListDatasets(input *ListDatasetsInput) (*ListDatasetsOutput, error) {
	req, out := c.ListDatasetsRequest(input)
	return out, req.Send()
}

// ListDatasetsWithContext is the same as ListDatasets with the addition of
// the ability to pass a context and additional request options.
//
// See ListDatasets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListDatasetsWithContext(ctx aws.Context, input *ListDatasetsInput, opts ...request.Option) (*ListDatasetsOutput, error) {
	req, out := c.ListDatasetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDatasetsPages iterates over the pages of a ListDatasets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDatasets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDatasets operation.
//	pageNum := 0
//	err := client.ListDatasetsPages(params,
//	    func(page *personalize.ListDatasetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Personalize) ListDatasetsPages(input *ListDatasetsInput, fn func(*ListDatasetsOutput, bool) bool) error {
	return c.ListDatasetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDatasetsPagesWithContext same as ListDatasetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListDatasetsPagesWithContext(ctx aws.Context, input *ListDatasetsInput, fn func(*ListDatasetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDatasetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDatasetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDatasetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEventTrackers = "ListEventTrackers"

// ListEventTrackersRequest generates a "aws/request.Request" representing the
// client's request for the ListEventTrackers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEventTrackers for more information on using the ListEventTrackers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEventTrackersRequest method.
//	req, resp := client.ListEventTrackersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListEventTrackers
func (c *Personalize) ListEventTrackersRequest(input *ListEventTrackersInput) (req *request.Request, output *ListEventTrackersOutput) {
	op := &request.Operation{
		Name:       opListEventTrackers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEventTrackersInput{}
	}

	output = &ListEventTrackersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEventTrackers API operation for Amazon Personalize.
//
// Returns the list of event trackers associated with the account. The response
// provides the properties for each event tracker, including the Amazon Resource
// Name (ARN) and tracking ID. For more information on event trackers, see CreateEventTracker
// (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation ListEventTrackers for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - InvalidNextTokenException
//     The token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListEventTrackers
func (c *Personalize) ListEventTrackers(input *ListEventTrackersInput) (*ListEventTrackersOutput, error) {
	req, out := c.ListEventTrackersRequest(input)
	return out, req.Send()
}

// ListEventTrackersWithContext is the same as ListEventTrackers with the addition of
// the ability to pass a context and additional request options.
//
// See ListEventTrackers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListEventTrackersWithContext(ctx aws.Context, input *ListEventTrackersInput, opts ...request.Option) (*ListEventTrackersOutput, error) {
	req, out := c.ListEventTrackersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEventTrackersPages iterates over the pages of a ListEventTrackers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEventTrackers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEventTrackers operation.
//	pageNum := 0
//	err := client.ListEventTrackersPages(params,
//	    func(page *personalize.ListEventTrackersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Personalize) ListEventTrackersPages(input *ListEventTrackersInput, fn func(*ListEventTrackersOutput, bool) bool) error {
	return c.ListEventTrackersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEventTrackersPagesWithContext same as ListEventTrackersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListEventTrackersPagesWithContext(ctx aws.Context, input *ListEventTrackersInput, fn func(*ListEventTrackersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEventTrackersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEventTrackersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEventTrackersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFilters = "ListFilters"

// ListFiltersRequest generates a "aws/request.Request" representing the
// client's request for the ListFilters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFilters for more information on using the ListFilters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFiltersRequest method.
//	req, resp := client.ListFiltersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListFilters
func (c *Personalize) ListFiltersRequest(input *ListFiltersInput) (req *request.Request, output *ListFiltersOutput) {
	op := &request.Operation{
		Name:       opListFilters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFiltersInput{}
	}

	output = &ListFiltersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFilters API operation for Amazon Personalize.
//
// Lists all filters that belong to a given dataset group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation ListFilters for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - InvalidNextTokenException
//     The token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListFilters
func (c *Personalize) ListFilters(input *ListFiltersInput) (*ListFiltersOutput, error) {
	req, out := c.ListFiltersRequest(input)
	return out, req.Send()
}

// ListFiltersWithContext is the same as ListFilters with the addition of
// the ability to pass a context and additional request options.
//
// See ListFilters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListFiltersWithContext(ctx aws.Context, input *ListFiltersInput, opts ...request.Option) (*ListFiltersOutput, error) {
	req, out := c.ListFiltersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFiltersPages iterates over the pages of a ListFilters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFilters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFilters operation.
//	pageNum := 0
//	err := client.ListFiltersPages(params,
//	    func(page *personalize.ListFiltersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Personalize) ListFiltersPages(input *ListFiltersInput, fn func(*ListFiltersOutput, bool) bool) error {
	return c.ListFiltersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFiltersPagesWithContext same as ListFiltersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListFiltersPagesWithContext(ctx aws.Context, input *ListFiltersInput, fn func(*ListFiltersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFiltersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFiltersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFiltersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMetricAttributionMetrics = "ListMetricAttributionMetrics"

// ListMetricAttributionMetricsRequest generates a "aws/request.Request" representing the
// client's request for the ListMetricAttributionMetrics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMetricAttributionMetrics for more information on using the ListMetricAttributionMetrics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMetricAttributionMetricsRequest method.
//	req, resp := client.ListMetricAttributionMetricsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListMetricAttributionMetrics
func (c *Personalize) ListMetricAttributionMetricsRequest(input *ListMetricAttributionMetricsInput) (req *request.Request, output *ListMetricAttributionMetricsOutput) {
	op := &request.Operation{
		Name:       opListMetricAttributionMetrics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMetricAttributionMetricsInput{}
	}

	output = &ListMetricAttributionMetricsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMetricAttributionMetrics API operation for Amazon Personalize.
//
// Lists the metrics for the metric attribution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation ListMetricAttributionMetrics for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - InvalidNextTokenException
//     The token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListMetricAttributionMetrics
func (c *Personalize) ListMetricAttributionMetrics(input *ListMetricAttributionMetricsInput) (*ListMetricAttributionMetricsOutput, error) {
	req, out := c.ListMetricAttributionMetricsRequest(input)
	return out, req.Send()
}

// ListMetricAttributionMetricsWithContext is the same as ListMetricAttributionMetrics with the addition of
// the ability to pass a context and additional request options.
//
// See ListMetricAttributionMetrics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListMetricAttributionMetricsWithContext(ctx aws.Context, input *ListMetricAttributionMetricsInput, opts ...request.Option) (*ListMetricAttributionMetricsOutput, error) {
	req, out := c.ListMetricAttributionMetricsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMetricAttributionMetricsPages iterates over the pages of a ListMetricAttributionMetrics operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMetricAttributionMetrics method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMetricAttributionMetrics operation.
//	pageNum := 0
//	err := client.ListMetricAttributionMetricsPages(params,
//	    func(page *personalize.ListMetricAttributionMetricsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Personalize) ListMetricAttributionMetricsPages(input *ListMetricAttributionMetricsInput, fn func(*ListMetricAttributionMetricsOutput, bool) bool) error {
	return c.ListMetricAttributionMetricsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMetricAttributionMetricsPagesWithContext same as ListMetricAttributionMetricsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListMetricAttributionMetricsPagesWithContext(ctx aws.Context, input *ListMetricAttributionMetricsInput, fn func(*ListMetricAttributionMetricsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMetricAttributionMetricsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMetricAttributionMetricsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMetricAttributionMetricsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMetricAttributions = "ListMetricAttributions"

// ListMetricAttributionsRequest generates a "aws/request.Request" representing the
// client's request for the ListMetricAttributions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMetricAttributions for more information on using the ListMetricAttributions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMetricAttributionsRequest method.
//	req, resp := client.ListMetricAttributionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListMetricAttributions
func (c *Personalize) ListMetricAttributionsRequest(input *ListMetricAttributionsInput) (req *request.Request, output *ListMetricAttributionsOutput) {
	op := &request.Operation{
		Name:       opListMetricAttributions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMetricAttributionsInput{}
	}

	output = &ListMetricAttributionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMetricAttributions API operation for Amazon Personalize.
//
// Lists metric attributions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation ListMetricAttributions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - InvalidNextTokenException
//     The token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListMetricAttributions
func (c *Personalize) ListMetricAttributions(input *ListMetricAttributionsInput) (*ListMetricAttributionsOutput, error) {
	req, out := c.ListMetricAttributionsRequest(input)
	return out, req.Send()
}

// ListMetricAttributionsWithContext is the same as ListMetricAttributions with the addition of
// the ability to pass a context and additional request options.
//
// See ListMetricAttributions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListMetricAttributionsWithContext(ctx aws.Context, input *ListMetricAttributionsInput, opts ...request.Option) (*ListMetricAttributionsOutput, error) {
	req, out := c.ListMetricAttributionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMetricAttributionsPages iterates over the pages of a ListMetricAttributions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMetricAttributions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMetricAttributions operation.
//	pageNum := 0
//	err := client.ListMetricAttributionsPages(params,
//	    func(page *personalize.ListMetricAttributionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Personalize) ListMetricAttributionsPages(input *ListMetricAttributionsInput, fn func(*ListMetricAttributionsOutput, bool) bool) error {
	return c.ListMetricAttributionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMetricAttributionsPagesWithContext same as ListMetricAttributionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListMetricAttributionsPagesWithContext(ctx aws.Context, input *ListMetricAttributionsInput, fn func(*ListMetricAttributionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMetricAttributionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMetricAttributionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMetricAttributionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRecipes = "ListRecipes"

// ListRecipesRequest generates a "aws/request.Request" representing the
// client's request for the ListRecipes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRecipes for more information on using the ListRecipes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRecipesRequest method.
//	req, resp := client.ListRecipesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListRecipes
func (c *Personalize) ListRecipesRequest(input *ListRecipesInput) (req *request.Request, output *ListRecipesOutput) {
	op := &request.Operation{
		Name:       opListRecipes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRecipesInput{}
	}

	output = &ListRecipesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRecipes API operation for Amazon Personalize.
//
// Returns a list of available recipes. The response provides the properties
// for each recipe, including the recipe's Amazon Resource Name (ARN).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation ListRecipes for usage and error information.
//
// Returned Error Types:
//
//   - InvalidNextTokenException
//     The token is not valid.
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListRecipes
func (c *Personalize) ListRecipes(input *ListRecipesInput) (*ListRecipesOutput, error) {
	req, out := c.ListRecipesRequest(input)
	return out, req.Send()
}

// ListRecipesWithContext is the same as ListRecipes with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecipes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListRecipesWithContext(ctx aws.Context, input *ListRecipesInput, opts ...request.Option) (*ListRecipesOutput, error) {
	req, out := c.ListRecipesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRecipesPages iterates over the pages of a ListRecipes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRecipes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRecipes operation.
//	pageNum := 0
//	err := client.ListRecipesPages(params,
//	    func(page *personalize.ListRecipesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Personalize) ListRecipesPages(input *ListRecipesInput, fn func(*ListRecipesOutput, bool) bool) error {
	return c.ListRecipesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRecipesPagesWithContext same as ListRecipesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListRecipesPagesWithContext(ctx aws.Context, input *ListRecipesInput, fn func(*ListRecipesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRecipesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRecipesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRecipesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRecommenders = "ListRecommenders"

// ListRecommendersRequest generates a "aws/request.Request" representing the
// client's request for the ListRecommenders operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRecommenders for more information on using the ListRecommenders
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRecommendersRequest method.
//	req, resp := client.ListRecommendersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListRecommenders
func (c *Personalize) ListRecommendersRequest(input *ListRecommendersInput) (req *request.Request, output *ListRecommendersOutput) {
	op := &request.Operation{
		Name:       opListRecommenders,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRecommendersInput{}
	}

	output = &ListRecommendersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRecommenders API operation for Amazon Personalize.
//
// Returns a list of recommenders in a given Domain dataset group. When a Domain
// dataset group is not specified, all the recommenders associated with the
// account are listed. The response provides the properties for each recommender,
// including the Amazon Resource Name (ARN). For more information on recommenders,
// see CreateRecommender (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateRecommender.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation ListRecommenders for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - InvalidNextTokenException
//     The token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListRecommenders
func (c *Personalize) ListRecommenders(input *ListRecommendersInput) (*ListRecommendersOutput, error) {
	req, out := c.ListRecommendersRequest(input)
	return out, req.Send()
}

// ListRecommendersWithContext is the same as ListRecommenders with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecommenders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListRecommendersWithContext(ctx aws.Context, input *ListRecommendersInput, opts ...request.Option) (*ListRecommendersOutput, error) {
	req, out := c.ListRecommendersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRecommendersPages iterates over the pages of a ListRecommenders operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRecommenders method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRecommenders operation.
//	pageNum := 0
//	err := client.ListRecommendersPages(params,
//	    func(page *personalize.ListRecommendersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Personalize) ListRecommendersPages(input *ListRecommendersInput, fn func(*ListRecommendersOutput, bool) bool) error {
	return c.ListRecommendersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRecommendersPagesWithContext same as ListRecommendersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListRecommendersPagesWithContext(ctx aws.Context, input *ListRecommendersInput, fn func(*ListRecommendersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRecommendersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRecommendersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRecommendersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSchemas = "ListSchemas"

// ListSchemasRequest generates a "aws/request.Request" representing the
// client's request for the ListSchemas operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSchemas for more information on using the ListSchemas
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSchemasRequest method.
//	req, resp := client.ListSchemasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListSchemas
func (c *Personalize) ListSchemasRequest(input *ListSchemasInput) (req *request.Request, output *ListSchemasOutput) {
	op := &request.Operation{
		Name:       opListSchemas,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSchemasInput{}
	}

	output = &ListSchemasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSchemas API operation for Amazon Personalize.
//
// Returns the list of schemas associated with the account. The response provides
// the properties for each schema, including the Amazon Resource Name (ARN).
// For more information on schemas, see CreateSchema (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation ListSchemas for usage and error information.
//
// Returned Error Types:
//   - InvalidNextTokenException
//     The token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListSchemas
func (c *Personalize) ListSchemas(input *ListSchemasInput) (*ListSchemasOutput, error) {
	req, out := c.ListSchemasRequest(input)
	return out, req.Send()
}

// ListSchemasWithContext is the same as ListSchemas with the addition of
// the ability to pass a context and additional request options.
//
// See ListSchemas for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListSchemasWithContext(ctx aws.Context, input *ListSchemasInput, opts ...request.Option) (*ListSchemasOutput, error) {
	req, out := c.ListSchemasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSchemasPages iterates over the pages of a ListSchemas operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSchemas method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSchemas operation.
//	pageNum := 0
//	err := client.ListSchemasPages(params,
//	    func(page *personalize.ListSchemasOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Personalize) ListSchemasPages(input *ListSchemasInput, fn func(*ListSchemasOutput, bool) bool) error {
	return c.ListSchemasPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSchemasPagesWithContext same as ListSchemasPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListSchemasPagesWithContext(ctx aws.Context, input *ListSchemasInput, fn func(*ListSchemasOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSchemasInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSchemasRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSchemasOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSolutionVersions = "ListSolutionVersions"

// ListSolutionVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListSolutionVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSolutionVersions for more information on using the ListSolutionVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSolutionVersionsRequest method.
//	req, resp := client.ListSolutionVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListSolutionVersions
func (c *Personalize) ListSolutionVersionsRequest(input *ListSolutionVersionsInput) (req *request.Request, output *ListSolutionVersionsOutput) {
	op := &request.Operation{
		Name:       opListSolutionVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSolutionVersionsInput{}
	}

	output = &ListSolutionVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSolutionVersions API operation for Amazon Personalize.
//
// Returns a list of solution versions for the given solution. When a solution
// is not specified, all the solution versions associated with the account are
// listed. The response provides the properties for each solution version, including
// the Amazon Resource Name (ARN).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation ListSolutionVersions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - InvalidNextTokenException
//     The token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListSolutionVersions
func (c *Personalize) ListSolutionVersions(input *ListSolutionVersionsInput) (*ListSolutionVersionsOutput, error) {
	req, out := c.ListSolutionVersionsRequest(input)
	return out, req.Send()
}

// ListSolutionVersionsWithContext is the same as ListSolutionVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListSolutionVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListSolutionVersionsWithContext(ctx aws.Context, input *ListSolutionVersionsInput, opts ...request.Option) (*ListSolutionVersionsOutput, error) {
	req, out := c.ListSolutionVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSolutionVersionsPages iterates over the pages of a ListSolutionVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSolutionVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSolutionVersions operation.
//	pageNum := 0
//	err := client.ListSolutionVersionsPages(params,
//	    func(page *personalize.ListSolutionVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Personalize) ListSolutionVersionsPages(input *ListSolutionVersionsInput, fn func(*ListSolutionVersionsOutput, bool) bool) error {
	return c.ListSolutionVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSolutionVersionsPagesWithContext same as ListSolutionVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListSolutionVersionsPagesWithContext(ctx aws.Context, input *ListSolutionVersionsInput, fn func(*ListSolutionVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSolutionVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSolutionVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSolutionVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSolutions = "ListSolutions"

// ListSolutionsRequest generates a "aws/request.Request" representing the
// client's request for the ListSolutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSolutions for more information on using the ListSolutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSolutionsRequest method.
//	req, resp := client.ListSolutionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListSolutions
func (c *Personalize) ListSolutionsRequest(input *ListSolutionsInput) (req *request.Request, output *ListSolutionsOutput) {
	op := &request.Operation{
		Name:       opListSolutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSolutionsInput{}
	}

	output = &ListSolutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSolutions API operation for Amazon Personalize.
//
// Returns a list of solutions that use the given dataset group. When a dataset
// group is not specified, all the solutions associated with the account are
// listed. The response provides the properties for each solution, including
// the Amazon Resource Name (ARN). For more information on solutions, see CreateSolution
// (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation ListSolutions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - InvalidNextTokenException
//     The token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListSolutions
func (c *Personalize) ListSolutions(input *ListSolutionsInput) (*ListSolutionsOutput, error) {
	req, out := c.ListSolutionsRequest(input)
	return out, req.Send()
}

// ListSolutionsWithContext is the same as ListSolutions with the addition of
// the ability to pass a context and additional request options.
//
// See ListSolutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListSolutionsWithContext(ctx aws.Context, input *ListSolutionsInput, opts ...request.Option) (*ListSolutionsOutput, error) {
	req, out := c.ListSolutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSolutionsPages iterates over the pages of a ListSolutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSolutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSolutions operation.
//	pageNum := 0
//	err := client.ListSolutionsPages(params,
//	    func(page *personalize.ListSolutionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Personalize) ListSolutionsPages(input *ListSolutionsInput, fn func(*ListSolutionsOutput, bool) bool) error {
	return c.ListSolutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSolutionsPagesWithContext same as ListSolutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListSolutionsPagesWithContext(ctx aws.Context, input *ListSolutionsInput, fn func(*ListSolutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSolutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSolutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSolutionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListTagsForResource
func (c *Personalize) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Personalize.
//
// Get a list of tags (https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html)
// attached to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListTagsForResource
func (c *Personalize) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartRecommender = "StartRecommender"

// StartRecommenderRequest generates a "aws/request.Request" representing the
// client's request for the StartRecommender operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartRecommender for more information on using the StartRecommender
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartRecommenderRequest method.
//	req, resp := client.StartRecommenderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/StartRecommender
func (c *Personalize) StartRecommenderRequest(input *StartRecommenderInput) (req *request.Request, output *StartRecommenderOutput) {
	op := &request.Operation{
		Name:       opStartRecommender,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartRecommenderInput{}
	}

	output = &StartRecommenderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartRecommender API operation for Amazon Personalize.
//
// Starts a recommender that is INACTIVE. Starting a recommender does not create
// any new models, but resumes billing and automatic retraining for the recommender.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation StartRecommender for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/StartRecommender
func (c *Personalize) StartRecommender(input *StartRecommenderInput) (*StartRecommenderOutput, error) {
	req, out := c.StartRecommenderRequest(input)
	return out, req.Send()
}

// StartRecommenderWithContext is the same as StartRecommender with the addition of
// the ability to pass a context and additional request options.
//
// See StartRecommender for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) StartRecommenderWithContext(ctx aws.Context, input *StartRecommenderInput, opts ...request.Option) (*StartRecommenderOutput, error) {
	req, out := c.StartRecommenderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopRecommender = "StopRecommender"

// StopRecommenderRequest generates a "aws/request.Request" representing the
// client's request for the StopRecommender operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopRecommender for more information on using the StopRecommender
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopRecommenderRequest method.
//	req, resp := client.StopRecommenderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/StopRecommender
func (c *Personalize) StopRecommenderRequest(input *StopRecommenderInput) (req *request.Request, output *StopRecommenderOutput) {
	op := &request.Operation{
		Name:       opStopRecommender,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopRecommenderInput{}
	}

	output = &StopRecommenderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopRecommender API operation for Amazon Personalize.
//
// Stops a recommender that is ACTIVE. Stopping a recommender halts billing
// and automatic retraining for the recommender.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation StopRecommender for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/StopRecommender
func (c *Personalize) StopRecommender(input *StopRecommenderInput) (*StopRecommenderOutput, error) {
	req, out := c.StopRecommenderRequest(input)
	return out, req.Send()
}

// StopRecommenderWithContext is the same as StopRecommender with the addition of
// the ability to pass a context and additional request options.
//
// See StopRecommender for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) StopRecommenderWithContext(ctx aws.Context, input *StopRecommenderInput, opts ...request.Option) (*StopRecommenderOutput, error) {
	req, out := c.StopRecommenderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopSolutionVersionCreation = "StopSolutionVersionCreation"

// StopSolutionVersionCreationRequest generates a "aws/request.Request" representing the
// client's request for the StopSolutionVersionCreation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopSolutionVersionCreation for more information on using the StopSolutionVersionCreation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopSolutionVersionCreationRequest method.
//	req, resp := client.StopSolutionVersionCreationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/StopSolutionVersionCreation
func (c *Personalize) StopSolutionVersionCreationRequest(input *StopSolutionVersionCreationInput) (req *request.Request, output *StopSolutionVersionCreationOutput) {
	op := &request.Operation{
		Name:       opStopSolutionVersionCreation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopSolutionVersionCreationInput{}
	}

	output = &StopSolutionVersionCreationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopSolutionVersionCreation API operation for Amazon Personalize.
//
// Stops creating a solution version that is in a state of CREATE_PENDING or
// CREATE IN_PROGRESS.
//
// Depending on the current state of the solution version, the solution version
// state changes as follows:
//
//   - CREATE_PENDING > CREATE_STOPPED or
//
//   - CREATE_IN_PROGRESS > CREATE_STOPPING > CREATE_STOPPED
//
// You are billed for all of the training completed up until you stop the solution
// version creation. You cannot resume creating a solution version once it has
// been stopped.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation StopSolutionVersionCreation for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/StopSolutionVersionCreation
func (c *Personalize) StopSolutionVersionCreation(input *StopSolutionVersionCreationInput) (*StopSolutionVersionCreationOutput, error) {
	req, out := c.StopSolutionVersionCreationRequest(input)
	return out, req.Send()
}

// StopSolutionVersionCreationWithContext is the same as StopSolutionVersionCreation with the addition of
// the ability to pass a context and additional request options.
//
// See StopSolutionVersionCreation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) StopSolutionVersionCreationWithContext(ctx aws.Context, input *StopSolutionVersionCreationInput, opts ...request.Option) (*StopSolutionVersionCreationOutput, error) {
	req, out := c.StopSolutionVersionCreationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/TagResource
func (c *Personalize) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Personalize.
//
// Add a list of tags to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - TooManyTagsException
//     You have exceeded the maximum number of tags you can apply to this resource.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
//   - LimitExceededException
//     The limit on the number of requests per second has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/TagResource
func (c *Personalize) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/UntagResource
func (c *Personalize) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Personalize.
//
// Remove tags (https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html)
// that are attached to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - TooManyTagKeysException
//     The request contains more tag keys than can be associated with a resource
//     (50 tag keys per resource).
//
//   - ResourceInUseException
//     The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/UntagResource
func (c *Personalize) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCampaign = "UpdateCampaign"

// UpdateCampaignRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCampaign for more information on using the UpdateCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateCampaignRequest method.
//	req, resp := client.UpdateCampaignRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/UpdateCampaign
func (c *Personalize) UpdateCampaignRequest(input *UpdateCampaignInput) (req *request.Request, output *UpdateCampaignOutput) {
	op := &request.Operation{
		Name:       opUpdateCampaign,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCampaignInput{}
	}

	output = &UpdateCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCampaign API operation for Amazon Personalize.
//
// Updates a campaign to deploy a retrained solution version with an existing
// campaign, change your campaign's minProvisionedTPS, or modify your campaign's
// configuration, such as the exploration configuration.
//
// To update a campaign, the campaign status must be ACTIVE or CREATE FAILED.
// Check the campaign status using the DescribeCampaign (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html)
// operation.
//
// You can still get recommendations from a campaign while an update is in progress.
// The campaign will use the previous solution version and campaign configuration
// to generate recommendations until the latest campaign update status is Active.
//
// For more information about updating a campaign, including code samples, see
// Updating a campaign (https://docs.aws.amazon.com/personalize/latest/dg/update-campaigns.html).
// For more information about campaigns, see Creating a campaign (https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation UpdateCampaign for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/UpdateCampaign
func (c *Personalize) UpdateCampaign(input *UpdateCampaignInput) (*UpdateCampaignOutput, error) {
	req, out := c.UpdateCampaignRequest(input)
	return out, req.Send()
}

// UpdateCampaignWithContext is the same as UpdateCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) UpdateCampaignWithContext(ctx aws.Context, input *UpdateCampaignInput, opts ...request.Option) (*UpdateCampaignOutput, error) {
	req, out := c.UpdateCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataset = "UpdateDataset"

// UpdateDatasetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataset for more information on using the UpdateDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDatasetRequest method.
//	req, resp := client.UpdateDatasetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/UpdateDataset
func (c *Personalize) UpdateDatasetRequest(input *UpdateDatasetInput) (req *request.Request, output *UpdateDatasetOutput) {
	op := &request.Operation{
		Name:       opUpdateDataset,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDatasetInput{}
	}

	output = &UpdateDatasetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDataset API operation for Amazon Personalize.
//
// Update a dataset to replace its schema with a new or existing one. For more
// information, see Replacing a dataset's schema (https://docs.aws.amazon.com/personalize/latest/dg/updating-dataset-schema.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation UpdateDataset for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/UpdateDataset
func (c *Personalize) UpdateDataset(input *UpdateDatasetInput) (*UpdateDatasetOutput, error) {
	req, out := c.UpdateDatasetRequest(input)
	return out, req.Send()
}

// UpdateDatasetWithContext is the same as UpdateDataset with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) UpdateDatasetWithContext(ctx aws.Context, input *UpdateDatasetInput, opts ...request.Option) (*UpdateDatasetOutput, error) {
	req, out := c.UpdateDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMetricAttribution = "UpdateMetricAttribution"

// UpdateMetricAttributionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMetricAttribution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMetricAttribution for more information on using the UpdateMetricAttribution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateMetricAttributionRequest method.
//	req, resp := client.UpdateMetricAttributionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/UpdateMetricAttribution
func (c *Personalize) UpdateMetricAttributionRequest(input *UpdateMetricAttributionInput) (req *request.Request, output *UpdateMetricAttributionOutput) {
	op := &request.Operation{
		Name:       opUpdateMetricAttribution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateMetricAttributionInput{}
	}

	output = &UpdateMetricAttributionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMetricAttribution API operation for Amazon Personalize.
//
// Updates a metric attribution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation UpdateMetricAttribution for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
//   - ResourceAlreadyExistsException
//     The specified resource already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/UpdateMetricAttribution
func (c *Personalize) UpdateMetricAttribution(input *UpdateMetricAttributionInput) (*UpdateMetricAttributionOutput, error) {
	req, out := c.UpdateMetricAttributionRequest(input)
	return out, req.Send()
}

// UpdateMetricAttributionWithContext is the same as UpdateMetricAttribution with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMetricAttribution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) UpdateMetricAttributionWithContext(ctx aws.Context, input *UpdateMetricAttributionInput, opts ...request.Option) (*UpdateMetricAttributionOutput, error) {
	req, out := c.UpdateMetricAttributionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRecommender = "UpdateRecommender"

// UpdateRecommenderRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRecommender operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRecommender for more information on using the UpdateRecommender
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRecommenderRequest method.
//	req, resp := client.UpdateRecommenderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/UpdateRecommender
func (c *Personalize) UpdateRecommenderRequest(input *UpdateRecommenderInput) (req *request.Request, output *UpdateRecommenderOutput) {
	op := &request.Operation{
		Name:       opUpdateRecommender,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRecommenderInput{}
	}

	output = &UpdateRecommenderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRecommender API operation for Amazon Personalize.
//
// Updates the recommender to modify the recommender configuration. If you update
// the recommender to modify the columns used in training, Amazon Personalize
// automatically starts a full retraining of the models backing your recommender.
// While the update completes, you can still get recommendations from the recommender.
// The recommender uses the previous configuration until the update completes.
// To track the status of this update, use the latestRecommenderUpdate returned
// in the DescribeRecommender (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html)
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize's
// API operation UpdateRecommender for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     Could not find the specified resource.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/UpdateRecommender
func (c *Personalize) UpdateRecommender(input *UpdateRecommenderInput) (*UpdateRecommenderOutput, error) {
	req, out := c.UpdateRecommenderRequest(input)
	return out, req.Send()
}

// UpdateRecommenderWithContext is the same as UpdateRecommender with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRecommender for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Personalize) UpdateRecommenderWithContext(ctx aws.Context, input *UpdateRecommenderInput, opts ...request.Option) (*UpdateRecommenderOutput, error) {
	req, out := c.UpdateRecommenderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Describes a custom algorithm.
type Algorithm struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the algorithm.
	AlgorithmArn *string `locationName:"algorithmArn" type:"string"`

	// The URI of the Docker container for the algorithm image.
	AlgorithmImage *AlgorithmImage `locationName:"algorithmImage" type:"structure"`

	// The date and time (in Unix time) that the algorithm was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// Specifies the default hyperparameters, their ranges, and whether they are
	// tunable. A tunable hyperparameter can have its value determined during hyperparameter
	// optimization (HPO).
	DefaultHyperParameterRanges *DefaultHyperParameterRanges `locationName:"defaultHyperParameterRanges" type:"structure"`

	// Specifies the default hyperparameters.
	DefaultHyperParameters map[string]*string `locationName:"defaultHyperParameters" type:"map"`

	// Specifies the default maximum number of training jobs and parallel training
	// jobs.
	DefaultResourceConfig map[string]*string `locationName:"defaultResourceConfig" type:"map"`

	// The date and time (in Unix time) that the algorithm was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the algorithm.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the role.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The training input mode.
	TrainingInputMode *string `locationName:"trainingInputMode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Algorithm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Algorithm) GoString() string {
	return s.String()
}

// SetAlgorithmArn sets the AlgorithmArn field's value.
func (s *Algorithm) SetAlgorithmArn(v string) *Algorithm {
	s.AlgorithmArn = &v
	return s
}

// SetAlgorithmImage sets the AlgorithmImage field's value.
func (s *Algorithm) SetAlgorithmImage(v *AlgorithmImage) *Algorithm {
	s.AlgorithmImage = v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *Algorithm) SetCreationDateTime(v time.Time) *Algorithm {
	s.CreationDateTime = &v
	return s
}

// SetDefaultHyperParameterRanges sets the DefaultHyperParameterRanges field's value.
func (s *Algorithm) SetDefaultHyperParameterRanges(v *DefaultHyperParameterRanges) *Algorithm {
	s.DefaultHyperParameterRanges = v
	return s
}

// SetDefaultHyperParameters sets the DefaultHyperParameters field's value.
func (s *Algorithm) SetDefaultHyperParameters(v map[string]*string) *Algorithm {
	s.DefaultHyperParameters = v
	return s
}

// SetDefaultResourceConfig sets the DefaultResourceConfig field's value.
func (s *Algorithm) SetDefaultResourceConfig(v map[string]*string) *Algorithm {
	s.DefaultResourceConfig = v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *Algorithm) SetLastUpdatedDateTime(v time.Time) *Algorithm {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Algorithm) SetName(v string) *Algorithm {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Algorithm) SetRoleArn(v string) *Algorithm {
	s.RoleArn = &v
	return s
}

// SetTrainingInputMode sets the TrainingInputMode field's value.
func (s *Algorithm) SetTrainingInputMode(v string) *Algorithm {
	s.TrainingInputMode = &v
	return s
}

// Describes an algorithm image.
type AlgorithmImage struct {
	_ struct{} `type:"structure"`

	// The URI of the Docker container for the algorithm image.
	//
	// DockerURI is a required field
	DockerURI *string `locationName:"dockerURI" type:"string" required:"true"`

	// The name of the algorithm image.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlgorithmImage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlgorithmImage) GoString() string {
	return s.String()
}

// SetDockerURI sets the DockerURI field's value.
func (s *AlgorithmImage) SetDockerURI(v string) *AlgorithmImage {
	s.DockerURI = &v
	return s
}

// SetName sets the Name field's value.
func (s *AlgorithmImage) SetName(v string) *AlgorithmImage {
	s.Name = &v
	return s
}

// When the solution performs AutoML (performAutoML is true in CreateSolution
// (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html)),
// Amazon Personalize determines which recipe, from the specified list, optimizes
// the given metric. Amazon Personalize then uses that recipe for the solution.
type AutoMLConfig struct {
	_ struct{} `type:"structure"`

	// The metric to optimize.
	MetricName *string `locationName:"metricName" type:"string"`

	// The list of candidate recipes.
	RecipeList []*string `locationName:"recipeList" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoMLConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoMLConfig) GoString() string {
	return s.String()
}

// SetMetricName sets the MetricName field's value.
func (s *AutoMLConfig) SetMetricName(v string) *AutoMLConfig {
	s.MetricName = &v
	return s
}

// SetRecipeList sets the RecipeList field's value.
func (s *AutoMLConfig) SetRecipeList(v []*string) *AutoMLConfig {
	s.RecipeList = v
	return s
}

// When the solution performs AutoML (performAutoML is true in CreateSolution
// (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html)),
// specifies the recipe that best optimized the specified metric.
type AutoMLResult struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the best recipe.
	BestRecipeArn *string `locationName:"bestRecipeArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoMLResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoMLResult) GoString() string {
	return s.String()
}

// SetBestRecipeArn sets the BestRecipeArn field's value.
func (s *AutoMLResult) SetBestRecipeArn(v string) *AutoMLResult {
	s.BestRecipeArn = &v
	return s
}

// Contains information on a batch inference job.
type BatchInferenceJob struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the batch inference job.
	BatchInferenceJobArn *string `locationName:"batchInferenceJobArn" type:"string"`

	// A string to string map of the configuration details of a batch inference
	// job.
	BatchInferenceJobConfig *BatchInferenceJobConfig `locationName:"batchInferenceJobConfig" type:"structure"`

	// The job's mode.
	BatchInferenceJobMode *string `locationName:"batchInferenceJobMode" type:"string" enum:"BatchInferenceJobMode"`

	// The time at which the batch inference job was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// If the batch inference job failed, the reason for the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The ARN of the filter used on the batch inference job.
	FilterArn *string `locationName:"filterArn" type:"string"`

	// The Amazon S3 path that leads to the input data used to generate the batch
	// inference job.
	JobInput *BatchInferenceJobInput `locationName:"jobInput" type:"structure"`

	// The name of the batch inference job.
	JobName *string `locationName:"jobName" min:"1" type:"string"`

	// The Amazon S3 bucket that contains the output data generated by the batch
	// inference job.
	JobOutput *BatchInferenceJobOutput `locationName:"jobOutput" type:"structure"`

	// The time at which the batch inference job was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The number of recommendations generated by the batch inference job. This
	// number includes the error messages generated for failed input records.
	NumResults *int64 `locationName:"numResults" type:"integer"`

	// The ARN of the Amazon Identity and Access Management (IAM) role that requested
	// the batch inference job.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The Amazon Resource Name (ARN) of the solution version from which the batch
	// inference job was created.
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string"`

	// The status of the batch inference job. The status is one of the following
	// values:
	//
	//    * PENDING
	//
	//    * IN PROGRESS
	//
	//    * ACTIVE
	//
	//    * CREATE FAILED
	Status *string `locationName:"status" type:"string"`

	// The job's theme generation settings.
	ThemeGenerationConfig *ThemeGenerationConfig `locationName:"themeGenerationConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchInferenceJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchInferenceJob) GoString() string {
	return s.String()
}

// SetBatchInferenceJobArn sets the BatchInferenceJobArn field's value.
func (s *BatchInferenceJob) SetBatchInferenceJobArn(v string) *BatchInferenceJob {
	s.BatchInferenceJobArn = &v
	return s
}

// SetBatchInferenceJobConfig sets the BatchInferenceJobConfig field's value.
func (s *BatchInferenceJob) SetBatchInferenceJobConfig(v *BatchInferenceJobConfig) *BatchInferenceJob {
	s.BatchInferenceJobConfig = v
	return s
}

// SetBatchInferenceJobMode sets the BatchInferenceJobMode field's value.
func (s *BatchInferenceJob) SetBatchInferenceJobMode(v string) *BatchInferenceJob {
	s.BatchInferenceJobMode = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *BatchInferenceJob) SetCreationDateTime(v time.Time) *BatchInferenceJob {
	s.CreationDateTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *BatchInferenceJob) SetFailureReason(v string) *BatchInferenceJob {
	s.FailureReason = &v
	return s
}

// SetFilterArn sets the FilterArn field's value.
func (s *BatchInferenceJob) SetFilterArn(v string) *BatchInferenceJob {
	s.FilterArn = &v
	return s
}

// SetJobInput sets the JobInput field's value.
func (s *BatchInferenceJob) SetJobInput(v *BatchInferenceJobInput) *BatchInferenceJob {
	s.JobInput = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *BatchInferenceJob) SetJobName(v string) *BatchInferenceJob {
	s.JobName = &v
	return s
}

// SetJobOutput sets the JobOutput field's value.
func (s *BatchInferenceJob) SetJobOutput(v *BatchInferenceJobOutput) *BatchInferenceJob {
	s.JobOutput = v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *BatchInferenceJob) SetLastUpdatedDateTime(v time.Time) *BatchInferenceJob {
	s.LastUpdatedDateTime = &v
	return s
}

// SetNumResults sets the NumResults field's value.
func (s *BatchInferenceJob) SetNumResults(v int64) *BatchInferenceJob {
	s.NumResults = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *BatchInferenceJob) SetRoleArn(v string) *BatchInferenceJob {
	s.RoleArn = &v
	return s
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *BatchInferenceJob) SetSolutionVersionArn(v string) *BatchInferenceJob {
	s.SolutionVersionArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *BatchInferenceJob) SetStatus(v string) *BatchInferenceJob {
	s.Status = &v
	return s
}

// SetThemeGenerationConfig sets the ThemeGenerationConfig field's value.
func (s *BatchInferenceJob) SetThemeGenerationConfig(v *ThemeGenerationConfig) *BatchInferenceJob {
	s.ThemeGenerationConfig = v
	return s
}

// The configuration details of a batch inference job.
type BatchInferenceJobConfig struct {
	_ struct{} `type:"structure"`

	// A string to string map specifying the exploration configuration hyperparameters,
	// including explorationWeight and explorationItemAgeCutOff, you want to use
	// to configure the amount of item exploration Amazon Personalize uses when
	// recommending items. See User-Personalization (https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html).
	ItemExplorationConfig map[string]*string `locationName:"itemExplorationConfig" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchInferenceJobConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchInferenceJobConfig) GoString() string {
	return s.String()
}

// SetItemExplorationConfig sets the ItemExplorationConfig field's value.
func (s *BatchInferenceJobConfig) SetItemExplorationConfig(v map[string]*string) *BatchInferenceJobConfig {
	s.ItemExplorationConfig = v
	return s
}

// The input configuration of a batch inference job.
type BatchInferenceJobInput struct {
	_ struct{} `type:"structure"`

	// The URI of the Amazon S3 location that contains your input data. The Amazon
	// S3 bucket must be in the same region as the API endpoint you are calling.
	//
	// S3DataSource is a required field
	S3DataSource *S3DataConfig `locationName:"s3DataSource" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchInferenceJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchInferenceJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchInferenceJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchInferenceJobInput"}
	if s.S3DataSource == nil {
		invalidParams.Add(request.NewErrParamRequired("S3DataSource"))
	}
	if s.S3DataSource != nil {
		if err := s.S3DataSource.Validate(); err != nil {
			invalidParams.AddNested("S3DataSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3DataSource sets the S3DataSource field's value.
func (s *BatchInferenceJobInput) SetS3DataSource(v *S3DataConfig) *BatchInferenceJobInput {
	s.S3DataSource = v
	return s
}

// The output configuration parameters of a batch inference job.
type BatchInferenceJobOutput struct {
	_ struct{} `type:"structure"`

	// Information on the Amazon S3 bucket in which the batch inference job's output
	// is stored.
	//
	// S3DataDestination is a required field
	S3DataDestination *S3DataConfig `locationName:"s3DataDestination" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchInferenceJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchInferenceJobOutput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchInferenceJobOutput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchInferenceJobOutput"}
	if s.S3DataDestination == nil {
		invalidParams.Add(request.NewErrParamRequired("S3DataDestination"))
	}
	if s.S3DataDestination != nil {
		if err := s.S3DataDestination.Validate(); err != nil {
			invalidParams.AddNested("S3DataDestination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3DataDestination sets the S3DataDestination field's value.
func (s *BatchInferenceJobOutput) SetS3DataDestination(v *S3DataConfig) *BatchInferenceJobOutput {
	s.S3DataDestination = v
	return s
}

// A truncated version of the BatchInferenceJob (https://docs.aws.amazon.com/personalize/latest/dg/API_BatchInferenceJob.html).
// The ListBatchInferenceJobs (https://docs.aws.amazon.com/personalize/latest/dg/API_ListBatchInferenceJobs.html)
// operation returns a list of batch inference job summaries.
type BatchInferenceJobSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the batch inference job.
	BatchInferenceJobArn *string `locationName:"batchInferenceJobArn" type:"string"`

	// The job's mode.
	BatchInferenceJobMode *string `locationName:"batchInferenceJobMode" type:"string" enum:"BatchInferenceJobMode"`

	// The time at which the batch inference job was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// If the batch inference job failed, the reason for the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The name of the batch inference job.
	JobName *string `locationName:"jobName" min:"1" type:"string"`

	// The time at which the batch inference job was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The ARN of the solution version used by the batch inference job.
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string"`

	// The status of the batch inference job. The status is one of the following
	// values:
	//
	//    * PENDING
	//
	//    * IN PROGRESS
	//
	//    * ACTIVE
	//
	//    * CREATE FAILED
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchInferenceJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchInferenceJobSummary) GoString() string {
	return s.String()
}

// SetBatchInferenceJobArn sets the BatchInferenceJobArn field's value.
func (s *BatchInferenceJobSummary) SetBatchInferenceJobArn(v string) *BatchInferenceJobSummary {
	s.BatchInferenceJobArn = &v
	return s
}

// SetBatchInferenceJobMode sets the BatchInferenceJobMode field's value.
func (s *BatchInferenceJobSummary) SetBatchInferenceJobMode(v string) *BatchInferenceJobSummary {
	s.BatchInferenceJobMode = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *BatchInferenceJobSummary) SetCreationDateTime(v time.Time) *BatchInferenceJobSummary {
	s.CreationDateTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *BatchInferenceJobSummary) SetFailureReason(v string) *BatchInferenceJobSummary {
	s.FailureReason = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *BatchInferenceJobSummary) SetJobName(v string) *BatchInferenceJobSummary {
	s.JobName = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *BatchInferenceJobSummary) SetLastUpdatedDateTime(v time.Time) *BatchInferenceJobSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *BatchInferenceJobSummary) SetSolutionVersionArn(v string) *BatchInferenceJobSummary {
	s.SolutionVersionArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *BatchInferenceJobSummary) SetStatus(v string) *BatchInferenceJobSummary {
	s.Status = &v
	return s
}

// Contains information on a batch segment job.
type BatchSegmentJob struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the batch segment job.
	BatchSegmentJobArn *string `locationName:"batchSegmentJobArn" type:"string"`

	// The time at which the batch segment job was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// If the batch segment job failed, the reason for the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The ARN of the filter used on the batch segment job.
	FilterArn *string `locationName:"filterArn" type:"string"`

	// The Amazon S3 path that leads to the input data used to generate the batch
	// segment job.
	JobInput *BatchSegmentJobInput_ `locationName:"jobInput" type:"structure"`

	// The name of the batch segment job.
	JobName *string `locationName:"jobName" min:"1" type:"string"`

	// The Amazon S3 bucket that contains the output data generated by the batch
	// segment job.
	JobOutput *BatchSegmentJobOutput_ `locationName:"jobOutput" type:"structure"`

	// The time at which the batch segment job last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The number of predicted users generated by the batch segment job for each
	// line of input data. The maximum number of users per segment is 5 million.
	NumResults *int64 `locationName:"numResults" type:"integer"`

	// The ARN of the Amazon Identity and Access Management (IAM) role that requested
	// the batch segment job.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The Amazon Resource Name (ARN) of the solution version used by the batch
	// segment job to generate batch segments.
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string"`

	// The status of the batch segment job. The status is one of the following values:
	//
	//    * PENDING
	//
	//    * IN PROGRESS
	//
	//    * ACTIVE
	//
	//    * CREATE FAILED
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchSegmentJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchSegmentJob) GoString() string {
	return s.String()
}

// SetBatchSegmentJobArn sets the BatchSegmentJobArn field's value.
func (s *BatchSegmentJob) SetBatchSegmentJobArn(v string) *BatchSegmentJob {
	s.BatchSegmentJobArn = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *BatchSegmentJob) SetCreationDateTime(v time.Time) *BatchSegmentJob {
	s.CreationDateTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *BatchSegmentJob) SetFailureReason(v string) *BatchSegmentJob {
	s.FailureReason = &v
	return s
}

// SetFilterArn sets the FilterArn field's value.
func (s *BatchSegmentJob) SetFilterArn(v string) *BatchSegmentJob {
	s.FilterArn = &v
	return s
}

// SetJobInput sets the JobInput field's value.
func (s *BatchSegmentJob) SetJobInput(v *BatchSegmentJobInput_) *BatchSegmentJob {
	s.JobInput = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *BatchSegmentJob) SetJobName(v string) *BatchSegmentJob {
	s.JobName = &v
	return s
}

// SetJobOutput sets the JobOutput field's value.
func (s *BatchSegmentJob) SetJobOutput(v *BatchSegmentJobOutput_) *BatchSegmentJob {
	s.JobOutput = v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *BatchSegmentJob) SetLastUpdatedDateTime(v time.Time) *BatchSegmentJob {
	s.LastUpdatedDateTime = &v
	return s
}

// SetNumResults sets the NumResults field's value.
func (s *BatchSegmentJob) SetNumResults(v int64) *BatchSegmentJob {
	s.NumResults = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *BatchSegmentJob) SetRoleArn(v string) *BatchSegmentJob {
	s.RoleArn = &v
	return s
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *BatchSegmentJob) SetSolutionVersionArn(v string) *BatchSegmentJob {
	s.SolutionVersionArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *BatchSegmentJob) SetStatus(v string) *BatchSegmentJob {
	s.Status = &v
	return s
}

// The input configuration of a batch segment job.
type BatchSegmentJobInput_ struct {
	_ struct{} `type:"structure"`

	// The configuration details of an Amazon S3 input or output bucket.
	//
	// S3DataSource is a required field
	S3DataSource *S3DataConfig `locationName:"s3DataSource" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchSegmentJobInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchSegmentJobInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchSegmentJobInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchSegmentJobInput_"}
	if s.S3DataSource == nil {
		invalidParams.Add(request.NewErrParamRequired("S3DataSource"))
	}
	if s.S3DataSource != nil {
		if err := s.S3DataSource.Validate(); err != nil {
			invalidParams.AddNested("S3DataSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3DataSource sets the S3DataSource field's value.
func (s *BatchSegmentJobInput_) SetS3DataSource(v *S3DataConfig) *BatchSegmentJobInput_ {
	s.S3DataSource = v
	return s
}

// The output configuration parameters of a batch segment job.
type BatchSegmentJobOutput_ struct {
	_ struct{} `type:"structure"`

	// The configuration details of an Amazon S3 input or output bucket.
	//
	// S3DataDestination is a required field
	S3DataDestination *S3DataConfig `locationName:"s3DataDestination" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchSegmentJobOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchSegmentJobOutput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchSegmentJobOutput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchSegmentJobOutput_"}
	if s.S3DataDestination == nil {
		invalidParams.Add(request.NewErrParamRequired("S3DataDestination"))
	}
	if s.S3DataDestination != nil {
		if err := s.S3DataDestination.Validate(); err != nil {
			invalidParams.AddNested("S3DataDestination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3DataDestination sets the S3DataDestination field's value.
func (s *BatchSegmentJobOutput_) SetS3DataDestination(v *S3DataConfig) *BatchSegmentJobOutput_ {
	s.S3DataDestination = v
	return s
}

// A truncated version of the BatchSegmentJob (https://docs.aws.amazon.com/personalize/latest/dg/API_BatchSegmentJob.html)
// datatype. ListBatchSegmentJobs (https://docs.aws.amazon.com/personalize/latest/dg/API_ListBatchSegmentJobs.html)
// operation returns a list of batch segment job summaries.
type BatchSegmentJobSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the batch segment job.
	BatchSegmentJobArn *string `locationName:"batchSegmentJobArn" type:"string"`

	// The time at which the batch segment job was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// If the batch segment job failed, the reason for the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The name of the batch segment job.
	JobName *string `locationName:"jobName" min:"1" type:"string"`

	// The time at which the batch segment job was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the solution version used by the batch
	// segment job to generate batch segments.
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string"`

	// The status of the batch segment job. The status is one of the following values:
	//
	//    * PENDING
	//
	//    * IN PROGRESS
	//
	//    * ACTIVE
	//
	//    * CREATE FAILED
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchSegmentJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchSegmentJobSummary) GoString() string {
	return s.String()
}

// SetBatchSegmentJobArn sets the BatchSegmentJobArn field's value.
func (s *BatchSegmentJobSummary) SetBatchSegmentJobArn(v string) *BatchSegmentJobSummary {
	s.BatchSegmentJobArn = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *BatchSegmentJobSummary) SetCreationDateTime(v time.Time) *BatchSegmentJobSummary {
	s.CreationDateTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *BatchSegmentJobSummary) SetFailureReason(v string) *BatchSegmentJobSummary {
	s.FailureReason = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *BatchSegmentJobSummary) SetJobName(v string) *BatchSegmentJobSummary {
	s.JobName = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *BatchSegmentJobSummary) SetLastUpdatedDateTime(v time.Time) *BatchSegmentJobSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *BatchSegmentJobSummary) SetSolutionVersionArn(v string) *BatchSegmentJobSummary {
	s.SolutionVersionArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *BatchSegmentJobSummary) SetStatus(v string) *BatchSegmentJobSummary {
	s.Status = &v
	return s
}

// An object that describes the deployment of a solution version. For more information
// on campaigns, see CreateCampaign (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html).
type Campaign struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the campaign.
	CampaignArn *string `locationName:"campaignArn" type:"string"`

	// The configuration details of a campaign.
	CampaignConfig *CampaignConfig `locationName:"campaignConfig" type:"structure"`

	// The date and time (in Unix format) that the campaign was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// If a campaign fails, the reason behind the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The date and time (in Unix format) that the campaign was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// Provides a summary of the properties of a campaign update. For a complete
	// listing, call the DescribeCampaign (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html)
	// API.
	LatestCampaignUpdate *CampaignUpdateSummary `locationName:"latestCampaignUpdate" type:"structure"`

	// Specifies the requested minimum provisioned transactions (recommendations)
	// per second. A high minProvisionedTPS will increase your bill. We recommend
	// starting with 1 for minProvisionedTPS (the default). Track your usage using
	// Amazon CloudWatch metrics, and increase the minProvisionedTPS as necessary.
	MinProvisionedTPS *int64 `locationName:"minProvisionedTPS" min:"1" type:"integer"`

	// The name of the campaign.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of a specific version of the solution.
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string"`

	// The status of the campaign.
	//
	// A campaign can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Campaign) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Campaign) GoString() string {
	return s.String()
}

// SetCampaignArn sets the CampaignArn field's value.
func (s *Campaign) SetCampaignArn(v string) *Campaign {
	s.CampaignArn = &v
	return s
}

// SetCampaignConfig sets the CampaignConfig field's value.
func (s *Campaign) SetCampaignConfig(v *CampaignConfig) *Campaign {
	s.CampaignConfig = v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *Campaign) SetCreationDateTime(v time.Time) *Campaign {
	s.CreationDateTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *Campaign) SetFailureReason(v string) *Campaign {
	s.FailureReason = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *Campaign) SetLastUpdatedDateTime(v time.Time) *Campaign {
	s.LastUpdatedDateTime = &v
	return s
}

// SetLatestCampaignUpdate sets the LatestCampaignUpdate field's value.
func (s *Campaign) SetLatestCampaignUpdate(v *CampaignUpdateSummary) *Campaign {
	s.LatestCampaignUpdate = v
	return s
}

// SetMinProvisionedTPS sets the MinProvisionedTPS field's value.
func (s *Campaign) SetMinProvisionedTPS(v int64) *Campaign {
	s.MinProvisionedTPS = &v
	return s
}

// SetName sets the Name field's value.
func (s *Campaign) SetName(v string) *Campaign {
	s.Name = &v
	return s
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *Campaign) SetSolutionVersionArn(v string) *Campaign {
	s.SolutionVersionArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Campaign) SetStatus(v string) *Campaign {
	s.Status = &v
	return s
}

// The configuration details of a campaign.
type CampaignConfig struct {
	_ struct{} `type:"structure"`

	// Whether metadata with recommendations is enabled for the campaign. If enabled,
	// you can specify the columns from your Items dataset in your request for recommendations.
	// Amazon Personalize returns this data for each item in the recommendation
	// response. For information about enabling metadata for a campaign, see Enabling
	// metadata in recommendations for a campaign (https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-return-metadata).
	//
	// If you enable metadata in recommendations, you will incur additional costs.
	// For more information, see Amazon Personalize pricing (https://aws.amazon.com/personalize/pricing/).
	EnableMetadataWithRecommendations *bool `locationName:"enableMetadataWithRecommendations" type:"boolean"`

	// Specifies the exploration configuration hyperparameters, including explorationWeight
	// and explorationItemAgeCutOff, you want to use to configure the amount of
	// item exploration Amazon Personalize uses when recommending items. Provide
	// itemExplorationConfig data only if your solution uses the User-Personalization
	// (https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html)
	// recipe.
	ItemExplorationConfig map[string]*string `locationName:"itemExplorationConfig" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CampaignConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CampaignConfig) GoString() string {
	return s.String()
}

// SetEnableMetadataWithRecommendations sets the EnableMetadataWithRecommendations field's value.
func (s *CampaignConfig) SetEnableMetadataWithRecommendations(v bool) *CampaignConfig {
	s.EnableMetadataWithRecommendations = &v
	return s
}

// SetItemExplorationConfig sets the ItemExplorationConfig field's value.
func (s *CampaignConfig) SetItemExplorationConfig(v map[string]*string) *CampaignConfig {
	s.ItemExplorationConfig = v
	return s
}

// Provides a summary of the properties of a campaign. For a complete listing,
// call the DescribeCampaign (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html)
// API.
type CampaignSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the campaign.
	CampaignArn *string `locationName:"campaignArn" type:"string"`

	// The date and time (in Unix time) that the campaign was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// If a campaign fails, the reason behind the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The date and time (in Unix time) that the campaign was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the campaign.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the campaign.
	//
	// A campaign can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CampaignSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CampaignSummary) GoString() string {
	return s.String()
}

// SetCampaignArn sets the CampaignArn field's value.
func (s *CampaignSummary) SetCampaignArn(v string) *CampaignSummary {
	s.CampaignArn = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CampaignSummary) SetCreationDateTime(v time.Time) *CampaignSummary {
	s.CreationDateTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *CampaignSummary) SetFailureReason(v string) *CampaignSummary {
	s.FailureReason = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *CampaignSummary) SetLastUpdatedDateTime(v time.Time) *CampaignSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *CampaignSummary) SetName(v string) *CampaignSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CampaignSummary) SetStatus(v string) *CampaignSummary {
	s.Status = &v
	return s
}

// Provides a summary of the properties of a campaign update. For a complete
// listing, call the DescribeCampaign (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html)
// API.
type CampaignUpdateSummary struct {
	_ struct{} `type:"structure"`

	// The configuration details of a campaign.
	CampaignConfig *CampaignConfig `locationName:"campaignConfig" type:"structure"`

	// The date and time (in Unix time) that the campaign update was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// If a campaign update fails, the reason behind the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The date and time (in Unix time) that the campaign update was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// Specifies the requested minimum provisioned transactions (recommendations)
	// per second that Amazon Personalize will support.
	MinProvisionedTPS *int64 `locationName:"minProvisionedTPS" min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of the deployed solution version.
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string"`

	// The status of the campaign update.
	//
	// A campaign update can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CampaignUpdateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CampaignUpdateSummary) GoString() string {
	return s.String()
}

// SetCampaignConfig sets the CampaignConfig field's value.
func (s *CampaignUpdateSummary) SetCampaignConfig(v *CampaignConfig) *CampaignUpdateSummary {
	s.CampaignConfig = v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CampaignUpdateSummary) SetCreationDateTime(v time.Time) *CampaignUpdateSummary {
	s.CreationDateTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *CampaignUpdateSummary) SetFailureReason(v string) *CampaignUpdateSummary {
	s.FailureReason = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *CampaignUpdateSummary) SetLastUpdatedDateTime(v time.Time) *CampaignUpdateSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetMinProvisionedTPS sets the MinProvisionedTPS field's value.
func (s *CampaignUpdateSummary) SetMinProvisionedTPS(v int64) *CampaignUpdateSummary {
	s.MinProvisionedTPS = &v
	return s
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *CampaignUpdateSummary) SetSolutionVersionArn(v string) *CampaignUpdateSummary {
	s.SolutionVersionArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CampaignUpdateSummary) SetStatus(v string) *CampaignUpdateSummary {
	s.Status = &v
	return s
}

// Provides the name and range of a categorical hyperparameter.
type CategoricalHyperParameterRange struct {
	_ struct{} `type:"structure"`

	// The name of the hyperparameter.
	Name *string `locationName:"name" type:"string"`

	// A list of the categories for the hyperparameter.
	Values []*string `locationName:"values" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CategoricalHyperParameterRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CategoricalHyperParameterRange) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *CategoricalHyperParameterRange) SetName(v string) *CategoricalHyperParameterRange {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *CategoricalHyperParameterRange) SetValues(v []*string) *CategoricalHyperParameterRange {
	s.Values = v
	return s
}

// Provides the name and range of a continuous hyperparameter.
type ContinuousHyperParameterRange struct {
	_ struct{} `type:"structure"`

	// The maximum allowable value for the hyperparameter.
	MaxValue *float64 `locationName:"maxValue" type:"double"`

	// The minimum allowable value for the hyperparameter.
	MinValue *float64 `locationName:"minValue" type:"double"`

	// The name of the hyperparameter.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContinuousHyperParameterRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContinuousHyperParameterRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContinuousHyperParameterRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContinuousHyperParameterRange"}
	if s.MaxValue != nil && *s.MaxValue < -1e+06 {
		invalidParams.Add(request.NewErrParamMinValue("MaxValue", -1e+06))
	}
	if s.MinValue != nil && *s.MinValue < -1e+06 {
		invalidParams.Add(request.NewErrParamMinValue("MinValue", -1e+06))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxValue sets the MaxValue field's value.
func (s *ContinuousHyperParameterRange) SetMaxValue(v float64) *ContinuousHyperParameterRange {
	s.MaxValue = &v
	return s
}

// SetMinValue sets the MinValue field's value.
func (s *ContinuousHyperParameterRange) SetMinValue(v float64) *ContinuousHyperParameterRange {
	s.MinValue = &v
	return s
}

// SetName sets the Name field's value.
func (s *ContinuousHyperParameterRange) SetName(v string) *ContinuousHyperParameterRange {
	s.Name = &v
	return s
}

type CreateBatchInferenceJobInput struct {
	_ struct{} `type:"structure"`

	// The configuration details of a batch inference job.
	BatchInferenceJobConfig *BatchInferenceJobConfig `locationName:"batchInferenceJobConfig" type:"structure"`

	// The mode of the batch inference job. To generate descriptive themes for groups
	// of similar items, set the job mode to THEME_GENERATION. If you don't want
	// to generate themes, use the default BATCH_INFERENCE.
	//
	// When you get batch recommendations with themes, you will incur additional
	// costs. For more information, see Amazon Personalize pricing (https://aws.amazon.com/personalize/pricing/).
	BatchInferenceJobMode *string `locationName:"batchInferenceJobMode" type:"string" enum:"BatchInferenceJobMode"`

	// The ARN of the filter to apply to the batch inference job. For more information
	// on using filters, see Filtering batch recommendations (https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html).
	FilterArn *string `locationName:"filterArn" type:"string"`

	// The Amazon S3 path that leads to the input file to base your recommendations
	// on. The input material must be in JSON format.
	//
	// JobInput is a required field
	JobInput *BatchInferenceJobInput `locationName:"jobInput" type:"structure" required:"true"`

	// The name of the batch inference job to create.
	//
	// JobName is a required field
	JobName *string `locationName:"jobName" min:"1" type:"string" required:"true"`

	// The path to the Amazon S3 bucket where the job's output will be stored.
	//
	// JobOutput is a required field
	JobOutput *BatchInferenceJobOutput `locationName:"jobOutput" type:"structure" required:"true"`

	// The number of recommendations to retrieve.
	NumResults *int64 `locationName:"numResults" type:"integer"`

	// The ARN of the Amazon Identity and Access Management role that has permissions
	// to read and write to your input and output Amazon S3 buckets respectively.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the solution version that will be used
	// to generate the batch inference recommendations.
	//
	// SolutionVersionArn is a required field
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string" required:"true"`

	// A list of tags (https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html)
	// to apply to the batch inference job.
	Tags []*Tag `locationName:"tags" type:"list"`

	// For theme generation jobs, specify the name of the column in your Items dataset
	// that contains each item's name.
	ThemeGenerationConfig *ThemeGenerationConfig `locationName:"themeGenerationConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBatchInferenceJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBatchInferenceJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBatchInferenceJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBatchInferenceJobInput"}
	if s.JobInput == nil {
		invalidParams.Add(request.NewErrParamRequired("JobInput"))
	}
	if s.JobName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobName"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.JobOutput == nil {
		invalidParams.Add(request.NewErrParamRequired("JobOutput"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.SolutionVersionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SolutionVersionArn"))
	}
	if s.JobInput != nil {
		if err := s.JobInput.Validate(); err != nil {
			invalidParams.AddNested("JobInput", err.(request.ErrInvalidParams))
		}
	}
	if s.JobOutput != nil {
		if err := s.JobOutput.Validate(); err != nil {
			invalidParams.AddNested("JobOutput", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ThemeGenerationConfig != nil {
		if err := s.ThemeGenerationConfig.Validate(); err != nil {
			invalidParams.AddNested("ThemeGenerationConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchInferenceJobConfig sets the BatchInferenceJobConfig field's value.
func (s *CreateBatchInferenceJobInput) SetBatchInferenceJobConfig(v *BatchInferenceJobConfig) *CreateBatchInferenceJobInput {
	s.BatchInferenceJobConfig = v
	return s
}

// SetBatchInferenceJobMode sets the BatchInferenceJobMode field's value.
func (s *CreateBatchInferenceJobInput) SetBatchInferenceJobMode(v string) *CreateBatchInferenceJobInput {
	s.BatchInferenceJobMode = &v
	return s
}

// SetFilterArn sets the FilterArn field's value.
func (s *CreateBatchInferenceJobInput) SetFilterArn(v string) *CreateBatchInferenceJobInput {
	s.FilterArn = &v
	return s
}

// SetJobInput sets the JobInput field's value.
func (s *CreateBatchInferenceJobInput) SetJobInput(v *BatchInferenceJobInput) *CreateBatchInferenceJobInput {
	s.JobInput = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *CreateBatchInferenceJobInput) SetJobName(v string) *CreateBatchInferenceJobInput {
	s.JobName = &v
	return s
}

// SetJobOutput sets the JobOutput field's value.
func (s *CreateBatchInferenceJobInput) SetJobOutput(v *BatchInferenceJobOutput) *CreateBatchInferenceJobInput {
	s.JobOutput = v
	return s
}

// SetNumResults sets the NumResults field's value.
func (s *CreateBatchInferenceJobInput) SetNumResults(v int64) *CreateBatchInferenceJobInput {
	s.NumResults = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateBatchInferenceJobInput) SetRoleArn(v string) *CreateBatchInferenceJobInput {
	s.RoleArn = &v
	return s
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *CreateBatchInferenceJobInput) SetSolutionVersionArn(v string) *CreateBatchInferenceJobInput {
	s.SolutionVersionArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateBatchInferenceJobInput) SetTags(v []*Tag) *CreateBatchInferenceJobInput {
	s.Tags = v
	return s
}

// SetThemeGenerationConfig sets the ThemeGenerationConfig field's value.
func (s *CreateBatchInferenceJobInput) SetThemeGenerationConfig(v *ThemeGenerationConfig) *CreateBatchInferenceJobInput {
	s.ThemeGenerationConfig = v
	return s
}

type CreateBatchInferenceJobOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the batch inference job.
	BatchInferenceJobArn *string `locationName:"batchInferenceJobArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBatchInferenceJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBatchInferenceJobOutput) GoString() string {
	return s.String()
}

// SetBatchInferenceJobArn sets the BatchInferenceJobArn field's value.
func (s *CreateBatchInferenceJobOutput) SetBatchInferenceJobArn(v string) *CreateBatchInferenceJobOutput {
	s.BatchInferenceJobArn = &v
	return s
}

type CreateBatchSegmentJobInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the filter to apply to the batch segment job. For more information
	// on using filters, see Filtering batch recommendations (https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html).
	FilterArn *string `locationName:"filterArn" type:"string"`

	// The Amazon S3 path for the input data used to generate the batch segment
	// job.
	//
	// JobInput is a required field
	JobInput *BatchSegmentJobInput_ `locationName:"jobInput" type:"structure" required:"true"`

	// The name of the batch segment job to create.
	//
	// JobName is a required field
	JobName *string `locationName:"jobName" min:"1" type:"string" required:"true"`

	// The Amazon S3 path for the bucket where the job's output will be stored.
	//
	// JobOutput is a required field
	JobOutput *BatchSegmentJobOutput_ `locationName:"jobOutput" type:"structure" required:"true"`

	// The number of predicted users generated by the batch segment job for each
	// line of input data. The maximum number of users per segment is 5 million.
	NumResults *int64 `locationName:"numResults" type:"integer"`

	// The ARN of the Amazon Identity and Access Management role that has permissions
	// to read and write to your input and output Amazon S3 buckets respectively.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the solution version you want the batch
	// segment job to use to generate batch segments.
	//
	// SolutionVersionArn is a required field
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string" required:"true"`

	// A list of tags (https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html)
	// to apply to the batch segment job.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBatchSegmentJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBatchSegmentJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBatchSegmentJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBatchSegmentJobInput"}
	if s.JobInput == nil {
		invalidParams.Add(request.NewErrParamRequired("JobInput"))
	}
	if s.JobName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobName"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.JobOutput == nil {
		invalidParams.Add(request.NewErrParamRequired("JobOutput"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.SolutionVersionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SolutionVersionArn"))
	}
	if s.JobInput != nil {
		if err := s.JobInput.Validate(); err != nil {
			invalidParams.AddNested("JobInput", err.(request.ErrInvalidParams))
		}
	}
	if s.JobOutput != nil {
		if err := s.JobOutput.Validate(); err != nil {
			invalidParams.AddNested("JobOutput", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterArn sets the FilterArn field's value.
func (s *CreateBatchSegmentJobInput) SetFilterArn(v string) *CreateBatchSegmentJobInput {
	s.FilterArn = &v
	return s
}

// SetJobInput sets the JobInput field's value.
func (s *CreateBatchSegmentJobInput) SetJobInput(v *BatchSegmentJobInput_) *CreateBatchSegmentJobInput {
	s.JobInput = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *CreateBatchSegmentJobInput) SetJobName(v string) *CreateBatchSegmentJobInput {
	s.JobName = &v
	return s
}

// SetJobOutput sets the JobOutput field's value.
func (s *CreateBatchSegmentJobInput) SetJobOutput(v *BatchSegmentJobOutput_) *CreateBatchSegmentJobInput {
	s.JobOutput = v
	return s
}

// SetNumResults sets the NumResults field's value.
func (s *CreateBatchSegmentJobInput) SetNumResults(v int64) *CreateBatchSegmentJobInput {
	s.NumResults = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateBatchSegmentJobInput) SetRoleArn(v string) *CreateBatchSegmentJobInput {
	s.RoleArn = &v
	return s
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *CreateBatchSegmentJobInput) SetSolutionVersionArn(v string) *CreateBatchSegmentJobInput {
	s.SolutionVersionArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateBatchSegmentJobInput) SetTags(v []*Tag) *CreateBatchSegmentJobInput {
	s.Tags = v
	return s
}

type CreateBatchSegmentJobOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the batch segment job.
	BatchSegmentJobArn *string `locationName:"batchSegmentJobArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBatchSegmentJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBatchSegmentJobOutput) GoString() string {
	return s.String()
}

// SetBatchSegmentJobArn sets the BatchSegmentJobArn field's value.
func (s *CreateBatchSegmentJobOutput) SetBatchSegmentJobArn(v string) *CreateBatchSegmentJobOutput {
	s.BatchSegmentJobArn = &v
	return s
}

type CreateCampaignInput struct {
	_ struct{} `type:"structure"`

	// The configuration details of a campaign.
	CampaignConfig *CampaignConfig `locationName:"campaignConfig" type:"structure"`

	// Specifies the requested minimum provisioned transactions (recommendations)
	// per second that Amazon Personalize will support. A high minProvisionedTPS
	// will increase your bill. We recommend starting with 1 for minProvisionedTPS
	// (the default). Track your usage using Amazon CloudWatch metrics, and increase
	// the minProvisionedTPS as necessary.
	MinProvisionedTPS *int64 `locationName:"minProvisionedTPS" min:"1" type:"integer"`

	// A name for the new campaign. The campaign name must be unique within your
	// account.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the solution version to deploy.
	//
	// SolutionVersionArn is a required field
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string" required:"true"`

	// A list of tags (https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html)
	// to apply to the campaign.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCampaignInput"}
	if s.MinProvisionedTPS != nil && *s.MinProvisionedTPS < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinProvisionedTPS", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SolutionVersionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SolutionVersionArn"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCampaignConfig sets the CampaignConfig field's value.
func (s *CreateCampaignInput) SetCampaignConfig(v *CampaignConfig) *CreateCampaignInput {
	s.CampaignConfig = v
	return s
}

// SetMinProvisionedTPS sets the MinProvisionedTPS field's value.
func (s *CreateCampaignInput) SetMinProvisionedTPS(v int64) *CreateCampaignInput {
	s.MinProvisionedTPS = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCampaignInput) SetName(v string) *CreateCampaignInput {
	s.Name = &v
	return s
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *CreateCampaignInput) SetSolutionVersionArn(v string) *CreateCampaignInput {
	s.SolutionVersionArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCampaignInput) SetTags(v []*Tag) *CreateCampaignInput {
	s.Tags = v
	return s
}

type CreateCampaignOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the campaign.
	CampaignArn *string `locationName:"campaignArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCampaignOutput) GoString() string {
	return s.String()
}

// SetCampaignArn sets the CampaignArn field's value.
func (s *CreateCampaignOutput) SetCampaignArn(v string) *CreateCampaignOutput {
	s.CampaignArn = &v
	return s
}

type CreateDatasetExportJobInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset that contains the data to export.
	//
	// DatasetArn is a required field
	DatasetArn *string `locationName:"datasetArn" type:"string" required:"true"`

	// The data to export, based on how you imported the data. You can choose to
	// export only BULK data that you imported using a dataset import job, only
	// PUT data that you imported incrementally (using the console, PutEvents, PutUsers
	// and PutItems operations), or ALL for both types. The default value is PUT.
	IngestionMode *string `locationName:"ingestionMode" type:"string" enum:"IngestionMode"`

	// The name for the dataset export job.
	//
	// JobName is a required field
	JobName *string `locationName:"jobName" min:"1" type:"string" required:"true"`

	// The path to the Amazon S3 bucket where the job's output is stored.
	//
	// JobOutput is a required field
	JobOutput *DatasetExportJobOutput `locationName:"jobOutput" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM service role that has permissions
	// to add data to your output Amazon S3 bucket.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// A list of tags (https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html)
	// to apply to the dataset export job.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetExportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetExportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatasetExportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDatasetExportJobInput"}
	if s.DatasetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetArn"))
	}
	if s.JobName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobName"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.JobOutput == nil {
		invalidParams.Add(request.NewErrParamRequired("JobOutput"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.JobOutput != nil {
		if err := s.JobOutput.Validate(); err != nil {
			invalidParams.AddNested("JobOutput", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *CreateDatasetExportJobInput) SetDatasetArn(v string) *CreateDatasetExportJobInput {
	s.DatasetArn = &v
	return s
}

// SetIngestionMode sets the IngestionMode field's value.
func (s *CreateDatasetExportJobInput) SetIngestionMode(v string) *CreateDatasetExportJobInput {
	s.IngestionMode = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *CreateDatasetExportJobInput) SetJobName(v string) *CreateDatasetExportJobInput {
	s.JobName = &v
	return s
}

// SetJobOutput sets the JobOutput field's value.
func (s *CreateDatasetExportJobInput) SetJobOutput(v *DatasetExportJobOutput) *CreateDatasetExportJobInput {
	s.JobOutput = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateDatasetExportJobInput) SetRoleArn(v string) *CreateDatasetExportJobInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDatasetExportJobInput) SetTags(v []*Tag) *CreateDatasetExportJobInput {
	s.Tags = v
	return s
}

type CreateDatasetExportJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset export job.
	DatasetExportJobArn *string `locationName:"datasetExportJobArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetExportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetExportJobOutput) GoString() string {
	return s.String()
}

// SetDatasetExportJobArn sets the DatasetExportJobArn field's value.
func (s *CreateDatasetExportJobOutput) SetDatasetExportJobArn(v string) *CreateDatasetExportJobOutput {
	s.DatasetExportJobArn = &v
	return s
}

type CreateDatasetGroupInput struct {
	_ struct{} `type:"structure"`

	// The domain of the dataset group. Specify a domain to create a Domain dataset
	// group. The domain you specify determines the default schemas for datasets
	// and the use cases available for recommenders. If you don't specify a domain,
	// you create a Custom dataset group with solution versions that you deploy
	// with a campaign.
	Domain *string `locationName:"domain" type:"string" enum:"Domain"`

	// The Amazon Resource Name (ARN) of a Key Management Service (KMS) key used
	// to encrypt the datasets.
	KmsKeyArn *string `locationName:"kmsKeyArn" type:"string"`

	// The name for the new dataset group.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The ARN of the Identity and Access Management (IAM) role that has permissions
	// to access the Key Management Service (KMS) key. Supplying an IAM role is
	// only valid when also specifying a KMS key.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// A list of tags (https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html)
	// to apply to the dataset group.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatasetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDatasetGroupInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *CreateDatasetGroupInput) SetDomain(v string) *CreateDatasetGroupInput {
	s.Domain = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *CreateDatasetGroupInput) SetKmsKeyArn(v string) *CreateDatasetGroupInput {
	s.KmsKeyArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDatasetGroupInput) SetName(v string) *CreateDatasetGroupInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateDatasetGroupInput) SetRoleArn(v string) *CreateDatasetGroupInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDatasetGroupInput) SetTags(v []*Tag) *CreateDatasetGroupInput {
	s.Tags = v
	return s
}

type CreateDatasetGroupOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the new dataset group.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// The domain for the new Domain dataset group.
	Domain *string `locationName:"domain" type:"string" enum:"Domain"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetGroupOutput) GoString() string {
	return s.String()
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *CreateDatasetGroupOutput) SetDatasetGroupArn(v string) *CreateDatasetGroupOutput {
	s.DatasetGroupArn = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *CreateDatasetGroupOutput) SetDomain(v string) *CreateDatasetGroupOutput {
	s.Domain = &v
	return s
}

type CreateDatasetImportJobInput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket that contains the training data to import.
	//
	// DataSource is a required field
	DataSource *DataSource `locationName:"dataSource" type:"structure" required:"true"`

	// The ARN of the dataset that receives the imported data.
	//
	// DatasetArn is a required field
	DatasetArn *string `locationName:"datasetArn" type:"string" required:"true"`

	// Specify how to add the new records to an existing dataset. The default import
	// mode is FULL. If you haven't imported bulk records into the dataset previously,
	// you can only specify FULL.
	//
	//    * Specify FULL to overwrite all existing bulk data in your dataset. Data
	//    you imported individually is not replaced.
	//
	//    * Specify INCREMENTAL to append the new records to the existing data in
	//    your dataset. Amazon Personalize replaces any record with the same ID
	//    with the new one.
	ImportMode *string `locationName:"importMode" type:"string" enum:"ImportMode"`

	// The name for the dataset import job.
	//
	// JobName is a required field
	JobName *string `locationName:"jobName" min:"1" type:"string" required:"true"`

	// If you created a metric attribution, specify whether to publish metrics for
	// this import job to Amazon S3
	PublishAttributionMetricsToS3 *bool `locationName:"publishAttributionMetricsToS3" type:"boolean"`

	// The ARN of the IAM role that has permissions to read from the Amazon S3 data
	// source.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// A list of tags (https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html)
	// to apply to the dataset import job.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatasetImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDatasetImportJobInput"}
	if s.DataSource == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSource"))
	}
	if s.DatasetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetArn"))
	}
	if s.JobName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobName"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSource sets the DataSource field's value.
func (s *CreateDatasetImportJobInput) SetDataSource(v *DataSource) *CreateDatasetImportJobInput {
	s.DataSource = v
	return s
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *CreateDatasetImportJobInput) SetDatasetArn(v string) *CreateDatasetImportJobInput {
	s.DatasetArn = &v
	return s
}

// SetImportMode sets the ImportMode field's value.
func (s *CreateDatasetImportJobInput) SetImportMode(v string) *CreateDatasetImportJobInput {
	s.ImportMode = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *CreateDatasetImportJobInput) SetJobName(v string) *CreateDatasetImportJobInput {
	s.JobName = &v
	return s
}

// SetPublishAttributionMetricsToS3 sets the PublishAttributionMetricsToS3 field's value.
func (s *CreateDatasetImportJobInput) SetPublishAttributionMetricsToS3(v bool) *CreateDatasetImportJobInput {
	s.PublishAttributionMetricsToS3 = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateDatasetImportJobInput) SetRoleArn(v string) *CreateDatasetImportJobInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDatasetImportJobInput) SetTags(v []*Tag) *CreateDatasetImportJobInput {
	s.Tags = v
	return s
}

type CreateDatasetImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the dataset import job.
	DatasetImportJobArn *string `locationName:"datasetImportJobArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetImportJobOutput) GoString() string {
	return s.String()
}

// SetDatasetImportJobArn sets the DatasetImportJobArn field's value.
func (s *CreateDatasetImportJobOutput) SetDatasetImportJobArn(v string) *CreateDatasetImportJobOutput {
	s.DatasetImportJobArn = &v
	return s
}

type CreateDatasetInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset group to add the dataset to.
	//
	// DatasetGroupArn is a required field
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string" required:"true"`

	// The type of dataset.
	//
	// One of the following (case insensitive) values:
	//
	//    * Interactions
	//
	//    * Items
	//
	//    * Users
	//
	//    * Actions
	//
	//    * Action_Interactions
	//
	// DatasetType is a required field
	DatasetType *string `locationName:"datasetType" type:"string" required:"true"`

	// The name for the dataset.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The ARN of the schema to associate with the dataset. The schema defines the
	// dataset fields.
	//
	// SchemaArn is a required field
	SchemaArn *string `locationName:"schemaArn" type:"string" required:"true"`

	// A list of tags (https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html)
	// to apply to the dataset.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDatasetInput"}
	if s.DatasetGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetGroupArn"))
	}
	if s.DatasetType == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetType"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaArn"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *CreateDatasetInput) SetDatasetGroupArn(v string) *CreateDatasetInput {
	s.DatasetGroupArn = &v
	return s
}

// SetDatasetType sets the DatasetType field's value.
func (s *CreateDatasetInput) SetDatasetType(v string) *CreateDatasetInput {
	s.DatasetType = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDatasetInput) SetName(v string) *CreateDatasetInput {
	s.Name = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *CreateDatasetInput) SetSchemaArn(v string) *CreateDatasetInput {
	s.SchemaArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDatasetInput) SetTags(v []*Tag) *CreateDatasetInput {
	s.Tags = v
	return s
}

type CreateDatasetOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the dataset.
	DatasetArn *string `locationName:"datasetArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetOutput) GoString() string {
	return s.String()
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *CreateDatasetOutput) SetDatasetArn(v string) *CreateDatasetOutput {
	s.DatasetArn = &v
	return s
}

type CreateEventTrackerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset group that receives the event
	// data.
	//
	// DatasetGroupArn is a required field
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string" required:"true"`

	// The name for the event tracker.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A list of tags (https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html)
	// to apply to the event tracker.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventTrackerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventTrackerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEventTrackerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEventTrackerInput"}
	if s.DatasetGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetGroupArn"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *CreateEventTrackerInput) SetDatasetGroupArn(v string) *CreateEventTrackerInput {
	s.DatasetGroupArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEventTrackerInput) SetName(v string) *CreateEventTrackerInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEventTrackerInput) SetTags(v []*Tag) *CreateEventTrackerInput {
	s.Tags = v
	return s
}

type CreateEventTrackerOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the event tracker.
	EventTrackerArn *string `locationName:"eventTrackerArn" type:"string"`

	// The ID of the event tracker. Include this ID in requests to the PutEvents
	// (https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html)
	// API.
	TrackingId *string `locationName:"trackingId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventTrackerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventTrackerOutput) GoString() string {
	return s.String()
}

// SetEventTrackerArn sets the EventTrackerArn field's value.
func (s *CreateEventTrackerOutput) SetEventTrackerArn(v string) *CreateEventTrackerOutput {
	s.EventTrackerArn = &v
	return s
}

// SetTrackingId sets the TrackingId field's value.
func (s *CreateEventTrackerOutput) SetTrackingId(v string) *CreateEventTrackerOutput {
	s.TrackingId = &v
	return s
}

type CreateFilterInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the dataset group that the filter will belong to.
	//
	// DatasetGroupArn is a required field
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string" required:"true"`

	// The filter expression defines which items are included or excluded from recommendations.
	// Filter expression must follow specific format rules. For information about
	// filter expression structure and syntax, see Filter expressions (https://docs.aws.amazon.com/personalize/latest/dg/filter-expressions.html).
	//
	// FilterExpression is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateFilterInput's
	// String and GoString methods.
	//
	// FilterExpression is a required field
	FilterExpression *string `locationName:"filterExpression" min:"1" type:"string" required:"true" sensitive:"true"`

	// The name of the filter to create.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A list of tags (https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html)
	// to apply to the filter.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFilterInput"}
	if s.DatasetGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetGroupArn"))
	}
	if s.FilterExpression == nil {
		invalidParams.Add(request.NewErrParamRequired("FilterExpression"))
	}
	if s.FilterExpression != nil && len(*s.FilterExpression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FilterExpression", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *CreateFilterInput) SetDatasetGroupArn(v string) *CreateFilterInput {
	s.DatasetGroupArn = &v
	return s
}

// SetFilterExpression sets the FilterExpression field's value.
func (s *CreateFilterInput) SetFilterExpression(v string) *CreateFilterInput {
	s.FilterExpression = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFilterInput) SetName(v string) *CreateFilterInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFilterInput) SetTags(v []*Tag) *CreateFilterInput {
	s.Tags = v
	return s
}

type CreateFilterOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the new filter.
	FilterArn *string `locationName:"filterArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFilterOutput) GoString() string {
	return s.String()
}

// SetFilterArn sets the FilterArn field's value.
func (s *CreateFilterOutput) SetFilterArn(v string) *CreateFilterOutput {
	s.FilterArn = &v
	return s
}

type CreateMetricAttributionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the destination dataset group for the metric
	// attribution.
	//
	// DatasetGroupArn is a required field
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string" required:"true"`

	// A list of metric attributes for the metric attribution. Each metric attribute
	// specifies an event type to track and a function. Available functions are
	// SUM() or SAMPLECOUNT(). For SUM() functions, provide the dataset type (either
	// Interactions or Items) and column to sum as a parameter. For example SUM(Items.PRICE).
	//
	// Metrics is a required field
	Metrics []*MetricAttribute `locationName:"metrics" type:"list" required:"true"`

	// The output configuration details for the metric attribution.
	//
	// MetricsOutputConfig is a required field
	MetricsOutputConfig *MetricAttributionOutput_ `locationName:"metricsOutputConfig" type:"structure" required:"true"`

	// A name for the metric attribution.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMetricAttributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMetricAttributionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMetricAttributionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMetricAttributionInput"}
	if s.DatasetGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetGroupArn"))
	}
	if s.Metrics == nil {
		invalidParams.Add(request.NewErrParamRequired("Metrics"))
	}
	if s.MetricsOutputConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricsOutputConfig"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Metrics != nil {
		for i, v := range s.Metrics {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Metrics", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MetricsOutputConfig != nil {
		if err := s.MetricsOutputConfig.Validate(); err != nil {
			invalidParams.AddNested("MetricsOutputConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *CreateMetricAttributionInput) SetDatasetGroupArn(v string) *CreateMetricAttributionInput {
	s.DatasetGroupArn = &v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *CreateMetricAttributionInput) SetMetrics(v []*MetricAttribute) *CreateMetricAttributionInput {
	s.Metrics = v
	return s
}

// SetMetricsOutputConfig sets the MetricsOutputConfig field's value.
func (s *CreateMetricAttributionInput) SetMetricsOutputConfig(v *MetricAttributionOutput_) *CreateMetricAttributionInput {
	s.MetricsOutputConfig = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateMetricAttributionInput) SetName(v string) *CreateMetricAttributionInput {
	s.Name = &v
	return s
}

type CreateMetricAttributionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the new metric attribution.
	MetricAttributionArn *string `locationName:"metricAttributionArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMetricAttributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMetricAttributionOutput) GoString() string {
	return s.String()
}

// SetMetricAttributionArn sets the MetricAttributionArn field's value.
func (s *CreateMetricAttributionOutput) SetMetricAttributionArn(v string) *CreateMetricAttributionOutput {
	s.MetricAttributionArn = &v
	return s
}

type CreateRecommenderInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the destination domain dataset group for
	// the recommender.
	//
	// DatasetGroupArn is a required field
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string" required:"true"`

	// The name of the recommender.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the recipe that the recommender will use.
	// For a recommender, a recipe is a Domain dataset group use case. Only Domain
	// dataset group use cases can be used to create a recommender. For information
	// about use cases see Choosing recommender use cases (https://docs.aws.amazon.com/personalize/latest/dg/domain-use-cases.html).
	//
	// RecipeArn is a required field
	RecipeArn *string `locationName:"recipeArn" type:"string" required:"true"`

	// The configuration details of the recommender.
	RecommenderConfig *RecommenderConfig `locationName:"recommenderConfig" type:"structure"`

	// A list of tags (https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html)
	// to apply to the recommender.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRecommenderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRecommenderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRecommenderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRecommenderInput"}
	if s.DatasetGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetGroupArn"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RecipeArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RecipeArn"))
	}
	if s.RecommenderConfig != nil {
		if err := s.RecommenderConfig.Validate(); err != nil {
			invalidParams.AddNested("RecommenderConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *CreateRecommenderInput) SetDatasetGroupArn(v string) *CreateRecommenderInput {
	s.DatasetGroupArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRecommenderInput) SetName(v string) *CreateRecommenderInput {
	s.Name = &v
	return s
}

// SetRecipeArn sets the RecipeArn field's value.
func (s *CreateRecommenderInput) SetRecipeArn(v string) *CreateRecommenderInput {
	s.RecipeArn = &v
	return s
}

// SetRecommenderConfig sets the RecommenderConfig field's value.
func (s *CreateRecommenderInput) SetRecommenderConfig(v *RecommenderConfig) *CreateRecommenderInput {
	s.RecommenderConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRecommenderInput) SetTags(v []*Tag) *CreateRecommenderInput {
	s.Tags = v
	return s
}

type CreateRecommenderOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the recommender.
	RecommenderArn *string `locationName:"recommenderArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRecommenderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRecommenderOutput) GoString() string {
	return s.String()
}

// SetRecommenderArn sets the RecommenderArn field's value.
func (s *CreateRecommenderOutput) SetRecommenderArn(v string) *CreateRecommenderOutput {
	s.RecommenderArn = &v
	return s
}

type CreateSchemaInput struct {
	_ struct{} `type:"structure"`

	// The domain for the schema. If you are creating a schema for a dataset in
	// a Domain dataset group, specify the domain you chose when you created the
	// Domain dataset group.
	Domain *string `locationName:"domain" type:"string" enum:"Domain"`

	// The name for the schema.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A schema in Avro JSON format.
	//
	// Schema is a required field
	Schema *string `locationName:"schema" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSchemaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSchemaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSchemaInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Schema == nil {
		invalidParams.Add(request.NewErrParamRequired("Schema"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *CreateSchemaInput) SetDomain(v string) *CreateSchemaInput {
	s.Domain = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSchemaInput) SetName(v string) *CreateSchemaInput {
	s.Name = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *CreateSchemaInput) SetSchema(v string) *CreateSchemaInput {
	s.Schema = &v
	return s
}

type CreateSchemaOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the created schema.
	SchemaArn *string `locationName:"schemaArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSchemaOutput) GoString() string {
	return s.String()
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *CreateSchemaOutput) SetSchemaArn(v string) *CreateSchemaOutput {
	s.SchemaArn = &v
	return s
}

type CreateSolutionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset group that provides the training
	// data.
	//
	// DatasetGroupArn is a required field
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string" required:"true"`

	// When your have multiple event types (using an EVENT_TYPE schema field), this
	// parameter specifies which event type (for example, 'click' or 'like') is
	// used for training the model.
	//
	// If you do not provide an eventType, Amazon Personalize will use all interactions
	// for training with equal weight regardless of type.
	EventType *string `locationName:"eventType" type:"string"`

	// The name for the solution.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	//
	// We don't recommend enabling automated machine learning. Instead, match your
	// use case to the available Amazon Personalize recipes. For more information,
	// see Choosing a recipe (https://docs.aws.amazon.com/personalize/latest/dg/working-with-predefined-recipes.html).
	//
	// Whether to perform automated machine learning (AutoML). The default is false.
	// For this case, you must specify recipeArn.
	//
	// When set to true, Amazon Personalize analyzes your training data and selects
	// the optimal USER_PERSONALIZATION recipe and hyperparameters. In this case,
	// you must omit recipeArn. Amazon Personalize determines the optimal recipe
	// by running tests with different values for the hyperparameters. AutoML lengthens
	// the training process as compared to selecting a specific recipe.
	PerformAutoML *bool `locationName:"performAutoML" type:"boolean"`

	// Whether to perform hyperparameter optimization (HPO) on the specified or
	// selected recipe. The default is false.
	//
	// When performing AutoML, this parameter is always true and you should not
	// set it to false.
	PerformHPO *bool `locationName:"performHPO" type:"boolean"`

	// The Amazon Resource Name (ARN) of the recipe to use for model training. This
	// is required when performAutoML is false. For information about different
	// Amazon Personalize recipes and their ARNs, see Choosing a recipe (https://docs.aws.amazon.com/personalize/latest/dg/working-with-predefined-recipes.html).
	RecipeArn *string `locationName:"recipeArn" type:"string"`

	// The configuration to use with the solution. When performAutoML is set to
	// true, Amazon Personalize only evaluates the autoMLConfig section of the solution
	// configuration.
	//
	// Amazon Personalize doesn't support configuring the hpoObjective at this time.
	SolutionConfig *SolutionConfig `locationName:"solutionConfig" type:"structure"`

	// A list of tags (https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html)
	// to apply to the solution.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSolutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSolutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSolutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSolutionInput"}
	if s.DatasetGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetGroupArn"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SolutionConfig != nil {
		if err := s.SolutionConfig.Validate(); err != nil {
			invalidParams.AddNested("SolutionConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *CreateSolutionInput) SetDatasetGroupArn(v string) *CreateSolutionInput {
	s.DatasetGroupArn = &v
	return s
}

// SetEventType sets the EventType field's value.
func (s *CreateSolutionInput) SetEventType(v string) *CreateSolutionInput {
	s.EventType = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSolutionInput) SetName(v string) *CreateSolutionInput {
	s.Name = &v
	return s
}

// SetPerformAutoML sets the PerformAutoML field's value.
func (s *CreateSolutionInput) SetPerformAutoML(v bool) *CreateSolutionInput {
	s.PerformAutoML = &v
	return s
}

// SetPerformHPO sets the PerformHPO field's value.
func (s *CreateSolutionInput) SetPerformHPO(v bool) *CreateSolutionInput {
	s.PerformHPO = &v
	return s
}

// SetRecipeArn sets the RecipeArn field's value.
func (s *CreateSolutionInput) SetRecipeArn(v string) *CreateSolutionInput {
	s.RecipeArn = &v
	return s
}

// SetSolutionConfig sets the SolutionConfig field's value.
func (s *CreateSolutionInput) SetSolutionConfig(v *SolutionConfig) *CreateSolutionInput {
	s.SolutionConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSolutionInput) SetTags(v []*Tag) *CreateSolutionInput {
	s.Tags = v
	return s
}

type CreateSolutionOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the solution.
	SolutionArn *string `locationName:"solutionArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSolutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSolutionOutput) GoString() string {
	return s.String()
}

// SetSolutionArn sets the SolutionArn field's value.
func (s *CreateSolutionOutput) SetSolutionArn(v string) *CreateSolutionOutput {
	s.SolutionArn = &v
	return s
}

type CreateSolutionVersionInput struct {
	_ struct{} `type:"structure"`

	// The name of the solution version.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the solution containing the training configuration
	// information.
	//
	// SolutionArn is a required field
	SolutionArn *string `locationName:"solutionArn" type:"string" required:"true"`

	// A list of tags (https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html)
	// to apply to the solution version.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The scope of training to be performed when creating the solution version.
	// The default is FULL. This creates a completely new model based on the entirety
	// of the training data from the datasets in your dataset group.
	//
	// If you use User-Personalization (https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html),
	// you can specify a training mode of UPDATE. This updates the model to consider
	// new items for recommendations. It is not a full retraining. You should still
	// complete a full retraining weekly. If you specify UPDATE, Amazon Personalize
	// will stop automatic updates for the solution version. To resume updates,
	// create a new solution with training mode set to FULL and deploy it in a campaign.
	// For more information about automatic updates, see Automatic updates (https://docs.aws.amazon.com/personalize/latest/dg/use-case-recipe-features.html#maintaining-with-automatic-updates).
	//
	// The UPDATE option can only be used when you already have an active solution
	// version created from the input solution using the FULL option and the input
	// solution was trained with the User-Personalization (https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html)
	// recipe or the legacy HRNN-Coldstart (https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html)
	// recipe.
	TrainingMode *string `locationName:"trainingMode" type:"string" enum:"TrainingMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSolutionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSolutionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSolutionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSolutionVersionInput"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SolutionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SolutionArn"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateSolutionVersionInput) SetName(v string) *CreateSolutionVersionInput {
	s.Name = &v
	return s
}

// SetSolutionArn sets the SolutionArn field's value.
func (s *CreateSolutionVersionInput) SetSolutionArn(v string) *CreateSolutionVersionInput {
	s.SolutionArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSolutionVersionInput) SetTags(v []*Tag) *CreateSolutionVersionInput {
	s.Tags = v
	return s
}

// SetTrainingMode sets the TrainingMode field's value.
func (s *CreateSolutionVersionInput) SetTrainingMode(v string) *CreateSolutionVersionInput {
	s.TrainingMode = &v
	return s
}

type CreateSolutionVersionOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the new solution version.
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSolutionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSolutionVersionOutput) GoString() string {
	return s.String()
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *CreateSolutionVersionOutput) SetSolutionVersionArn(v string) *CreateSolutionVersionOutput {
	s.SolutionVersionArn = &v
	return s
}

// Describes the data source that contains the data to upload to a dataset.
type DataSource struct {
	_ struct{} `type:"structure"`

	// The path to the Amazon S3 bucket where the data that you want to upload to
	// your dataset is stored. For example:
	//
	// s3://bucket-name/folder-name/
	DataLocation *string `locationName:"dataLocation" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSource) GoString() string {
	return s.String()
}

// SetDataLocation sets the DataLocation field's value.
func (s *DataSource) SetDataLocation(v string) *DataSource {
	s.DataLocation = &v
	return s
}

// Provides metadata for a dataset.
type Dataset struct {
	_ struct{} `type:"structure"`

	// The creation date and time (in Unix time) of the dataset.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset that you want metadata for.
	DatasetArn *string `locationName:"datasetArn" type:"string"`

	// The Amazon Resource Name (ARN) of the dataset group.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// One of the following values:
	//
	//    * Interactions
	//
	//    * Items
	//
	//    * Users
	//
	//    * Actions
	//
	//    * Action_Interactions
	DatasetType *string `locationName:"datasetType" type:"string"`

	// A time stamp that shows when the dataset was updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// Describes the latest update to the dataset.
	LatestDatasetUpdate *DatasetUpdateSummary `locationName:"latestDatasetUpdate" type:"structure"`

	// The name of the dataset.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The ARN of the associated schema.
	SchemaArn *string `locationName:"schemaArn" type:"string"`

	// The status of the dataset.
	//
	// A dataset can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`

	// The ID of the event tracker for an Action interactions dataset. You specify
	// the tracker's ID in the PutActionInteractions API operation. Amazon Personalize
	// uses it to direct new data to the Action interactions dataset in your dataset
	// group.
	TrackingId *string `locationName:"trackingId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Dataset) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Dataset) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *Dataset) SetCreationDateTime(v time.Time) *Dataset {
	s.CreationDateTime = &v
	return s
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *Dataset) SetDatasetArn(v string) *Dataset {
	s.DatasetArn = &v
	return s
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *Dataset) SetDatasetGroupArn(v string) *Dataset {
	s.DatasetGroupArn = &v
	return s
}

// SetDatasetType sets the DatasetType field's value.
func (s *Dataset) SetDatasetType(v string) *Dataset {
	s.DatasetType = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *Dataset) SetLastUpdatedDateTime(v time.Time) *Dataset {
	s.LastUpdatedDateTime = &v
	return s
}

// SetLatestDatasetUpdate sets the LatestDatasetUpdate field's value.
func (s *Dataset) SetLatestDatasetUpdate(v *DatasetUpdateSummary) *Dataset {
	s.LatestDatasetUpdate = v
	return s
}

// SetName sets the Name field's value.
func (s *Dataset) SetName(v string) *Dataset {
	s.Name = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *Dataset) SetSchemaArn(v string) *Dataset {
	s.SchemaArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Dataset) SetStatus(v string) *Dataset {
	s.Status = &v
	return s
}

// SetTrackingId sets the TrackingId field's value.
func (s *Dataset) SetTrackingId(v string) *Dataset {
	s.TrackingId = &v
	return s
}

// Describes a job that exports a dataset to an Amazon S3 bucket. For more information,
// see CreateDatasetExportJob (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetExportJob.html).
//
// A dataset export job can be in one of the following states:
//
//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
type DatasetExportJob struct {
	_ struct{} `type:"structure"`

	// The creation date and time (in Unix time) of the dataset export job.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset to export.
	DatasetArn *string `locationName:"datasetArn" type:"string"`

	// The Amazon Resource Name (ARN) of the dataset export job.
	DatasetExportJobArn *string `locationName:"datasetExportJobArn" type:"string"`

	// If a dataset export job fails, provides the reason why.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The data to export, based on how you imported the data. You can choose to
	// export BULK data that you imported using a dataset import job, PUT data that
	// you imported incrementally (using the console, PutEvents, PutUsers and PutItems
	// operations), or ALL for both types. The default value is PUT.
	IngestionMode *string `locationName:"ingestionMode" type:"string" enum:"IngestionMode"`

	// The name of the export job.
	JobName *string `locationName:"jobName" min:"1" type:"string"`

	// The path to the Amazon S3 bucket where the job's output is stored. For example:
	//
	// s3://bucket-name/folder-name/
	JobOutput *DatasetExportJobOutput `locationName:"jobOutput" type:"structure"`

	// The date and time (in Unix time) the status of the dataset export job was
	// last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the IAM service role that has permissions
	// to add data to your output Amazon S3 bucket.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The status of the dataset export job.
	//
	// A dataset export job can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetExportJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetExportJob) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DatasetExportJob) SetCreationDateTime(v time.Time) *DatasetExportJob {
	s.CreationDateTime = &v
	return s
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *DatasetExportJob) SetDatasetArn(v string) *DatasetExportJob {
	s.DatasetArn = &v
	return s
}

// SetDatasetExportJobArn sets the DatasetExportJobArn field's value.
func (s *DatasetExportJob) SetDatasetExportJobArn(v string) *DatasetExportJob {
	s.DatasetExportJobArn = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DatasetExportJob) SetFailureReason(v string) *DatasetExportJob {
	s.FailureReason = &v
	return s
}

// SetIngestionMode sets the IngestionMode field's value.
func (s *DatasetExportJob) SetIngestionMode(v string) *DatasetExportJob {
	s.IngestionMode = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *DatasetExportJob) SetJobName(v string) *DatasetExportJob {
	s.JobName = &v
	return s
}

// SetJobOutput sets the JobOutput field's value.
func (s *DatasetExportJob) SetJobOutput(v *DatasetExportJobOutput) *DatasetExportJob {
	s.JobOutput = v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DatasetExportJob) SetLastUpdatedDateTime(v time.Time) *DatasetExportJob {
	s.LastUpdatedDateTime = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DatasetExportJob) SetRoleArn(v string) *DatasetExportJob {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DatasetExportJob) SetStatus(v string) *DatasetExportJob {
	s.Status = &v
	return s
}

// The output configuration parameters of a dataset export job.
type DatasetExportJobOutput struct {
	_ struct{} `type:"structure"`

	// The configuration details of an Amazon S3 input or output bucket.
	//
	// S3DataDestination is a required field
	S3DataDestination *S3DataConfig `locationName:"s3DataDestination" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetExportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetExportJobOutput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatasetExportJobOutput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatasetExportJobOutput"}
	if s.S3DataDestination == nil {
		invalidParams.Add(request.NewErrParamRequired("S3DataDestination"))
	}
	if s.S3DataDestination != nil {
		if err := s.S3DataDestination.Validate(); err != nil {
			invalidParams.AddNested("S3DataDestination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3DataDestination sets the S3DataDestination field's value.
func (s *DatasetExportJobOutput) SetS3DataDestination(v *S3DataConfig) *DatasetExportJobOutput {
	s.S3DataDestination = v
	return s
}

// Provides a summary of the properties of a dataset export job. For a complete
// listing, call the DescribeDatasetExportJob (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetExportJob.html)
// API.
type DatasetExportJobSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that the dataset export job was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset export job.
	DatasetExportJobArn *string `locationName:"datasetExportJobArn" type:"string"`

	// If a dataset export job fails, the reason behind the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The name of the dataset export job.
	JobName *string `locationName:"jobName" min:"1" type:"string"`

	// The date and time (in Unix time) that the dataset export job status was last
	// updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The status of the dataset export job.
	//
	// A dataset export job can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetExportJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetExportJobSummary) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DatasetExportJobSummary) SetCreationDateTime(v time.Time) *DatasetExportJobSummary {
	s.CreationDateTime = &v
	return s
}

// SetDatasetExportJobArn sets the DatasetExportJobArn field's value.
func (s *DatasetExportJobSummary) SetDatasetExportJobArn(v string) *DatasetExportJobSummary {
	s.DatasetExportJobArn = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DatasetExportJobSummary) SetFailureReason(v string) *DatasetExportJobSummary {
	s.FailureReason = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *DatasetExportJobSummary) SetJobName(v string) *DatasetExportJobSummary {
	s.JobName = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DatasetExportJobSummary) SetLastUpdatedDateTime(v time.Time) *DatasetExportJobSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DatasetExportJobSummary) SetStatus(v string) *DatasetExportJobSummary {
	s.Status = &v
	return s
}

// A dataset group is a collection of related datasets (Item interactions, Users,
// Items, Actions, Action interactions). You create a dataset group by calling
// CreateDatasetGroup (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html).
// You then create a dataset and add it to a dataset group by calling CreateDataset
// (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html).
// The dataset group is used to create and train a solution by calling CreateSolution
// (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html).
// A dataset group can contain only one of each type of dataset.
//
// You can specify an Key Management Service (KMS) key to encrypt the datasets
// in the group.
type DatasetGroup struct {
	_ struct{} `type:"structure"`

	// The creation date and time (in Unix time) of the dataset group.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset group.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// The domain of a Domain dataset group.
	Domain *string `locationName:"domain" type:"string" enum:"Domain"`

	// If creating a dataset group fails, provides the reason why.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The Amazon Resource Name (ARN) of the Key Management Service (KMS) key used
	// to encrypt the datasets.
	KmsKeyArn *string `locationName:"kmsKeyArn" type:"string"`

	// The last update date and time (in Unix time) of the dataset group.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the dataset group.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The ARN of the Identity and Access Management (IAM) role that has permissions
	// to access the Key Management Service (KMS) key. Supplying an IAM role is
	// only valid when also specifying a KMS key.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The current status of the dataset group.
	//
	// A dataset group can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetGroup) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DatasetGroup) SetCreationDateTime(v time.Time) *DatasetGroup {
	s.CreationDateTime = &v
	return s
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *DatasetGroup) SetDatasetGroupArn(v string) *DatasetGroup {
	s.DatasetGroupArn = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *DatasetGroup) SetDomain(v string) *DatasetGroup {
	s.Domain = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DatasetGroup) SetFailureReason(v string) *DatasetGroup {
	s.FailureReason = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *DatasetGroup) SetKmsKeyArn(v string) *DatasetGroup {
	s.KmsKeyArn = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DatasetGroup) SetLastUpdatedDateTime(v time.Time) *DatasetGroup {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DatasetGroup) SetName(v string) *DatasetGroup {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DatasetGroup) SetRoleArn(v string) *DatasetGroup {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DatasetGroup) SetStatus(v string) *DatasetGroup {
	s.Status = &v
	return s
}

// Provides a summary of the properties of a dataset group. For a complete listing,
// call the DescribeDatasetGroup (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetGroup.html)
// API.
type DatasetGroupSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that the dataset group was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset group.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// The domain of a Domain dataset group.
	Domain *string `locationName:"domain" type:"string" enum:"Domain"`

	// If creating a dataset group fails, the reason behind the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The date and time (in Unix time) that the dataset group was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the dataset group.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the dataset group.
	//
	// A dataset group can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetGroupSummary) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DatasetGroupSummary) SetCreationDateTime(v time.Time) *DatasetGroupSummary {
	s.CreationDateTime = &v
	return s
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *DatasetGroupSummary) SetDatasetGroupArn(v string) *DatasetGroupSummary {
	s.DatasetGroupArn = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *DatasetGroupSummary) SetDomain(v string) *DatasetGroupSummary {
	s.Domain = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DatasetGroupSummary) SetFailureReason(v string) *DatasetGroupSummary {
	s.FailureReason = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DatasetGroupSummary) SetLastUpdatedDateTime(v time.Time) *DatasetGroupSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DatasetGroupSummary) SetName(v string) *DatasetGroupSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DatasetGroupSummary) SetStatus(v string) *DatasetGroupSummary {
	s.Status = &v
	return s
}

// Describes a job that imports training data from a data source (Amazon S3
// bucket) to an Amazon Personalize dataset. For more information, see CreateDatasetImportJob
// (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html).
//
// A dataset import job can be in one of the following states:
//
//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
type DatasetImportJob struct {
	_ struct{} `type:"structure"`

	// The creation date and time (in Unix time) of the dataset import job.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon S3 bucket that contains the training data to import.
	DataSource *DataSource `locationName:"dataSource" type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset that receives the imported
	// data.
	DatasetArn *string `locationName:"datasetArn" type:"string"`

	// The ARN of the dataset import job.
	DatasetImportJobArn *string `locationName:"datasetImportJobArn" type:"string"`

	// If a dataset import job fails, provides the reason why.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The import mode used by the dataset import job to import new records.
	ImportMode *string `locationName:"importMode" type:"string" enum:"ImportMode"`

	// The name of the import job.
	JobName *string `locationName:"jobName" min:"1" type:"string"`

	// The date and time (in Unix time) the dataset was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// Whether the job publishes metrics to Amazon S3 for a metric attribution.
	PublishAttributionMetricsToS3 *bool `locationName:"publishAttributionMetricsToS3" type:"boolean"`

	// The ARN of the IAM role that has permissions to read from the Amazon S3 data
	// source.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The status of the dataset import job.
	//
	// A dataset import job can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetImportJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetImportJob) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DatasetImportJob) SetCreationDateTime(v time.Time) *DatasetImportJob {
	s.CreationDateTime = &v
	return s
}

// SetDataSource sets the DataSource field's value.
func (s *DatasetImportJob) SetDataSource(v *DataSource) *DatasetImportJob {
	s.DataSource = v
	return s
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *DatasetImportJob) SetDatasetArn(v string) *DatasetImportJob {
	s.DatasetArn = &v
	return s
}

// SetDatasetImportJobArn sets the DatasetImportJobArn field's value.
func (s *DatasetImportJob) SetDatasetImportJobArn(v string) *DatasetImportJob {
	s.DatasetImportJobArn = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DatasetImportJob) SetFailureReason(v string) *DatasetImportJob {
	s.FailureReason = &v
	return s
}

// SetImportMode sets the ImportMode field's value.
func (s *DatasetImportJob) SetImportMode(v string) *DatasetImportJob {
	s.ImportMode = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *DatasetImportJob) SetJobName(v string) *DatasetImportJob {
	s.JobName = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DatasetImportJob) SetLastUpdatedDateTime(v time.Time) *DatasetImportJob {
	s.LastUpdatedDateTime = &v
	return s
}

// SetPublishAttributionMetricsToS3 sets the PublishAttributionMetricsToS3 field's value.
func (s *DatasetImportJob) SetPublishAttributionMetricsToS3(v bool) *DatasetImportJob {
	s.PublishAttributionMetricsToS3 = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DatasetImportJob) SetRoleArn(v string) *DatasetImportJob {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DatasetImportJob) SetStatus(v string) *DatasetImportJob {
	s.Status = &v
	return s
}

// Provides a summary of the properties of a dataset import job. For a complete
// listing, call the DescribeDatasetImportJob (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetImportJob.html)
// API.
type DatasetImportJobSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that the dataset import job was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset import job.
	DatasetImportJobArn *string `locationName:"datasetImportJobArn" type:"string"`

	// If a dataset import job fails, the reason behind the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The import mode the dataset import job used to update the data in the dataset.
	// For more information see Updating existing bulk data (https://docs.aws.amazon.com/personalize/latest/dg/updating-existing-bulk-data.html).
	ImportMode *string `locationName:"importMode" type:"string" enum:"ImportMode"`

	// The name of the dataset import job.
	JobName *string `locationName:"jobName" min:"1" type:"string"`

	// The date and time (in Unix time) that the dataset import job status was last
	// updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The status of the dataset import job.
	//
	// A dataset import job can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetImportJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetImportJobSummary) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DatasetImportJobSummary) SetCreationDateTime(v time.Time) *DatasetImportJobSummary {
	s.CreationDateTime = &v
	return s
}

// SetDatasetImportJobArn sets the DatasetImportJobArn field's value.
func (s *DatasetImportJobSummary) SetDatasetImportJobArn(v string) *DatasetImportJobSummary {
	s.DatasetImportJobArn = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DatasetImportJobSummary) SetFailureReason(v string) *DatasetImportJobSummary {
	s.FailureReason = &v
	return s
}

// SetImportMode sets the ImportMode field's value.
func (s *DatasetImportJobSummary) SetImportMode(v string) *DatasetImportJobSummary {
	s.ImportMode = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *DatasetImportJobSummary) SetJobName(v string) *DatasetImportJobSummary {
	s.JobName = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DatasetImportJobSummary) SetLastUpdatedDateTime(v time.Time) *DatasetImportJobSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DatasetImportJobSummary) SetStatus(v string) *DatasetImportJobSummary {
	s.Status = &v
	return s
}

// Describes the schema for a dataset. For more information on schemas, see
// CreateSchema (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html).
type DatasetSchema struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that the schema was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The domain of a schema that you created for a dataset in a Domain dataset
	// group.
	Domain *string `locationName:"domain" type:"string" enum:"Domain"`

	// The date and time (in Unix time) that the schema was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the schema.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The schema.
	Schema *string `locationName:"schema" type:"string"`

	// The Amazon Resource Name (ARN) of the schema.
	SchemaArn *string `locationName:"schemaArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetSchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetSchema) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DatasetSchema) SetCreationDateTime(v time.Time) *DatasetSchema {
	s.CreationDateTime = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *DatasetSchema) SetDomain(v string) *DatasetSchema {
	s.Domain = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DatasetSchema) SetLastUpdatedDateTime(v time.Time) *DatasetSchema {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DatasetSchema) SetName(v string) *DatasetSchema {
	s.Name = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *DatasetSchema) SetSchema(v string) *DatasetSchema {
	s.Schema = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *DatasetSchema) SetSchemaArn(v string) *DatasetSchema {
	s.SchemaArn = &v
	return s
}

// Provides a summary of the properties of a dataset schema. For a complete
// listing, call the DescribeSchema (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSchema.html)
// API.
type DatasetSchemaSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that the schema was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The domain of a schema that you created for a dataset in a Domain dataset
	// group.
	Domain *string `locationName:"domain" type:"string" enum:"Domain"`

	// The date and time (in Unix time) that the schema was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the schema.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the schema.
	SchemaArn *string `locationName:"schemaArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetSchemaSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetSchemaSummary) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DatasetSchemaSummary) SetCreationDateTime(v time.Time) *DatasetSchemaSummary {
	s.CreationDateTime = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *DatasetSchemaSummary) SetDomain(v string) *DatasetSchemaSummary {
	s.Domain = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DatasetSchemaSummary) SetLastUpdatedDateTime(v time.Time) *DatasetSchemaSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DatasetSchemaSummary) SetName(v string) *DatasetSchemaSummary {
	s.Name = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *DatasetSchemaSummary) SetSchemaArn(v string) *DatasetSchemaSummary {
	s.SchemaArn = &v
	return s
}

// Provides a summary of the properties of a dataset. For a complete listing,
// call the DescribeDataset (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataset.html)
// API.
type DatasetSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that the dataset was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset.
	DatasetArn *string `locationName:"datasetArn" type:"string"`

	// The dataset type. One of the following values:
	//
	//    * Interactions
	//
	//    * Items
	//
	//    * Users
	//
	//    * Event-Interactions
	DatasetType *string `locationName:"datasetType" type:"string"`

	// The date and time (in Unix time) that the dataset was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the dataset.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the dataset.
	//
	// A dataset can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetSummary) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DatasetSummary) SetCreationDateTime(v time.Time) *DatasetSummary {
	s.CreationDateTime = &v
	return s
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *DatasetSummary) SetDatasetArn(v string) *DatasetSummary {
	s.DatasetArn = &v
	return s
}

// SetDatasetType sets the DatasetType field's value.
func (s *DatasetSummary) SetDatasetType(v string) *DatasetSummary {
	s.DatasetType = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DatasetSummary) SetLastUpdatedDateTime(v time.Time) *DatasetSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DatasetSummary) SetName(v string) *DatasetSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DatasetSummary) SetStatus(v string) *DatasetSummary {
	s.Status = &v
	return s
}

// Describes an update to a dataset.
type DatasetUpdateSummary struct {
	_ struct{} `type:"structure"`

	// The creation date and time (in Unix time) of the dataset update.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// If updating a dataset fails, provides the reason why.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The last update date and time (in Unix time) of the dataset.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the schema that replaced the previous schema
	// of the dataset.
	SchemaArn *string `locationName:"schemaArn" type:"string"`

	// The status of the dataset update.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetUpdateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetUpdateSummary) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DatasetUpdateSummary) SetCreationDateTime(v time.Time) *DatasetUpdateSummary {
	s.CreationDateTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DatasetUpdateSummary) SetFailureReason(v string) *DatasetUpdateSummary {
	s.FailureReason = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DatasetUpdateSummary) SetLastUpdatedDateTime(v time.Time) *DatasetUpdateSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *DatasetUpdateSummary) SetSchemaArn(v string) *DatasetUpdateSummary {
	s.SchemaArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DatasetUpdateSummary) SetStatus(v string) *DatasetUpdateSummary {
	s.Status = &v
	return s
}

// Provides the name and default range of a categorical hyperparameter and whether
// the hyperparameter is tunable. A tunable hyperparameter can have its value
// determined during hyperparameter optimization (HPO).
type DefaultCategoricalHyperParameterRange struct {
	_ struct{} `type:"structure"`

	// Whether the hyperparameter is tunable.
	IsTunable *bool `locationName:"isTunable" type:"boolean"`

	// The name of the hyperparameter.
	Name *string `locationName:"name" type:"string"`

	// A list of the categories for the hyperparameter.
	Values []*string `locationName:"values" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DefaultCategoricalHyperParameterRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DefaultCategoricalHyperParameterRange) GoString() string {
	return s.String()
}

// SetIsTunable sets the IsTunable field's value.
func (s *DefaultCategoricalHyperParameterRange) SetIsTunable(v bool) *DefaultCategoricalHyperParameterRange {
	s.IsTunable = &v
	return s
}

// SetName sets the Name field's value.
func (s *DefaultCategoricalHyperParameterRange) SetName(v string) *DefaultCategoricalHyperParameterRange {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *DefaultCategoricalHyperParameterRange) SetValues(v []*string) *DefaultCategoricalHyperParameterRange {
	s.Values = v
	return s
}

// Provides the name and default range of a continuous hyperparameter and whether
// the hyperparameter is tunable. A tunable hyperparameter can have its value
// determined during hyperparameter optimization (HPO).
type DefaultContinuousHyperParameterRange struct {
	_ struct{} `type:"structure"`

	// Whether the hyperparameter is tunable.
	IsTunable *bool `locationName:"isTunable" type:"boolean"`

	// The maximum allowable value for the hyperparameter.
	MaxValue *float64 `locationName:"maxValue" type:"double"`

	// The minimum allowable value for the hyperparameter.
	MinValue *float64 `locationName:"minValue" type:"double"`

	// The name of the hyperparameter.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DefaultContinuousHyperParameterRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DefaultContinuousHyperParameterRange) GoString() string {
	return s.String()
}

// SetIsTunable sets the IsTunable field's value.
func (s *DefaultContinuousHyperParameterRange) SetIsTunable(v bool) *DefaultContinuousHyperParameterRange {
	s.IsTunable = &v
	return s
}

// SetMaxValue sets the MaxValue field's value.
func (s *DefaultContinuousHyperParameterRange) SetMaxValue(v float64) *DefaultContinuousHyperParameterRange {
	s.MaxValue = &v
	return s
}

// SetMinValue sets the MinValue field's value.
func (s *DefaultContinuousHyperParameterRange) SetMinValue(v float64) *DefaultContinuousHyperParameterRange {
	s.MinValue = &v
	return s
}

// SetName sets the Name field's value.
func (s *DefaultContinuousHyperParameterRange) SetName(v string) *DefaultContinuousHyperParameterRange {
	s.Name = &v
	return s
}

// Specifies the hyperparameters and their default ranges. Hyperparameters can
// be categorical, continuous, or integer-valued.
type DefaultHyperParameterRanges struct {
	_ struct{} `type:"structure"`

	// The categorical hyperparameters and their default ranges.
	CategoricalHyperParameterRanges []*DefaultCategoricalHyperParameterRange `locationName:"categoricalHyperParameterRanges" type:"list"`

	// The continuous hyperparameters and their default ranges.
	ContinuousHyperParameterRanges []*DefaultContinuousHyperParameterRange `locationName:"continuousHyperParameterRanges" type:"list"`

	// The integer-valued hyperparameters and their default ranges.
	IntegerHyperParameterRanges []*DefaultIntegerHyperParameterRange `locationName:"integerHyperParameterRanges" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DefaultHyperParameterRanges) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DefaultHyperParameterRanges) GoString() string {
	return s.String()
}

// SetCategoricalHyperParameterRanges sets the CategoricalHyperParameterRanges field's value.
func (s *DefaultHyperParameterRanges) SetCategoricalHyperParameterRanges(v []*DefaultCategoricalHyperParameterRange) *DefaultHyperParameterRanges {
	s.CategoricalHyperParameterRanges = v
	return s
}

// SetContinuousHyperParameterRanges sets the ContinuousHyperParameterRanges field's value.
func (s *DefaultHyperParameterRanges) SetContinuousHyperParameterRanges(v []*DefaultContinuousHyperParameterRange) *DefaultHyperParameterRanges {
	s.ContinuousHyperParameterRanges = v
	return s
}

// SetIntegerHyperParameterRanges sets the IntegerHyperParameterRanges field's value.
func (s *DefaultHyperParameterRanges) SetIntegerHyperParameterRanges(v []*DefaultIntegerHyperParameterRange) *DefaultHyperParameterRanges {
	s.IntegerHyperParameterRanges = v
	return s
}

// Provides the name and default range of a integer-valued hyperparameter and
// whether the hyperparameter is tunable. A tunable hyperparameter can have
// its value determined during hyperparameter optimization (HPO).
type DefaultIntegerHyperParameterRange struct {
	_ struct{} `type:"structure"`

	// Indicates whether the hyperparameter is tunable.
	IsTunable *bool `locationName:"isTunable" type:"boolean"`

	// The maximum allowable value for the hyperparameter.
	MaxValue *int64 `locationName:"maxValue" type:"integer"`

	// The minimum allowable value for the hyperparameter.
	MinValue *int64 `locationName:"minValue" type:"integer"`

	// The name of the hyperparameter.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DefaultIntegerHyperParameterRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DefaultIntegerHyperParameterRange) GoString() string {
	return s.String()
}

// SetIsTunable sets the IsTunable field's value.
func (s *DefaultIntegerHyperParameterRange) SetIsTunable(v bool) *DefaultIntegerHyperParameterRange {
	s.IsTunable = &v
	return s
}

// SetMaxValue sets the MaxValue field's value.
func (s *DefaultIntegerHyperParameterRange) SetMaxValue(v int64) *DefaultIntegerHyperParameterRange {
	s.MaxValue = &v
	return s
}

// SetMinValue sets the MinValue field's value.
func (s *DefaultIntegerHyperParameterRange) SetMinValue(v int64) *DefaultIntegerHyperParameterRange {
	s.MinValue = &v
	return s
}

// SetName sets the Name field's value.
func (s *DefaultIntegerHyperParameterRange) SetName(v string) *DefaultIntegerHyperParameterRange {
	s.Name = &v
	return s
}

type DeleteCampaignInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the campaign to delete.
	//
	// CampaignArn is a required field
	CampaignArn *string `locationName:"campaignArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCampaignInput"}
	if s.CampaignArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCampaignArn sets the CampaignArn field's value.
func (s *DeleteCampaignInput) SetCampaignArn(v string) *DeleteCampaignInput {
	s.CampaignArn = &v
	return s
}

type DeleteCampaignOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCampaignOutput) GoString() string {
	return s.String()
}

type DeleteDatasetGroupInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the dataset group to delete.
	//
	// DatasetGroupArn is a required field
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatasetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatasetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDatasetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDatasetGroupInput"}
	if s.DatasetGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetGroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *DeleteDatasetGroupInput) SetDatasetGroupArn(v string) *DeleteDatasetGroupInput {
	s.DatasetGroupArn = &v
	return s
}

type DeleteDatasetGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatasetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatasetGroupOutput) GoString() string {
	return s.String()
}

type DeleteDatasetInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset to delete.
	//
	// DatasetArn is a required field
	DatasetArn *string `locationName:"datasetArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDatasetInput"}
	if s.DatasetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *DeleteDatasetInput) SetDatasetArn(v string) *DeleteDatasetInput {
	s.DatasetArn = &v
	return s
}

type DeleteDatasetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatasetOutput) GoString() string {
	return s.String()
}

type DeleteEventTrackerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the event tracker to delete.
	//
	// EventTrackerArn is a required field
	EventTrackerArn *string `locationName:"eventTrackerArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventTrackerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventTrackerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventTrackerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventTrackerInput"}
	if s.EventTrackerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EventTrackerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventTrackerArn sets the EventTrackerArn field's value.
func (s *DeleteEventTrackerInput) SetEventTrackerArn(v string) *DeleteEventTrackerInput {
	s.EventTrackerArn = &v
	return s
}

type DeleteEventTrackerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventTrackerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventTrackerOutput) GoString() string {
	return s.String()
}

type DeleteFilterInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the filter to delete.
	//
	// FilterArn is a required field
	FilterArn *string `locationName:"filterArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFilterInput"}
	if s.FilterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FilterArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterArn sets the FilterArn field's value.
func (s *DeleteFilterInput) SetFilterArn(v string) *DeleteFilterInput {
	s.FilterArn = &v
	return s
}

type DeleteFilterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFilterOutput) GoString() string {
	return s.String()
}

type DeleteMetricAttributionInput struct {
	_ struct{} `type:"structure"`

	// The metric attribution's Amazon Resource Name (ARN).
	//
	// MetricAttributionArn is a required field
	MetricAttributionArn *string `locationName:"metricAttributionArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMetricAttributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMetricAttributionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMetricAttributionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMetricAttributionInput"}
	if s.MetricAttributionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricAttributionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetricAttributionArn sets the MetricAttributionArn field's value.
func (s *DeleteMetricAttributionInput) SetMetricAttributionArn(v string) *DeleteMetricAttributionInput {
	s.MetricAttributionArn = &v
	return s
}

type DeleteMetricAttributionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMetricAttributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMetricAttributionOutput) GoString() string {
	return s.String()
}

type DeleteRecommenderInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the recommender to delete.
	//
	// RecommenderArn is a required field
	RecommenderArn *string `locationName:"recommenderArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecommenderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecommenderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRecommenderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRecommenderInput"}
	if s.RecommenderArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RecommenderArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecommenderArn sets the RecommenderArn field's value.
func (s *DeleteRecommenderInput) SetRecommenderArn(v string) *DeleteRecommenderInput {
	s.RecommenderArn = &v
	return s
}

type DeleteRecommenderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecommenderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecommenderOutput) GoString() string {
	return s.String()
}

type DeleteSchemaInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the schema to delete.
	//
	// SchemaArn is a required field
	SchemaArn *string `locationName:"schemaArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSchemaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSchemaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSchemaInput"}
	if s.SchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *DeleteSchemaInput) SetSchemaArn(v string) *DeleteSchemaInput {
	s.SchemaArn = &v
	return s
}

type DeleteSchemaOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSchemaOutput) GoString() string {
	return s.String()
}

type DeleteSolutionInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the solution to delete.
	//
	// SolutionArn is a required field
	SolutionArn *string `locationName:"solutionArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSolutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSolutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSolutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSolutionInput"}
	if s.SolutionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SolutionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSolutionArn sets the SolutionArn field's value.
func (s *DeleteSolutionInput) SetSolutionArn(v string) *DeleteSolutionInput {
	s.SolutionArn = &v
	return s
}

type DeleteSolutionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSolutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSolutionOutput) GoString() string {
	return s.String()
}

type DescribeAlgorithmInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the algorithm to describe.
	//
	// AlgorithmArn is a required field
	AlgorithmArn *string `locationName:"algorithmArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAlgorithmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAlgorithmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAlgorithmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAlgorithmInput"}
	if s.AlgorithmArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AlgorithmArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlgorithmArn sets the AlgorithmArn field's value.
func (s *DescribeAlgorithmInput) SetAlgorithmArn(v string) *DescribeAlgorithmInput {
	s.AlgorithmArn = &v
	return s
}

type DescribeAlgorithmOutput struct {
	_ struct{} `type:"structure"`

	// A listing of the properties of the algorithm.
	Algorithm *Algorithm `locationName:"algorithm" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAlgorithmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAlgorithmOutput) GoString() string {
	return s.String()
}

// SetAlgorithm sets the Algorithm field's value.
func (s *DescribeAlgorithmOutput) SetAlgorithm(v *Algorithm) *DescribeAlgorithmOutput {
	s.Algorithm = v
	return s
}

type DescribeBatchInferenceJobInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the batch inference job to describe.
	//
	// BatchInferenceJobArn is a required field
	BatchInferenceJobArn *string `locationName:"batchInferenceJobArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBatchInferenceJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBatchInferenceJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBatchInferenceJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBatchInferenceJobInput"}
	if s.BatchInferenceJobArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BatchInferenceJobArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchInferenceJobArn sets the BatchInferenceJobArn field's value.
func (s *DescribeBatchInferenceJobInput) SetBatchInferenceJobArn(v string) *DescribeBatchInferenceJobInput {
	s.BatchInferenceJobArn = &v
	return s
}

type DescribeBatchInferenceJobOutput struct {
	_ struct{} `type:"structure"`

	// Information on the specified batch inference job.
	BatchInferenceJob *BatchInferenceJob `locationName:"batchInferenceJob" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBatchInferenceJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBatchInferenceJobOutput) GoString() string {
	return s.String()
}

// SetBatchInferenceJob sets the BatchInferenceJob field's value.
func (s *DescribeBatchInferenceJobOutput) SetBatchInferenceJob(v *BatchInferenceJob) *DescribeBatchInferenceJobOutput {
	s.BatchInferenceJob = v
	return s
}

type DescribeBatchSegmentJobInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the batch segment job to describe.
	//
	// BatchSegmentJobArn is a required field
	BatchSegmentJobArn *string `locationName:"batchSegmentJobArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBatchSegmentJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBatchSegmentJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBatchSegmentJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBatchSegmentJobInput"}
	if s.BatchSegmentJobArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BatchSegmentJobArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchSegmentJobArn sets the BatchSegmentJobArn field's value.
func (s *DescribeBatchSegmentJobInput) SetBatchSegmentJobArn(v string) *DescribeBatchSegmentJobInput {
	s.BatchSegmentJobArn = &v
	return s
}

type DescribeBatchSegmentJobOutput struct {
	_ struct{} `type:"structure"`

	// Information on the specified batch segment job.
	BatchSegmentJob *BatchSegmentJob `locationName:"batchSegmentJob" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBatchSegmentJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBatchSegmentJobOutput) GoString() string {
	return s.String()
}

// SetBatchSegmentJob sets the BatchSegmentJob field's value.
func (s *DescribeBatchSegmentJobOutput) SetBatchSegmentJob(v *BatchSegmentJob) *DescribeBatchSegmentJobOutput {
	s.BatchSegmentJob = v
	return s
}

type DescribeCampaignInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the campaign.
	//
	// CampaignArn is a required field
	CampaignArn *string `locationName:"campaignArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCampaignInput"}
	if s.CampaignArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCampaignArn sets the CampaignArn field's value.
func (s *DescribeCampaignInput) SetCampaignArn(v string) *DescribeCampaignInput {
	s.CampaignArn = &v
	return s
}

type DescribeCampaignOutput struct {
	_ struct{} `type:"structure"`

	// The properties of the campaign.
	Campaign *Campaign `locationName:"campaign" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCampaignOutput) GoString() string {
	return s.String()
}

// SetCampaign sets the Campaign field's value.
func (s *DescribeCampaignOutput) SetCampaign(v *Campaign) *DescribeCampaignOutput {
	s.Campaign = v
	return s
}

type DescribeDatasetExportJobInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset export job to describe.
	//
	// DatasetExportJobArn is a required field
	DatasetExportJobArn *string `locationName:"datasetExportJobArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetExportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetExportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDatasetExportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDatasetExportJobInput"}
	if s.DatasetExportJobArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetExportJobArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetExportJobArn sets the DatasetExportJobArn field's value.
func (s *DescribeDatasetExportJobInput) SetDatasetExportJobArn(v string) *DescribeDatasetExportJobInput {
	s.DatasetExportJobArn = &v
	return s
}

type DescribeDatasetExportJobOutput struct {
	_ struct{} `type:"structure"`

	// Information about the dataset export job, including the status.
	//
	// The status is one of the following values:
	//
	//    * CREATE PENDING
	//
	//    * CREATE IN_PROGRESS
	//
	//    * ACTIVE
	//
	//    * CREATE FAILED
	DatasetExportJob *DatasetExportJob `locationName:"datasetExportJob" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetExportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetExportJobOutput) GoString() string {
	return s.String()
}

// SetDatasetExportJob sets the DatasetExportJob field's value.
func (s *DescribeDatasetExportJobOutput) SetDatasetExportJob(v *DatasetExportJob) *DescribeDatasetExportJobOutput {
	s.DatasetExportJob = v
	return s
}

type DescribeDatasetGroupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset group to describe.
	//
	// DatasetGroupArn is a required field
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDatasetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDatasetGroupInput"}
	if s.DatasetGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetGroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *DescribeDatasetGroupInput) SetDatasetGroupArn(v string) *DescribeDatasetGroupInput {
	s.DatasetGroupArn = &v
	return s
}

type DescribeDatasetGroupOutput struct {
	_ struct{} `type:"structure"`

	// A listing of the dataset group's properties.
	DatasetGroup *DatasetGroup `locationName:"datasetGroup" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetGroupOutput) GoString() string {
	return s.String()
}

// SetDatasetGroup sets the DatasetGroup field's value.
func (s *DescribeDatasetGroupOutput) SetDatasetGroup(v *DatasetGroup) *DescribeDatasetGroupOutput {
	s.DatasetGroup = v
	return s
}

type DescribeDatasetImportJobInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset import job to describe.
	//
	// DatasetImportJobArn is a required field
	DatasetImportJobArn *string `locationName:"datasetImportJobArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDatasetImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDatasetImportJobInput"}
	if s.DatasetImportJobArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetImportJobArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetImportJobArn sets the DatasetImportJobArn field's value.
func (s *DescribeDatasetImportJobInput) SetDatasetImportJobArn(v string) *DescribeDatasetImportJobInput {
	s.DatasetImportJobArn = &v
	return s
}

type DescribeDatasetImportJobOutput struct {
	_ struct{} `type:"structure"`

	// Information about the dataset import job, including the status.
	//
	// The status is one of the following values:
	//
	//    * CREATE PENDING
	//
	//    * CREATE IN_PROGRESS
	//
	//    * ACTIVE
	//
	//    * CREATE FAILED
	DatasetImportJob *DatasetImportJob `locationName:"datasetImportJob" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetImportJobOutput) GoString() string {
	return s.String()
}

// SetDatasetImportJob sets the DatasetImportJob field's value.
func (s *DescribeDatasetImportJobOutput) SetDatasetImportJob(v *DatasetImportJob) *DescribeDatasetImportJobOutput {
	s.DatasetImportJob = v
	return s
}

type DescribeDatasetInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset to describe.
	//
	// DatasetArn is a required field
	DatasetArn *string `locationName:"datasetArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDatasetInput"}
	if s.DatasetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *DescribeDatasetInput) SetDatasetArn(v string) *DescribeDatasetInput {
	s.DatasetArn = &v
	return s
}

type DescribeDatasetOutput struct {
	_ struct{} `type:"structure"`

	// A listing of the dataset's properties.
	Dataset *Dataset `locationName:"dataset" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetOutput) GoString() string {
	return s.String()
}

// SetDataset sets the Dataset field's value.
func (s *DescribeDatasetOutput) SetDataset(v *Dataset) *DescribeDatasetOutput {
	s.Dataset = v
	return s
}

type DescribeEventTrackerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the event tracker to describe.
	//
	// EventTrackerArn is a required field
	EventTrackerArn *string `locationName:"eventTrackerArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventTrackerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventTrackerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventTrackerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEventTrackerInput"}
	if s.EventTrackerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EventTrackerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventTrackerArn sets the EventTrackerArn field's value.
func (s *DescribeEventTrackerInput) SetEventTrackerArn(v string) *DescribeEventTrackerInput {
	s.EventTrackerArn = &v
	return s
}

type DescribeEventTrackerOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the event tracker.
	EventTracker *EventTracker `locationName:"eventTracker" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventTrackerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventTrackerOutput) GoString() string {
	return s.String()
}

// SetEventTracker sets the EventTracker field's value.
func (s *DescribeEventTrackerOutput) SetEventTracker(v *EventTracker) *DescribeEventTrackerOutput {
	s.EventTracker = v
	return s
}

type DescribeFeatureTransformationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the feature transformation to describe.
	//
	// FeatureTransformationArn is a required field
	FeatureTransformationArn *string `locationName:"featureTransformationArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFeatureTransformationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFeatureTransformationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFeatureTransformationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFeatureTransformationInput"}
	if s.FeatureTransformationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FeatureTransformationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFeatureTransformationArn sets the FeatureTransformationArn field's value.
func (s *DescribeFeatureTransformationInput) SetFeatureTransformationArn(v string) *DescribeFeatureTransformationInput {
	s.FeatureTransformationArn = &v
	return s
}

type DescribeFeatureTransformationOutput struct {
	_ struct{} `type:"structure"`

	// A listing of the FeatureTransformation properties.
	FeatureTransformation *FeatureTransformation `locationName:"featureTransformation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFeatureTransformationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFeatureTransformationOutput) GoString() string {
	return s.String()
}

// SetFeatureTransformation sets the FeatureTransformation field's value.
func (s *DescribeFeatureTransformationOutput) SetFeatureTransformation(v *FeatureTransformation) *DescribeFeatureTransformationOutput {
	s.FeatureTransformation = v
	return s
}

type DescribeFilterInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the filter to describe.
	//
	// FilterArn is a required field
	FilterArn *string `locationName:"filterArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFilterInput"}
	if s.FilterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FilterArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterArn sets the FilterArn field's value.
func (s *DescribeFilterInput) SetFilterArn(v string) *DescribeFilterInput {
	s.FilterArn = &v
	return s
}

type DescribeFilterOutput struct {
	_ struct{} `type:"structure"`

	// The filter's details.
	Filter *Filter `locationName:"filter" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFilterOutput) GoString() string {
	return s.String()
}

// SetFilter sets the Filter field's value.
func (s *DescribeFilterOutput) SetFilter(v *Filter) *DescribeFilterOutput {
	s.Filter = v
	return s
}

type DescribeMetricAttributionInput struct {
	_ struct{} `type:"structure"`

	// The metric attribution's Amazon Resource Name (ARN).
	//
	// MetricAttributionArn is a required field
	MetricAttributionArn *string `locationName:"metricAttributionArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetricAttributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetricAttributionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMetricAttributionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMetricAttributionInput"}
	if s.MetricAttributionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricAttributionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetricAttributionArn sets the MetricAttributionArn field's value.
func (s *DescribeMetricAttributionInput) SetMetricAttributionArn(v string) *DescribeMetricAttributionInput {
	s.MetricAttributionArn = &v
	return s
}

type DescribeMetricAttributionOutput struct {
	_ struct{} `type:"structure"`

	// The details of the metric attribution.
	MetricAttribution *MetricAttribution `locationName:"metricAttribution" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetricAttributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetricAttributionOutput) GoString() string {
	return s.String()
}

// SetMetricAttribution sets the MetricAttribution field's value.
func (s *DescribeMetricAttributionOutput) SetMetricAttribution(v *MetricAttribution) *DescribeMetricAttributionOutput {
	s.MetricAttribution = v
	return s
}

type DescribeRecipeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the recipe to describe.
	//
	// RecipeArn is a required field
	RecipeArn *string `locationName:"recipeArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecipeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecipeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRecipeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRecipeInput"}
	if s.RecipeArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RecipeArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecipeArn sets the RecipeArn field's value.
func (s *DescribeRecipeInput) SetRecipeArn(v string) *DescribeRecipeInput {
	s.RecipeArn = &v
	return s
}

type DescribeRecipeOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the recipe.
	Recipe *Recipe `locationName:"recipe" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecipeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecipeOutput) GoString() string {
	return s.String()
}

// SetRecipe sets the Recipe field's value.
func (s *DescribeRecipeOutput) SetRecipe(v *Recipe) *DescribeRecipeOutput {
	s.Recipe = v
	return s
}

type DescribeRecommenderInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the recommender to describe.
	//
	// RecommenderArn is a required field
	RecommenderArn *string `locationName:"recommenderArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecommenderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecommenderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRecommenderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRecommenderInput"}
	if s.RecommenderArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RecommenderArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecommenderArn sets the RecommenderArn field's value.
func (s *DescribeRecommenderInput) SetRecommenderArn(v string) *DescribeRecommenderInput {
	s.RecommenderArn = &v
	return s
}

type DescribeRecommenderOutput struct {
	_ struct{} `type:"structure"`

	// The properties of the recommender.
	Recommender *Recommender `locationName:"recommender" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecommenderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecommenderOutput) GoString() string {
	return s.String()
}

// SetRecommender sets the Recommender field's value.
func (s *DescribeRecommenderOutput) SetRecommender(v *Recommender) *DescribeRecommenderOutput {
	s.Recommender = v
	return s
}

type DescribeSchemaInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the schema to retrieve.
	//
	// SchemaArn is a required field
	SchemaArn *string `locationName:"schemaArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSchemaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSchemaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSchemaInput"}
	if s.SchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *DescribeSchemaInput) SetSchemaArn(v string) *DescribeSchemaInput {
	s.SchemaArn = &v
	return s
}

type DescribeSchemaOutput struct {
	_ struct{} `type:"structure"`

	// The requested schema.
	Schema *DatasetSchema `locationName:"schema" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSchemaOutput) GoString() string {
	return s.String()
}

// SetSchema sets the Schema field's value.
func (s *DescribeSchemaOutput) SetSchema(v *DatasetSchema) *DescribeSchemaOutput {
	s.Schema = v
	return s
}

type DescribeSolutionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the solution to describe.
	//
	// SolutionArn is a required field
	SolutionArn *string `locationName:"solutionArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSolutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSolutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSolutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSolutionInput"}
	if s.SolutionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SolutionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSolutionArn sets the SolutionArn field's value.
func (s *DescribeSolutionInput) SetSolutionArn(v string) *DescribeSolutionInput {
	s.SolutionArn = &v
	return s
}

type DescribeSolutionOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the solution.
	Solution *Solution `locationName:"solution" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSolutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSolutionOutput) GoString() string {
	return s.String()
}

// SetSolution sets the Solution field's value.
func (s *DescribeSolutionOutput) SetSolution(v *Solution) *DescribeSolutionOutput {
	s.Solution = v
	return s
}

type DescribeSolutionVersionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the solution version.
	//
	// SolutionVersionArn is a required field
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSolutionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSolutionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSolutionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSolutionVersionInput"}
	if s.SolutionVersionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SolutionVersionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *DescribeSolutionVersionInput) SetSolutionVersionArn(v string) *DescribeSolutionVersionInput {
	s.SolutionVersionArn = &v
	return s
}

type DescribeSolutionVersionOutput struct {
	_ struct{} `type:"structure"`

	// The solution version.
	SolutionVersion *SolutionVersion `locationName:"solutionVersion" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSolutionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSolutionVersionOutput) GoString() string {
	return s.String()
}

// SetSolutionVersion sets the SolutionVersion field's value.
func (s *DescribeSolutionVersionOutput) SetSolutionVersion(v *SolutionVersion) *DescribeSolutionVersionOutput {
	s.SolutionVersion = v
	return s
}

// Provides information about an event tracker.
type EventTracker struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account that owns the event tracker.
	AccountId *string `locationName:"accountId" type:"string"`

	// The date and time (in Unix format) that the event tracker was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset group that receives the event
	// data.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// The ARN of the event tracker.
	EventTrackerArn *string `locationName:"eventTrackerArn" type:"string"`

	// The date and time (in Unix time) that the event tracker was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the event tracker.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the event tracker.
	//
	// An event tracker can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`

	// The ID of the event tracker. Include this ID in requests to the PutEvents
	// (https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html)
	// API.
	TrackingId *string `locationName:"trackingId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventTracker) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventTracker) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *EventTracker) SetAccountId(v string) *EventTracker {
	s.AccountId = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *EventTracker) SetCreationDateTime(v time.Time) *EventTracker {
	s.CreationDateTime = &v
	return s
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *EventTracker) SetDatasetGroupArn(v string) *EventTracker {
	s.DatasetGroupArn = &v
	return s
}

// SetEventTrackerArn sets the EventTrackerArn field's value.
func (s *EventTracker) SetEventTrackerArn(v string) *EventTracker {
	s.EventTrackerArn = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *EventTracker) SetLastUpdatedDateTime(v time.Time) *EventTracker {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *EventTracker) SetName(v string) *EventTracker {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EventTracker) SetStatus(v string) *EventTracker {
	s.Status = &v
	return s
}

// SetTrackingId sets the TrackingId field's value.
func (s *EventTracker) SetTrackingId(v string) *EventTracker {
	s.TrackingId = &v
	return s
}

// Provides a summary of the properties of an event tracker. For a complete
// listing, call the DescribeEventTracker (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeEventTracker.html)
// API.
type EventTrackerSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that the event tracker was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the event tracker.
	EventTrackerArn *string `locationName:"eventTrackerArn" type:"string"`

	// The date and time (in Unix time) that the event tracker was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the event tracker.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the event tracker.
	//
	// An event tracker can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventTrackerSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventTrackerSummary) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *EventTrackerSummary) SetCreationDateTime(v time.Time) *EventTrackerSummary {
	s.CreationDateTime = &v
	return s
}

// SetEventTrackerArn sets the EventTrackerArn field's value.
func (s *EventTrackerSummary) SetEventTrackerArn(v string) *EventTrackerSummary {
	s.EventTrackerArn = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *EventTrackerSummary) SetLastUpdatedDateTime(v time.Time) *EventTrackerSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *EventTrackerSummary) SetName(v string) *EventTrackerSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EventTrackerSummary) SetStatus(v string) *EventTrackerSummary {
	s.Status = &v
	return s
}

// Provides feature transformation information. Feature transformation is the
// process of modifying raw input data into a form more suitable for model training.
type FeatureTransformation struct {
	_ struct{} `type:"structure"`

	// The creation date and time (in Unix time) of the feature transformation.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// Provides the default parameters for feature transformation.
	DefaultParameters map[string]*string `locationName:"defaultParameters" type:"map"`

	// The Amazon Resource Name (ARN) of the FeatureTransformation object.
	FeatureTransformationArn *string `locationName:"featureTransformationArn" type:"string"`

	// The last update date and time (in Unix time) of the feature transformation.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the feature transformation.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the feature transformation.
	//
	// A feature transformation can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FeatureTransformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FeatureTransformation) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *FeatureTransformation) SetCreationDateTime(v time.Time) *FeatureTransformation {
	s.CreationDateTime = &v
	return s
}

// SetDefaultParameters sets the DefaultParameters field's value.
func (s *FeatureTransformation) SetDefaultParameters(v map[string]*string) *FeatureTransformation {
	s.DefaultParameters = v
	return s
}

// SetFeatureTransformationArn sets the FeatureTransformationArn field's value.
func (s *FeatureTransformation) SetFeatureTransformationArn(v string) *FeatureTransformation {
	s.FeatureTransformationArn = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *FeatureTransformation) SetLastUpdatedDateTime(v time.Time) *FeatureTransformation {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *FeatureTransformation) SetName(v string) *FeatureTransformation {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FeatureTransformation) SetStatus(v string) *FeatureTransformation {
	s.Status = &v
	return s
}

// A string to string map of the configuration details for theme generation.
type FieldsForThemeGeneration struct {
	_ struct{} `type:"structure"`

	// The name of the Items dataset column that stores the name of each item in
	// the dataset.
	//
	// ItemName is a required field
	ItemName *string `locationName:"itemName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldsForThemeGeneration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldsForThemeGeneration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FieldsForThemeGeneration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FieldsForThemeGeneration"}
	if s.ItemName == nil {
		invalidParams.Add(request.NewErrParamRequired("ItemName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItemName sets the ItemName field's value.
func (s *FieldsForThemeGeneration) SetItemName(v string) *FieldsForThemeGeneration {
	s.ItemName = &v
	return s
}

// Contains information on a recommendation filter, including its ARN, status,
// and filter expression.
type Filter struct {
	_ struct{} `type:"structure"`

	// The time at which the filter was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The ARN of the dataset group to which the filter belongs.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// If the filter failed, the reason for its failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The ARN of the filter.
	FilterArn *string `locationName:"filterArn" type:"string"`

	// Specifies the type of item interactions to filter out of recommendation results.
	// The filter expression must follow specific format rules. For information
	// about filter expression structure and syntax, see Filter expressions (https://docs.aws.amazon.com/personalize/latest/dg/filter-expressions.html).
	//
	// FilterExpression is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Filter's
	// String and GoString methods.
	FilterExpression *string `locationName:"filterExpression" min:"1" type:"string" sensitive:"true"`

	// The time at which the filter was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the filter.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the filter.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *Filter) SetCreationDateTime(v time.Time) *Filter {
	s.CreationDateTime = &v
	return s
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *Filter) SetDatasetGroupArn(v string) *Filter {
	s.DatasetGroupArn = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *Filter) SetFailureReason(v string) *Filter {
	s.FailureReason = &v
	return s
}

// SetFilterArn sets the FilterArn field's value.
func (s *Filter) SetFilterArn(v string) *Filter {
	s.FilterArn = &v
	return s
}

// SetFilterExpression sets the FilterExpression field's value.
func (s *Filter) SetFilterExpression(v string) *Filter {
	s.FilterExpression = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *Filter) SetLastUpdatedDateTime(v time.Time) *Filter {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Filter) SetStatus(v string) *Filter {
	s.Status = &v
	return s
}

// A short summary of a filter's attributes.
type FilterSummary struct {
	_ struct{} `type:"structure"`

	// The time at which the filter was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The ARN of the dataset group to which the filter belongs.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// If the filter failed, the reason for the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The ARN of the filter.
	FilterArn *string `locationName:"filterArn" type:"string"`

	// The time at which the filter was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the filter.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the filter.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilterSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilterSummary) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *FilterSummary) SetCreationDateTime(v time.Time) *FilterSummary {
	s.CreationDateTime = &v
	return s
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *FilterSummary) SetDatasetGroupArn(v string) *FilterSummary {
	s.DatasetGroupArn = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *FilterSummary) SetFailureReason(v string) *FilterSummary {
	s.FailureReason = &v
	return s
}

// SetFilterArn sets the FilterArn field's value.
func (s *FilterSummary) SetFilterArn(v string) *FilterSummary {
	s.FilterArn = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *FilterSummary) SetLastUpdatedDateTime(v time.Time) *FilterSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *FilterSummary) SetName(v string) *FilterSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FilterSummary) SetStatus(v string) *FilterSummary {
	s.Status = &v
	return s
}

type GetSolutionMetricsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the solution version for which to get metrics.
	//
	// SolutionVersionArn is a required field
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolutionMetricsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolutionMetricsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSolutionMetricsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSolutionMetricsInput"}
	if s.SolutionVersionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SolutionVersionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *GetSolutionMetricsInput) SetSolutionVersionArn(v string) *GetSolutionMetricsInput {
	s.SolutionVersionArn = &v
	return s
}

type GetSolutionMetricsOutput struct {
	_ struct{} `type:"structure"`

	// The metrics for the solution version. For more information, see Evaluating
	// a solution version with metrics (https://docs.aws.amazon.com/personalize/latest/dg/working-with-training-metrics.html).
	Metrics map[string]*float64 `locationName:"metrics" type:"map"`

	// The same solution version ARN as specified in the request.
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolutionMetricsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSolutionMetricsOutput) GoString() string {
	return s.String()
}

// SetMetrics sets the Metrics field's value.
func (s *GetSolutionMetricsOutput) SetMetrics(v map[string]*float64) *GetSolutionMetricsOutput {
	s.Metrics = v
	return s
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *GetSolutionMetricsOutput) SetSolutionVersionArn(v string) *GetSolutionMetricsOutput {
	s.SolutionVersionArn = &v
	return s
}

// Describes the properties for hyperparameter optimization (HPO).
type HPOConfig struct {
	_ struct{} `type:"structure"`

	// The hyperparameters and their allowable ranges.
	AlgorithmHyperParameterRanges *HyperParameterRanges `locationName:"algorithmHyperParameterRanges" type:"structure"`

	// The metric to optimize during HPO.
	//
	// Amazon Personalize doesn't support configuring the hpoObjective at this time.
	HpoObjective *HPOObjective `locationName:"hpoObjective" type:"structure"`

	// Describes the resource configuration for HPO.
	HpoResourceConfig *HPOResourceConfig `locationName:"hpoResourceConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HPOConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HPOConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HPOConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HPOConfig"}
	if s.AlgorithmHyperParameterRanges != nil {
		if err := s.AlgorithmHyperParameterRanges.Validate(); err != nil {
			invalidParams.AddNested("AlgorithmHyperParameterRanges", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlgorithmHyperParameterRanges sets the AlgorithmHyperParameterRanges field's value.
func (s *HPOConfig) SetAlgorithmHyperParameterRanges(v *HyperParameterRanges) *HPOConfig {
	s.AlgorithmHyperParameterRanges = v
	return s
}

// SetHpoObjective sets the HpoObjective field's value.
func (s *HPOConfig) SetHpoObjective(v *HPOObjective) *HPOConfig {
	s.HpoObjective = v
	return s
}

// SetHpoResourceConfig sets the HpoResourceConfig field's value.
func (s *HPOConfig) SetHpoResourceConfig(v *HPOResourceConfig) *HPOConfig {
	s.HpoResourceConfig = v
	return s
}

// The metric to optimize during hyperparameter optimization (HPO).
//
// Amazon Personalize doesn't support configuring the hpoObjective at this time.
type HPOObjective struct {
	_ struct{} `type:"structure"`

	// The name of the metric.
	MetricName *string `locationName:"metricName" type:"string"`

	// A regular expression for finding the metric in the training job logs.
	MetricRegex *string `locationName:"metricRegex" type:"string"`

	// The type of the metric. Valid values are Maximize and Minimize.
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HPOObjective) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HPOObjective) GoString() string {
	return s.String()
}

// SetMetricName sets the MetricName field's value.
func (s *HPOObjective) SetMetricName(v string) *HPOObjective {
	s.MetricName = &v
	return s
}

// SetMetricRegex sets the MetricRegex field's value.
func (s *HPOObjective) SetMetricRegex(v string) *HPOObjective {
	s.MetricRegex = &v
	return s
}

// SetType sets the Type field's value.
func (s *HPOObjective) SetType(v string) *HPOObjective {
	s.Type = &v
	return s
}

// Describes the resource configuration for hyperparameter optimization (HPO).
type HPOResourceConfig struct {
	_ struct{} `type:"structure"`

	// The maximum number of training jobs when you create a solution version. The
	// maximum value for maxNumberOfTrainingJobs is 40.
	MaxNumberOfTrainingJobs *string `locationName:"maxNumberOfTrainingJobs" type:"string"`

	// The maximum number of parallel training jobs when you create a solution version.
	// The maximum value for maxParallelTrainingJobs is 10.
	MaxParallelTrainingJobs *string `locationName:"maxParallelTrainingJobs" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HPOResourceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HPOResourceConfig) GoString() string {
	return s.String()
}

// SetMaxNumberOfTrainingJobs sets the MaxNumberOfTrainingJobs field's value.
func (s *HPOResourceConfig) SetMaxNumberOfTrainingJobs(v string) *HPOResourceConfig {
	s.MaxNumberOfTrainingJobs = &v
	return s
}

// SetMaxParallelTrainingJobs sets the MaxParallelTrainingJobs field's value.
func (s *HPOResourceConfig) SetMaxParallelTrainingJobs(v string) *HPOResourceConfig {
	s.MaxParallelTrainingJobs = &v
	return s
}

// Specifies the hyperparameters and their ranges. Hyperparameters can be categorical,
// continuous, or integer-valued.
type HyperParameterRanges struct {
	_ struct{} `type:"structure"`

	// The categorical hyperparameters and their ranges.
	CategoricalHyperParameterRanges []*CategoricalHyperParameterRange `locationName:"categoricalHyperParameterRanges" type:"list"`

	// The continuous hyperparameters and their ranges.
	ContinuousHyperParameterRanges []*ContinuousHyperParameterRange `locationName:"continuousHyperParameterRanges" type:"list"`

	// The integer-valued hyperparameters and their ranges.
	IntegerHyperParameterRanges []*IntegerHyperParameterRange `locationName:"integerHyperParameterRanges" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HyperParameterRanges) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HyperParameterRanges) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HyperParameterRanges) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HyperParameterRanges"}
	if s.ContinuousHyperParameterRanges != nil {
		for i, v := range s.ContinuousHyperParameterRanges {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ContinuousHyperParameterRanges", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.IntegerHyperParameterRanges != nil {
		for i, v := range s.IntegerHyperParameterRanges {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "IntegerHyperParameterRanges", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategoricalHyperParameterRanges sets the CategoricalHyperParameterRanges field's value.
func (s *HyperParameterRanges) SetCategoricalHyperParameterRanges(v []*CategoricalHyperParameterRange) *HyperParameterRanges {
	s.CategoricalHyperParameterRanges = v
	return s
}

// SetContinuousHyperParameterRanges sets the ContinuousHyperParameterRanges field's value.
func (s *HyperParameterRanges) SetContinuousHyperParameterRanges(v []*ContinuousHyperParameterRange) *HyperParameterRanges {
	s.ContinuousHyperParameterRanges = v
	return s
}

// SetIntegerHyperParameterRanges sets the IntegerHyperParameterRanges field's value.
func (s *HyperParameterRanges) SetIntegerHyperParameterRanges(v []*IntegerHyperParameterRange) *HyperParameterRanges {
	s.IntegerHyperParameterRanges = v
	return s
}

// Provides the name and range of an integer-valued hyperparameter.
type IntegerHyperParameterRange struct {
	_ struct{} `type:"structure"`

	// The maximum allowable value for the hyperparameter.
	MaxValue *int64 `locationName:"maxValue" type:"integer"`

	// The minimum allowable value for the hyperparameter.
	MinValue *int64 `locationName:"minValue" type:"integer"`

	// The name of the hyperparameter.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntegerHyperParameterRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntegerHyperParameterRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IntegerHyperParameterRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IntegerHyperParameterRange"}
	if s.MinValue != nil && *s.MinValue < -1e+06 {
		invalidParams.Add(request.NewErrParamMinValue("MinValue", -1e+06))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxValue sets the MaxValue field's value.
func (s *IntegerHyperParameterRange) SetMaxValue(v int64) *IntegerHyperParameterRange {
	s.MaxValue = &v
	return s
}

// SetMinValue sets the MinValue field's value.
func (s *IntegerHyperParameterRange) SetMinValue(v int64) *IntegerHyperParameterRange {
	s.MinValue = &v
	return s
}

// SetName sets the Name field's value.
func (s *IntegerHyperParameterRange) SetName(v string) *IntegerHyperParameterRange {
	s.Name = &v
	return s
}

// Provide a valid value for the field or parameter.
type InvalidInputException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidInputException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidInputException) GoString() string {
	return s.String()
}

func newErrorInvalidInputException(v protocol.ResponseMetadata) error {
	return &InvalidInputException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidInputException) Code() string {
	return "InvalidInputException"
}

// Message returns the exception's message.
func (s *InvalidInputException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidInputException) OrigErr() error {
	return nil
}

func (s *InvalidInputException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidInputException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidInputException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The token is not valid.
type InvalidNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s *InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The limit on the number of requests per second has been exceeded.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListBatchInferenceJobsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of batch inference job results to return in each page.
	// The default value is 100.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The Amazon Resource Name (ARN) of the solution version from which the batch
	// inference jobs were created.
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBatchInferenceJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBatchInferenceJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBatchInferenceJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBatchInferenceJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBatchInferenceJobsInput) SetMaxResults(v int64) *ListBatchInferenceJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBatchInferenceJobsInput) SetNextToken(v string) *ListBatchInferenceJobsInput {
	s.NextToken = &v
	return s
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *ListBatchInferenceJobsInput) SetSolutionVersionArn(v string) *ListBatchInferenceJobsInput {
	s.SolutionVersionArn = &v
	return s
}

type ListBatchInferenceJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing information on each job that is returned.
	BatchInferenceJobs []*BatchInferenceJobSummary `locationName:"batchInferenceJobs" type:"list"`

	// The token to use to retrieve the next page of results. The value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBatchInferenceJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBatchInferenceJobsOutput) GoString() string {
	return s.String()
}

// SetBatchInferenceJobs sets the BatchInferenceJobs field's value.
func (s *ListBatchInferenceJobsOutput) SetBatchInferenceJobs(v []*BatchInferenceJobSummary) *ListBatchInferenceJobsOutput {
	s.BatchInferenceJobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBatchInferenceJobsOutput) SetNextToken(v string) *ListBatchInferenceJobsOutput {
	s.NextToken = &v
	return s
}

type ListBatchSegmentJobsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of batch segment job results to return in each page. The
	// default value is 100.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The Amazon Resource Name (ARN) of the solution version that the batch segment
	// jobs used to generate batch segments.
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBatchSegmentJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBatchSegmentJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBatchSegmentJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBatchSegmentJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBatchSegmentJobsInput) SetMaxResults(v int64) *ListBatchSegmentJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBatchSegmentJobsInput) SetNextToken(v string) *ListBatchSegmentJobsInput {
	s.NextToken = &v
	return s
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *ListBatchSegmentJobsInput) SetSolutionVersionArn(v string) *ListBatchSegmentJobsInput {
	s.SolutionVersionArn = &v
	return s
}

type ListBatchSegmentJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing information on each job that is returned.
	BatchSegmentJobs []*BatchSegmentJobSummary `locationName:"batchSegmentJobs" type:"list"`

	// The token to use to retrieve the next page of results. The value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBatchSegmentJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBatchSegmentJobsOutput) GoString() string {
	return s.String()
}

// SetBatchSegmentJobs sets the BatchSegmentJobs field's value.
func (s *ListBatchSegmentJobsOutput) SetBatchSegmentJobs(v []*BatchSegmentJobSummary) *ListBatchSegmentJobsOutput {
	s.BatchSegmentJobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBatchSegmentJobsOutput) SetNextToken(v string) *ListBatchSegmentJobsOutput {
	s.NextToken = &v
	return s
}

type ListCampaignsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of campaigns to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token returned from the previous call to ListCampaigns (https://docs.aws.amazon.com/personalize/latest/dg/API_ListCampaigns.html)
	// for getting the next set of campaigns (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`

	// The Amazon Resource Name (ARN) of the solution to list the campaigns for.
	// When a solution is not specified, all the campaigns associated with the account
	// are listed.
	SolutionArn *string `locationName:"solutionArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCampaignsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCampaignsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCampaignsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCampaignsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCampaignsInput) SetMaxResults(v int64) *ListCampaignsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCampaignsInput) SetNextToken(v string) *ListCampaignsInput {
	s.NextToken = &v
	return s
}

// SetSolutionArn sets the SolutionArn field's value.
func (s *ListCampaignsInput) SetSolutionArn(v string) *ListCampaignsInput {
	s.SolutionArn = &v
	return s
}

type ListCampaignsOutput struct {
	_ struct{} `type:"structure"`

	// A list of the campaigns.
	Campaigns []*CampaignSummary `locationName:"campaigns" type:"list"`

	// A token for getting the next set of campaigns (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCampaignsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCampaignsOutput) GoString() string {
	return s.String()
}

// SetCampaigns sets the Campaigns field's value.
func (s *ListCampaignsOutput) SetCampaigns(v []*CampaignSummary) *ListCampaignsOutput {
	s.Campaigns = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCampaignsOutput) SetNextToken(v string) *ListCampaignsOutput {
	s.NextToken = &v
	return s
}

type ListDatasetExportJobsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset to list the dataset export
	// jobs for.
	DatasetArn *string `locationName:"datasetArn" type:"string"`

	// The maximum number of dataset export jobs to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token returned from the previous call to ListDatasetExportJobs for getting
	// the next set of dataset export jobs (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetExportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetExportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatasetExportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDatasetExportJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *ListDatasetExportJobsInput) SetDatasetArn(v string) *ListDatasetExportJobsInput {
	s.DatasetArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDatasetExportJobsInput) SetMaxResults(v int64) *ListDatasetExportJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetExportJobsInput) SetNextToken(v string) *ListDatasetExportJobsInput {
	s.NextToken = &v
	return s
}

type ListDatasetExportJobsOutput struct {
	_ struct{} `type:"structure"`

	// The list of dataset export jobs.
	DatasetExportJobs []*DatasetExportJobSummary `locationName:"datasetExportJobs" type:"list"`

	// A token for getting the next set of dataset export jobs (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetExportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetExportJobsOutput) GoString() string {
	return s.String()
}

// SetDatasetExportJobs sets the DatasetExportJobs field's value.
func (s *ListDatasetExportJobsOutput) SetDatasetExportJobs(v []*DatasetExportJobSummary) *ListDatasetExportJobsOutput {
	s.DatasetExportJobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetExportJobsOutput) SetNextToken(v string) *ListDatasetExportJobsOutput {
	s.NextToken = &v
	return s
}

type ListDatasetGroupsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of dataset groups to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token returned from the previous call to ListDatasetGroups for getting
	// the next set of dataset groups (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatasetGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDatasetGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDatasetGroupsInput) SetMaxResults(v int64) *ListDatasetGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetGroupsInput) SetNextToken(v string) *ListDatasetGroupsInput {
	s.NextToken = &v
	return s
}

type ListDatasetGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The list of your dataset groups.
	DatasetGroups []*DatasetGroupSummary `locationName:"datasetGroups" type:"list"`

	// A token for getting the next set of dataset groups (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetGroupsOutput) GoString() string {
	return s.String()
}

// SetDatasetGroups sets the DatasetGroups field's value.
func (s *ListDatasetGroupsOutput) SetDatasetGroups(v []*DatasetGroupSummary) *ListDatasetGroupsOutput {
	s.DatasetGroups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetGroupsOutput) SetNextToken(v string) *ListDatasetGroupsOutput {
	s.NextToken = &v
	return s
}

type ListDatasetImportJobsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset to list the dataset import
	// jobs for.
	DatasetArn *string `locationName:"datasetArn" type:"string"`

	// The maximum number of dataset import jobs to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token returned from the previous call to ListDatasetImportJobs for getting
	// the next set of dataset import jobs (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetImportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetImportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatasetImportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDatasetImportJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *ListDatasetImportJobsInput) SetDatasetArn(v string) *ListDatasetImportJobsInput {
	s.DatasetArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDatasetImportJobsInput) SetMaxResults(v int64) *ListDatasetImportJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetImportJobsInput) SetNextToken(v string) *ListDatasetImportJobsInput {
	s.NextToken = &v
	return s
}

type ListDatasetImportJobsOutput struct {
	_ struct{} `type:"structure"`

	// The list of dataset import jobs.
	DatasetImportJobs []*DatasetImportJobSummary `locationName:"datasetImportJobs" type:"list"`

	// A token for getting the next set of dataset import jobs (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetImportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetImportJobsOutput) GoString() string {
	return s.String()
}

// SetDatasetImportJobs sets the DatasetImportJobs field's value.
func (s *ListDatasetImportJobsOutput) SetDatasetImportJobs(v []*DatasetImportJobSummary) *ListDatasetImportJobsOutput {
	s.DatasetImportJobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetImportJobsOutput) SetNextToken(v string) *ListDatasetImportJobsOutput {
	s.NextToken = &v
	return s
}

type ListDatasetsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset group that contains the datasets
	// to list.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// The maximum number of datasets to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token returned from the previous call to ListDatasets for getting the next
	// set of dataset import jobs (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatasetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDatasetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *ListDatasetsInput) SetDatasetGroupArn(v string) *ListDatasetsInput {
	s.DatasetGroupArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDatasetsInput) SetMaxResults(v int64) *ListDatasetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetsInput) SetNextToken(v string) *ListDatasetsInput {
	s.NextToken = &v
	return s
}

type ListDatasetsOutput struct {
	_ struct{} `type:"structure"`

	// An array of Dataset objects. Each object provides metadata information.
	Datasets []*DatasetSummary `locationName:"datasets" type:"list"`

	// A token for getting the next set of datasets (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetsOutput) GoString() string {
	return s.String()
}

// SetDatasets sets the Datasets field's value.
func (s *ListDatasetsOutput) SetDatasets(v []*DatasetSummary) *ListDatasetsOutput {
	s.Datasets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetsOutput) SetNextToken(v string) *ListDatasetsOutput {
	s.NextToken = &v
	return s
}

type ListEventTrackersInput struct {
	_ struct{} `type:"structure"`

	// The ARN of a dataset group used to filter the response.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// The maximum number of event trackers to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token returned from the previous call to ListEventTrackers for getting
	// the next set of event trackers (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventTrackersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventTrackersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEventTrackersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEventTrackersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *ListEventTrackersInput) SetDatasetGroupArn(v string) *ListEventTrackersInput {
	s.DatasetGroupArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEventTrackersInput) SetMaxResults(v int64) *ListEventTrackersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventTrackersInput) SetNextToken(v string) *ListEventTrackersInput {
	s.NextToken = &v
	return s
}

type ListEventTrackersOutput struct {
	_ struct{} `type:"structure"`

	// A list of event trackers.
	EventTrackers []*EventTrackerSummary `locationName:"eventTrackers" type:"list"`

	// A token for getting the next set of event trackers (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventTrackersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventTrackersOutput) GoString() string {
	return s.String()
}

// SetEventTrackers sets the EventTrackers field's value.
func (s *ListEventTrackersOutput) SetEventTrackers(v []*EventTrackerSummary) *ListEventTrackersOutput {
	s.EventTrackers = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventTrackersOutput) SetNextToken(v string) *ListEventTrackersOutput {
	s.NextToken = &v
	return s
}

type ListFiltersInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the dataset group that contains the filters.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// The maximum number of filters to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token returned from the previous call to ListFilters for getting the next
	// set of filters (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFiltersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFiltersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFiltersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFiltersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *ListFiltersInput) SetDatasetGroupArn(v string) *ListFiltersInput {
	s.DatasetGroupArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFiltersInput) SetMaxResults(v int64) *ListFiltersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFiltersInput) SetNextToken(v string) *ListFiltersInput {
	s.NextToken = &v
	return s
}

type ListFiltersOutput struct {
	_ struct{} `type:"structure"`

	// A list of returned filters.
	Filters []*FilterSummary `type:"list"`

	// A token for getting the next set of filters (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFiltersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFiltersOutput) GoString() string {
	return s.String()
}

// SetFilters sets the Filters field's value.
func (s *ListFiltersOutput) SetFilters(v []*FilterSummary) *ListFiltersOutput {
	s.Filters = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFiltersOutput) SetNextToken(v string) *ListFiltersOutput {
	s.NextToken = &v
	return s
}

type ListMetricAttributionMetricsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of metrics to return in one page of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of the metric attribution to retrieve attributes
	// for.
	MetricAttributionArn *string `locationName:"metricAttributionArn" type:"string"`

	// Specify the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMetricAttributionMetricsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMetricAttributionMetricsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMetricAttributionMetricsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMetricAttributionMetricsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMetricAttributionMetricsInput) SetMaxResults(v int64) *ListMetricAttributionMetricsInput {
	s.MaxResults = &v
	return s
}

// SetMetricAttributionArn sets the MetricAttributionArn field's value.
func (s *ListMetricAttributionMetricsInput) SetMetricAttributionArn(v string) *ListMetricAttributionMetricsInput {
	s.MetricAttributionArn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMetricAttributionMetricsInput) SetNextToken(v string) *ListMetricAttributionMetricsInput {
	s.NextToken = &v
	return s
}

type ListMetricAttributionMetricsOutput struct {
	_ struct{} `type:"structure"`

	// The metrics for the specified metric attribution.
	Metrics []*MetricAttribute `locationName:"metrics" type:"list"`

	// Specify the pagination token from a previous ListMetricAttributionMetricsResponse
	// request to retrieve the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMetricAttributionMetricsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMetricAttributionMetricsOutput) GoString() string {
	return s.String()
}

// SetMetrics sets the Metrics field's value.
func (s *ListMetricAttributionMetricsOutput) SetMetrics(v []*MetricAttribute) *ListMetricAttributionMetricsOutput {
	s.Metrics = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMetricAttributionMetricsOutput) SetNextToken(v string) *ListMetricAttributionMetricsOutput {
	s.NextToken = &v
	return s
}

type ListMetricAttributionsInput struct {
	_ struct{} `type:"structure"`

	// The metric attributions' dataset group Amazon Resource Name (ARN).
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// The maximum number of metric attributions to return in one page of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Specify the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMetricAttributionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMetricAttributionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMetricAttributionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMetricAttributionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *ListMetricAttributionsInput) SetDatasetGroupArn(v string) *ListMetricAttributionsInput {
	s.DatasetGroupArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMetricAttributionsInput) SetMaxResults(v int64) *ListMetricAttributionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMetricAttributionsInput) SetNextToken(v string) *ListMetricAttributionsInput {
	s.NextToken = &v
	return s
}

type ListMetricAttributionsOutput struct {
	_ struct{} `type:"structure"`

	// The list of metric attributions.
	MetricAttributions []*MetricAttributionSummary `locationName:"metricAttributions" type:"list"`

	// Specify the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMetricAttributionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMetricAttributionsOutput) GoString() string {
	return s.String()
}

// SetMetricAttributions sets the MetricAttributions field's value.
func (s *ListMetricAttributionsOutput) SetMetricAttributions(v []*MetricAttributionSummary) *ListMetricAttributionsOutput {
	s.MetricAttributions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMetricAttributionsOutput) SetNextToken(v string) *ListMetricAttributionsOutput {
	s.NextToken = &v
	return s
}

type ListRecipesInput struct {
	_ struct{} `type:"structure"`

	// Filters returned recipes by domain for a Domain dataset group. Only recipes
	// (Domain dataset group use cases) for this domain are included in the response.
	// If you don't specify a domain, all recipes are returned.
	Domain *string `locationName:"domain" type:"string" enum:"Domain"`

	// The maximum number of recipes to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token returned from the previous call to ListRecipes for getting the next
	// set of recipes (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`

	// The default is SERVICE.
	RecipeProvider *string `locationName:"recipeProvider" type:"string" enum:"RecipeProvider"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecipesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecipesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRecipesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRecipesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *ListRecipesInput) SetDomain(v string) *ListRecipesInput {
	s.Domain = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRecipesInput) SetMaxResults(v int64) *ListRecipesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecipesInput) SetNextToken(v string) *ListRecipesInput {
	s.NextToken = &v
	return s
}

// SetRecipeProvider sets the RecipeProvider field's value.
func (s *ListRecipesInput) SetRecipeProvider(v string) *ListRecipesInput {
	s.RecipeProvider = &v
	return s
}

type ListRecipesOutput struct {
	_ struct{} `type:"structure"`

	// A token for getting the next set of recipes.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of available recipes.
	Recipes []*RecipeSummary `locationName:"recipes" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecipesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecipesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecipesOutput) SetNextToken(v string) *ListRecipesOutput {
	s.NextToken = &v
	return s
}

// SetRecipes sets the Recipes field's value.
func (s *ListRecipesOutput) SetRecipes(v []*RecipeSummary) *ListRecipesOutput {
	s.Recipes = v
	return s
}

type ListRecommendersInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Domain dataset group to list the recommenders
	// for. When a Domain dataset group is not specified, all the recommenders associated
	// with the account are listed.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// The maximum number of recommenders to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token returned from the previous call to ListRecommenders for getting the
	// next set of recommenders (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecommendersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecommendersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRecommendersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRecommendersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *ListRecommendersInput) SetDatasetGroupArn(v string) *ListRecommendersInput {
	s.DatasetGroupArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRecommendersInput) SetMaxResults(v int64) *ListRecommendersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecommendersInput) SetNextToken(v string) *ListRecommendersInput {
	s.NextToken = &v
	return s
}

type ListRecommendersOutput struct {
	_ struct{} `type:"structure"`

	// A token for getting the next set of recommenders (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of the recommenders.
	Recommenders []*RecommenderSummary `locationName:"recommenders" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecommendersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecommendersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecommendersOutput) SetNextToken(v string) *ListRecommendersOutput {
	s.NextToken = &v
	return s
}

// SetRecommenders sets the Recommenders field's value.
func (s *ListRecommendersOutput) SetRecommenders(v []*RecommenderSummary) *ListRecommendersOutput {
	s.Recommenders = v
	return s
}

type ListSchemasInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of schemas to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token returned from the previous call to ListSchemas for getting the next
	// set of schemas (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchemasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchemasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSchemasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSchemasInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSchemasInput) SetMaxResults(v int64) *ListSchemasInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSchemasInput) SetNextToken(v string) *ListSchemasInput {
	s.NextToken = &v
	return s
}

type ListSchemasOutput struct {
	_ struct{} `type:"structure"`

	// A token used to get the next set of schemas (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of schemas.
	Schemas []*DatasetSchemaSummary `locationName:"schemas" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchemasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchemasOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSchemasOutput) SetNextToken(v string) *ListSchemasOutput {
	s.NextToken = &v
	return s
}

// SetSchemas sets the Schemas field's value.
func (s *ListSchemasOutput) SetSchemas(v []*DatasetSchemaSummary) *ListSchemasOutput {
	s.Schemas = v
	return s
}

type ListSolutionVersionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of solution versions to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token returned from the previous call to ListSolutionVersions for getting
	// the next set of solution versions (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`

	// The Amazon Resource Name (ARN) of the solution.
	SolutionArn *string `locationName:"solutionArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolutionVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolutionVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSolutionVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSolutionVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSolutionVersionsInput) SetMaxResults(v int64) *ListSolutionVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSolutionVersionsInput) SetNextToken(v string) *ListSolutionVersionsInput {
	s.NextToken = &v
	return s
}

// SetSolutionArn sets the SolutionArn field's value.
func (s *ListSolutionVersionsInput) SetSolutionArn(v string) *ListSolutionVersionsInput {
	s.SolutionArn = &v
	return s
}

type ListSolutionVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A token for getting the next set of solution versions (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of solution versions describing the version properties.
	SolutionVersions []*SolutionVersionSummary `locationName:"solutionVersions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolutionVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolutionVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSolutionVersionsOutput) SetNextToken(v string) *ListSolutionVersionsOutput {
	s.NextToken = &v
	return s
}

// SetSolutionVersions sets the SolutionVersions field's value.
func (s *ListSolutionVersionsOutput) SetSolutionVersions(v []*SolutionVersionSummary) *ListSolutionVersionsOutput {
	s.SolutionVersions = v
	return s
}

type ListSolutionsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset group.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// The maximum number of solutions to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token returned from the previous call to ListSolutions for getting the
	// next set of solutions (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolutionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSolutionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSolutionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *ListSolutionsInput) SetDatasetGroupArn(v string) *ListSolutionsInput {
	s.DatasetGroupArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSolutionsInput) SetMaxResults(v int64) *ListSolutionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSolutionsInput) SetNextToken(v string) *ListSolutionsInput {
	s.NextToken = &v
	return s
}

type ListSolutionsOutput struct {
	_ struct{} `type:"structure"`

	// A token for getting the next set of solutions (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of the current solutions.
	Solutions []*SolutionSummary `locationName:"solutions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolutionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSolutionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSolutionsOutput) SetNextToken(v string) *ListSolutionsOutput {
	s.NextToken = &v
	return s
}

// SetSolutions sets the Solutions field's value.
func (s *ListSolutionsOutput) SetSolutions(v []*SolutionSummary) *ListSolutionsOutput {
	s.Solutions = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource's Amazon Resource Name.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The resource's tags.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Contains information on a metric that a metric attribution reports on. For
// more information, see Measuring impact of recommendations (https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html).
type MetricAttribute struct {
	_ struct{} `type:"structure"`

	// The metric's event type.
	//
	// EventType is a required field
	EventType *string `locationName:"eventType" type:"string" required:"true"`

	// The attribute's expression. Available functions are SUM() or SAMPLECOUNT().
	// For SUM() functions, provide the dataset type (either Interactions or Items)
	// and column to sum as a parameter. For example SUM(Items.PRICE).
	//
	// Expression is a required field
	Expression *string `locationName:"expression" type:"string" required:"true"`

	// The metric's name. The name helps you identify the metric in Amazon CloudWatch
	// or Amazon S3.
	//
	// MetricName is a required field
	MetricName *string `locationName:"metricName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricAttribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricAttribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricAttribute"}
	if s.EventType == nil {
		invalidParams.Add(request.NewErrParamRequired("EventType"))
	}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventType sets the EventType field's value.
func (s *MetricAttribute) SetEventType(v string) *MetricAttribute {
	s.EventType = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *MetricAttribute) SetExpression(v string) *MetricAttribute {
	s.Expression = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *MetricAttribute) SetMetricName(v string) *MetricAttribute {
	s.MetricName = &v
	return s
}

// Contains information on a metric attribution. A metric attribution creates
// reports on the data that you import into Amazon Personalize. Depending on
// how you import the data, you can view reports in Amazon CloudWatch or Amazon
// S3. For more information, see Measuring impact of recommendations (https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html).
type MetricAttribution struct {
	_ struct{} `type:"structure"`

	// The metric attribution's creation date time.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The metric attribution's dataset group Amazon Resource Name (ARN).
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// The metric attribution's failure reason.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The metric attribution's last updated date time.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The metric attribution's Amazon Resource Name (ARN).
	MetricAttributionArn *string `locationName:"metricAttributionArn" type:"string"`

	// The metric attribution's output configuration.
	MetricsOutputConfig *MetricAttributionOutput_ `locationName:"metricsOutputConfig" type:"structure"`

	// The metric attribution's name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The metric attribution's status.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricAttribution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricAttribution) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *MetricAttribution) SetCreationDateTime(v time.Time) *MetricAttribution {
	s.CreationDateTime = &v
	return s
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *MetricAttribution) SetDatasetGroupArn(v string) *MetricAttribution {
	s.DatasetGroupArn = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *MetricAttribution) SetFailureReason(v string) *MetricAttribution {
	s.FailureReason = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *MetricAttribution) SetLastUpdatedDateTime(v time.Time) *MetricAttribution {
	s.LastUpdatedDateTime = &v
	return s
}

// SetMetricAttributionArn sets the MetricAttributionArn field's value.
func (s *MetricAttribution) SetMetricAttributionArn(v string) *MetricAttribution {
	s.MetricAttributionArn = &v
	return s
}

// SetMetricsOutputConfig sets the MetricsOutputConfig field's value.
func (s *MetricAttribution) SetMetricsOutputConfig(v *MetricAttributionOutput_) *MetricAttribution {
	s.MetricsOutputConfig = v
	return s
}

// SetName sets the Name field's value.
func (s *MetricAttribution) SetName(v string) *MetricAttribution {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *MetricAttribution) SetStatus(v string) *MetricAttribution {
	s.Status = &v
	return s
}

// The output configuration details for a metric attribution.
type MetricAttributionOutput_ struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM service role that has permissions
	// to add data to your output Amazon S3 bucket and add metrics to Amazon CloudWatch.
	// For more information, see Measuring impact of recommendations (https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html).
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The configuration details of an Amazon S3 input or output bucket.
	S3DataDestination *S3DataConfig `locationName:"s3DataDestination" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricAttributionOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricAttributionOutput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricAttributionOutput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricAttributionOutput_"}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.S3DataDestination != nil {
		if err := s.S3DataDestination.Validate(); err != nil {
			invalidParams.AddNested("S3DataDestination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleArn sets the RoleArn field's value.
func (s *MetricAttributionOutput_) SetRoleArn(v string) *MetricAttributionOutput_ {
	s.RoleArn = &v
	return s
}

// SetS3DataDestination sets the S3DataDestination field's value.
func (s *MetricAttributionOutput_) SetS3DataDestination(v *S3DataConfig) *MetricAttributionOutput_ {
	s.S3DataDestination = v
	return s
}

// Provides a summary of the properties of a metric attribution. For a complete
// listing, call the DescribeMetricAttribution (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeMetricAttribution.html).
type MetricAttributionSummary struct {
	_ struct{} `type:"structure"`

	// The metric attribution's creation date time.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The metric attribution's failure reason.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The metric attribution's last updated date time.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The metric attribution's Amazon Resource Name (ARN).
	MetricAttributionArn *string `locationName:"metricAttributionArn" type:"string"`

	// The name of the metric attribution.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The metric attribution's status.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricAttributionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricAttributionSummary) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *MetricAttributionSummary) SetCreationDateTime(v time.Time) *MetricAttributionSummary {
	s.CreationDateTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *MetricAttributionSummary) SetFailureReason(v string) *MetricAttributionSummary {
	s.FailureReason = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *MetricAttributionSummary) SetLastUpdatedDateTime(v time.Time) *MetricAttributionSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetMetricAttributionArn sets the MetricAttributionArn field's value.
func (s *MetricAttributionSummary) SetMetricAttributionArn(v string) *MetricAttributionSummary {
	s.MetricAttributionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *MetricAttributionSummary) SetName(v string) *MetricAttributionSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *MetricAttributionSummary) SetStatus(v string) *MetricAttributionSummary {
	s.Status = &v
	return s
}

// Describes the additional objective for the solution, such as maximizing streaming
// minutes or increasing revenue. For more information see Optimizing a solution
// (https://docs.aws.amazon.com/personalize/latest/dg/optimizing-solution-for-objective.html).
type OptimizationObjective struct {
	_ struct{} `type:"structure"`

	// The numerical metadata column in an Items dataset related to the optimization
	// objective. For example, VIDEO_LENGTH (to maximize streaming minutes), or
	// PRICE (to maximize revenue).
	ItemAttribute *string `locationName:"itemAttribute" min:"1" type:"string"`

	// Specifies how Amazon Personalize balances the importance of your optimization
	// objective versus relevance.
	ObjectiveSensitivity *string `locationName:"objectiveSensitivity" type:"string" enum:"ObjectiveSensitivity"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OptimizationObjective) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OptimizationObjective) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OptimizationObjective) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OptimizationObjective"}
	if s.ItemAttribute != nil && len(*s.ItemAttribute) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ItemAttribute", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItemAttribute sets the ItemAttribute field's value.
func (s *OptimizationObjective) SetItemAttribute(v string) *OptimizationObjective {
	s.ItemAttribute = &v
	return s
}

// SetObjectiveSensitivity sets the ObjectiveSensitivity field's value.
func (s *OptimizationObjective) SetObjectiveSensitivity(v string) *OptimizationObjective {
	s.ObjectiveSensitivity = &v
	return s
}

// Provides information about a recipe. Each recipe provides an algorithm that
// Amazon Personalize uses in model training when you use the CreateSolution
// (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html)
// operation.
type Recipe struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the algorithm that Amazon Personalize uses
	// to train the model.
	AlgorithmArn *string `locationName:"algorithmArn" type:"string"`

	// The date and time (in Unix format) that the recipe was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The description of the recipe.
	Description *string `locationName:"description" type:"string"`

	// The ARN of the FeatureTransformation object.
	FeatureTransformationArn *string `locationName:"featureTransformationArn" type:"string"`

	// The date and time (in Unix format) that the recipe was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the recipe.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the recipe.
	RecipeArn *string `locationName:"recipeArn" type:"string"`

	// One of the following values:
	//
	//    * PERSONALIZED_RANKING
	//
	//    * RELATED_ITEMS
	//
	//    * USER_PERSONALIZATION
	RecipeType *string `locationName:"recipeType" type:"string"`

	// The status of the recipe.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Recipe) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Recipe) GoString() string {
	return s.String()
}

// SetAlgorithmArn sets the AlgorithmArn field's value.
func (s *Recipe) SetAlgorithmArn(v string) *Recipe {
	s.AlgorithmArn = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *Recipe) SetCreationDateTime(v time.Time) *Recipe {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Recipe) SetDescription(v string) *Recipe {
	s.Description = &v
	return s
}

// SetFeatureTransformationArn sets the FeatureTransformationArn field's value.
func (s *Recipe) SetFeatureTransformationArn(v string) *Recipe {
	s.FeatureTransformationArn = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *Recipe) SetLastUpdatedDateTime(v time.Time) *Recipe {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Recipe) SetName(v string) *Recipe {
	s.Name = &v
	return s
}

// SetRecipeArn sets the RecipeArn field's value.
func (s *Recipe) SetRecipeArn(v string) *Recipe {
	s.RecipeArn = &v
	return s
}

// SetRecipeType sets the RecipeType field's value.
func (s *Recipe) SetRecipeType(v string) *Recipe {
	s.RecipeType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Recipe) SetStatus(v string) *Recipe {
	s.Status = &v
	return s
}

// Provides a summary of the properties of a recipe. For a complete listing,
// call the DescribeRecipe (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecipe.html)
// API.
type RecipeSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that the recipe was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The domain of the recipe (if the recipe is a Domain dataset group use case).
	Domain *string `locationName:"domain" type:"string" enum:"Domain"`

	// The date and time (in Unix time) that the recipe was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the recipe.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the recipe.
	RecipeArn *string `locationName:"recipeArn" type:"string"`

	// The status of the recipe.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecipeSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecipeSummary) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *RecipeSummary) SetCreationDateTime(v time.Time) *RecipeSummary {
	s.CreationDateTime = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *RecipeSummary) SetDomain(v string) *RecipeSummary {
	s.Domain = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *RecipeSummary) SetLastUpdatedDateTime(v time.Time) *RecipeSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *RecipeSummary) SetName(v string) *RecipeSummary {
	s.Name = &v
	return s
}

// SetRecipeArn sets the RecipeArn field's value.
func (s *RecipeSummary) SetRecipeArn(v string) *RecipeSummary {
	s.RecipeArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RecipeSummary) SetStatus(v string) *RecipeSummary {
	s.Status = &v
	return s
}

// Describes a recommendation generator for a Domain dataset group. You create
// a recommender in a Domain dataset group for a specific domain use case (domain
// recipe), and specify the recommender in a GetRecommendations (https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html)
// request.
type Recommender struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix format) that the recommender was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the Domain dataset group that contains
	// the recommender.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// If a recommender fails, the reason behind the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The date and time (in Unix format) that the recommender was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// Provides a summary of the latest updates to the recommender.
	LatestRecommenderUpdate *RecommenderUpdateSummary `locationName:"latestRecommenderUpdate" type:"structure"`

	// Provides evaluation metrics that help you determine the performance of a
	// recommender. For more information, see Evaluating a recommender (https://docs.aws.amazon.com/personalize/latest/dg/evaluating-recommenders.html).
	ModelMetrics map[string]*float64 `locationName:"modelMetrics" type:"map"`

	// The name of the recommender.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the recipe (Domain dataset group use case)
	// that the recommender was created for.
	RecipeArn *string `locationName:"recipeArn" type:"string"`

	// The Amazon Resource Name (ARN) of the recommender.
	RecommenderArn *string `locationName:"recommenderArn" type:"string"`

	// The configuration details of the recommender.
	RecommenderConfig *RecommenderConfig `locationName:"recommenderConfig" type:"structure"`

	// The status of the recommender.
	//
	// A recommender can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * STOP PENDING > STOP IN_PROGRESS > INACTIVE > START PENDING > START IN_PROGRESS
	//    > ACTIVE
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Recommender) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Recommender) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *Recommender) SetCreationDateTime(v time.Time) *Recommender {
	s.CreationDateTime = &v
	return s
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *Recommender) SetDatasetGroupArn(v string) *Recommender {
	s.DatasetGroupArn = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *Recommender) SetFailureReason(v string) *Recommender {
	s.FailureReason = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *Recommender) SetLastUpdatedDateTime(v time.Time) *Recommender {
	s.LastUpdatedDateTime = &v
	return s
}

// SetLatestRecommenderUpdate sets the LatestRecommenderUpdate field's value.
func (s *Recommender) SetLatestRecommenderUpdate(v *RecommenderUpdateSummary) *Recommender {
	s.LatestRecommenderUpdate = v
	return s
}

// SetModelMetrics sets the ModelMetrics field's value.
func (s *Recommender) SetModelMetrics(v map[string]*float64) *Recommender {
	s.ModelMetrics = v
	return s
}

// SetName sets the Name field's value.
func (s *Recommender) SetName(v string) *Recommender {
	s.Name = &v
	return s
}

// SetRecipeArn sets the RecipeArn field's value.
func (s *Recommender) SetRecipeArn(v string) *Recommender {
	s.RecipeArn = &v
	return s
}

// SetRecommenderArn sets the RecommenderArn field's value.
func (s *Recommender) SetRecommenderArn(v string) *Recommender {
	s.RecommenderArn = &v
	return s
}

// SetRecommenderConfig sets the RecommenderConfig field's value.
func (s *Recommender) SetRecommenderConfig(v *RecommenderConfig) *Recommender {
	s.RecommenderConfig = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Recommender) SetStatus(v string) *Recommender {
	s.Status = &v
	return s
}

// The configuration details of the recommender.
type RecommenderConfig struct {
	_ struct{} `type:"structure"`

	// Whether metadata with recommendations is enabled for the recommender. If
	// enabled, you can specify the columns from your Items dataset in your request
	// for recommendations. Amazon Personalize returns this data for each item in
	// the recommendation response. For information about enabling metadata for
	// a recommender, see Enabling metadata in recommendations for a recommender
	// (https://docs.aws.amazon.com/personalize/latest/dg/creating-recommenders.html#create-recommender-return-metadata).
	//
	// If you enable metadata in recommendations, you will incur additional costs.
	// For more information, see Amazon Personalize pricing (https://aws.amazon.com/personalize/pricing/).
	EnableMetadataWithRecommendations *bool `locationName:"enableMetadataWithRecommendations" type:"boolean"`

	// Specifies the exploration configuration hyperparameters, including explorationWeight
	// and explorationItemAgeCutOff, you want to use to configure the amount of
	// item exploration Amazon Personalize uses when recommending items. Provide
	// itemExplorationConfig data only if your recommenders generate personalized
	// recommendations for a user (not popular items or similar items).
	ItemExplorationConfig map[string]*string `locationName:"itemExplorationConfig" type:"map"`

	// Specifies the requested minimum provisioned recommendation requests per second
	// that Amazon Personalize will support. A high minRecommendationRequestsPerSecond
	// will increase your bill. We recommend starting with 1 for minRecommendationRequestsPerSecond
	// (the default). Track your usage using Amazon CloudWatch metrics, and increase
	// the minRecommendationRequestsPerSecond as necessary.
	MinRecommendationRequestsPerSecond *int64 `locationName:"minRecommendationRequestsPerSecond" min:"1" type:"integer"`

	// Specifies the training data configuration to use when creating a domain recommender.
	TrainingDataConfig *TrainingDataConfig `locationName:"trainingDataConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommenderConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommenderConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecommenderConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RecommenderConfig"}
	if s.MinRecommendationRequestsPerSecond != nil && *s.MinRecommendationRequestsPerSecond < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinRecommendationRequestsPerSecond", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnableMetadataWithRecommendations sets the EnableMetadataWithRecommendations field's value.
func (s *RecommenderConfig) SetEnableMetadataWithRecommendations(v bool) *RecommenderConfig {
	s.EnableMetadataWithRecommendations = &v
	return s
}

// SetItemExplorationConfig sets the ItemExplorationConfig field's value.
func (s *RecommenderConfig) SetItemExplorationConfig(v map[string]*string) *RecommenderConfig {
	s.ItemExplorationConfig = v
	return s
}

// SetMinRecommendationRequestsPerSecond sets the MinRecommendationRequestsPerSecond field's value.
func (s *RecommenderConfig) SetMinRecommendationRequestsPerSecond(v int64) *RecommenderConfig {
	s.MinRecommendationRequestsPerSecond = &v
	return s
}

// SetTrainingDataConfig sets the TrainingDataConfig field's value.
func (s *RecommenderConfig) SetTrainingDataConfig(v *TrainingDataConfig) *RecommenderConfig {
	s.TrainingDataConfig = v
	return s
}

// Provides a summary of the properties of the recommender.
type RecommenderSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix format) that the recommender was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the Domain dataset group that contains
	// the recommender.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// The date and time (in Unix format) that the recommender was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the recommender.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the recipe (Domain dataset group use case)
	// that the recommender was created for.
	RecipeArn *string `locationName:"recipeArn" type:"string"`

	// The Amazon Resource Name (ARN) of the recommender.
	RecommenderArn *string `locationName:"recommenderArn" type:"string"`

	// The configuration details of the recommender.
	RecommenderConfig *RecommenderConfig `locationName:"recommenderConfig" type:"structure"`

	// The status of the recommender. A recommender can be in one of the following
	// states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * STOP PENDING > STOP IN_PROGRESS > INACTIVE > START PENDING > START IN_PROGRESS
	//    > ACTIVE
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommenderSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommenderSummary) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *RecommenderSummary) SetCreationDateTime(v time.Time) *RecommenderSummary {
	s.CreationDateTime = &v
	return s
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *RecommenderSummary) SetDatasetGroupArn(v string) *RecommenderSummary {
	s.DatasetGroupArn = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *RecommenderSummary) SetLastUpdatedDateTime(v time.Time) *RecommenderSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *RecommenderSummary) SetName(v string) *RecommenderSummary {
	s.Name = &v
	return s
}

// SetRecipeArn sets the RecipeArn field's value.
func (s *RecommenderSummary) SetRecipeArn(v string) *RecommenderSummary {
	s.RecipeArn = &v
	return s
}

// SetRecommenderArn sets the RecommenderArn field's value.
func (s *RecommenderSummary) SetRecommenderArn(v string) *RecommenderSummary {
	s.RecommenderArn = &v
	return s
}

// SetRecommenderConfig sets the RecommenderConfig field's value.
func (s *RecommenderSummary) SetRecommenderConfig(v *RecommenderConfig) *RecommenderSummary {
	s.RecommenderConfig = v
	return s
}

// SetStatus sets the Status field's value.
func (s *RecommenderSummary) SetStatus(v string) *RecommenderSummary {
	s.Status = &v
	return s
}

// Provides a summary of the properties of a recommender update. For a complete
// listing, call the DescribeRecommender (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html)
// API.
type RecommenderUpdateSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix format) that the recommender update was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// If a recommender update fails, the reason behind the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The date and time (in Unix time) that the recommender update was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The configuration details of the recommender update.
	RecommenderConfig *RecommenderConfig `locationName:"recommenderConfig" type:"structure"`

	// The status of the recommender update.
	//
	// A recommender can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * STOP PENDING > STOP IN_PROGRESS > INACTIVE > START PENDING > START IN_PROGRESS
	//    > ACTIVE
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommenderUpdateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommenderUpdateSummary) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *RecommenderUpdateSummary) SetCreationDateTime(v time.Time) *RecommenderUpdateSummary {
	s.CreationDateTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *RecommenderUpdateSummary) SetFailureReason(v string) *RecommenderUpdateSummary {
	s.FailureReason = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *RecommenderUpdateSummary) SetLastUpdatedDateTime(v time.Time) *RecommenderUpdateSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetRecommenderConfig sets the RecommenderConfig field's value.
func (s *RecommenderUpdateSummary) SetRecommenderConfig(v *RecommenderConfig) *RecommenderUpdateSummary {
	s.RecommenderConfig = v
	return s
}

// SetStatus sets the Status field's value.
func (s *RecommenderUpdateSummary) SetStatus(v string) *RecommenderUpdateSummary {
	s.Status = &v
	return s
}

// The specified resource already exists.
type ResourceAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorResourceAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &ResourceAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceAlreadyExistsException) Code() string {
	return "ResourceAlreadyExistsException"
}

// Message returns the exception's message.
func (s *ResourceAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *ResourceAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource is in use.
type ResourceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) GoString() string {
	return s.String()
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s *ResourceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUseException) OrigErr() error {
	return nil
}

func (s *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Could not find the specified resource.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configuration details of an Amazon S3 input or output bucket.
type S3DataConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Key Management Service (KMS) key that
	// Amazon Personalize uses to encrypt or decrypt the input and output files.
	KmsKeyArn *string `locationName:"kmsKeyArn" type:"string"`

	// The file path of the Amazon S3 bucket.
	//
	// Path is a required field
	Path *string `locationName:"path" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3DataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3DataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3DataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3DataConfig"}
	if s.Path == nil {
		invalidParams.Add(request.NewErrParamRequired("Path"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *S3DataConfig) SetKmsKeyArn(v string) *S3DataConfig {
	s.KmsKeyArn = &v
	return s
}

// SetPath sets the Path field's value.
func (s *S3DataConfig) SetPath(v string) *S3DataConfig {
	s.Path = &v
	return s
}

// An object that provides information about a solution. A solution is a trained
// model that can be deployed as a campaign.
type Solution struct {
	_ struct{} `type:"structure"`

	// When performAutoML is true, specifies the best recipe found.
	AutoMLResult *AutoMLResult `locationName:"autoMLResult" type:"structure"`

	// The creation date and time (in Unix time) of the solution.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset group that provides the training
	// data.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// The event type (for example, 'click' or 'like') that is used for training
	// the model. If no eventType is provided, Amazon Personalize uses all interactions
	// for training with equal weight regardless of type.
	EventType *string `locationName:"eventType" type:"string"`

	// The date and time (in Unix time) that the solution was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// Describes the latest version of the solution, including the status and the
	// ARN.
	LatestSolutionVersion *SolutionVersionSummary `locationName:"latestSolutionVersion" type:"structure"`

	// The name of the solution.
	Name *string `locationName:"name" min:"1" type:"string"`

	//
	// We don't recommend enabling automated machine learning. Instead, match your
	// use case to the available Amazon Personalize recipes. For more information,
	// see Determining your use case. (https://docs.aws.amazon.com/personalize/latest/dg/determining-use-case.html)
	//
	// When true, Amazon Personalize performs a search for the best USER_PERSONALIZATION
	// recipe from the list specified in the solution configuration (recipeArn must
	// not be specified). When false (the default), Amazon Personalize uses recipeArn
	// for training.
	PerformAutoML *bool `locationName:"performAutoML" type:"boolean"`

	// Whether to perform hyperparameter optimization (HPO) on the chosen recipe.
	// The default is false.
	PerformHPO *bool `locationName:"performHPO" type:"boolean"`

	// The ARN of the recipe used to create the solution. This is required when
	// performAutoML is false.
	RecipeArn *string `locationName:"recipeArn" type:"string"`

	// The ARN of the solution.
	SolutionArn *string `locationName:"solutionArn" type:"string"`

	// Describes the configuration properties for the solution.
	SolutionConfig *SolutionConfig `locationName:"solutionConfig" type:"structure"`

	// The status of the solution.
	//
	// A solution can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Solution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Solution) GoString() string {
	return s.String()
}

// SetAutoMLResult sets the AutoMLResult field's value.
func (s *Solution) SetAutoMLResult(v *AutoMLResult) *Solution {
	s.AutoMLResult = v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *Solution) SetCreationDateTime(v time.Time) *Solution {
	s.CreationDateTime = &v
	return s
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *Solution) SetDatasetGroupArn(v string) *Solution {
	s.DatasetGroupArn = &v
	return s
}

// SetEventType sets the EventType field's value.
func (s *Solution) SetEventType(v string) *Solution {
	s.EventType = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *Solution) SetLastUpdatedDateTime(v time.Time) *Solution {
	s.LastUpdatedDateTime = &v
	return s
}

// SetLatestSolutionVersion sets the LatestSolutionVersion field's value.
func (s *Solution) SetLatestSolutionVersion(v *SolutionVersionSummary) *Solution {
	s.LatestSolutionVersion = v
	return s
}

// SetName sets the Name field's value.
func (s *Solution) SetName(v string) *Solution {
	s.Name = &v
	return s
}

// SetPerformAutoML sets the PerformAutoML field's value.
func (s *Solution) SetPerformAutoML(v bool) *Solution {
	s.PerformAutoML = &v
	return s
}

// SetPerformHPO sets the PerformHPO field's value.
func (s *Solution) SetPerformHPO(v bool) *Solution {
	s.PerformHPO = &v
	return s
}

// SetRecipeArn sets the RecipeArn field's value.
func (s *Solution) SetRecipeArn(v string) *Solution {
	s.RecipeArn = &v
	return s
}

// SetSolutionArn sets the SolutionArn field's value.
func (s *Solution) SetSolutionArn(v string) *Solution {
	s.SolutionArn = &v
	return s
}

// SetSolutionConfig sets the SolutionConfig field's value.
func (s *Solution) SetSolutionConfig(v *SolutionConfig) *Solution {
	s.SolutionConfig = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Solution) SetStatus(v string) *Solution {
	s.Status = &v
	return s
}

// Describes the configuration properties for the solution.
type SolutionConfig struct {
	_ struct{} `type:"structure"`

	// Lists the algorithm hyperparameters and their values.
	AlgorithmHyperParameters map[string]*string `locationName:"algorithmHyperParameters" type:"map"`

	// The AutoMLConfig (https://docs.aws.amazon.com/personalize/latest/dg/API_AutoMLConfig.html)
	// object containing a list of recipes to search when AutoML is performed.
	AutoMLConfig *AutoMLConfig `locationName:"autoMLConfig" type:"structure"`

	// Only events with a value greater than or equal to this threshold are used
	// for training a model.
	EventValueThreshold *string `locationName:"eventValueThreshold" type:"string"`

	// Lists the feature transformation parameters.
	FeatureTransformationParameters map[string]*string `locationName:"featureTransformationParameters" type:"map"`

	// Describes the properties for hyperparameter optimization (HPO).
	HpoConfig *HPOConfig `locationName:"hpoConfig" type:"structure"`

	// Describes the additional objective for the solution, such as maximizing streaming
	// minutes or increasing revenue. For more information see Optimizing a solution
	// (https://docs.aws.amazon.com/personalize/latest/dg/optimizing-solution-for-objective.html).
	OptimizationObjective *OptimizationObjective `locationName:"optimizationObjective" type:"structure"`

	// Specifies the training data configuration to use when creating a custom solution
	// version (trained model).
	TrainingDataConfig *TrainingDataConfig `locationName:"trainingDataConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SolutionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SolutionConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SolutionConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SolutionConfig"}
	if s.HpoConfig != nil {
		if err := s.HpoConfig.Validate(); err != nil {
			invalidParams.AddNested("HpoConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OptimizationObjective != nil {
		if err := s.OptimizationObjective.Validate(); err != nil {
			invalidParams.AddNested("OptimizationObjective", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlgorithmHyperParameters sets the AlgorithmHyperParameters field's value.
func (s *SolutionConfig) SetAlgorithmHyperParameters(v map[string]*string) *SolutionConfig {
	s.AlgorithmHyperParameters = v
	return s
}

// SetAutoMLConfig sets the AutoMLConfig field's value.
func (s *SolutionConfig) SetAutoMLConfig(v *AutoMLConfig) *SolutionConfig {
	s.AutoMLConfig = v
	return s
}

// SetEventValueThreshold sets the EventValueThreshold field's value.
func (s *SolutionConfig) SetEventValueThreshold(v string) *SolutionConfig {
	s.EventValueThreshold = &v
	return s
}

// SetFeatureTransformationParameters sets the FeatureTransformationParameters field's value.
func (s *SolutionConfig) SetFeatureTransformationParameters(v map[string]*string) *SolutionConfig {
	s.FeatureTransformationParameters = v
	return s
}

// SetHpoConfig sets the HpoConfig field's value.
func (s *SolutionConfig) SetHpoConfig(v *HPOConfig) *SolutionConfig {
	s.HpoConfig = v
	return s
}

// SetOptimizationObjective sets the OptimizationObjective field's value.
func (s *SolutionConfig) SetOptimizationObjective(v *OptimizationObjective) *SolutionConfig {
	s.OptimizationObjective = v
	return s
}

// SetTrainingDataConfig sets the TrainingDataConfig field's value.
func (s *SolutionConfig) SetTrainingDataConfig(v *TrainingDataConfig) *SolutionConfig {
	s.TrainingDataConfig = v
	return s
}

// Provides a summary of the properties of a solution. For a complete listing,
// call the DescribeSolution (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html)
// API.
type SolutionSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that the solution was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The date and time (in Unix time) that the solution was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the solution.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the recipe used by the solution.
	RecipeArn *string `locationName:"recipeArn" type:"string"`

	// The Amazon Resource Name (ARN) of the solution.
	SolutionArn *string `locationName:"solutionArn" type:"string"`

	// The status of the solution.
	//
	// A solution can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//    * DELETE PENDING > DELETE IN_PROGRESS
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SolutionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SolutionSummary) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *SolutionSummary) SetCreationDateTime(v time.Time) *SolutionSummary {
	s.CreationDateTime = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *SolutionSummary) SetLastUpdatedDateTime(v time.Time) *SolutionSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *SolutionSummary) SetName(v string) *SolutionSummary {
	s.Name = &v
	return s
}

// SetRecipeArn sets the RecipeArn field's value.
func (s *SolutionSummary) SetRecipeArn(v string) *SolutionSummary {
	s.RecipeArn = &v
	return s
}

// SetSolutionArn sets the SolutionArn field's value.
func (s *SolutionSummary) SetSolutionArn(v string) *SolutionSummary {
	s.SolutionArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SolutionSummary) SetStatus(v string) *SolutionSummary {
	s.Status = &v
	return s
}

// An object that provides information about a specific version of a Solution
// (https://docs.aws.amazon.com/personalize/latest/dg/API_Solution.html) in
// a Custom dataset group.
type SolutionVersion struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that this version of the solution was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset group providing the training
	// data.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// The event type (for example, 'click' or 'like') that is used for training
	// the model.
	EventType *string `locationName:"eventType" type:"string"`

	// If training a solution version fails, the reason for the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The date and time (in Unix time) that the solution was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The name of the solution version.
	Name *string `locationName:"name" min:"1" type:"string"`

	// When true, Amazon Personalize searches for the most optimal recipe according
	// to the solution configuration. When false (the default), Amazon Personalize
	// uses recipeArn.
	PerformAutoML *bool `locationName:"performAutoML" type:"boolean"`

	// Whether to perform hyperparameter optimization (HPO) on the chosen recipe.
	// The default is false.
	PerformHPO *bool `locationName:"performHPO" type:"boolean"`

	// The ARN of the recipe used in the solution.
	RecipeArn *string `locationName:"recipeArn" type:"string"`

	// The ARN of the solution.
	SolutionArn *string `locationName:"solutionArn" type:"string"`

	// Describes the configuration properties for the solution.
	SolutionConfig *SolutionConfig `locationName:"solutionConfig" type:"structure"`

	// The ARN of the solution version.
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string"`

	// The status of the solution version.
	//
	// A solution version can be in one of the following states:
	//
	//    * CREATE PENDING
	//
	//    * CREATE IN_PROGRESS
	//
	//    * ACTIVE
	//
	//    * CREATE FAILED
	//
	//    * CREATE STOPPING
	//
	//    * CREATE STOPPED
	Status *string `locationName:"status" type:"string"`

	// The time used to train the model. You are billed for the time it takes to
	// train a model. This field is visible only after Amazon Personalize successfully
	// trains a model.
	TrainingHours *float64 `locationName:"trainingHours" type:"double"`

	// The scope of training to be performed when creating the solution version.
	// The FULL option trains the solution version based on the entirety of the
	// input solution's training data, while the UPDATE option processes only the
	// data that has changed in comparison to the input solution. Choose UPDATE
	// when you want to incrementally update your solution version instead of creating
	// an entirely new one.
	//
	// The UPDATE option can only be used when you already have an active solution
	// version created from the input solution using the FULL option and the input
	// solution was trained with the User-Personalization (https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html)
	// recipe or the HRNN-Coldstart (https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html)
	// recipe.
	TrainingMode *string `locationName:"trainingMode" type:"string" enum:"TrainingMode"`

	// If hyperparameter optimization was performed, contains the hyperparameter
	// values of the best performing model.
	TunedHPOParams *TunedHPOParams `locationName:"tunedHPOParams" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SolutionVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SolutionVersion) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *SolutionVersion) SetCreationDateTime(v time.Time) *SolutionVersion {
	s.CreationDateTime = &v
	return s
}

// SetDatasetGroupArn sets the DatasetGroupArn field's value.
func (s *SolutionVersion) SetDatasetGroupArn(v string) *SolutionVersion {
	s.DatasetGroupArn = &v
	return s
}

// SetEventType sets the EventType field's value.
func (s *SolutionVersion) SetEventType(v string) *SolutionVersion {
	s.EventType = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *SolutionVersion) SetFailureReason(v string) *SolutionVersion {
	s.FailureReason = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *SolutionVersion) SetLastUpdatedDateTime(v time.Time) *SolutionVersion {
	s.LastUpdatedDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *SolutionVersion) SetName(v string) *SolutionVersion {
	s.Name = &v
	return s
}

// SetPerformAutoML sets the PerformAutoML field's value.
func (s *SolutionVersion) SetPerformAutoML(v bool) *SolutionVersion {
	s.PerformAutoML = &v
	return s
}

// SetPerformHPO sets the PerformHPO field's value.
func (s *SolutionVersion) SetPerformHPO(v bool) *SolutionVersion {
	s.PerformHPO = &v
	return s
}

// SetRecipeArn sets the RecipeArn field's value.
func (s *SolutionVersion) SetRecipeArn(v string) *SolutionVersion {
	s.RecipeArn = &v
	return s
}

// SetSolutionArn sets the SolutionArn field's value.
func (s *SolutionVersion) SetSolutionArn(v string) *SolutionVersion {
	s.SolutionArn = &v
	return s
}

// SetSolutionConfig sets the SolutionConfig field's value.
func (s *SolutionVersion) SetSolutionConfig(v *SolutionConfig) *SolutionVersion {
	s.SolutionConfig = v
	return s
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *SolutionVersion) SetSolutionVersionArn(v string) *SolutionVersion {
	s.SolutionVersionArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SolutionVersion) SetStatus(v string) *SolutionVersion {
	s.Status = &v
	return s
}

// SetTrainingHours sets the TrainingHours field's value.
func (s *SolutionVersion) SetTrainingHours(v float64) *SolutionVersion {
	s.TrainingHours = &v
	return s
}

// SetTrainingMode sets the TrainingMode field's value.
func (s *SolutionVersion) SetTrainingMode(v string) *SolutionVersion {
	s.TrainingMode = &v
	return s
}

// SetTunedHPOParams sets the TunedHPOParams field's value.
func (s *SolutionVersion) SetTunedHPOParams(v *TunedHPOParams) *SolutionVersion {
	s.TunedHPOParams = v
	return s
}

// Provides a summary of the properties of a solution version. For a complete
// listing, call the DescribeSolutionVersion (https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html)
// API.
type SolutionVersionSummary struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) that this version of a solution was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// If a solution version fails, the reason behind the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The date and time (in Unix time) that the solution version was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the solution version.
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string"`

	// The status of the solution version.
	//
	// A solution version can be in one of the following states:
	//
	//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SolutionVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SolutionVersionSummary) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *SolutionVersionSummary) SetCreationDateTime(v time.Time) *SolutionVersionSummary {
	s.CreationDateTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *SolutionVersionSummary) SetFailureReason(v string) *SolutionVersionSummary {
	s.FailureReason = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *SolutionVersionSummary) SetLastUpdatedDateTime(v time.Time) *SolutionVersionSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *SolutionVersionSummary) SetSolutionVersionArn(v string) *SolutionVersionSummary {
	s.SolutionVersionArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SolutionVersionSummary) SetStatus(v string) *SolutionVersionSummary {
	s.Status = &v
	return s
}

type StartRecommenderInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the recommender to start.
	//
	// RecommenderArn is a required field
	RecommenderArn *string `locationName:"recommenderArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRecommenderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRecommenderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartRecommenderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartRecommenderInput"}
	if s.RecommenderArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RecommenderArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecommenderArn sets the RecommenderArn field's value.
func (s *StartRecommenderInput) SetRecommenderArn(v string) *StartRecommenderInput {
	s.RecommenderArn = &v
	return s
}

type StartRecommenderOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the recommender you started.
	RecommenderArn *string `locationName:"recommenderArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRecommenderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRecommenderOutput) GoString() string {
	return s.String()
}

// SetRecommenderArn sets the RecommenderArn field's value.
func (s *StartRecommenderOutput) SetRecommenderArn(v string) *StartRecommenderOutput {
	s.RecommenderArn = &v
	return s
}

type StopRecommenderInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the recommender to stop.
	//
	// RecommenderArn is a required field
	RecommenderArn *string `locationName:"recommenderArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopRecommenderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopRecommenderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopRecommenderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopRecommenderInput"}
	if s.RecommenderArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RecommenderArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecommenderArn sets the RecommenderArn field's value.
func (s *StopRecommenderInput) SetRecommenderArn(v string) *StopRecommenderInput {
	s.RecommenderArn = &v
	return s
}

type StopRecommenderOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the recommender you stopped.
	RecommenderArn *string `locationName:"recommenderArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopRecommenderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopRecommenderOutput) GoString() string {
	return s.String()
}

// SetRecommenderArn sets the RecommenderArn field's value.
func (s *StopRecommenderOutput) SetRecommenderArn(v string) *StopRecommenderOutput {
	s.RecommenderArn = &v
	return s
}

type StopSolutionVersionCreationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the solution version you want to stop creating.
	//
	// SolutionVersionArn is a required field
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopSolutionVersionCreationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopSolutionVersionCreationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopSolutionVersionCreationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopSolutionVersionCreationInput"}
	if s.SolutionVersionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SolutionVersionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *StopSolutionVersionCreationInput) SetSolutionVersionArn(v string) *StopSolutionVersionCreationInput {
	s.SolutionVersionArn = &v
	return s
}

type StopSolutionVersionCreationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopSolutionVersionCreationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopSolutionVersionCreationOutput) GoString() string {
	return s.String()
}

// The optional metadata that you apply to resources to help you categorize
// and organize them. Each tag consists of a key and an optional value, both
// of which you define. For more information see Tagging Amazon Personalize
// recources (https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html).
type Tag struct {
	_ struct{} `type:"structure"`

	// One part of a key-value pair that makes up a tag. A key is a general label
	// that acts like a category for more specific tag values.
	//
	// TagKey is a required field
	TagKey *string `locationName:"tagKey" min:"1" type:"string" required:"true"`

	// The optional part of a key-value pair that makes up a tag. A value acts as
	// a descriptor within a tag category (key).
	//
	// TagValue is a required field
	TagValue *string `locationName:"tagValue" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.TagKey == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKey"))
	}
	if s.TagKey != nil && len(*s.TagKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKey", 1))
	}
	if s.TagValue == nil {
		invalidParams.Add(request.NewErrParamRequired("TagValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTagKey sets the TagKey field's value.
func (s *Tag) SetTagKey(v string) *Tag {
	s.TagKey = &v
	return s
}

// SetTagValue sets the TagValue field's value.
func (s *Tag) SetTagValue(v string) *Tag {
	s.TagValue = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource's Amazon Resource Name (ARN).
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`

	// Tags to apply to the resource. For more information see Tagging Amazon Personalize
	// recources (https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html).
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The configuration details for generating themes with a batch inference job.
type ThemeGenerationConfig struct {
	_ struct{} `type:"structure"`

	// Fields used to generate descriptive themes for a batch inference job.
	//
	// FieldsForThemeGeneration is a required field
	FieldsForThemeGeneration *FieldsForThemeGeneration `locationName:"fieldsForThemeGeneration" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThemeGenerationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThemeGenerationConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ThemeGenerationConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ThemeGenerationConfig"}
	if s.FieldsForThemeGeneration == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldsForThemeGeneration"))
	}
	if s.FieldsForThemeGeneration != nil {
		if err := s.FieldsForThemeGeneration.Validate(); err != nil {
			invalidParams.AddNested("FieldsForThemeGeneration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFieldsForThemeGeneration sets the FieldsForThemeGeneration field's value.
func (s *ThemeGenerationConfig) SetFieldsForThemeGeneration(v *FieldsForThemeGeneration) *ThemeGenerationConfig {
	s.FieldsForThemeGeneration = v
	return s
}

// The request contains more tag keys than can be associated with a resource
// (50 tag keys per resource).
type TooManyTagKeysException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagKeysException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagKeysException) GoString() string {
	return s.String()
}

func newErrorTooManyTagKeysException(v protocol.ResponseMetadata) error {
	return &TooManyTagKeysException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagKeysException) Code() string {
	return "TooManyTagKeysException"
}

// Message returns the exception's message.
func (s *TooManyTagKeysException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagKeysException) OrigErr() error {
	return nil
}

func (s *TooManyTagKeysException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagKeysException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagKeysException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have exceeded the maximum number of tags you can apply to this resource.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The training data configuration to use when creating a domain recommender
// or custom solution version (trained model).
type TrainingDataConfig struct {
	_ struct{} `type:"structure"`

	// Specifies the columns to exclude from training. Each key is a dataset type,
	// and each value is a list of columns. Exclude columns to control what data
	// Amazon Personalize uses to generate recommendations. For example, you might
	// have a column that you want to use only to filter recommendations. You can
	// exclude this column from training and Amazon Personalize considers it only
	// when filtering.
	ExcludedDatasetColumns map[string][]*string `locationName:"excludedDatasetColumns" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrainingDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrainingDataConfig) GoString() string {
	return s.String()
}

// SetExcludedDatasetColumns sets the ExcludedDatasetColumns field's value.
func (s *TrainingDataConfig) SetExcludedDatasetColumns(v map[string][]*string) *TrainingDataConfig {
	s.ExcludedDatasetColumns = v
	return s
}

// If hyperparameter optimization (HPO) was performed, contains the hyperparameter
// values of the best performing model.
type TunedHPOParams struct {
	_ struct{} `type:"structure"`

	// A list of the hyperparameter values of the best performing model.
	AlgorithmHyperParameters map[string]*string `locationName:"algorithmHyperParameters" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TunedHPOParams) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TunedHPOParams) GoString() string {
	return s.String()
}

// SetAlgorithmHyperParameters sets the AlgorithmHyperParameters field's value.
func (s *TunedHPOParams) SetAlgorithmHyperParameters(v map[string]*string) *TunedHPOParams {
	s.AlgorithmHyperParameters = v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource's Amazon Resource Name (ARN).
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`

	// Keys to remove from the resource's tags.
	//
	// TagKeys is a required field
	TagKeys []*string `locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateCampaignInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the campaign.
	//
	// CampaignArn is a required field
	CampaignArn *string `locationName:"campaignArn" type:"string" required:"true"`

	// The configuration details of a campaign.
	CampaignConfig *CampaignConfig `locationName:"campaignConfig" type:"structure"`

	// Specifies the requested minimum provisioned transactions (recommendations)
	// per second that Amazon Personalize will support. A high minProvisionedTPS
	// will increase your bill. We recommend starting with 1 for minProvisionedTPS
	// (the default). Track your usage using Amazon CloudWatch metrics, and increase
	// the minProvisionedTPS as necessary.
	MinProvisionedTPS *int64 `locationName:"minProvisionedTPS" min:"1" type:"integer"`

	// The ARN of a new solution version to deploy.
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCampaignInput"}
	if s.CampaignArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignArn"))
	}
	if s.MinProvisionedTPS != nil && *s.MinProvisionedTPS < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinProvisionedTPS", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCampaignArn sets the CampaignArn field's value.
func (s *UpdateCampaignInput) SetCampaignArn(v string) *UpdateCampaignInput {
	s.CampaignArn = &v
	return s
}

// SetCampaignConfig sets the CampaignConfig field's value.
func (s *UpdateCampaignInput) SetCampaignConfig(v *CampaignConfig) *UpdateCampaignInput {
	s.CampaignConfig = v
	return s
}

// SetMinProvisionedTPS sets the MinProvisionedTPS field's value.
func (s *UpdateCampaignInput) SetMinProvisionedTPS(v int64) *UpdateCampaignInput {
	s.MinProvisionedTPS = &v
	return s
}

// SetSolutionVersionArn sets the SolutionVersionArn field's value.
func (s *UpdateCampaignInput) SetSolutionVersionArn(v string) *UpdateCampaignInput {
	s.SolutionVersionArn = &v
	return s
}

type UpdateCampaignOutput struct {
	_ struct{} `type:"structure"`

	// The same campaign ARN as given in the request.
	CampaignArn *string `locationName:"campaignArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCampaignOutput) GoString() string {
	return s.String()
}

// SetCampaignArn sets the CampaignArn field's value.
func (s *UpdateCampaignOutput) SetCampaignArn(v string) *UpdateCampaignOutput {
	s.CampaignArn = &v
	return s
}

type UpdateDatasetInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset that you want to update.
	//
	// DatasetArn is a required field
	DatasetArn *string `locationName:"datasetArn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the new schema you want use.
	//
	// SchemaArn is a required field
	SchemaArn *string `locationName:"schemaArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDatasetInput"}
	if s.DatasetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetArn"))
	}
	if s.SchemaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *UpdateDatasetInput) SetDatasetArn(v string) *UpdateDatasetInput {
	s.DatasetArn = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *UpdateDatasetInput) SetSchemaArn(v string) *UpdateDatasetInput {
	s.SchemaArn = &v
	return s
}

type UpdateDatasetOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset you updated.
	DatasetArn *string `locationName:"datasetArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatasetOutput) GoString() string {
	return s.String()
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *UpdateDatasetOutput) SetDatasetArn(v string) *UpdateDatasetOutput {
	s.DatasetArn = &v
	return s
}

type UpdateMetricAttributionInput struct {
	_ struct{} `type:"structure"`

	// Add new metric attributes to the metric attribution.
	AddMetrics []*MetricAttribute `locationName:"addMetrics" type:"list"`

	// The Amazon Resource Name (ARN) for the metric attribution to update.
	MetricAttributionArn *string `locationName:"metricAttributionArn" type:"string"`

	// An output config for the metric attribution.
	MetricsOutputConfig *MetricAttributionOutput_ `locationName:"metricsOutputConfig" type:"structure"`

	// Remove metric attributes from the metric attribution.
	RemoveMetrics []*string `locationName:"removeMetrics" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMetricAttributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMetricAttributionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMetricAttributionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMetricAttributionInput"}
	if s.AddMetrics != nil {
		for i, v := range s.AddMetrics {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AddMetrics", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MetricsOutputConfig != nil {
		if err := s.MetricsOutputConfig.Validate(); err != nil {
			invalidParams.AddNested("MetricsOutputConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddMetrics sets the AddMetrics field's value.
func (s *UpdateMetricAttributionInput) SetAddMetrics(v []*MetricAttribute) *UpdateMetricAttributionInput {
	s.AddMetrics = v
	return s
}

// SetMetricAttributionArn sets the MetricAttributionArn field's value.
func (s *UpdateMetricAttributionInput) SetMetricAttributionArn(v string) *UpdateMetricAttributionInput {
	s.MetricAttributionArn = &v
	return s
}

// SetMetricsOutputConfig sets the MetricsOutputConfig field's value.
func (s *UpdateMetricAttributionInput) SetMetricsOutputConfig(v *MetricAttributionOutput_) *UpdateMetricAttributionInput {
	s.MetricsOutputConfig = v
	return s
}

// SetRemoveMetrics sets the RemoveMetrics field's value.
func (s *UpdateMetricAttributionInput) SetRemoveMetrics(v []*string) *UpdateMetricAttributionInput {
	s.RemoveMetrics = v
	return s
}

type UpdateMetricAttributionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the metric attribution that you updated.
	MetricAttributionArn *string `locationName:"metricAttributionArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMetricAttributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMetricAttributionOutput) GoString() string {
	return s.String()
}

// SetMetricAttributionArn sets the MetricAttributionArn field's value.
func (s *UpdateMetricAttributionOutput) SetMetricAttributionArn(v string) *UpdateMetricAttributionOutput {
	s.MetricAttributionArn = &v
	return s
}

type UpdateRecommenderInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the recommender to modify.
	//
	// RecommenderArn is a required field
	RecommenderArn *string `locationName:"recommenderArn" type:"string" required:"true"`

	// The configuration details of the recommender.
	//
	// RecommenderConfig is a required field
	RecommenderConfig *RecommenderConfig `locationName:"recommenderConfig" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecommenderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecommenderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRecommenderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRecommenderInput"}
	if s.RecommenderArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RecommenderArn"))
	}
	if s.RecommenderConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("RecommenderConfig"))
	}
	if s.RecommenderConfig != nil {
		if err := s.RecommenderConfig.Validate(); err != nil {
			invalidParams.AddNested("RecommenderConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecommenderArn sets the RecommenderArn field's value.
func (s *UpdateRecommenderInput) SetRecommenderArn(v string) *UpdateRecommenderInput {
	s.RecommenderArn = &v
	return s
}

// SetRecommenderConfig sets the RecommenderConfig field's value.
func (s *UpdateRecommenderInput) SetRecommenderConfig(v *RecommenderConfig) *UpdateRecommenderInput {
	s.RecommenderConfig = v
	return s
}

type UpdateRecommenderOutput struct {
	_ struct{} `type:"structure"`

	// The same recommender Amazon Resource Name (ARN) as given in the request.
	RecommenderArn *string `locationName:"recommenderArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecommenderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecommenderOutput) GoString() string {
	return s.String()
}

// SetRecommenderArn sets the RecommenderArn field's value.
func (s *UpdateRecommenderOutput) SetRecommenderArn(v string) *UpdateRecommenderOutput {
	s.RecommenderArn = &v
	return s
}

const (
	// BatchInferenceJobModeBatchInference is a BatchInferenceJobMode enum value
	BatchInferenceJobModeBatchInference = "BATCH_INFERENCE"

	// BatchInferenceJobModeThemeGeneration is a BatchInferenceJobMode enum value
	BatchInferenceJobModeThemeGeneration = "THEME_GENERATION"
)

// BatchInferenceJobMode_Values returns all elements of the BatchInferenceJobMode enum
func BatchInferenceJobMode_Values() []string {
	return []string{
		BatchInferenceJobModeBatchInference,
		BatchInferenceJobModeThemeGeneration,
	}
}

const (
	// DomainEcommerce is a Domain enum value
	DomainEcommerce = "ECOMMERCE"

	// DomainVideoOnDemand is a Domain enum value
	DomainVideoOnDemand = "VIDEO_ON_DEMAND"
)

// Domain_Values returns all elements of the Domain enum
func Domain_Values() []string {
	return []string{
		DomainEcommerce,
		DomainVideoOnDemand,
	}
}

const (
	// ImportModeFull is a ImportMode enum value
	ImportModeFull = "FULL"

	// ImportModeIncremental is a ImportMode enum value
	ImportModeIncremental = "INCREMENTAL"
)

// ImportMode_Values returns all elements of the ImportMode enum
func ImportMode_Values() []string {
	return []string{
		ImportModeFull,
		ImportModeIncremental,
	}
}

const (
	// IngestionModeBulk is a IngestionMode enum value
	IngestionModeBulk = "BULK"

	// IngestionModePut is a IngestionMode enum value
	IngestionModePut = "PUT"

	// IngestionModeAll is a IngestionMode enum value
	IngestionModeAll = "ALL"
)

// IngestionMode_Values returns all elements of the IngestionMode enum
func IngestionMode_Values() []string {
	return []string{
		IngestionModeBulk,
		IngestionModePut,
		IngestionModeAll,
	}
}

const (
	// ObjectiveSensitivityLow is a ObjectiveSensitivity enum value
	ObjectiveSensitivityLow = "LOW"

	// ObjectiveSensitivityMedium is a ObjectiveSensitivity enum value
	ObjectiveSensitivityMedium = "MEDIUM"

	// ObjectiveSensitivityHigh is a ObjectiveSensitivity enum value
	ObjectiveSensitivityHigh = "HIGH"

	// ObjectiveSensitivityOff is a ObjectiveSensitivity enum value
	ObjectiveSensitivityOff = "OFF"
)

// ObjectiveSensitivity_Values returns all elements of the ObjectiveSensitivity enum
func ObjectiveSensitivity_Values() []string {
	return []string{
		ObjectiveSensitivityLow,
		ObjectiveSensitivityMedium,
		ObjectiveSensitivityHigh,
		ObjectiveSensitivityOff,
	}
}

const (
	// RecipeProviderService is a RecipeProvider enum value
	RecipeProviderService = "SERVICE"
)

// RecipeProvider_Values returns all elements of the RecipeProvider enum
func RecipeProvider_Values() []string {
	return []string{
		RecipeProviderService,
	}
}

const (
	// TrainingModeFull is a TrainingMode enum value
	TrainingModeFull = "FULL"

	// TrainingModeUpdate is a TrainingMode enum value
	TrainingModeUpdate = "UPDATE"
)

// TrainingMode_Values returns all elements of the TrainingMode enum
func TrainingMode_Values() []string {
	return []string{
		TrainingModeFull,
		TrainingModeUpdate,
	}
}
