// Code generated by 'ccgo -o speedtest1/main_windows_386.go -trace-translation-units testdata/sqlite-src-3330000/test/speedtest1.c -Itestdata/sqlite-amalgamation-3330000 -l modernc.org/sqlite/lib -DNDEBUG -DHAVE_USLEEP -DLONGDOUBLE_TYPE=double -DSQLITE_CORE -DSQLITE_ENABLE_COLUMN_METADATA -DSQLITE_ENABLE_FTS5 -DSQLITE_ENABLE_GEOPOLY -DSQLITE_ENABLE_JSON1 -DSQLITE_ENABLE_MEMORY_MANAGEMENT -DSQLITE_ENABLE_OFFSET_SQL_FUNC -DSQLITE_ENABLE_PREUPDATE_HOOK -DSQLITE_ENABLE_RBU -DSQLITE_ENABLE_RTREE -DSQLITE_ENABLE_SNAPSHOT -DSQLITE_ENABLE_STAT4 -DSQLITE_ENABLE_UNLOCK_NOTIFY -DSQLITE_LIKE_DOESNT_MATCH_BLOBS -DSQLITE_MUTEX_APPDEF=1 -DSQLITE_MUTEX_NOOP -DSQLITE_SOUNDEX -DSQLITE_THREADSAFE=1 -DSQLITE_OS_WIN=1 -D_MSC_VER=1900', DO NOT EDIT.

package main

import (
	"math"
	"reflect"
	"sync/atomic"
	"unsafe"

	"modernc.org/libc"
	"modernc.org/sqlite/lib"
)

var _ = math.Pi
var _ reflect.Kind
var _ atomic.Value
var _ unsafe.Pointer

func main() { libc.Start(main1) }

type ptrdiff_t = int32 /* <builtin>:3:26 */

type size_t = uint32 /* <builtin>:9:23 */

type wchar_t = uint16 /* <builtin>:15:24 */

type va_list = uintptr /* <builtin>:51:27 */

// A program for performance testing.
//
// The available command-line options are described below:
var zHelp = *(*[2146]int8)(unsafe.Pointer(ts /* "Usage: %s [--opt..." */)) /* speedtest1.c:6:19 */

// CAPI3REF: 64-Bit Integer Types
// KEYWORDS: sqlite_int64 sqlite_uint64
//
// Because there is no cross-platform way to specify 64-bit integer types
// SQLite includes typedefs for 64-bit signed and unsigned integers.
//
// The sqlite3_int64 and sqlite3_uint64 are the preferred type definitions.
// The sqlite_int64 and sqlite_uint64 types are supported for backwards
// compatibility only.
//
// ^The sqlite3_int64 and sqlite_int64 types can store integer values
// between -9223372036854775808 and +9223372036854775807 inclusive.  ^The
// sqlite3_uint64 and sqlite_uint64 types can store integer values
// between 0 and +18446744073709551615 inclusive.
type sqlite_int64 = int64           /* sqlite3.h:275:19 */
type sqlite_uint64 = uint64         /* sqlite3.h:276:28 */
type sqlite3_int64 = sqlite_int64   /* sqlite3.h:281:22 */
type sqlite3_uint64 = sqlite_uint64 /* sqlite3.h:282:23 */

// The type for a callback function.
// This is legacy and deprecated.  It is included for historical
// compatibility and is not documented.
type sqlite3_callback = uintptr /* sqlite3.h:338:13 */

// CAPI3REF: Result Codes
// KEYWORDS: {result code definitions}
//
// Many SQLite functions return an integer result code from the set shown
// here in order to indicate success or failure.
//
// New error codes may be added in future versions of SQLite.
//
// See also: [extended result code definitions]
// beginning-of-error-codes
// end-of-error-codes

// CAPI3REF: Extended Result Codes
// KEYWORDS: {extended result code definitions}
//
// In its default configuration, SQLite API routines return one of 30 integer
// [result codes].  However, experience has shown that many of
// these result codes are too coarse-grained.  They do not provide as
// much information about problems as programmers might like.  In an effort to
// address this, newer versions of SQLite (version 3.3.8 [dateof:3.3.8]
// and later) include
// support for additional result codes that provide more detailed information
// about errors. These [extended result codes] are enabled or disabled
// on a per database connection basis using the
// [sqlite3_extended_result_codes()] API.  Or, the extended code for
// the most recent error can be obtained using
// [sqlite3_extended_errcode()].

// CAPI3REF: Flags For File Open Operations
//
// These bit values are intended for use in the
// 3rd parameter to the [sqlite3_open_v2()] interface and
// in the 4th parameter to the [sqlite3_vfs.xOpen] method.

// Reserved:                         0x00F00000
// Legacy compatibility:

// CAPI3REF: Device Characteristics
//
// The xDeviceCharacteristics method of the [sqlite3_io_methods]
// object returns an integer which is a vector of these
// bit values expressing I/O characteristics of the mass storage
// device that holds the file that the [sqlite3_io_methods]
// refers to.
//
// The SQLITE_IOCAP_ATOMIC property means that all writes of
// any size are atomic.  The SQLITE_IOCAP_ATOMICnnn values
// mean that writes of blocks that are nnn bytes in size and
// are aligned to an address which is an integer multiple of
// nnn are atomic.  The SQLITE_IOCAP_SAFE_APPEND value means
// that when data is appended to a file, the data is appended
// first then the size of the file is extended, never the other
// way around.  The SQLITE_IOCAP_SEQUENTIAL property means that
// information is written to disk in the same order as calls
// to xWrite().  The SQLITE_IOCAP_POWERSAFE_OVERWRITE property means that
// after reboot following a crash or power loss, the only bytes in a
// file that were written at the application level might have changed
// and that adjacent bytes, even bytes within the same sector are
// guaranteed to be unchanged.  The SQLITE_IOCAP_UNDELETABLE_WHEN_OPEN
// flag indicates that a file cannot be deleted when open.  The
// SQLITE_IOCAP_IMMUTABLE flag indicates that the file is on
// read-only media and cannot be changed even by processes with
// elevated privileges.
//
// The SQLITE_IOCAP_BATCH_ATOMIC property means that the underlying
// filesystem supports doing multiple write operations atomically when those
// write operations are bracketed by [SQLITE_FCNTL_BEGIN_ATOMIC_WRITE] and
// [SQLITE_FCNTL_COMMIT_ATOMIC_WRITE].

// CAPI3REF: File Locking Levels
//
// SQLite uses one of these integer values as the second
// argument to calls it makes to the xLock() and xUnlock() methods
// of an [sqlite3_io_methods] object.

// CAPI3REF: Synchronization Type Flags
//
// When SQLite invokes the xSync() method of an
// [sqlite3_io_methods] object it uses a combination of
// these integer values as the second argument.
//
// When the SQLITE_SYNC_DATAONLY flag is used, it means that the
// sync operation only needs to flush data to mass storage.  Inode
// information need not be flushed. If the lower four bits of the flag
// equal SQLITE_SYNC_NORMAL, that means to use normal fsync() semantics.
// If the lower four bits equal SQLITE_SYNC_FULL, that means
// to use Mac OS X style fullsync instead of fsync().
//
// Do not confuse the SQLITE_SYNC_NORMAL and SQLITE_SYNC_FULL flags
// with the [PRAGMA synchronous]=NORMAL and [PRAGMA synchronous]=FULL
// settings.  The [synchronous pragma] determines when calls to the
// xSync VFS method occur and applies uniformly across all platforms.
// The SQLITE_SYNC_NORMAL and SQLITE_SYNC_FULL flags determine how
// energetic or rigorous or forceful the sync operations are and
// only make a difference on Mac OSX for the default SQLite code.
// (Third-party VFS implementations might also make the distinction
// between SQLITE_SYNC_NORMAL and SQLITE_SYNC_FULL, but among the
// operating systems natively supported by SQLite, only Mac OSX
// cares about the difference.)

// CAPI3REF: OS Interface Open File Handle
//
// An [sqlite3_file] object represents an open file in the
// [sqlite3_vfs | OS interface layer].  Individual OS interface
// implementations will
// want to subclass this object by appending additional fields
// for their own use.  The pMethods entry is a pointer to an
// [sqlite3_io_methods] object that defines methods for performing
// I/O operations on the open file.
type sqlite3_file1 = struct{ pMethods uintptr } /* sqlite3.h:683:9 */

// CAPI3REF: Result Codes
// KEYWORDS: {result code definitions}
//
// Many SQLite functions return an integer result code from the set shown
// here in order to indicate success or failure.
//
// New error codes may be added in future versions of SQLite.
//
// See also: [extended result code definitions]
// beginning-of-error-codes
// end-of-error-codes

// CAPI3REF: Extended Result Codes
// KEYWORDS: {extended result code definitions}
//
// In its default configuration, SQLite API routines return one of 30 integer
// [result codes].  However, experience has shown that many of
// these result codes are too coarse-grained.  They do not provide as
// much information about problems as programmers might like.  In an effort to
// address this, newer versions of SQLite (version 3.3.8 [dateof:3.3.8]
// and later) include
// support for additional result codes that provide more detailed information
// about errors. These [extended result codes] are enabled or disabled
// on a per database connection basis using the
// [sqlite3_extended_result_codes()] API.  Or, the extended code for
// the most recent error can be obtained using
// [sqlite3_extended_errcode()].

// CAPI3REF: Flags For File Open Operations
//
// These bit values are intended for use in the
// 3rd parameter to the [sqlite3_open_v2()] interface and
// in the 4th parameter to the [sqlite3_vfs.xOpen] method.

// Reserved:                         0x00F00000
// Legacy compatibility:

// CAPI3REF: Device Characteristics
//
// The xDeviceCharacteristics method of the [sqlite3_io_methods]
// object returns an integer which is a vector of these
// bit values expressing I/O characteristics of the mass storage
// device that holds the file that the [sqlite3_io_methods]
// refers to.
//
// The SQLITE_IOCAP_ATOMIC property means that all writes of
// any size are atomic.  The SQLITE_IOCAP_ATOMICnnn values
// mean that writes of blocks that are nnn bytes in size and
// are aligned to an address which is an integer multiple of
// nnn are atomic.  The SQLITE_IOCAP_SAFE_APPEND value means
// that when data is appended to a file, the data is appended
// first then the size of the file is extended, never the other
// way around.  The SQLITE_IOCAP_SEQUENTIAL property means that
// information is written to disk in the same order as calls
// to xWrite().  The SQLITE_IOCAP_POWERSAFE_OVERWRITE property means that
// after reboot following a crash or power loss, the only bytes in a
// file that were written at the application level might have changed
// and that adjacent bytes, even bytes within the same sector are
// guaranteed to be unchanged.  The SQLITE_IOCAP_UNDELETABLE_WHEN_OPEN
// flag indicates that a file cannot be deleted when open.  The
// SQLITE_IOCAP_IMMUTABLE flag indicates that the file is on
// read-only media and cannot be changed even by processes with
// elevated privileges.
//
// The SQLITE_IOCAP_BATCH_ATOMIC property means that the underlying
// filesystem supports doing multiple write operations atomically when those
// write operations are bracketed by [SQLITE_FCNTL_BEGIN_ATOMIC_WRITE] and
// [SQLITE_FCNTL_COMMIT_ATOMIC_WRITE].

// CAPI3REF: File Locking Levels
//
// SQLite uses one of these integer values as the second
// argument to calls it makes to the xLock() and xUnlock() methods
// of an [sqlite3_io_methods] object.

// CAPI3REF: Synchronization Type Flags
//
// When SQLite invokes the xSync() method of an
// [sqlite3_io_methods] object it uses a combination of
// these integer values as the second argument.
//
// When the SQLITE_SYNC_DATAONLY flag is used, it means that the
// sync operation only needs to flush data to mass storage.  Inode
// information need not be flushed. If the lower four bits of the flag
// equal SQLITE_SYNC_NORMAL, that means to use normal fsync() semantics.
// If the lower four bits equal SQLITE_SYNC_FULL, that means
// to use Mac OS X style fullsync instead of fsync().
//
// Do not confuse the SQLITE_SYNC_NORMAL and SQLITE_SYNC_FULL flags
// with the [PRAGMA synchronous]=NORMAL and [PRAGMA synchronous]=FULL
// settings.  The [synchronous pragma] determines when calls to the
// xSync VFS method occur and applies uniformly across all platforms.
// The SQLITE_SYNC_NORMAL and SQLITE_SYNC_FULL flags determine how
// energetic or rigorous or forceful the sync operations are and
// only make a difference on Mac OSX for the default SQLite code.
// (Third-party VFS implementations might also make the distinction
// between SQLITE_SYNC_NORMAL and SQLITE_SYNC_FULL, but among the
// operating systems natively supported by SQLite, only Mac OSX
// cares about the difference.)

// CAPI3REF: OS Interface Open File Handle
//
// An [sqlite3_file] object represents an open file in the
// [sqlite3_vfs | OS interface layer].  Individual OS interface
// implementations will
// want to subclass this object by appending additional fields
// for their own use.  The pMethods entry is a pointer to an
// [sqlite3_io_methods] object that defines methods for performing
// I/O operations on the open file.
type sqlite3_file = sqlite3_file1 /* sqlite3.h:683:29 */
type sqlite3_io_methods1 = struct {
	iVersion               int32
	xClose                 uintptr
	xRead                  uintptr
	xWrite                 uintptr
	xTruncate              uintptr
	xSync                  uintptr
	xFileSize              uintptr
	xLock                  uintptr
	xUnlock                uintptr
	xCheckReservedLock     uintptr
	xFileControl           uintptr
	xSectorSize            uintptr
	xDeviceCharacteristics uintptr
	xShmMap                uintptr
	xShmLock               uintptr
	xShmBarrier            uintptr
	xShmUnmap              uintptr
	xFetch                 uintptr
	xUnfetch               uintptr
} /* sqlite3.h:683:9 */

// CAPI3REF: OS Interface File Virtual Methods Object
//
// Every file opened by the [sqlite3_vfs.xOpen] method populates an
// [sqlite3_file] object (or, more commonly, a subclass of the
// [sqlite3_file] object) with a pointer to an instance of this object.
// This object defines the methods used to perform various operations
// against the open file represented by the [sqlite3_file] object.
//
// If the [sqlite3_vfs.xOpen] method sets the sqlite3_file.pMethods element
// to a non-NULL pointer, then the sqlite3_io_methods.xClose method
// may be invoked even if the [sqlite3_vfs.xOpen] reported that it failed.  The
// only way to prevent a call to xClose following a failed [sqlite3_vfs.xOpen]
// is for the [sqlite3_vfs.xOpen] to set the sqlite3_file.pMethods element
// to NULL.
//
// The flags argument to xSync may be one of [SQLITE_SYNC_NORMAL] or
// [SQLITE_SYNC_FULL].  The first choice is the normal fsync().
// The second choice is a Mac OS X style fullsync.  The [SQLITE_SYNC_DATAONLY]
// flag may be ORed in to indicate that only the data of the file
// and not its inode needs to be synced.
//
// The integer values to xLock() and xUnlock() are one of
// <ul>
// <li> [SQLITE_LOCK_NONE],
// <li> [SQLITE_LOCK_SHARED],
// <li> [SQLITE_LOCK_RESERVED],
// <li> [SQLITE_LOCK_PENDING], or
// <li> [SQLITE_LOCK_EXCLUSIVE].
// </ul>
// xLock() increases the lock. xUnlock() decreases the lock.
// The xCheckReservedLock() method checks whether any database connection,
// either in this process or in some other process, is holding a RESERVED,
// PENDING, or EXCLUSIVE lock on the file.  It returns true
// if such a lock exists and false otherwise.
//
// The xFileControl() method is a generic interface that allows custom
// VFS implementations to directly control an open file using the
// [sqlite3_file_control()] interface.  The second "op" argument is an
// integer opcode.  The third argument is a generic pointer intended to
// point to a structure that may contain arguments or space in which to
// write return values.  Potential uses for xFileControl() might be
// functions to enable blocking locks with timeouts, to change the
// locking strategy (for example to use dot-file locks), to inquire
// about the status of a lock, or to break stale locks.  The SQLite
// core reserves all opcodes less than 100 for its own use.
// A [file control opcodes | list of opcodes] less than 100 is available.
// Applications that define a custom xFileControl method should use opcodes
// greater than 100 to avoid conflicts.  VFS implementations should
// return [SQLITE_NOTFOUND] for file control opcodes that they do not
// recognize.
//
// The xSectorSize() method returns the sector size of the
// device that underlies the file.  The sector size is the
// minimum write that can be performed without disturbing
// other bytes in the file.  The xDeviceCharacteristics()
// method returns a bit vector describing behaviors of the
// underlying device:
//
// <ul>
// <li> [SQLITE_IOCAP_ATOMIC]
// <li> [SQLITE_IOCAP_ATOMIC512]
// <li> [SQLITE_IOCAP_ATOMIC1K]
// <li> [SQLITE_IOCAP_ATOMIC2K]
// <li> [SQLITE_IOCAP_ATOMIC4K]
// <li> [SQLITE_IOCAP_ATOMIC8K]
// <li> [SQLITE_IOCAP_ATOMIC16K]
// <li> [SQLITE_IOCAP_ATOMIC32K]
// <li> [SQLITE_IOCAP_ATOMIC64K]
// <li> [SQLITE_IOCAP_SAFE_APPEND]
// <li> [SQLITE_IOCAP_SEQUENTIAL]
// <li> [SQLITE_IOCAP_UNDELETABLE_WHEN_OPEN]
// <li> [SQLITE_IOCAP_POWERSAFE_OVERWRITE]
// <li> [SQLITE_IOCAP_IMMUTABLE]
// <li> [SQLITE_IOCAP_BATCH_ATOMIC]
// </ul>
//
// The SQLITE_IOCAP_ATOMIC property means that all writes of
// any size are atomic.  The SQLITE_IOCAP_ATOMICnnn values
// mean that writes of blocks that are nnn bytes in size and
// are aligned to an address which is an integer multiple of
// nnn are atomic.  The SQLITE_IOCAP_SAFE_APPEND value means
// that when data is appended to a file, the data is appended
// first then the size of the file is extended, never the other
// way around.  The SQLITE_IOCAP_SEQUENTIAL property means that
// information is written to disk in the same order as calls
// to xWrite().
//
// If xRead() returns SQLITE_IOERR_SHORT_READ it must also fill
// in the unread portions of the buffer with zeros.  A VFS that
// fails to zero-fill short reads might seem to work.  However,
// failure to zero-fill short reads will eventually lead to
// database corruption.
type sqlite3_io_methods = sqlite3_io_methods1 /* sqlite3.h:782:35 */

// CAPI3REF: OS Interface Object
//
// An instance of the sqlite3_vfs object defines the interface between
// the SQLite core and the underlying operating system.  The "vfs"
// in the name of the object stands for "virtual file system".  See
// the [VFS | VFS documentation] for further information.
//
// The VFS interface is sometimes extended by adding new methods onto
// the end.  Each time such an extension occurs, the iVersion field
// is incremented.  The iVersion value started out as 1 in
// SQLite [version 3.5.0] on [dateof:3.5.0], then increased to 2
// with SQLite [version 3.7.0] on [dateof:3.7.0], and then increased
// to 3 with SQLite [version 3.7.6] on [dateof:3.7.6].  Additional fields
// may be appended to the sqlite3_vfs object and the iVersion value
// may increase again in future versions of SQLite.
// Note that due to an oversight, the structure
// of the sqlite3_vfs object changed in the transition from
// SQLite [version 3.5.9] to [version 3.6.0] on [dateof:3.6.0]
// and yet the iVersion field was not increased.
//
// The szOsFile field is the size of the subclassed [sqlite3_file]
// structure used by this VFS.  mxPathname is the maximum length of
// a pathname in this VFS.
//
// Registered sqlite3_vfs objects are kept on a linked list formed by
// the pNext pointer.  The [sqlite3_vfs_register()]
// and [sqlite3_vfs_unregister()] interfaces manage this list
// in a thread-safe way.  The [sqlite3_vfs_find()] interface
// searches the list.  Neither the application code nor the VFS
// implementation should use the pNext pointer.
//
// The pNext field is the only field in the sqlite3_vfs
// structure that SQLite will ever modify.  SQLite will only access
// or modify this field while holding a particular static mutex.
// The application should never modify anything within the sqlite3_vfs
// object once the object has been registered.
//
// The zName field holds the name of the VFS module.  The name must
// be unique across all VFS modules.
//
// [[sqlite3_vfs.xOpen]]
// ^SQLite guarantees that the zFilename parameter to xOpen
// is either a NULL pointer or string obtained
// from xFullPathname() with an optional suffix added.
// ^If a suffix is added to the zFilename parameter, it will
// consist of a single "-" character followed by no more than
// 11 alphanumeric and/or "-" characters.
// ^SQLite further guarantees that
// the string will be valid and unchanged until xClose() is
// called. Because of the previous sentence,
// the [sqlite3_file] can safely store a pointer to the
// filename if it needs to remember the filename for some reason.
// If the zFilename parameter to xOpen is a NULL pointer then xOpen
// must invent its own temporary name for the file.  ^Whenever the
// xFilename parameter is NULL it will also be the case that the
// flags parameter will include [SQLITE_OPEN_DELETEONCLOSE].
//
// The flags argument to xOpen() includes all bits set in
// the flags argument to [sqlite3_open_v2()].  Or if [sqlite3_open()]
// or [sqlite3_open16()] is used, then flags includes at least
// [SQLITE_OPEN_READWRITE] | [SQLITE_OPEN_CREATE].
// If xOpen() opens a file read-only then it sets *pOutFlags to
// include [SQLITE_OPEN_READONLY].  Other bits in *pOutFlags may be set.
//
// ^(SQLite will also add one of the following flags to the xOpen()
// call, depending on the object being opened:
//
// <ul>
// <li>  [SQLITE_OPEN_MAIN_DB]
// <li>  [SQLITE_OPEN_MAIN_JOURNAL]
// <li>  [SQLITE_OPEN_TEMP_DB]
// <li>  [SQLITE_OPEN_TEMP_JOURNAL]
// <li>  [SQLITE_OPEN_TRANSIENT_DB]
// <li>  [SQLITE_OPEN_SUBJOURNAL]
// <li>  [SQLITE_OPEN_SUPER_JOURNAL]
// <li>  [SQLITE_OPEN_WAL]
// </ul>)^
//
// The file I/O implementation can use the object type flags to
// change the way it deals with files.  For example, an application
// that does not care about crash recovery or rollback might make
// the open of a journal file a no-op.  Writes to this journal would
// also be no-ops, and any attempt to read the journal would return
// SQLITE_IOERR.  Or the implementation might recognize that a database
// file will be doing page-aligned sector reads and writes in a random
// order and set up its I/O subsystem accordingly.
//
// SQLite might also add one of the following flags to the xOpen method:
//
// <ul>
// <li> [SQLITE_OPEN_DELETEONCLOSE]
// <li> [SQLITE_OPEN_EXCLUSIVE]
// </ul>
//
// The [SQLITE_OPEN_DELETEONCLOSE] flag means the file should be
// deleted when it is closed.  ^The [SQLITE_OPEN_DELETEONCLOSE]
// will be set for TEMP databases and their journals, transient
// databases, and subjournals.
//
// ^The [SQLITE_OPEN_EXCLUSIVE] flag is always used in conjunction
// with the [SQLITE_OPEN_CREATE] flag, which are both directly
// analogous to the O_EXCL and O_CREAT flags of the POSIX open()
// API.  The SQLITE_OPEN_EXCLUSIVE flag, when paired with the
// SQLITE_OPEN_CREATE, is used to indicate that file should always
// be created, and that it is an error if it already exists.
// It is <i>not</i> used to indicate the file should be opened
// for exclusive access.
//
// ^At least szOsFile bytes of memory are allocated by SQLite
// to hold the [sqlite3_file] structure passed as the third
// argument to xOpen.  The xOpen method does not have to
// allocate the structure; it should just fill it in.  Note that
// the xOpen method must set the sqlite3_file.pMethods to either
// a valid [sqlite3_io_methods] object or to NULL.  xOpen must do
// this even if the open fails.  SQLite expects that the sqlite3_file.pMethods
// element will be valid after xOpen returns regardless of the success
// or failure of the xOpen call.
//
// [[sqlite3_vfs.xAccess]]
// ^The flags argument to xAccess() may be [SQLITE_ACCESS_EXISTS]
// to test for the existence of a file, or [SQLITE_ACCESS_READWRITE] to
// test whether a file is readable and writable, or [SQLITE_ACCESS_READ]
// to test whether a file is at least readable.  The SQLITE_ACCESS_READ
// flag is never actually used and is not implemented in the built-in
// VFSes of SQLite.  The file is named by the second argument and can be a
// directory. The xAccess method returns [SQLITE_OK] on success or some
// non-zero error code if there is an I/O error or if the name of
// the file given in the second argument is illegal.  If SQLITE_OK
// is returned, then non-zero or zero is written into *pResOut to indicate
// whether or not the file is accessible.
//
// ^SQLite will always allocate at least mxPathname+1 bytes for the
// output buffer xFullPathname.  The exact size of the output buffer
// is also passed as a parameter to both  methods. If the output buffer
// is not large enough, [SQLITE_CANTOPEN] should be returned. Since this is
// handled as a fatal error by SQLite, vfs implementations should endeavor
// to prevent this by setting mxPathname to a sufficiently large value.
//
// The xRandomness(), xSleep(), xCurrentTime(), and xCurrentTimeInt64()
// interfaces are not strictly a part of the filesystem, but they are
// included in the VFS structure for completeness.
// The xRandomness() function attempts to return nBytes bytes
// of good-quality randomness into zOut.  The return value is
// the actual number of bytes of randomness obtained.
// The xSleep() method causes the calling thread to sleep for at
// least the number of microseconds given.  ^The xCurrentTime()
// method returns a Julian Day Number for the current date and time as
// a floating point value.
// ^The xCurrentTimeInt64() method returns, as an integer, the Julian
// Day Number multiplied by 86400000 (the number of milliseconds in
// a 24-hour day).
// ^SQLite will use the xCurrentTimeInt64() method to get the current
// date and time if that method is available (if iVersion is 2 or
// greater and the function pointer is not NULL) and will fall back
// to xCurrentTime() if xCurrentTimeInt64() is unavailable.
//
// ^The xSetSystemCall(), xGetSystemCall(), and xNestSystemCall() interfaces
// are not used by the SQLite core.  These optional interfaces are provided
// by some VFSes to facilitate testing of the VFS code. By overriding
// system calls with functions under its control, a test program can
// simulate faults and error conditions that would otherwise be difficult
// or impossible to induce.  The set of system calls that can be overridden
// varies from one VFS to another, and from one version of the same VFS to the
// next.  Applications that use these interfaces must be prepared for any
// or all of these interfaces to be NULL or for their behavior to change
// from one release to the next.  Applications must not attempt to access
// any of these methods if the iVersion of the VFS is less than 3.
type sqlite3_vfs1 = struct {
	iVersion          int32
	szOsFile          int32
	mxPathname        int32
	pNext             uintptr
	zName             uintptr
	pAppData          uintptr
	xOpen             uintptr
	xDelete           uintptr
	xAccess           uintptr
	xFullPathname     uintptr
	xDlOpen           uintptr
	xDlError          uintptr
	xDlSym            uintptr
	xDlClose          uintptr
	xRandomness       uintptr
	xSleep            uintptr
	xCurrentTime      uintptr
	xGetLastError     uintptr
	xCurrentTimeInt64 uintptr
	xSetSystemCall    uintptr
	xGetSystemCall    uintptr
	xNextSystemCall   uintptr
} /* sqlite3.h:1367:9 */

// CAPI3REF: OS Interface Object
//
// An instance of the sqlite3_vfs object defines the interface between
// the SQLite core and the underlying operating system.  The "vfs"
// in the name of the object stands for "virtual file system".  See
// the [VFS | VFS documentation] for further information.
//
// The VFS interface is sometimes extended by adding new methods onto
// the end.  Each time such an extension occurs, the iVersion field
// is incremented.  The iVersion value started out as 1 in
// SQLite [version 3.5.0] on [dateof:3.5.0], then increased to 2
// with SQLite [version 3.7.0] on [dateof:3.7.0], and then increased
// to 3 with SQLite [version 3.7.6] on [dateof:3.7.6].  Additional fields
// may be appended to the sqlite3_vfs object and the iVersion value
// may increase again in future versions of SQLite.
// Note that due to an oversight, the structure
// of the sqlite3_vfs object changed in the transition from
// SQLite [version 3.5.9] to [version 3.6.0] on [dateof:3.6.0]
// and yet the iVersion field was not increased.
//
// The szOsFile field is the size of the subclassed [sqlite3_file]
// structure used by this VFS.  mxPathname is the maximum length of
// a pathname in this VFS.
//
// Registered sqlite3_vfs objects are kept on a linked list formed by
// the pNext pointer.  The [sqlite3_vfs_register()]
// and [sqlite3_vfs_unregister()] interfaces manage this list
// in a thread-safe way.  The [sqlite3_vfs_find()] interface
// searches the list.  Neither the application code nor the VFS
// implementation should use the pNext pointer.
//
// The pNext field is the only field in the sqlite3_vfs
// structure that SQLite will ever modify.  SQLite will only access
// or modify this field while holding a particular static mutex.
// The application should never modify anything within the sqlite3_vfs
// object once the object has been registered.
//
// The zName field holds the name of the VFS module.  The name must
// be unique across all VFS modules.
//
// [[sqlite3_vfs.xOpen]]
// ^SQLite guarantees that the zFilename parameter to xOpen
// is either a NULL pointer or string obtained
// from xFullPathname() with an optional suffix added.
// ^If a suffix is added to the zFilename parameter, it will
// consist of a single "-" character followed by no more than
// 11 alphanumeric and/or "-" characters.
// ^SQLite further guarantees that
// the string will be valid and unchanged until xClose() is
// called. Because of the previous sentence,
// the [sqlite3_file] can safely store a pointer to the
// filename if it needs to remember the filename for some reason.
// If the zFilename parameter to xOpen is a NULL pointer then xOpen
// must invent its own temporary name for the file.  ^Whenever the
// xFilename parameter is NULL it will also be the case that the
// flags parameter will include [SQLITE_OPEN_DELETEONCLOSE].
//
// The flags argument to xOpen() includes all bits set in
// the flags argument to [sqlite3_open_v2()].  Or if [sqlite3_open()]
// or [sqlite3_open16()] is used, then flags includes at least
// [SQLITE_OPEN_READWRITE] | [SQLITE_OPEN_CREATE].
// If xOpen() opens a file read-only then it sets *pOutFlags to
// include [SQLITE_OPEN_READONLY].  Other bits in *pOutFlags may be set.
//
// ^(SQLite will also add one of the following flags to the xOpen()
// call, depending on the object being opened:
//
// <ul>
// <li>  [SQLITE_OPEN_MAIN_DB]
// <li>  [SQLITE_OPEN_MAIN_JOURNAL]
// <li>  [SQLITE_OPEN_TEMP_DB]
// <li>  [SQLITE_OPEN_TEMP_JOURNAL]
// <li>  [SQLITE_OPEN_TRANSIENT_DB]
// <li>  [SQLITE_OPEN_SUBJOURNAL]
// <li>  [SQLITE_OPEN_SUPER_JOURNAL]
// <li>  [SQLITE_OPEN_WAL]
// </ul>)^
//
// The file I/O implementation can use the object type flags to
// change the way it deals with files.  For example, an application
// that does not care about crash recovery or rollback might make
// the open of a journal file a no-op.  Writes to this journal would
// also be no-ops, and any attempt to read the journal would return
// SQLITE_IOERR.  Or the implementation might recognize that a database
// file will be doing page-aligned sector reads and writes in a random
// order and set up its I/O subsystem accordingly.
//
// SQLite might also add one of the following flags to the xOpen method:
//
// <ul>
// <li> [SQLITE_OPEN_DELETEONCLOSE]
// <li> [SQLITE_OPEN_EXCLUSIVE]
// </ul>
//
// The [SQLITE_OPEN_DELETEONCLOSE] flag means the file should be
// deleted when it is closed.  ^The [SQLITE_OPEN_DELETEONCLOSE]
// will be set for TEMP databases and their journals, transient
// databases, and subjournals.
//
// ^The [SQLITE_OPEN_EXCLUSIVE] flag is always used in conjunction
// with the [SQLITE_OPEN_CREATE] flag, which are both directly
// analogous to the O_EXCL and O_CREAT flags of the POSIX open()
// API.  The SQLITE_OPEN_EXCLUSIVE flag, when paired with the
// SQLITE_OPEN_CREATE, is used to indicate that file should always
// be created, and that it is an error if it already exists.
// It is <i>not</i> used to indicate the file should be opened
// for exclusive access.
//
// ^At least szOsFile bytes of memory are allocated by SQLite
// to hold the [sqlite3_file] structure passed as the third
// argument to xOpen.  The xOpen method does not have to
// allocate the structure; it should just fill it in.  Note that
// the xOpen method must set the sqlite3_file.pMethods to either
// a valid [sqlite3_io_methods] object or to NULL.  xOpen must do
// this even if the open fails.  SQLite expects that the sqlite3_file.pMethods
// element will be valid after xOpen returns regardless of the success
// or failure of the xOpen call.
//
// [[sqlite3_vfs.xAccess]]
// ^The flags argument to xAccess() may be [SQLITE_ACCESS_EXISTS]
// to test for the existence of a file, or [SQLITE_ACCESS_READWRITE] to
// test whether a file is readable and writable, or [SQLITE_ACCESS_READ]
// to test whether a file is at least readable.  The SQLITE_ACCESS_READ
// flag is never actually used and is not implemented in the built-in
// VFSes of SQLite.  The file is named by the second argument and can be a
// directory. The xAccess method returns [SQLITE_OK] on success or some
// non-zero error code if there is an I/O error or if the name of
// the file given in the second argument is illegal.  If SQLITE_OK
// is returned, then non-zero or zero is written into *pResOut to indicate
// whether or not the file is accessible.
//
// ^SQLite will always allocate at least mxPathname+1 bytes for the
// output buffer xFullPathname.  The exact size of the output buffer
// is also passed as a parameter to both  methods. If the output buffer
// is not large enough, [SQLITE_CANTOPEN] should be returned. Since this is
// handled as a fatal error by SQLite, vfs implementations should endeavor
// to prevent this by setting mxPathname to a sufficiently large value.
//
// The xRandomness(), xSleep(), xCurrentTime(), and xCurrentTimeInt64()
// interfaces are not strictly a part of the filesystem, but they are
// included in the VFS structure for completeness.
// The xRandomness() function attempts to return nBytes bytes
// of good-quality randomness into zOut.  The return value is
// the actual number of bytes of randomness obtained.
// The xSleep() method causes the calling thread to sleep for at
// least the number of microseconds given.  ^The xCurrentTime()
// method returns a Julian Day Number for the current date and time as
// a floating point value.
// ^The xCurrentTimeInt64() method returns, as an integer, the Julian
// Day Number multiplied by 86400000 (the number of milliseconds in
// a 24-hour day).
// ^SQLite will use the xCurrentTimeInt64() method to get the current
// date and time if that method is available (if iVersion is 2 or
// greater and the function pointer is not NULL) and will fall back
// to xCurrentTime() if xCurrentTimeInt64() is unavailable.
//
// ^The xSetSystemCall(), xGetSystemCall(), and xNestSystemCall() interfaces
// are not used by the SQLite core.  These optional interfaces are provided
// by some VFSes to facilitate testing of the VFS code. By overriding
// system calls with functions under its control, a test program can
// simulate faults and error conditions that would otherwise be difficult
// or impossible to induce.  The set of system calls that can be overridden
// varies from one VFS to another, and from one version of the same VFS to the
// next.  Applications that use these interfaces must be prepared for any
// or all of these interfaces to be NULL or for their behavior to change
// from one release to the next.  Applications must not attempt to access
// any of these methods if the iVersion of the VFS is less than 3.
type sqlite3_vfs = sqlite3_vfs1    /* sqlite3.h:1367:28 */
type sqlite3_syscall_ptr = uintptr /* sqlite3.h:1368:14 */

// CAPI3REF: Memory Allocation Routines
//
// An instance of this object defines the interface between SQLite
// and low-level memory allocation routines.
//
// This object is used in only one place in the SQLite interface.
// A pointer to an instance of this object is the argument to
// [sqlite3_config()] when the configuration option is
// [SQLITE_CONFIG_MALLOC] or [SQLITE_CONFIG_GETMALLOC].
// By creating an instance of this object
// and passing it to [sqlite3_config]([SQLITE_CONFIG_MALLOC])
// during configuration, an application can specify an alternative
// memory allocation subsystem for SQLite to use for all of its
// dynamic memory needs.
//
// Note that SQLite comes with several [built-in memory allocators]
// that are perfectly adequate for the overwhelming majority of applications
// and that this object is only useful to a tiny minority of applications
// with specialized memory allocation requirements.  This object is
// also used during testing of SQLite in order to specify an alternative
// memory allocator that simulates memory out-of-memory conditions in
// order to verify that SQLite recovers gracefully from such
// conditions.
//
// The xMalloc, xRealloc, and xFree methods must work like the
// malloc(), realloc() and free() functions from the standard C library.
// ^SQLite guarantees that the second argument to
// xRealloc is always a value returned by a prior call to xRoundup.
//
// xSize should return the allocated size of a memory allocation
// previously obtained from xMalloc or xRealloc.  The allocated size
// is always at least as big as the requested size but may be larger.
//
// The xRoundup method returns what would be the allocated size of
// a memory allocation given a particular requested size.  Most memory
// allocators round up memory allocations at least to the next multiple
// of 8.  Some allocators round up to a larger multiple or to a power of 2.
// Every memory allocation request coming in through [sqlite3_malloc()]
// or [sqlite3_realloc()] first calls xRoundup.  If xRoundup returns 0,
// that causes the corresponding memory allocation to fail.
//
// The xInit method initializes the memory allocator.  For example,
// it might allocate any required mutexes or initialize internal data
// structures.  The xShutdown method is invoked (indirectly) by
// [sqlite3_shutdown()] and should deallocate any resources acquired
// by xInit.  The pAppData pointer is used as the only parameter to
// xInit and xShutdown.
//
// SQLite holds the [SQLITE_MUTEX_STATIC_MAIN] mutex when it invokes
// the xInit method, so the xInit method need not be threadsafe.  The
// xShutdown method is only called from [sqlite3_shutdown()] so it does
// not need to be threadsafe either.  For all other methods, SQLite
// holds the [SQLITE_MUTEX_STATIC_MEM] mutex as long as the
// [SQLITE_CONFIG_MEMSTATUS] configuration option is turned on (which
// it is by default) and so the methods are automatically serialized.
// However, if [SQLITE_CONFIG_MEMSTATUS] is disabled, then the other
// methods must be threadsafe or else make their own arrangements for
// serialization.
//
// SQLite will never invoke xInit() more than once without an intervening
// call to xShutdown().
type sqlite3_mem_methods1 = struct {
	xMalloc   uintptr
	xFree     uintptr
	xRealloc  uintptr
	xSize     uintptr
	xRoundup  uintptr
	xInit     uintptr
	xShutdown uintptr
	pAppData  uintptr
} /* sqlite3.h:1665:9 */

// CAPI3REF: Memory Allocation Routines
//
// An instance of this object defines the interface between SQLite
// and low-level memory allocation routines.
//
// This object is used in only one place in the SQLite interface.
// A pointer to an instance of this object is the argument to
// [sqlite3_config()] when the configuration option is
// [SQLITE_CONFIG_MALLOC] or [SQLITE_CONFIG_GETMALLOC].
// By creating an instance of this object
// and passing it to [sqlite3_config]([SQLITE_CONFIG_MALLOC])
// during configuration, an application can specify an alternative
// memory allocation subsystem for SQLite to use for all of its
// dynamic memory needs.
//
// Note that SQLite comes with several [built-in memory allocators]
// that are perfectly adequate for the overwhelming majority of applications
// and that this object is only useful to a tiny minority of applications
// with specialized memory allocation requirements.  This object is
// also used during testing of SQLite in order to specify an alternative
// memory allocator that simulates memory out-of-memory conditions in
// order to verify that SQLite recovers gracefully from such
// conditions.
//
// The xMalloc, xRealloc, and xFree methods must work like the
// malloc(), realloc() and free() functions from the standard C library.
// ^SQLite guarantees that the second argument to
// xRealloc is always a value returned by a prior call to xRoundup.
//
// xSize should return the allocated size of a memory allocation
// previously obtained from xMalloc or xRealloc.  The allocated size
// is always at least as big as the requested size but may be larger.
//
// The xRoundup method returns what would be the allocated size of
// a memory allocation given a particular requested size.  Most memory
// allocators round up memory allocations at least to the next multiple
// of 8.  Some allocators round up to a larger multiple or to a power of 2.
// Every memory allocation request coming in through [sqlite3_malloc()]
// or [sqlite3_realloc()] first calls xRoundup.  If xRoundup returns 0,
// that causes the corresponding memory allocation to fail.
//
// The xInit method initializes the memory allocator.  For example,
// it might allocate any required mutexes or initialize internal data
// structures.  The xShutdown method is invoked (indirectly) by
// [sqlite3_shutdown()] and should deallocate any resources acquired
// by xInit.  The pAppData pointer is used as the only parameter to
// xInit and xShutdown.
//
// SQLite holds the [SQLITE_MUTEX_STATIC_MAIN] mutex when it invokes
// the xInit method, so the xInit method need not be threadsafe.  The
// xShutdown method is only called from [sqlite3_shutdown()] so it does
// not need to be threadsafe either.  For all other methods, SQLite
// holds the [SQLITE_MUTEX_STATIC_MEM] mutex as long as the
// [SQLITE_CONFIG_MEMSTATUS] configuration option is turned on (which
// it is by default) and so the methods are automatically serialized.
// However, if [SQLITE_CONFIG_MEMSTATUS] is disabled, then the other
// methods must be threadsafe or else make their own arrangements for
// serialization.
//
// SQLite will never invoke xInit() more than once without an intervening
// call to xShutdown().
type sqlite3_mem_methods = sqlite3_mem_methods1 /* sqlite3.h:1665:36 */

// CAPI3REF: Constants Defining Special Destructor Behavior
//
// These are special values for the destructor that is passed in as the
// final argument to routines like [sqlite3_result_blob()].  ^If the destructor
// argument is SQLITE_STATIC, it means that the content pointer is constant
// and will never change.  It does not need to be destroyed.  ^The
// SQLITE_TRANSIENT value means that the content will likely change in
// the near future and that SQLite should make its own private copy of
// the content before returning.
//
// The typedef is necessary to work around problems in certain
// C++ compilers.
type sqlite3_destructor_type = uintptr /* sqlite3.h:5621:14 */

// The interface to the virtual-table mechanism is currently considered
// to be experimental.  The interface might change in incompatible ways.
// If this is a problem for you, do not use the interface at this time.
//
// When the virtual-table mechanism stabilizes, we will declare the
// interface fixed, support it indefinitely, and remove this comment.

// Structures used by the virtual table interface
type sqlite3_vtab1 = struct {
	pModule uintptr
	nRef    int32
	zErrMsg uintptr
} /* sqlite3.h:6689:9 */

// The interface to the virtual-table mechanism is currently considered
// to be experimental.  The interface might change in incompatible ways.
// If this is a problem for you, do not use the interface at this time.
//
// When the virtual-table mechanism stabilizes, we will declare the
// interface fixed, support it indefinitely, and remove this comment.

// Structures used by the virtual table interface
type sqlite3_vtab = sqlite3_vtab1 /* sqlite3.h:6689:29 */
type sqlite3_index_info1 = struct {
	nConstraint      int32
	aConstraint      uintptr
	nOrderBy         int32
	aOrderBy         uintptr
	aConstraintUsage uintptr
	idxNum           int32
	idxStr           uintptr
	needToFreeIdxStr int32
	orderByConsumed  int32
	_                [4]byte
	estimatedCost    float64
	estimatedRows    sqlite3_int64
	idxFlags         int32
	_                [4]byte
	colUsed          sqlite3_uint64
} /* sqlite3.h:6690:9 */

type sqlite3_index_info = sqlite3_index_info1       /* sqlite3.h:6690:35 */
type sqlite3_vtab_cursor1 = struct{ pVtab uintptr } /* sqlite3.h:6691:9 */

type sqlite3_vtab_cursor = sqlite3_vtab_cursor1 /* sqlite3.h:6691:36 */
type sqlite3_module1 = struct {
	iVersion      int32
	xCreate       uintptr
	xConnect      uintptr
	xBestIndex    uintptr
	xDisconnect   uintptr
	xDestroy      uintptr
	xOpen         uintptr
	xClose        uintptr
	xFilter       uintptr
	xNext         uintptr
	xEof          uintptr
	xColumn       uintptr
	xRowid        uintptr
	xUpdate       uintptr
	xBegin        uintptr
	xSync         uintptr
	xCommit       uintptr
	xRollback     uintptr
	xFindFunction uintptr
	xRename       uintptr
	xSavepoint    uintptr
	xRelease      uintptr
	xRollbackTo   uintptr
	xShadowName   uintptr
} /* sqlite3.h:6689:9 */

type sqlite3_module = sqlite3_module1 /* sqlite3.h:6692:31 */

// CAPI3REF: Virtual Table Indexing Information
// KEYWORDS: sqlite3_index_info
//
// The sqlite3_index_info structure and its substructures is used as part
// of the [virtual table] interface to
// pass information into and receive the reply from the [xBestIndex]
// method of a [virtual table module].  The fields under **Inputs** are the
// inputs to xBestIndex and are read-only.  xBestIndex inserts its
// results into the **Outputs** fields.
//
// ^(The aConstraint[] array records WHERE clause constraints of the form:
//
// <blockquote>column OP expr</blockquote>
//
// where OP is =, &lt;, &lt;=, &gt;, or &gt;=.)^  ^(The particular operator is
// stored in aConstraint[].op using one of the
// [SQLITE_INDEX_CONSTRAINT_EQ | SQLITE_INDEX_CONSTRAINT_ values].)^
// ^(The index of the column is stored in
// aConstraint[].iColumn.)^  ^(aConstraint[].usable is TRUE if the
// expr on the right-hand side can be evaluated (and thus the constraint
// is usable) and false if it cannot.)^
//
// ^The optimizer automatically inverts terms of the form "expr OP column"
// and makes other simplifications to the WHERE clause in an attempt to
// get as many WHERE clause terms into the form shown above as possible.
// ^The aConstraint[] array only reports WHERE clause terms that are
// relevant to the particular virtual table being queried.
//
// ^Information about the ORDER BY clause is stored in aOrderBy[].
// ^Each term of aOrderBy records a column of the ORDER BY clause.
//
// The colUsed field indicates which columns of the virtual table may be
// required by the current scan. Virtual table columns are numbered from
// zero in the order in which they appear within the CREATE TABLE statement
// passed to sqlite3_declare_vtab(). For the first 63 columns (columns 0-62),
// the corresponding bit is set within the colUsed mask if the column may be
// required by SQLite. If the table has at least 64 columns and any column
// to the right of the first 63 is required, then bit 63 of colUsed is also
// set. In other words, column iCol may be required if the expression
// (colUsed & ((sqlite3_uint64)1 << (iCol>=63 ? 63 : iCol))) evaluates to
// non-zero.
//
// The [xBestIndex] method must fill aConstraintUsage[] with information
// about what parameters to pass to xFilter.  ^If argvIndex>0 then
// the right-hand side of the corresponding aConstraint[] is evaluated
// and becomes the argvIndex-th entry in argv.  ^(If aConstraintUsage[].omit
// is true, then the constraint is assumed to be fully handled by the
// virtual table and might not be checked again by the byte code.)^ ^(The
// aConstraintUsage[].omit flag is an optimization hint. When the omit flag
// is left in its default setting of false, the constraint will always be
// checked separately in byte code.  If the omit flag is change to true, then
// the constraint may or may not be checked in byte code.  In other words,
// when the omit flag is true there is no guarantee that the constraint will
// not be checked again using byte code.)^
//
// ^The idxNum and idxPtr values are recorded and passed into the
// [xFilter] method.
// ^[sqlite3_free()] is used to free idxPtr if and only if
// needToFreeIdxPtr is true.
//
// ^The orderByConsumed means that output from [xFilter]/[xNext] will occur in
// the correct order to satisfy the ORDER BY clause so that no separate
// sorting step is required.
//
// ^The estimatedCost value is an estimate of the cost of a particular
// strategy. A cost of N indicates that the cost of the strategy is similar
// to a linear scan of an SQLite table with N rows. A cost of log(N)
// indicates that the expense of the operation is similar to that of a
// binary search on a unique indexed field of an SQLite table with N rows.
//
// ^The estimatedRows value is an estimate of the number of rows that
// will be returned by the strategy.
//
// The xBestIndex method may optionally populate the idxFlags field with a
// mask of SQLITE_INDEX_SCAN_* flags. Currently there is only one such flag -
// SQLITE_INDEX_SCAN_UNIQUE. If the xBestIndex method sets this flag, SQLite
// assumes that the strategy may visit at most one row.
//
// Additionally, if xBestIndex sets the SQLITE_INDEX_SCAN_UNIQUE flag, then
// SQLite also assumes that if a call to the xUpdate() method is made as
// part of the same statement to delete or update a virtual table row and the
// implementation returns SQLITE_CONSTRAINT, then there is no need to rollback
// any database changes. In other words, if the xUpdate() returns
// SQLITE_CONSTRAINT, the database contents must be exactly as they were
// before xUpdate was called. By contrast, if SQLITE_INDEX_SCAN_UNIQUE is not
// set and xUpdate returns SQLITE_CONSTRAINT, any database changes made by
// the xUpdate method are automatically rolled back by SQLite.
//
// IMPORTANT: The estimatedRows field was added to the sqlite3_index_info
// structure for SQLite [version 3.8.2] ([dateof:3.8.2]).
// If a virtual table extension is
// used with an SQLite version earlier than 3.8.2, the results of attempting
// to read or write the estimatedRows field are undefined (but are likely
// to include crashing the application). The estimatedRows field should
// therefore only be used if [sqlite3_libversion_number()] returns a
// value greater than or equal to 3008002. Similarly, the idxFlags field
// was added for [version 3.9.0] ([dateof:3.9.0]).
// It may therefore only be used if
// sqlite3_libversion_number() returns a value greater than or equal to
// 3009000.
type sqlite3_index_constraint = struct {
	iColumn     int32
	op          uint8
	usable      uint8
	_           [2]byte
	iTermOffset int32
} /* sqlite3.h:6690:9 */

// CAPI3REF: Virtual Table Indexing Information
// KEYWORDS: sqlite3_index_info
//
// The sqlite3_index_info structure and its substructures is used as part
// of the [virtual table] interface to
// pass information into and receive the reply from the [xBestIndex]
// method of a [virtual table module].  The fields under **Inputs** are the
// inputs to xBestIndex and are read-only.  xBestIndex inserts its
// results into the **Outputs** fields.
//
// ^(The aConstraint[] array records WHERE clause constraints of the form:
//
// <blockquote>column OP expr</blockquote>
//
// where OP is =, &lt;, &lt;=, &gt;, or &gt;=.)^  ^(The particular operator is
// stored in aConstraint[].op using one of the
// [SQLITE_INDEX_CONSTRAINT_EQ | SQLITE_INDEX_CONSTRAINT_ values].)^
// ^(The index of the column is stored in
// aConstraint[].iColumn.)^  ^(aConstraint[].usable is TRUE if the
// expr on the right-hand side can be evaluated (and thus the constraint
// is usable) and false if it cannot.)^
//
// ^The optimizer automatically inverts terms of the form "expr OP column"
// and makes other simplifications to the WHERE clause in an attempt to
// get as many WHERE clause terms into the form shown above as possible.
// ^The aConstraint[] array only reports WHERE clause terms that are
// relevant to the particular virtual table being queried.
//
// ^Information about the ORDER BY clause is stored in aOrderBy[].
// ^Each term of aOrderBy records a column of the ORDER BY clause.
//
// The colUsed field indicates which columns of the virtual table may be
// required by the current scan. Virtual table columns are numbered from
// zero in the order in which they appear within the CREATE TABLE statement
// passed to sqlite3_declare_vtab(). For the first 63 columns (columns 0-62),
// the corresponding bit is set within the colUsed mask if the column may be
// required by SQLite. If the table has at least 64 columns and any column
// to the right of the first 63 is required, then bit 63 of colUsed is also
// set. In other words, column iCol may be required if the expression
// (colUsed & ((sqlite3_uint64)1 << (iCol>=63 ? 63 : iCol))) evaluates to
// non-zero.
//
// The [xBestIndex] method must fill aConstraintUsage[] with information
// about what parameters to pass to xFilter.  ^If argvIndex>0 then
// the right-hand side of the corresponding aConstraint[] is evaluated
// and becomes the argvIndex-th entry in argv.  ^(If aConstraintUsage[].omit
// is true, then the constraint is assumed to be fully handled by the
// virtual table and might not be checked again by the byte code.)^ ^(The
// aConstraintUsage[].omit flag is an optimization hint. When the omit flag
// is left in its default setting of false, the constraint will always be
// checked separately in byte code.  If the omit flag is change to true, then
// the constraint may or may not be checked in byte code.  In other words,
// when the omit flag is true there is no guarantee that the constraint will
// not be checked again using byte code.)^
//
// ^The idxNum and idxPtr values are recorded and passed into the
// [xFilter] method.
// ^[sqlite3_free()] is used to free idxPtr if and only if
// needToFreeIdxPtr is true.
//
// ^The orderByConsumed means that output from [xFilter]/[xNext] will occur in
// the correct order to satisfy the ORDER BY clause so that no separate
// sorting step is required.
//
// ^The estimatedCost value is an estimate of the cost of a particular
// strategy. A cost of N indicates that the cost of the strategy is similar
// to a linear scan of an SQLite table with N rows. A cost of log(N)
// indicates that the expense of the operation is similar to that of a
// binary search on a unique indexed field of an SQLite table with N rows.
//
// ^The estimatedRows value is an estimate of the number of rows that
// will be returned by the strategy.
//
// The xBestIndex method may optionally populate the idxFlags field with a
// mask of SQLITE_INDEX_SCAN_* flags. Currently there is only one such flag -
// SQLITE_INDEX_SCAN_UNIQUE. If the xBestIndex method sets this flag, SQLite
// assumes that the strategy may visit at most one row.
//
// Additionally, if xBestIndex sets the SQLITE_INDEX_SCAN_UNIQUE flag, then
// SQLite also assumes that if a call to the xUpdate() method is made as
// part of the same statement to delete or update a virtual table row and the
// implementation returns SQLITE_CONSTRAINT, then there is no need to rollback
// any database changes. In other words, if the xUpdate() returns
// SQLITE_CONSTRAINT, the database contents must be exactly as they were
// before xUpdate was called. By contrast, if SQLITE_INDEX_SCAN_UNIQUE is not
// set and xUpdate returns SQLITE_CONSTRAINT, any database changes made by
// the xUpdate method are automatically rolled back by SQLite.
//
// IMPORTANT: The estimatedRows field was added to the sqlite3_index_info
// structure for SQLite [version 3.8.2] ([dateof:3.8.2]).
// If a virtual table extension is
// used with an SQLite version earlier than 3.8.2, the results of attempting
// to read or write the estimatedRows field are undefined (but are likely
// to include crashing the application). The estimatedRows field should
// therefore only be used if [sqlite3_libversion_number()] returns a
// value greater than or equal to 3008002. Similarly, the idxFlags field
// was added for [version 3.9.0] ([dateof:3.9.0]).
// It may therefore only be used if
// sqlite3_libversion_number() returns a value greater than or equal to
// 3009000.
type sqlite3_index_orderby = struct {
	iColumn int32
	desc    uint8
	_       [3]byte
} /* sqlite3.h:6690:9 */

// CAPI3REF: Virtual Table Indexing Information
// KEYWORDS: sqlite3_index_info
//
// The sqlite3_index_info structure and its substructures is used as part
// of the [virtual table] interface to
// pass information into and receive the reply from the [xBestIndex]
// method of a [virtual table module].  The fields under **Inputs** are the
// inputs to xBestIndex and are read-only.  xBestIndex inserts its
// results into the **Outputs** fields.
//
// ^(The aConstraint[] array records WHERE clause constraints of the form:
//
// <blockquote>column OP expr</blockquote>
//
// where OP is =, &lt;, &lt;=, &gt;, or &gt;=.)^  ^(The particular operator is
// stored in aConstraint[].op using one of the
// [SQLITE_INDEX_CONSTRAINT_EQ | SQLITE_INDEX_CONSTRAINT_ values].)^
// ^(The index of the column is stored in
// aConstraint[].iColumn.)^  ^(aConstraint[].usable is TRUE if the
// expr on the right-hand side can be evaluated (and thus the constraint
// is usable) and false if it cannot.)^
//
// ^The optimizer automatically inverts terms of the form "expr OP column"
// and makes other simplifications to the WHERE clause in an attempt to
// get as many WHERE clause terms into the form shown above as possible.
// ^The aConstraint[] array only reports WHERE clause terms that are
// relevant to the particular virtual table being queried.
//
// ^Information about the ORDER BY clause is stored in aOrderBy[].
// ^Each term of aOrderBy records a column of the ORDER BY clause.
//
// The colUsed field indicates which columns of the virtual table may be
// required by the current scan. Virtual table columns are numbered from
// zero in the order in which they appear within the CREATE TABLE statement
// passed to sqlite3_declare_vtab(). For the first 63 columns (columns 0-62),
// the corresponding bit is set within the colUsed mask if the column may be
// required by SQLite. If the table has at least 64 columns and any column
// to the right of the first 63 is required, then bit 63 of colUsed is also
// set. In other words, column iCol may be required if the expression
// (colUsed & ((sqlite3_uint64)1 << (iCol>=63 ? 63 : iCol))) evaluates to
// non-zero.
//
// The [xBestIndex] method must fill aConstraintUsage[] with information
// about what parameters to pass to xFilter.  ^If argvIndex>0 then
// the right-hand side of the corresponding aConstraint[] is evaluated
// and becomes the argvIndex-th entry in argv.  ^(If aConstraintUsage[].omit
// is true, then the constraint is assumed to be fully handled by the
// virtual table and might not be checked again by the byte code.)^ ^(The
// aConstraintUsage[].omit flag is an optimization hint. When the omit flag
// is left in its default setting of false, the constraint will always be
// checked separately in byte code.  If the omit flag is change to true, then
// the constraint may or may not be checked in byte code.  In other words,
// when the omit flag is true there is no guarantee that the constraint will
// not be checked again using byte code.)^
//
// ^The idxNum and idxPtr values are recorded and passed into the
// [xFilter] method.
// ^[sqlite3_free()] is used to free idxPtr if and only if
// needToFreeIdxPtr is true.
//
// ^The orderByConsumed means that output from [xFilter]/[xNext] will occur in
// the correct order to satisfy the ORDER BY clause so that no separate
// sorting step is required.
//
// ^The estimatedCost value is an estimate of the cost of a particular
// strategy. A cost of N indicates that the cost of the strategy is similar
// to a linear scan of an SQLite table with N rows. A cost of log(N)
// indicates that the expense of the operation is similar to that of a
// binary search on a unique indexed field of an SQLite table with N rows.
//
// ^The estimatedRows value is an estimate of the number of rows that
// will be returned by the strategy.
//
// The xBestIndex method may optionally populate the idxFlags field with a
// mask of SQLITE_INDEX_SCAN_* flags. Currently there is only one such flag -
// SQLITE_INDEX_SCAN_UNIQUE. If the xBestIndex method sets this flag, SQLite
// assumes that the strategy may visit at most one row.
//
// Additionally, if xBestIndex sets the SQLITE_INDEX_SCAN_UNIQUE flag, then
// SQLite also assumes that if a call to the xUpdate() method is made as
// part of the same statement to delete or update a virtual table row and the
// implementation returns SQLITE_CONSTRAINT, then there is no need to rollback
// any database changes. In other words, if the xUpdate() returns
// SQLITE_CONSTRAINT, the database contents must be exactly as they were
// before xUpdate was called. By contrast, if SQLITE_INDEX_SCAN_UNIQUE is not
// set and xUpdate returns SQLITE_CONSTRAINT, any database changes made by
// the xUpdate method are automatically rolled back by SQLite.
//
// IMPORTANT: The estimatedRows field was added to the sqlite3_index_info
// structure for SQLite [version 3.8.2] ([dateof:3.8.2]).
// If a virtual table extension is
// used with an SQLite version earlier than 3.8.2, the results of attempting
// to read or write the estimatedRows field are undefined (but are likely
// to include crashing the application). The estimatedRows field should
// therefore only be used if [sqlite3_libversion_number()] returns a
// value greater than or equal to 3008002. Similarly, the idxFlags field
// was added for [version 3.9.0] ([dateof:3.9.0]).
// It may therefore only be used if
// sqlite3_libversion_number() returns a value greater than or equal to
// 3009000.
type sqlite3_index_constraint_usage = struct {
	argvIndex int32
	omit      uint8
	_         [3]byte
} /* sqlite3.h:6690:9 */

// CAPI3REF: Mutex Methods Object
//
// An instance of this structure defines the low-level routines
// used to allocate and use mutexes.
//
// Usually, the default mutex implementations provided by SQLite are
// sufficient, however the application has the option of substituting a custom
// implementation for specialized deployments or systems for which SQLite
// does not provide a suitable implementation. In this case, the application
// creates and populates an instance of this structure to pass
// to sqlite3_config() along with the [SQLITE_CONFIG_MUTEX] option.
// Additionally, an instance of this structure can be used as an
// output variable when querying the system for the current mutex
// implementation, using the [SQLITE_CONFIG_GETMUTEX] option.
//
// ^The xMutexInit method defined by this structure is invoked as
// part of system initialization by the sqlite3_initialize() function.
// ^The xMutexInit routine is called by SQLite exactly once for each
// effective call to [sqlite3_initialize()].
//
// ^The xMutexEnd method defined by this structure is invoked as
// part of system shutdown by the sqlite3_shutdown() function. The
// implementation of this method is expected to release all outstanding
// resources obtained by the mutex methods implementation, especially
// those obtained by the xMutexInit method.  ^The xMutexEnd()
// interface is invoked exactly once for each call to [sqlite3_shutdown()].
//
// ^(The remaining seven methods defined by this structure (xMutexAlloc,
// xMutexFree, xMutexEnter, xMutexTry, xMutexLeave, xMutexHeld and
// xMutexNotheld) implement the following interfaces (respectively):
//
// <ul>
//   <li>  [sqlite3_mutex_alloc()] </li>
//   <li>  [sqlite3_mutex_free()] </li>
//   <li>  [sqlite3_mutex_enter()] </li>
//   <li>  [sqlite3_mutex_try()] </li>
//   <li>  [sqlite3_mutex_leave()] </li>
//   <li>  [sqlite3_mutex_held()] </li>
//   <li>  [sqlite3_mutex_notheld()] </li>
// </ul>)^
//
// The only difference is that the public sqlite3_XXX functions enumerated
// above silently ignore any invocations that pass a NULL pointer instead
// of a valid mutex handle. The implementations of the methods defined
// by this structure are not required to handle this case. The results
// of passing a NULL pointer instead of a valid mutex handle are undefined
// (i.e. it is acceptable to provide an implementation that segfaults if
// it is passed a NULL pointer).
//
// The xMutexInit() method must be threadsafe.  It must be harmless to
// invoke xMutexInit() multiple times within the same process and without
// intervening calls to xMutexEnd().  Second and subsequent calls to
// xMutexInit() must be no-ops.
//
// xMutexInit() must not use SQLite memory allocation ([sqlite3_malloc()]
// and its associates).  Similarly, xMutexAlloc() must not use SQLite memory
// allocation for a static mutex.  ^However xMutexAlloc() may use SQLite
// memory allocation for a fast or recursive mutex.
//
// ^SQLite will invoke the xMutexEnd() method when [sqlite3_shutdown()] is
// called, but only if the prior call to xMutexInit returned SQLITE_OK.
// If xMutexInit fails in any way, it is expected to clean up after itself
// prior to returning.
type sqlite3_mutex_methods1 = struct {
	xMutexInit    uintptr
	xMutexEnd     uintptr
	xMutexAlloc   uintptr
	xMutexFree    uintptr
	xMutexEnter   uintptr
	xMutexTry     uintptr
	xMutexLeave   uintptr
	xMutexHeld    uintptr
	xMutexNotheld uintptr
} /* sqlite3.h:7524:9 */

// CAPI3REF: Mutex Methods Object
//
// An instance of this structure defines the low-level routines
// used to allocate and use mutexes.
//
// Usually, the default mutex implementations provided by SQLite are
// sufficient, however the application has the option of substituting a custom
// implementation for specialized deployments or systems for which SQLite
// does not provide a suitable implementation. In this case, the application
// creates and populates an instance of this structure to pass
// to sqlite3_config() along with the [SQLITE_CONFIG_MUTEX] option.
// Additionally, an instance of this structure can be used as an
// output variable when querying the system for the current mutex
// implementation, using the [SQLITE_CONFIG_GETMUTEX] option.
//
// ^The xMutexInit method defined by this structure is invoked as
// part of system initialization by the sqlite3_initialize() function.
// ^The xMutexInit routine is called by SQLite exactly once for each
// effective call to [sqlite3_initialize()].
//
// ^The xMutexEnd method defined by this structure is invoked as
// part of system shutdown by the sqlite3_shutdown() function. The
// implementation of this method is expected to release all outstanding
// resources obtained by the mutex methods implementation, especially
// those obtained by the xMutexInit method.  ^The xMutexEnd()
// interface is invoked exactly once for each call to [sqlite3_shutdown()].
//
// ^(The remaining seven methods defined by this structure (xMutexAlloc,
// xMutexFree, xMutexEnter, xMutexTry, xMutexLeave, xMutexHeld and
// xMutexNotheld) implement the following interfaces (respectively):
//
// <ul>
//   <li>  [sqlite3_mutex_alloc()] </li>
//   <li>  [sqlite3_mutex_free()] </li>
//   <li>  [sqlite3_mutex_enter()] </li>
//   <li>  [sqlite3_mutex_try()] </li>
//   <li>  [sqlite3_mutex_leave()] </li>
//   <li>  [sqlite3_mutex_held()] </li>
//   <li>  [sqlite3_mutex_notheld()] </li>
// </ul>)^
//
// The only difference is that the public sqlite3_XXX functions enumerated
// above silently ignore any invocations that pass a NULL pointer instead
// of a valid mutex handle. The implementations of the methods defined
// by this structure are not required to handle this case. The results
// of passing a NULL pointer instead of a valid mutex handle are undefined
// (i.e. it is acceptable to provide an implementation that segfaults if
// it is passed a NULL pointer).
//
// The xMutexInit() method must be threadsafe.  It must be harmless to
// invoke xMutexInit() multiple times within the same process and without
// intervening calls to xMutexEnd().  Second and subsequent calls to
// xMutexInit() must be no-ops.
//
// xMutexInit() must not use SQLite memory allocation ([sqlite3_malloc()]
// and its associates).  Similarly, xMutexAlloc() must not use SQLite memory
// allocation for a static mutex.  ^However xMutexAlloc() may use SQLite
// memory allocation for a fast or recursive mutex.
//
// ^SQLite will invoke the xMutexEnd() method when [sqlite3_shutdown()] is
// called, but only if the prior call to xMutexInit returned SQLITE_OK.
// If xMutexInit fails in any way, it is expected to clean up after itself
// prior to returning.
type sqlite3_mutex_methods = sqlite3_mutex_methods1 /* sqlite3.h:7524:38 */

// CAPI3REF: Custom Page Cache Object
//
// The sqlite3_pcache_page object represents a single page in the
// page cache.  The page cache will allocate instances of this
// object.  Various methods of the page cache use pointers to instances
// of this object as parameters or as their return value.
//
// See [sqlite3_pcache_methods2] for additional information.
type sqlite3_pcache_page1 = struct {
	pBuf   uintptr
	pExtra uintptr
} /* sqlite3.h:8277:9 */

// CAPI3REF: Custom Page Cache Object
//
// The sqlite3_pcache_page object represents a single page in the
// page cache.  The page cache will allocate instances of this
// object.  Various methods of the page cache use pointers to instances
// of this object as parameters or as their return value.
//
// See [sqlite3_pcache_methods2] for additional information.
type sqlite3_pcache_page = sqlite3_pcache_page1 /* sqlite3.h:8277:36 */

// CAPI3REF: Application Defined Page Cache.
// KEYWORDS: {page cache}
//
// ^(The [sqlite3_config]([SQLITE_CONFIG_PCACHE2], ...) interface can
// register an alternative page cache implementation by passing in an
// instance of the sqlite3_pcache_methods2 structure.)^
// In many applications, most of the heap memory allocated by
// SQLite is used for the page cache.
// By implementing a
// custom page cache using this API, an application can better control
// the amount of memory consumed by SQLite, the way in which
// that memory is allocated and released, and the policies used to
// determine exactly which parts of a database file are cached and for
// how long.
//
// The alternative page cache mechanism is an
// extreme measure that is only needed by the most demanding applications.
// The built-in page cache is recommended for most uses.
//
// ^(The contents of the sqlite3_pcache_methods2 structure are copied to an
// internal buffer by SQLite within the call to [sqlite3_config].  Hence
// the application may discard the parameter after the call to
// [sqlite3_config()] returns.)^
//
// [[the xInit() page cache method]]
// ^(The xInit() method is called once for each effective
// call to [sqlite3_initialize()])^
// (usually only once during the lifetime of the process). ^(The xInit()
// method is passed a copy of the sqlite3_pcache_methods2.pArg value.)^
// The intent of the xInit() method is to set up global data structures
// required by the custom page cache implementation.
// ^(If the xInit() method is NULL, then the
// built-in default page cache is used instead of the application defined
// page cache.)^
//
// [[the xShutdown() page cache method]]
// ^The xShutdown() method is called by [sqlite3_shutdown()].
// It can be used to clean up
// any outstanding resources before process shutdown, if required.
// ^The xShutdown() method may be NULL.
//
// ^SQLite automatically serializes calls to the xInit method,
// so the xInit method need not be threadsafe.  ^The
// xShutdown method is only called from [sqlite3_shutdown()] so it does
// not need to be threadsafe either.  All other methods must be threadsafe
// in multithreaded applications.
//
// ^SQLite will never invoke xInit() more than once without an intervening
// call to xShutdown().
//
// [[the xCreate() page cache methods]]
// ^SQLite invokes the xCreate() method to construct a new cache instance.
// SQLite will typically create one cache instance for each open database file,
// though this is not guaranteed. ^The
// first parameter, szPage, is the size in bytes of the pages that must
// be allocated by the cache.  ^szPage will always a power of two.  ^The
// second parameter szExtra is a number of bytes of extra storage
// associated with each page cache entry.  ^The szExtra parameter will
// a number less than 250.  SQLite will use the
// extra szExtra bytes on each page to store metadata about the underlying
// database page on disk.  The value passed into szExtra depends
// on the SQLite version, the target platform, and how SQLite was compiled.
// ^The third argument to xCreate(), bPurgeable, is true if the cache being
// created will be used to cache database pages of a file stored on disk, or
// false if it is used for an in-memory database. The cache implementation
// does not have to do anything special based with the value of bPurgeable;
// it is purely advisory.  ^On a cache where bPurgeable is false, SQLite will
// never invoke xUnpin() except to deliberately delete a page.
// ^In other words, calls to xUnpin() on a cache with bPurgeable set to
// false will always have the "discard" flag set to true.
// ^Hence, a cache created with bPurgeable false will
// never contain any unpinned pages.
//
// [[the xCachesize() page cache method]]
// ^(The xCachesize() method may be called at any time by SQLite to set the
// suggested maximum cache-size (number of pages stored by) the cache
// instance passed as the first argument. This is the value configured using
// the SQLite "[PRAGMA cache_size]" command.)^  As with the bPurgeable
// parameter, the implementation is not required to do anything with this
// value; it is advisory only.
//
// [[the xPagecount() page cache methods]]
// The xPagecount() method must return the number of pages currently
// stored in the cache, both pinned and unpinned.
//
// [[the xFetch() page cache methods]]
// The xFetch() method locates a page in the cache and returns a pointer to
// an sqlite3_pcache_page object associated with that page, or a NULL pointer.
// The pBuf element of the returned sqlite3_pcache_page object will be a
// pointer to a buffer of szPage bytes used to store the content of a
// single database page.  The pExtra element of sqlite3_pcache_page will be
// a pointer to the szExtra bytes of extra storage that SQLite has requested
// for each entry in the page cache.
//
// The page to be fetched is determined by the key. ^The minimum key value
// is 1.  After it has been retrieved using xFetch, the page is considered
// to be "pinned".
//
// If the requested page is already in the page cache, then the page cache
// implementation must return a pointer to the page buffer with its content
// intact.  If the requested page is not already in the cache, then the
// cache implementation should use the value of the createFlag
// parameter to help it determined what action to take:
//
// <table border=1 width=85% align=center>
// <tr><th> createFlag <th> Behavior when page is not already in cache
// <tr><td> 0 <td> Do not allocate a new page.  Return NULL.
// <tr><td> 1 <td> Allocate a new page if it easy and convenient to do so.
//                 Otherwise return NULL.
// <tr><td> 2 <td> Make every effort to allocate a new page.  Only return
//                 NULL if allocating a new page is effectively impossible.
// </table>
//
// ^(SQLite will normally invoke xFetch() with a createFlag of 0 or 1.  SQLite
// will only use a createFlag of 2 after a prior call with a createFlag of 1
// failed.)^  In between the xFetch() calls, SQLite may
// attempt to unpin one or more cache pages by spilling the content of
// pinned pages to disk and synching the operating system disk cache.
//
// [[the xUnpin() page cache method]]
// ^xUnpin() is called by SQLite with a pointer to a currently pinned page
// as its second argument.  If the third parameter, discard, is non-zero,
// then the page must be evicted from the cache.
// ^If the discard parameter is
// zero, then the page may be discarded or retained at the discretion of
// page cache implementation. ^The page cache implementation
// may choose to evict unpinned pages at any time.
//
// The cache must not perform any reference counting. A single
// call to xUnpin() unpins the page regardless of the number of prior calls
// to xFetch().
//
// [[the xRekey() page cache methods]]
// The xRekey() method is used to change the key value associated with the
// page passed as the second argument. If the cache
// previously contains an entry associated with newKey, it must be
// discarded. ^Any prior cache entry associated with newKey is guaranteed not
// to be pinned.
//
// When SQLite calls the xTruncate() method, the cache must discard all
// existing cache entries with page numbers (keys) greater than or equal
// to the value of the iLimit parameter passed to xTruncate(). If any
// of these pages are pinned, they are implicitly unpinned, meaning that
// they can be safely discarded.
//
// [[the xDestroy() page cache method]]
// ^The xDestroy() method is used to delete a cache allocated by xCreate().
// All resources associated with the specified cache should be freed. ^After
// calling the xDestroy() method, SQLite considers the [sqlite3_pcache*]
// handle invalid, and will not use it with any other sqlite3_pcache_methods2
// functions.
//
// [[the xShrink() page cache method]]
// ^SQLite invokes the xShrink() method when it wants the page cache to
// free up as much of heap memory as possible.  The page cache implementation
// is not obligated to free any memory, but well-behaved implementations should
// do their best.
type sqlite3_pcache_methods21 = struct {
	iVersion   int32
	pArg       uintptr
	xInit      uintptr
	xShutdown  uintptr
	xCreate    uintptr
	xCachesize uintptr
	xPagecount uintptr
	xFetch     uintptr
	xUnpin     uintptr
	xRekey     uintptr
	xTruncate  uintptr
	xDestroy   uintptr
	xShrink    uintptr
} /* sqlite3.h:8442:9 */

// CAPI3REF: Application Defined Page Cache.
// KEYWORDS: {page cache}
//
// ^(The [sqlite3_config]([SQLITE_CONFIG_PCACHE2], ...) interface can
// register an alternative page cache implementation by passing in an
// instance of the sqlite3_pcache_methods2 structure.)^
// In many applications, most of the heap memory allocated by
// SQLite is used for the page cache.
// By implementing a
// custom page cache using this API, an application can better control
// the amount of memory consumed by SQLite, the way in which
// that memory is allocated and released, and the policies used to
// determine exactly which parts of a database file are cached and for
// how long.
//
// The alternative page cache mechanism is an
// extreme measure that is only needed by the most demanding applications.
// The built-in page cache is recommended for most uses.
//
// ^(The contents of the sqlite3_pcache_methods2 structure are copied to an
// internal buffer by SQLite within the call to [sqlite3_config].  Hence
// the application may discard the parameter after the call to
// [sqlite3_config()] returns.)^
//
// [[the xInit() page cache method]]
// ^(The xInit() method is called once for each effective
// call to [sqlite3_initialize()])^
// (usually only once during the lifetime of the process). ^(The xInit()
// method is passed a copy of the sqlite3_pcache_methods2.pArg value.)^
// The intent of the xInit() method is to set up global data structures
// required by the custom page cache implementation.
// ^(If the xInit() method is NULL, then the
// built-in default page cache is used instead of the application defined
// page cache.)^
//
// [[the xShutdown() page cache method]]
// ^The xShutdown() method is called by [sqlite3_shutdown()].
// It can be used to clean up
// any outstanding resources before process shutdown, if required.
// ^The xShutdown() method may be NULL.
//
// ^SQLite automatically serializes calls to the xInit method,
// so the xInit method need not be threadsafe.  ^The
// xShutdown method is only called from [sqlite3_shutdown()] so it does
// not need to be threadsafe either.  All other methods must be threadsafe
// in multithreaded applications.
//
// ^SQLite will never invoke xInit() more than once without an intervening
// call to xShutdown().
//
// [[the xCreate() page cache methods]]
// ^SQLite invokes the xCreate() method to construct a new cache instance.
// SQLite will typically create one cache instance for each open database file,
// though this is not guaranteed. ^The
// first parameter, szPage, is the size in bytes of the pages that must
// be allocated by the cache.  ^szPage will always a power of two.  ^The
// second parameter szExtra is a number of bytes of extra storage
// associated with each page cache entry.  ^The szExtra parameter will
// a number less than 250.  SQLite will use the
// extra szExtra bytes on each page to store metadata about the underlying
// database page on disk.  The value passed into szExtra depends
// on the SQLite version, the target platform, and how SQLite was compiled.
// ^The third argument to xCreate(), bPurgeable, is true if the cache being
// created will be used to cache database pages of a file stored on disk, or
// false if it is used for an in-memory database. The cache implementation
// does not have to do anything special based with the value of bPurgeable;
// it is purely advisory.  ^On a cache where bPurgeable is false, SQLite will
// never invoke xUnpin() except to deliberately delete a page.
// ^In other words, calls to xUnpin() on a cache with bPurgeable set to
// false will always have the "discard" flag set to true.
// ^Hence, a cache created with bPurgeable false will
// never contain any unpinned pages.
//
// [[the xCachesize() page cache method]]
// ^(The xCachesize() method may be called at any time by SQLite to set the
// suggested maximum cache-size (number of pages stored by) the cache
// instance passed as the first argument. This is the value configured using
// the SQLite "[PRAGMA cache_size]" command.)^  As with the bPurgeable
// parameter, the implementation is not required to do anything with this
// value; it is advisory only.
//
// [[the xPagecount() page cache methods]]
// The xPagecount() method must return the number of pages currently
// stored in the cache, both pinned and unpinned.
//
// [[the xFetch() page cache methods]]
// The xFetch() method locates a page in the cache and returns a pointer to
// an sqlite3_pcache_page object associated with that page, or a NULL pointer.
// The pBuf element of the returned sqlite3_pcache_page object will be a
// pointer to a buffer of szPage bytes used to store the content of a
// single database page.  The pExtra element of sqlite3_pcache_page will be
// a pointer to the szExtra bytes of extra storage that SQLite has requested
// for each entry in the page cache.
//
// The page to be fetched is determined by the key. ^The minimum key value
// is 1.  After it has been retrieved using xFetch, the page is considered
// to be "pinned".
//
// If the requested page is already in the page cache, then the page cache
// implementation must return a pointer to the page buffer with its content
// intact.  If the requested page is not already in the cache, then the
// cache implementation should use the value of the createFlag
// parameter to help it determined what action to take:
//
// <table border=1 width=85% align=center>
// <tr><th> createFlag <th> Behavior when page is not already in cache
// <tr><td> 0 <td> Do not allocate a new page.  Return NULL.
// <tr><td> 1 <td> Allocate a new page if it easy and convenient to do so.
//                 Otherwise return NULL.
// <tr><td> 2 <td> Make every effort to allocate a new page.  Only return
//                 NULL if allocating a new page is effectively impossible.
// </table>
//
// ^(SQLite will normally invoke xFetch() with a createFlag of 0 or 1.  SQLite
// will only use a createFlag of 2 after a prior call with a createFlag of 1
// failed.)^  In between the xFetch() calls, SQLite may
// attempt to unpin one or more cache pages by spilling the content of
// pinned pages to disk and synching the operating system disk cache.
//
// [[the xUnpin() page cache method]]
// ^xUnpin() is called by SQLite with a pointer to a currently pinned page
// as its second argument.  If the third parameter, discard, is non-zero,
// then the page must be evicted from the cache.
// ^If the discard parameter is
// zero, then the page may be discarded or retained at the discretion of
// page cache implementation. ^The page cache implementation
// may choose to evict unpinned pages at any time.
//
// The cache must not perform any reference counting. A single
// call to xUnpin() unpins the page regardless of the number of prior calls
// to xFetch().
//
// [[the xRekey() page cache methods]]
// The xRekey() method is used to change the key value associated with the
// page passed as the second argument. If the cache
// previously contains an entry associated with newKey, it must be
// discarded. ^Any prior cache entry associated with newKey is guaranteed not
// to be pinned.
//
// When SQLite calls the xTruncate() method, the cache must discard all
// existing cache entries with page numbers (keys) greater than or equal
// to the value of the iLimit parameter passed to xTruncate(). If any
// of these pages are pinned, they are implicitly unpinned, meaning that
// they can be safely discarded.
//
// [[the xDestroy() page cache method]]
// ^The xDestroy() method is used to delete a cache allocated by xCreate().
// All resources associated with the specified cache should be freed. ^After
// calling the xDestroy() method, SQLite considers the [sqlite3_pcache*]
// handle invalid, and will not use it with any other sqlite3_pcache_methods2
// functions.
//
// [[the xShrink() page cache method]]
// ^SQLite invokes the xShrink() method when it wants the page cache to
// free up as much of heap memory as possible.  The page cache implementation
// is not obligated to free any memory, but well-behaved implementations should
// do their best.
type sqlite3_pcache_methods2 = sqlite3_pcache_methods21 /* sqlite3.h:8442:40 */

// This is the obsolete pcache_methods object that has now been replaced
// by sqlite3_pcache_methods2.  This object is not used by SQLite.  It is
// retained in the header file for backwards compatibility only.
type sqlite3_pcache_methods1 = struct {
	pArg       uintptr
	xInit      uintptr
	xShutdown  uintptr
	xCreate    uintptr
	xCachesize uintptr
	xPagecount uintptr
	xFetch     uintptr
	xUnpin     uintptr
	xRekey     uintptr
	xTruncate  uintptr
	xDestroy   uintptr
} /* sqlite3.h:8465:9 */

// This is the obsolete pcache_methods object that has now been replaced
// by sqlite3_pcache_methods2.  This object is not used by SQLite.  It is
// retained in the header file for backwards compatibility only.
type sqlite3_pcache_methods = sqlite3_pcache_methods1 /* sqlite3.h:8465:39 */

// CAPI3REF: Database Snapshot
// KEYWORDS: {snapshot} {sqlite3_snapshot}
//
// An instance of the snapshot object records the state of a [WAL mode]
// database for some specific point in history.
//
// In [WAL mode], multiple [database connections] that are open on the
// same database file can each be reading a different historical version
// of the database file.  When a [database connection] begins a read
// transaction, that connection sees an unchanging copy of the database
// as it existed for the point in time when the transaction first started.
// Subsequent changes to the database from other connections are not seen
// by the reader until a new read transaction is started.
//
// The sqlite3_snapshot object records state information about an historical
// version of the database file so that it is possible to later open a new read
// transaction that sees that historical version of the database rather than
// the most recent version.
type sqlite3_snapshot1 = struct{ hidden [48]uint8 } /* sqlite3.h:9512:9 */

// CAPI3REF: Database Snapshot
// KEYWORDS: {snapshot} {sqlite3_snapshot}
//
// An instance of the snapshot object records the state of a [WAL mode]
// database for some specific point in history.
//
// In [WAL mode], multiple [database connections] that are open on the
// same database file can each be reading a different historical version
// of the database file.  When a [database connection] begins a read
// transaction, that connection sees an unchanging copy of the database
// as it existed for the point in time when the transaction first started.
// Subsequent changes to the database from other connections are not seen
// by the reader until a new read transaction is started.
//
// The sqlite3_snapshot object records state information about an historical
// version of the database file so that it is possible to later open a new read
// transaction that sees that historical version of the database rather than
// the most recent version.
type sqlite3_snapshot = sqlite3_snapshot1 /* sqlite3.h:9514:3 */

// CAPI3REF: Flags for sqlite3_deserialize()
//
// The following are allowed values for 6th argument (the F argument) to
// the [sqlite3_deserialize(D,S,P,N,M,F)] interface.
//
// The SQLITE_DESERIALIZE_FREEONCLOSE means that the database serialization
// in the P argument is held in memory obtained from [sqlite3_malloc64()]
// and that SQLite should take ownership of this memory and automatically
// free it when it has finished using it.  Without this flag, the caller
// is responsible for freeing any dynamically allocated memory.
//
// The SQLITE_DESERIALIZE_RESIZEABLE flag means that SQLite is allowed to
// grow the size of the database using calls to [sqlite3_realloc64()].  This
// flag should only be used if SQLITE_DESERIALIZE_FREEONCLOSE is also used.
// Without this flag, the deserialized database cannot increase in size beyond
// the number of bytes specified by the M parameter.
//
// The SQLITE_DESERIALIZE_READONLY flag means that the deserialized database
// should be treated as read-only.

// Undo the hack that converts floating point types to integer for
// builds on processors without floating point support.

//******* Begin file sqlite3rtree.h ********
// 2010 August 30
//
// The author disclaims copyright to this source code.  In place of
// a legal notice, here is a blessing:
//
//    May you do good and not evil.
//    May you find forgiveness for yourself and forgive others.
//    May you share freely, never taking more than you give.
//
//

type sqlite3_rtree_geometry1 = struct {
	pContext uintptr
	nParam   int32
	aParam   uintptr
	pUser    uintptr
	xDelUser uintptr
} /* sqlite3.h:9839:9 */

// CAPI3REF: Flags for sqlite3_deserialize()
//
// The following are allowed values for 6th argument (the F argument) to
// the [sqlite3_deserialize(D,S,P,N,M,F)] interface.
//
// The SQLITE_DESERIALIZE_FREEONCLOSE means that the database serialization
// in the P argument is held in memory obtained from [sqlite3_malloc64()]
// and that SQLite should take ownership of this memory and automatically
// free it when it has finished using it.  Without this flag, the caller
// is responsible for freeing any dynamically allocated memory.
//
// The SQLITE_DESERIALIZE_RESIZEABLE flag means that SQLite is allowed to
// grow the size of the database using calls to [sqlite3_realloc64()].  This
// flag should only be used if SQLITE_DESERIALIZE_FREEONCLOSE is also used.
// Without this flag, the deserialized database cannot increase in size beyond
// the number of bytes specified by the M parameter.
//
// The SQLITE_DESERIALIZE_READONLY flag means that the deserialized database
// should be treated as read-only.

// Undo the hack that converts floating point types to integer for
// builds on processors without floating point support.

//******* Begin file sqlite3rtree.h ********
// 2010 August 30
//
// The author disclaims copyright to this source code.  In place of
// a legal notice, here is a blessing:
//
//    May you do good and not evil.
//    May you find forgiveness for yourself and forgive others.
//    May you share freely, never taking more than you give.
//
//

type sqlite3_rtree_geometry = sqlite3_rtree_geometry1 /* sqlite3.h:9839:39 */
type sqlite3_rtree_query_info1 = struct {
	pContext      uintptr
	nParam        int32
	aParam        uintptr
	pUser         uintptr
	xDelUser      uintptr
	aCoord        uintptr
	anQueue       uintptr
	nCoord        int32
	iLevel        int32
	mxLevel       int32
	iRowid        sqlite3_int64
	rParentScore  sqlite3_rtree_dbl
	eParentWithin int32
	eWithin       int32
	rScore        sqlite3_rtree_dbl
	apSqlParam    uintptr
	_             [4]byte
} /* sqlite3.h:9840:9 */

type sqlite3_rtree_query_info = sqlite3_rtree_query_info1 /* sqlite3.h:9840:41 */

// The double-precision datatype used by RTree depends on the
// SQLITE_RTREE_INT_ONLY compile-time option.
type sqlite3_rtree_dbl = float64 /* sqlite3.h:9848:18 */

// Allowed values for sqlite3_rtree_query.eWithin and .eParentWithin.

//******* End of sqlite3rtree.h ********
//******* Begin file sqlite3session.h ********

//******* End of sqlite3session.h ********
//******* Begin file fts5.h ********
// 2014 May 31
//
// The author disclaims copyright to this source code.  In place of
// a legal notice, here is a blessing:
//
//    May you do good and not evil.
//    May you find forgiveness for yourself and forgive others.
//    May you share freely, never taking more than you give.
//
//
//
// Interfaces to extend FTS5. Using the interfaces defined in this file,
// FTS5 may be extended with:
//
//     * custom tokenizers, and
//     * custom auxiliary functions.

// ************************************************************************
//
// CUSTOM AUXILIARY FUNCTIONS
//
// Virtual table implementations may overload SQL functions by implementing
// the sqlite3_module.xFindFunction() method.

type Fts5ExtensionApi1 = struct {
	iVersion           int32
	xUserData          uintptr
	xColumnCount       uintptr
	xRowCount          uintptr
	xColumnTotalSize   uintptr
	xTokenize          uintptr
	xPhraseCount       uintptr
	xPhraseSize        uintptr
	xInstCount         uintptr
	xInst              uintptr
	xRowid             uintptr
	xColumnText        uintptr
	xColumnSize        uintptr
	xQueryPhrase       uintptr
	xSetAuxdata        uintptr
	xGetAuxdata        uintptr
	xPhraseFirst       uintptr
	xPhraseNext        uintptr
	xPhraseFirstColumn uintptr
	xPhraseNextColumn  uintptr
} /* sqlite3.h:11634:9 */

// Allowed values for sqlite3_rtree_query.eWithin and .eParentWithin.

//******* End of sqlite3rtree.h ********
//******* Begin file sqlite3session.h ********

//******* End of sqlite3session.h ********
//******* Begin file fts5.h ********
// 2014 May 31
//
// The author disclaims copyright to this source code.  In place of
// a legal notice, here is a blessing:
//
//    May you do good and not evil.
//    May you find forgiveness for yourself and forgive others.
//    May you share freely, never taking more than you give.
//
//
//
// Interfaces to extend FTS5. Using the interfaces defined in this file,
// FTS5 may be extended with:
//
//     * custom tokenizers, and
//     * custom auxiliary functions.

// ************************************************************************
//
// CUSTOM AUXILIARY FUNCTIONS
//
// Virtual table implementations may overload SQL functions by implementing
// the sqlite3_module.xFindFunction() method.

type Fts5ExtensionApi = Fts5ExtensionApi1 /* sqlite3.h:11634:33 */
type Fts5PhraseIter1 = struct {
	a uintptr
	b uintptr
} /* sqlite3.h:11636:9 */

type Fts5PhraseIter = Fts5PhraseIter1 /* sqlite3.h:11636:31 */

type fts5_extension_function = uintptr /* sqlite3.h:11638:14 */
type fts5_tokenizer1 = struct {
	xCreate   uintptr
	xDelete   uintptr
	xTokenize uintptr
} /* sqlite3.h:12097:9 */

type fts5_tokenizer = fts5_tokenizer1 /* sqlite3.h:12097:31 */

// Flags that may be passed as the third argument to xTokenize()

// Flags that may be passed by the tokenizer implementation back to FTS5
// as the third argument to the supplied xToken callback.

//
// END OF CUSTOM TOKENIZERS
//

// ************************************************************************
//
// FTS5 EXTENSION REGISTRATION API
type fts5_api1 = struct {
	iVersion         int32
	xCreateTokenizer uintptr
	xFindTokenizer   uintptr
	xCreateFunction  uintptr
} /* sqlite3.h:12133:9 */

// Flags that may be passed as the third argument to xTokenize()

// Flags that may be passed by the tokenizer implementation back to FTS5
// as the third argument to the supplied xToken callback.

//
// END OF CUSTOM TOKENIZERS
//

// ************************************************************************
//
// FTS5 EXTENSION REGISTRATION API
type fts5_api = fts5_api1 /* sqlite3.h:12133:25 */

type ssize_t = int32 /* crtdefs.h:47:13 */

type rsize_t = size_t /* crtdefs.h:52:16 */

type intptr_t = int32 /* crtdefs.h:64:13 */

type uintptr_t = uint32 /* crtdefs.h:77:22 */

type wint_t = uint16   /* crtdefs.h:106:24 */
type wctype_t = uint16 /* crtdefs.h:107:24 */

type errno_t = int32 /* crtdefs.h:113:13 */

type time_t = int32 /* crtdefs.h:136:20 */

type threadlocaleinfostruct = struct {
	refcount      int32
	lc_codepage   uint32
	lc_collate_cp uint32
	lc_handle     [6]uint32
	lc_id         [6]LC_ID
	lc_category   [6]struct {
		locale    uintptr
		wlocale   uintptr
		refcount  uintptr
		wrefcount uintptr
	}
	lc_clike            int32
	mb_cur_max          int32
	lconv_intl_refcount uintptr
	lconv_num_refcount  uintptr
	lconv_mon_refcount  uintptr
	lconv               uintptr
	ctype1_refcount     uintptr
	ctype1              uintptr
	pctype              uintptr
	pclmap              uintptr
	pcumap              uintptr
	lc_time_curr        uintptr
} /* crtdefs.h:422:1 */

type pthreadlocinfo = uintptr /* crtdefs.h:424:39 */
type pthreadmbcinfo = uintptr /* crtdefs.h:425:36 */

type localeinfo_struct = struct {
	locinfo pthreadlocinfo
	mbcinfo pthreadmbcinfo
} /* crtdefs.h:428:9 */

type _locale_tstruct = localeinfo_struct /* crtdefs.h:431:3 */
type _locale_t = uintptr                 /* crtdefs.h:431:19 */

type tagLC_ID = struct {
	wLanguage uint16
	wCountry  uint16
	wCodePage uint16
} /* crtdefs.h:422:1 */

type LC_ID = tagLC_ID  /* crtdefs.h:439:3 */
type LPLC_ID = uintptr /* crtdefs.h:439:9 */

type threadlocinfo = threadlocaleinfostruct /* crtdefs.h:468:3 */

// Static assertion.  Requires support in the compiler.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// Undefine __mingw_<printf> macros.

type _iobuf = struct {
	_ptr      uintptr
	_cnt      int32
	_base     uintptr
	_flag     int32
	_file     int32
	_charbuf  int32
	_bufsiz   int32
	_tmpfname uintptr
} /* stdio.h:26:3 */

type FILE = _iobuf /* stdio.h:36:25 */

type _off_t = int32  /* _mingw_off_t.h:5:16 */
type off32_t = int32 /* _mingw_off_t.h:7:16 */

type _off64_t = int64 /* _mingw_off_t.h:13:39 */
type off64_t = int64  /* _mingw_off_t.h:15:39 */

type off_t = off64_t /* _mingw_off_t.h:24:17 */ // A pointer to an array of FILE

type fpos_t = int64 /* stdio.h:104:37 */

func vsnwprintf(tls *libc.TLS, s uintptr, n size_t, format uintptr, arg va_list) int32 { /* stdio.h:1213:15: */
	return libc.X_vsnwprintf(tls, s, n, format, arg)

}

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

func vswprintf(tls *libc.TLS, __stream uintptr, __count size_t, __format uintptr, __local_argv uintptr) int32 { /* swprintf.inl:27:5: */
	return vsnwprintf(tls, __stream, __count, __format, __local_argv)
}

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// Define __mingw_<printf> macros.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// Copyright (C) 1992-2018 Free Software Foundation, Inc.
//
// This file is part of GCC.
//
// GCC is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 3, or (at your option) any later
// version.
//
// GCC is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// Under Section 7 of GPL version 3, you are granted additional
// permissions described in the GCC Runtime Library Exception, version
// 3.1, as published by the Free Software Foundation.
//
// You should have received a copy of the GNU General Public License and
// a copy of the GCC Runtime Library Exception along with this program;
// see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
// <http://www.gnu.org/licenses/>.

// This administrivia gets added to the beginning of limits.h
//    if the system has its own version of limits.h.

// We use _GCC_LIMITS_H_ because we want this not to match
//    any macros that the system's limits.h uses for its own purposes.

// Use "..." so that we find syslimits.h only in this same directory.
// syslimits.h stands for the system's own limits.h file.
//    If we can use it ok unmodified, then we install this text.
//    If fixincludes fixes it, then the fixed version is installed
//    instead of this text.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.
// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// File system limits
//
// NOTE: Apparently the actual size of PATH_MAX is 260, but a space is
//       required for the NUL. TODO: Test?
// NOTE: PATH_MAX is the POSIX equivalent for Microsoft's MAX_PATH; the two
//       are semantically identical, with a limit of 259 characters for the
//       path name, plus one for a terminating NUL, for a total of 260.

// Copyright (C) 1991-2018 Free Software Foundation, Inc.
//
// This file is part of GCC.
//
// GCC is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 3, or (at your option) any later
// version.
//
// GCC is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// Under Section 7 of GPL version 3, you are granted additional
// permissions described in the GCC Runtime Library Exception, version
// 3.1, as published by the Free Software Foundation.
//
// You should have received a copy of the GNU General Public License and
// a copy of the GCC Runtime Library Exception along with this program;
// see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
// <http://www.gnu.org/licenses/>.

// Number of bits in a `char'.

// Maximum length of a multibyte character.

// Minimum and maximum values a `signed char' can hold.

// Maximum value an `unsigned char' can hold.  (Minimum is 0).

// Minimum and maximum values a `char' can hold.

// Minimum and maximum values a `signed short int' can hold.

// Maximum value an `unsigned short int' can hold.  (Minimum is 0).

// Minimum and maximum values a `signed int' can hold.

// Maximum value an `unsigned int' can hold.  (Minimum is 0).

// Minimum and maximum values a `signed long int' can hold.
//    (Same as `int').

// Maximum value an `unsigned long int' can hold.  (Minimum is 0).

// Minimum and maximum values a `signed long long int' can hold.

// Maximum value an `unsigned long long int' can hold.  (Minimum is 0).

// Minimum and maximum values a `signed long long int' can hold.

// Maximum value an `unsigned long long int' can hold.  (Minimum is 0).

// This administrivia gets added to the end of limits.h
//    if the system has its own version of limits.h.

type _onexit_t = uintptr /* stdlib.h:49:15 */

type _div_t = struct {
	quot int32
	rem  int32
} /* stdlib.h:59:11 */

type div_t = _div_t /* stdlib.h:62:5 */

type _ldiv_t = struct {
	quot int32
	rem  int32
} /* stdlib.h:64:11 */

type ldiv_t = _ldiv_t /* stdlib.h:67:5 */

type _LDOUBLE = struct{ ld [10]uint8 } /* stdlib.h:76:5 */

type _CRT_DOUBLE = struct{ x float64 } /* stdlib.h:83:5 */

type _CRT_FLOAT = struct{ f float32 } /* stdlib.h:87:5 */

type _LONGDOUBLE = struct{ x float64 } /* stdlib.h:94:5 */

type _LDBL12 = struct{ ld12 [12]uint8 } /* stdlib.h:101:5 */

type _purecall_handler = uintptr /* stdlib.h:142:16 */

type _invalid_parameter_handler = uintptr /* stdlib.h:147:16 */

type lldiv_t = struct {
	quot int64
	rem  int64
} /* stdlib.h:699:61 */

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// Return codes for _heapwalk()

// Values for _heapinfo.useflag

// The structure used to walk through the heap with _heapwalk.
type _heapinfo = struct {
	_pentry  uintptr
	_size    size_t
	_useflag int32
} /* malloc.h:46:11 */

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// Return codes for _heapwalk()

// Values for _heapinfo.useflag

// The structure used to walk through the heap with _heapwalk.
type _HEAPINFO = _heapinfo /* malloc.h:50:5 */
type _fsize_t = uint32     /* io.h:29:25 */

type _finddata32_t = struct {
	attrib      uint32
	time_create int32
	time_access int32
	time_write  int32
	size        _fsize_t
	name        [260]int8
} /* io.h:35:3 */

type _finddata32i64_t = struct {
	attrib      uint32
	time_create int32
	time_access int32
	time_write  int32
	size        int64
	name        [260]int8
	_           [4]byte
} /* io.h:44:3 */

type _finddata64i32_t = struct {
	attrib      uint32
	_           [4]byte
	time_create int64
	time_access int64
	time_write  int64
	size        _fsize_t
	name        [260]int8
} /* io.h:53:3 */

type __finddata64_t = struct {
	attrib      uint32
	_           [4]byte
	time_create int64
	time_access int64
	time_write  int64
	size        int64
	name        [260]int8
	_           [4]byte
} /* io.h:62:3 */

type _wfinddata32_t = struct {
	attrib      uint32
	time_create int32
	time_access int32
	time_write  int32
	size        _fsize_t
	name        [260]wchar_t
} /* io.h:94:3 */

type _wfinddata32i64_t = struct {
	attrib      uint32
	time_create int32
	time_access int32
	time_write  int32
	size        int64
	name        [260]wchar_t
} /* io.h:103:3 */

type _wfinddata64i32_t = struct {
	attrib      uint32
	_           [4]byte
	time_create int64
	time_access int64
	time_write  int64
	size        _fsize_t
	name        [260]wchar_t
	_           [4]byte
} /* io.h:112:3 */

type _wfinddata64_t = struct {
	attrib      uint32
	_           [4]byte
	time_create int64
	time_access int64
	time_write  int64
	size        int64
	name        [260]wchar_t
} /* io.h:121:3 */

type u64 = sqlite3_uint64 /* speedtest1.c:66:24 */

// State structure for a Hash hash in progress
type HashContext1 = struct {
	isInit uint8
	i      uint8
	j      uint8
	s      [256]uint8
	r      [32]uint8
} /* speedtest1.c:71:9 */

// State structure for a Hash hash in progress
type HashContext = HashContext1 /* speedtest1.c:71:28 */

// All global state is held in this structure
type Global = struct {
	db            uintptr
	pStmt         uintptr
	iStart        sqlite3_int64
	iTotal        sqlite3_int64
	bWithoutRowid int32
	bReprepare    int32
	bSqlOnly      int32
	bExplain      int32
	bVerify       int32
	bMemShrink    int32
	eTemp         int32
	szTest        int32
	nRepeat       int32
	doCheckpoint  int32
	zWR           uintptr
	zNN           uintptr
	zPK           uintptr
	x             uint32
	y             uint32
	_             [4]byte
	nResByte      u64
	nResult       int32
	zResult       [3000]int8
	hashFile      uintptr
	hash          HashContext
	_             [5]byte
} /* speedtest1.c:81:8 */

// All global state is held in this structure
var g Global /* speedtest1.c:107:3: */

// Return " TEMP" or "", as appropriate for creating a table.
func isTemp(tls *libc.TLS, N int32) uintptr { /* speedtest1.c:111:19: */
	if g.eTemp >= N {
		return ts + 2146 /* " TEMP" */
	}
	return ts + 2152 /* "" */
}

// Print an error message and exit
func fatal_error(tls *libc.TLS, zMsg uintptr, va uintptr) { /* speedtest1.c:116:13: */
	var ap va_list
	_ = ap
	ap = va
	libc.Xvfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), zMsg, ap)
	_ = ap
	libc.Xexit(tls, 1)
}

// ***************************************************************************
//
// Hash algorithm used to verify that compilation is not miscompiled
// in such a was as to generate an incorrect result.

// Initialize a new hash.  iSize determines the size of the hash
// in bits and should be one of 224, 256, 384, or 512.  Or iSize
// can be zero to use the default hash size of 256 bits.
func HashInit(tls *libc.TLS) { /* speedtest1.c:135:13: */
	var k uint32
	g.hash.i = uint8(0)
	g.hash.j = uint8(0)
	for k = uint32(0); k < uint32(256); k++ {
		*(*uint8)(unsafe.Pointer((uintptr(unsafe.Pointer(&g)) + 3104 /* &.hash */ + 3 /* &.s */) + uintptr(k))) = uint8(k)
	}
}

// Make consecutive calls to the HashUpdate function to add new content
// to the hash
func HashUpdate(tls *libc.TLS, aData uintptr, nData uint32) { /* speedtest1.c:146:13: */
	var t uint8
	var i uint8 = g.hash.i
	var j uint8 = g.hash.j
	var k uint32
	if g.hashFile != 0 {
		libc.Xfwrite(tls, aData, uint32(1), nData, g.hashFile)
	}
	for k = uint32(0); k < nData; k++ {
		j = uint8(int32(j) + (int32(*(*uint8)(unsafe.Pointer((uintptr(unsafe.Pointer(&g)) + 3104 /* &.hash */ + 3 /* &.s */) + uintptr(i)))) + int32(*(*uint8)(unsafe.Pointer(aData + uintptr(k))))))
		t = *(*uint8)(unsafe.Pointer((uintptr(unsafe.Pointer(&g)) + 3104 /* &.hash */ + 3 /* &.s */) + uintptr(j)))
		*(*uint8)(unsafe.Pointer((uintptr(unsafe.Pointer(&g)) + 3104 /* &.hash */ + 3 /* &.s */) + uintptr(j))) = *(*uint8)(unsafe.Pointer((uintptr(unsafe.Pointer(&g)) + 3104 /* &.hash */ + 3 /* &.s */) + uintptr(i)))
		*(*uint8)(unsafe.Pointer((uintptr(unsafe.Pointer(&g)) + 3104 /* &.hash */ + 3 /* &.s */) + uintptr(i))) = t
		i++
	}
	g.hash.i = i
	g.hash.j = j
}

// After all content has been added, invoke HashFinal() to compute
// the final hash.  The hash result is stored in g.hash.r[].
func HashFinal(tls *libc.TLS) { /* speedtest1.c:170:13: */
	var k uint32
	var t uint8
	var i uint8
	var j uint8
	i = g.hash.i
	j = g.hash.j
	for k = uint32(0); k < uint32(32); k++ {
		i++
		t = *(*uint8)(unsafe.Pointer((uintptr(unsafe.Pointer(&g)) + 3104 /* &.hash */ + 3 /* &.s */) + uintptr(i)))
		j = uint8(int32(j) + (int32(t)))
		*(*uint8)(unsafe.Pointer((uintptr(unsafe.Pointer(&g)) + 3104 /* &.hash */ + 3 /* &.s */) + uintptr(i))) = *(*uint8)(unsafe.Pointer((uintptr(unsafe.Pointer(&g)) + 3104 /* &.hash */ + 3 /* &.s */) + uintptr(j)))
		*(*uint8)(unsafe.Pointer((uintptr(unsafe.Pointer(&g)) + 3104 /* &.hash */ + 3 /* &.s */) + uintptr(j))) = t
		t = uint8(int32(t) + (int32(*(*uint8)(unsafe.Pointer((uintptr(unsafe.Pointer(&g)) + 3104 /* &.hash */ + 3 /* &.s */) + uintptr(i))))))
		*(*uint8)(unsafe.Pointer((uintptr(unsafe.Pointer(&g)) + 3104 /* &.hash */ + 259 /* &.r */) + uintptr(k))) = *(*uint8)(unsafe.Pointer((uintptr(unsafe.Pointer(&g)) + 3104 /* &.hash */ + 3 /* &.s */) + uintptr(t)))
	}
}

// End of the Hash hashing logic
//

// Return the value of a hexadecimal digit.  Return -1 if the input
// is not a hex digit.
func hexDigitValue(tls *libc.TLS, c int8) int32 { /* speedtest1.c:194:12: */
	if (int32(c) >= '0') && (int32(c) <= '9') {
		return (int32(c) - '0')
	}
	if (int32(c) >= 'a') && (int32(c) <= 'f') {
		return ((int32(c) - 'a') + 10)
	}
	if (int32(c) >= 'A') && (int32(c) <= 'F') {
		return ((int32(c) - 'A') + 10)
	}
	return -1
}

// Provide an alternative to sqlite3_stricmp() in older versions of
// SQLite

// Interpret zArg as an integer value, possibly with suffixes.
func integerValue(tls *libc.TLS, zArg uintptr) int32 { /* speedtest1.c:210:12: */
	var v sqlite3_int64 = int64(0)
	var i int32
	var isNeg int32 = 0
	if int32(*(*int8)(unsafe.Pointer(zArg + uintptr(0)))) == '-' {
		isNeg = 1
		zArg++
	} else if int32(*(*int8)(unsafe.Pointer(zArg + uintptr(0)))) == '+' {
		zArg++
	}
	if (int32(*(*int8)(unsafe.Pointer(zArg + uintptr(0)))) == '0') && (int32(*(*int8)(unsafe.Pointer(zArg + uintptr(1)))) == 'x') {
		var x int32
		zArg += uintptr(2)
		for (libc.AssignInt32(&x, hexDigitValue(tls, *(*int8)(unsafe.Pointer(zArg + uintptr(0)))))) >= 0 {
			v = ((v << 4) + sqlite3_int64(x))
			zArg++
		}
	} else {
		for libc.Xisdigit(tls, int32(*(*int8)(unsafe.Pointer(zArg + uintptr(0))))) != 0 {
			v = (((v * int64(10)) + sqlite3_int64(*(*int8)(unsafe.Pointer(zArg + uintptr(0))))) - int64('0'))
			zArg++
		}
	}
	for i = 0; uint32(i) < (uint32(unsafe.Sizeof(aMult)) / uint32(unsafe.Sizeof(struct {
		zSuffix uintptr
		iMult   int32
	}{}))); i++ {
		if sqlite3.Xsqlite3_stricmp(tls, aMult[i].zSuffix, zArg) == 0 {
			v = v * (sqlite3_int64(aMult[i].iMult))
			break
		}
	}
	if v > int64(0x7fffffff) {
		fatal_error(tls, ts+2153 /* "parameter too la..." */, 0)
	}
	return func() int32 {
		if isNeg != 0 {
			return int32(-v)
		}
		return int32(v)
	}()
}

var aMult = [9]struct {
	zSuffix uintptr
	iMult   int32
}{
	{
		zSuffix: ts + 2190, /* "KiB" */
		iMult:   1024},
	{
		zSuffix: ts + 2194, /* "MiB" */
		iMult:   (1024 * 1024)},
	{
		zSuffix: ts + 2198, /* "GiB" */
		iMult:   ((1024 * 1024) * 1024)},
	{
		zSuffix: ts + 2202, /* "KB" */
		iMult:   1000},
	{
		zSuffix: ts + 2205, /* "MB" */
		iMult:   1000000},
	{
		zSuffix: ts + 2208, /* "GB" */
		iMult:   1000000000},
	{
		zSuffix: ts + 2211, /* "K" */
		iMult:   1000},
	{
		zSuffix: ts + 2213, /* "M" */
		iMult:   1000000},
	{
		zSuffix: ts + 2215, /* "G" */
		iMult:   1000000000},
} /* speedtest1.c:212:53 */

// Return the current wall-clock time, in milliseconds
func speedtest1_timestamp(tls *libc.TLS) sqlite3_int64 { /* speedtest1.c:255:15: */
	bp := tls.Alloc(16)
	defer tls.Free(16)

	// var t sqlite3_int64 at bp, 8

	if clockVfs == uintptr(0) {
		clockVfs = sqlite3.Xsqlite3_vfs_find(tls, uintptr(0))
	}
	if ((*sqlite3_vfs)(unsafe.Pointer(clockVfs)).iVersion >= 2) && ((*sqlite3_vfs)(unsafe.Pointer(clockVfs)).xCurrentTimeInt64 != uintptr(0)) {
		(*(*func(*libc.TLS, uintptr, uintptr) int32)(unsafe.Pointer((clockVfs + 72 /* &.xCurrentTimeInt64 */))))(tls, clockVfs, bp /* &t */)
	} else {
		// var r float64 at bp+8, 8

		(*(*func(*libc.TLS, uintptr, uintptr) int32)(unsafe.Pointer((clockVfs + 64 /* &.xCurrentTime */))))(tls, clockVfs, bp+8 /* &r */)
		*(*sqlite3_int64)(unsafe.Pointer(bp /* t */)) = (sqlite3_int64(*(*float64)(unsafe.Pointer(bp + 8 /* r */)) * 86400000.0))
	}
	return *(*sqlite3_int64)(unsafe.Pointer(bp /* t */))
}

var clockVfs uintptr = uintptr(0) /* speedtest1.c:259:22 */

// Return a pseudo-random unsigned integer
func speedtest1_random(tls *libc.TLS) uint32 { /* speedtest1.c:277:14: */
	g.x = ((g.x >> 1) ^ ((uint32(1) + ^(g.x & uint32(1))) & 0xd0000001))
	g.y = ((g.y * uint32(1103515245)) + uint32(12345))
	return (g.x ^ g.y)
}

// Map the value in within the range of 1...limit into another
// number in a way that is chatic and invertable.
func swizzle(tls *libc.TLS, in uint32, limit uint32) uint32 { /* speedtest1.c:286:10: */
	var out uint32 = uint32(0)
	for limit != 0 {
		out = ((out << 1) | (in & uint32(1)))
		in >>= 1
		limit >>= 1
	}
	return out
}

// Round up a number so that it is a power of two minus one
func roundup_allones(tls *libc.TLS, limit uint32) uint32 { /* speedtest1.c:298:10: */
	var m uint32 = uint32(1)
	for m < limit {
		m = ((m << 1) + uint32(1))
	}
	return m
}

// The speedtest1_numbername procedure below converts its argment (an integer)
// into a string which is the English-language name for that number.
// The returned string should be freed with sqlite3_free().
//
// Example:
//
//     speedtest1_numbername(123)   ->  "one hundred twenty three"
func speedtest1_numbername(tls *libc.TLS, n uint32, zOut uintptr, nOut int32) int32 { /* speedtest1.c:312:5: */
	bp := tls.Alloc(48)
	defer tls.Free(48)

	var i int32 = 0

	if n >= uint32(1000000000) {
		i = i + (speedtest1_numbername(tls, (n / uint32(1000000000)), (zOut + uintptr(i)), (nOut - i)))
		sqlite3.Xsqlite3_snprintf(tls, (nOut - i), (zOut + uintptr(i)), ts+2217 /* " billion" */, 0)
		i = i + (int32(libc.Xstrlen(tls, (zOut + uintptr(i)))))
		n = (n % uint32(1000000000))
	}
	if n >= uint32(1000000) {
		if (i != 0) && (i < (nOut - 1)) {
			*(*int8)(unsafe.Pointer(zOut + uintptr(libc.PostIncInt32(&i, 1)))) = int8(' ')
		}
		i = i + (speedtest1_numbername(tls, (n / uint32(1000000)), (zOut + uintptr(i)), (nOut - i)))
		sqlite3.Xsqlite3_snprintf(tls, (nOut - i), (zOut + uintptr(i)), ts+2226 /* " million" */, 0)
		i = i + (int32(libc.Xstrlen(tls, (zOut + uintptr(i)))))
		n = (n % uint32(1000000))
	}
	if n >= uint32(1000) {
		if (i != 0) && (i < (nOut - 1)) {
			*(*int8)(unsafe.Pointer(zOut + uintptr(libc.PostIncInt32(&i, 1)))) = int8(' ')
		}
		i = i + (speedtest1_numbername(tls, (n / uint32(1000)), (zOut + uintptr(i)), (nOut - i)))
		sqlite3.Xsqlite3_snprintf(tls, (nOut - i), (zOut + uintptr(i)), ts+2235 /* " thousand" */, 0)
		i = i + (int32(libc.Xstrlen(tls, (zOut + uintptr(i)))))
		n = (n % uint32(1000))
	}
	if n >= uint32(100) {
		if (i != 0) && (i < (nOut - 1)) {
			*(*int8)(unsafe.Pointer(zOut + uintptr(libc.PostIncInt32(&i, 1)))) = int8(' ')
		}
		sqlite3.Xsqlite3_snprintf(tls, (nOut - i), (zOut + uintptr(i)), ts+2245 /* "%s hundred" */, libc.VaList(bp, ones[(n/uint32(100))]))
		i = i + (int32(libc.Xstrlen(tls, (zOut + uintptr(i)))))
		n = (n % uint32(100))
	}
	if n >= uint32(20) {
		if (i != 0) && (i < (nOut - 1)) {
			*(*int8)(unsafe.Pointer(zOut + uintptr(libc.PostIncInt32(&i, 1)))) = int8(' ')
		}
		sqlite3.Xsqlite3_snprintf(tls, (nOut - i), (zOut + uintptr(i)), ts+2256 /* "%s" */, libc.VaList(bp+16, tens[(n/uint32(10))]))
		i = i + (int32(libc.Xstrlen(tls, (zOut + uintptr(i)))))
		n = (n % uint32(10))
	}
	if n > uint32(0) {
		if (i != 0) && (i < (nOut - 1)) {
			*(*int8)(unsafe.Pointer(zOut + uintptr(libc.PostIncInt32(&i, 1)))) = int8(' ')
		}
		sqlite3.Xsqlite3_snprintf(tls, (nOut - i), (zOut + uintptr(i)), ts+2256 /* "%s" */, libc.VaList(bp+32, ones[n]))
		i = i + (int32(libc.Xstrlen(tls, (zOut + uintptr(i)))))
	}
	if i == 0 {
		sqlite3.Xsqlite3_snprintf(tls, (nOut - i), (zOut + uintptr(i)), ts+2259 /* "zero" */, 0)
		i = i + (int32(libc.Xstrlen(tls, (zOut + uintptr(i)))))
	}
	return i
}

var ones = [20]uintptr{ts + 2259 /* "zero" */, ts + 2264 /* "one" */, ts + 2268 /* "two" */, ts + 2272 /* "three" */, ts + 2278 /* "four" */, ts + 2283, /* "five" */
	ts + 2288 /* "six" */, ts + 2292 /* "seven" */, ts + 2298 /* "eight" */, ts + 2304 /* "nine" */, ts + 2309 /* "ten" */, ts + 2313 /* "eleven" */, ts + 2320, /* "twelve" */
	ts + 2327 /* "thirteen" */, ts + 2336 /* "fourteen" */, ts + 2345 /* "fifteen" */, ts + 2353 /* "sixteen" */, ts + 2361, /* "seventeen" */
																	ts + 2371 /* "eighteen" */, ts + 2380 /* "nineteen" */} /* speedtest1.c:313:21 */
var tens = [10]uintptr{ts + 2152 /* "" */, ts + 2309 /* "ten" */, ts + 2389 /* "twenty" */, ts + 2396 /* "thirty" */, ts + 2403, /* "forty" */
	ts + 2409 /* "fifty" */, ts + 2415 /* "sixty" */, ts + 2421 /* "seventy" */, ts + 2429 /* "eighty" */, ts + 2436 /* "ninety" */} /* speedtest1.c:317:21 */

// Start a new test case
var zDots = *(*[72]int8)(unsafe.Pointer(ts + 2443 /* "..................." */)) /* speedtest1.c:368:19 */

func speedtest1_begin_test(tls *libc.TLS, iTestNum int32, zTestName uintptr, va uintptr) { /* speedtest1.c:370:6: */
	bp := tls.Alloc(80)
	defer tls.Free(80)

	var n int32 = int32(libc.Xstrlen(tls, zTestName))
	var zName uintptr
	var ap va_list
	_ = ap
	ap = va
	zName = sqlite3.Xsqlite3_vmprintf(tls, zTestName, ap)
	_ = ap
	n = int32(libc.Xstrlen(tls, zName))
	if n > 60 {
		*(*int8)(unsafe.Pointer(zName + uintptr(60))) = int8(0)
		n = 60
	}
	if g.bSqlOnly != 0 {
		libc.Xprintf(tls, ts+2515 /* "/* %4d - %s%.*s ..." */, libc.VaList(bp, iTestNum, zName, (60-n), uintptr(unsafe.Pointer(&zDots))))
	} else {
		libc.Xprintf(tls, ts+2535 /* "%4d - %s%.*s " */, libc.VaList(bp+40, iTestNum, zName, (60-n), uintptr(unsafe.Pointer(&zDots))))
		libc.Xfflush(tls, libc.X__acrt_iob_func(tls, uint32(1)))
	}
	sqlite3.Xsqlite3_free(tls, zName)
	g.nResult = 0
	g.iStart = speedtest1_timestamp(tls)
	g.x = 0xad131d0b
	g.y = uint32(0x44f9eac8)
}

// Complete a test case
func speedtest1_end_test(tls *libc.TLS) { /* speedtest1.c:399:6: */
	bp := tls.Alloc(24)
	defer tls.Free(24)

	var iElapseTime sqlite3_int64 = (speedtest1_timestamp(tls) - g.iStart)
	if g.doCheckpoint != 0 {
		speedtest1_exec(tls, ts+2549 /* "PRAGMA wal_check..." */, 0)
	}
	if !(g.bSqlOnly != 0) {
		*(*sqlite3_int64)(unsafe.Pointer(uintptr(unsafe.Pointer(&g)) + 16 /* &.iTotal */)) += (iElapseTime)
		libc.Xprintf(tls, ts+2572 /* "%4d.%03ds\n" */, libc.VaList(bp, (int32(iElapseTime/int64(1000))), (int32(iElapseTime%int64(1000)))))
	}
	if g.pStmt != 0 {
		sqlite3.Xsqlite3_finalize(tls, g.pStmt)
		g.pStmt = uintptr(0)
	}
}

// Report end of testing
func speedtest1_final(tls *libc.TLS) { /* speedtest1.c:413:6: */
	bp := tls.Alloc(72)
	defer tls.Free(72)

	if !(g.bSqlOnly != 0) {
		libc.Xprintf(tls, ts+2583 /* "       TOTAL%.*s..." */, libc.VaList(bp, (60-5), uintptr(unsafe.Pointer(&zDots)),
			(int32(g.iTotal/int64(1000))), (int32(g.iTotal%int64(1000)))))
	}
	if g.bVerify != 0 {
		var i int32
		libc.Xprintf(tls, ts+2611 /* "Verification Has..." */, libc.VaList(bp+40, g.nResByte))
		HashUpdate(tls, ts+2636 /* "\n" */, uint32(1))
		HashFinal(tls)
		for i = 0; i < 24; i++ {
			libc.Xprintf(tls, ts+2638 /* "%02x" */, libc.VaList(bp+56, int32(*(*uint8)(unsafe.Pointer((uintptr(unsafe.Pointer(&g)) + 3104 /* &.hash */ + 259 /* &.r */) + uintptr(i))))))
		}
		if (g.hashFile != 0) && (g.hashFile != (libc.X__acrt_iob_func(tls, uint32(1)))) {
			libc.Xfclose(tls, g.hashFile)
		}
		libc.Xprintf(tls, ts+2636 /* "\n" */, 0)
	}
}

// Print an SQL statement to standard output
func printSql(tls *libc.TLS, zSql uintptr) { /* speedtest1.c:436:13: */
	bp := tls.Alloc(48)
	defer tls.Free(48)

	var n int32 = int32(libc.Xstrlen(tls, zSql))
	for (n > 0) && ((int32(*(*int8)(unsafe.Pointer(zSql + uintptr((n - 1))))) == ';') || (libc.Xisspace(tls, int32(uint8(*(*int8)(unsafe.Pointer(zSql + uintptr((n - 1))))))) != 0)) {
		n--
	}
	if g.bExplain != 0 {
		libc.Xprintf(tls, ts+2643 /* "EXPLAIN " */, 0)
	}
	libc.Xprintf(tls, ts+2652 /* "%.*s;\n" */, libc.VaList(bp, n, zSql))
	if (g.bExplain != 0) &&
		(((sqlite3.Xsqlite3_strglob(tls, ts+2659 /* "CREATE *" */, zSql) == 0) ||
			(sqlite3.Xsqlite3_strglob(tls, ts+2668 /* "DROP *" */, zSql) == 0)) ||
			(sqlite3.Xsqlite3_strglob(tls, ts+2675 /* "ALTER *" */, zSql) == 0)) {
		libc.Xprintf(tls, ts+2652 /* "%.*s;\n" */, libc.VaList(bp+24, n, zSql))
	}
}

// Shrink memory used, if appropriate and if the SQLite version is capable
// of doing so.
func speedtest1_shrink_memory(tls *libc.TLS) { /* speedtest1.c:456:6: */
	if g.bMemShrink != 0 {
		sqlite3.Xsqlite3_db_release_memory(tls, g.db)
	}
}

// Run SQL
func speedtest1_exec(tls *libc.TLS, zFormat uintptr, va uintptr) { /* speedtest1.c:463:6: */
	bp := tls.Alloc(44)
	defer tls.Free(44)

	var ap va_list
	_ = ap
	var zSql uintptr
	ap = va
	zSql = sqlite3.Xsqlite3_vmprintf(tls, zFormat, ap)
	_ = ap
	if g.bSqlOnly != 0 {
		printSql(tls, zSql)
	} else {
		*(*uintptr)(unsafe.Pointer(bp + 40 /* zErrMsg */)) = uintptr(0)
		var rc int32 = sqlite3.Xsqlite3_exec(tls, g.db, zSql, uintptr(0), uintptr(0), bp+40 /* &zErrMsg */)
		if *(*uintptr)(unsafe.Pointer(bp + 40 /* zErrMsg */)) != 0 {
			fatal_error(tls, ts+2683 /* "SQL error: %s\n%s..." */, libc.VaList(bp, *(*uintptr)(unsafe.Pointer(bp + 40 /* zErrMsg */)), zSql))
		}
		if rc != 0 {
			fatal_error(tls, ts+2701 /* "exec error: %s\n" */, libc.VaList(bp+24, sqlite3.Xsqlite3_errmsg(tls, g.db)))
		}
	}
	sqlite3.Xsqlite3_free(tls, zSql)
	speedtest1_shrink_memory(tls)
}

// Run SQL and return the first column of the first row as a string.  The
// returned string is obtained from sqlite_malloc() and must be freed by
// the caller.
func speedtest1_once(tls *libc.TLS, zFormat uintptr, va uintptr) uintptr { /* speedtest1.c:485:6: */
	bp := tls.Alloc(36)
	defer tls.Free(36)

	var ap va_list
	_ = ap
	var zSql uintptr
	// var pStmt uintptr at bp+32, 4

	var zResult uintptr = uintptr(0)
	ap = va
	zSql = sqlite3.Xsqlite3_vmprintf(tls, zFormat, ap)
	_ = ap
	if g.bSqlOnly != 0 {
		printSql(tls, zSql)
	} else {
		var rc int32 = sqlite3.Xsqlite3_prepare_v2(tls, g.db, zSql, -1, bp+32 /* &pStmt */, uintptr(0))
		if rc != 0 {
			fatal_error(tls, ts+2717 /* "SQL error: %s\n" */, libc.VaList(bp, sqlite3.Xsqlite3_errmsg(tls, g.db)))
		}
		if sqlite3.Xsqlite3_step(tls, *(*uintptr)(unsafe.Pointer(bp + 32 /* pStmt */))) == 100 {
			var z uintptr = sqlite3.Xsqlite3_column_text(tls, *(*uintptr)(unsafe.Pointer(bp + 32 /* pStmt */)), 0)
			if z != 0 {
				zResult = sqlite3.Xsqlite3_mprintf(tls, ts+2256 /* "%s" */, libc.VaList(bp+16, z))
			}
		}
		sqlite3.Xsqlite3_finalize(tls, *(*uintptr)(unsafe.Pointer(bp + 32 /* pStmt */)))
	}
	sqlite3.Xsqlite3_free(tls, zSql)
	speedtest1_shrink_memory(tls)
	return zResult
}

// Prepare an SQL statement
func speedtest1_prepare(tls *libc.TLS, zFormat uintptr, va uintptr) { /* speedtest1.c:512:6: */
	bp := tls.Alloc(16)
	defer tls.Free(16)

	var ap va_list
	_ = ap
	var zSql uintptr
	ap = va
	zSql = sqlite3.Xsqlite3_vmprintf(tls, zFormat, ap)
	_ = ap
	if g.bSqlOnly != 0 {
		printSql(tls, zSql)
	} else {
		var rc int32
		if g.pStmt != 0 {
			sqlite3.Xsqlite3_finalize(tls, g.pStmt)
		}
		rc = sqlite3.Xsqlite3_prepare_v2(tls, g.db, zSql, -1, (uintptr(unsafe.Pointer(&g)) + 4 /* &.pStmt */), uintptr(0))
		if rc != 0 {
			fatal_error(tls, ts+2717 /* "SQL error: %s\n" */, libc.VaList(bp, sqlite3.Xsqlite3_errmsg(tls, g.db)))
		}
	}
	sqlite3.Xsqlite3_free(tls, zSql)
}

// Run an SQL statement previously prepared
func speedtest1_run(tls *libc.TLS) { /* speedtest1.c:532:6: */
	bp := tls.Alloc(8)
	defer tls.Free(8)

	var i int32
	var n int32
	var len int32
	if g.bSqlOnly != 0 {
		return
	}

	g.nResult = 0
	for sqlite3.Xsqlite3_step(tls, g.pStmt) == 100 {
		n = sqlite3.Xsqlite3_column_count(tls, g.pStmt)
		for i = 0; i < n; i++ {
			var z uintptr = sqlite3.Xsqlite3_column_text(tls, g.pStmt, i)
			if z == uintptr(0) {
				z = ts + 2732 /* "nil" */
			}
			len = int32(libc.Xstrlen(tls, z))
			if g.bVerify != 0 {
				var eType int32 = sqlite3.Xsqlite3_column_type(tls, g.pStmt, i)
				// var zPrefix [2]uint8 at bp, 2

				*(*uint8)(unsafe.Pointer(bp /* &zPrefix[0] */ + uintptr(0))) = uint8('\n')
				*(*uint8)(unsafe.Pointer(bp /* &zPrefix[0] */ + uintptr(1))) = uint8(*(*int8)(unsafe.Pointer(ts + 2736 /* "-IFTBN" */ + uintptr(eType))))
				if g.nResByte != 0 {
					HashUpdate(tls, bp /* &zPrefix[0] */, uint32(2))
				} else {
					HashUpdate(tls, (bp /* &zPrefix[0] */ + uintptr(1)), uint32(1))
				}
				if eType == 2 {
					// Omit the value of floating-point results from the verification
					// hash.  The only thing we record is the fact that the result was
					// a floating-point value.
					*(*u64)(unsafe.Pointer(uintptr(unsafe.Pointer(&g)) + 88 /* &.nResByte */)) += (uint64(2))
				} else if eType == 4 {
					var nBlob int32 = sqlite3.Xsqlite3_column_bytes(tls, g.pStmt, i)
					var iBlob int32
					// var zChar [2]uint8 at bp+2, 2

					var aBlob uintptr = sqlite3.Xsqlite3_column_blob(tls, g.pStmt, i)
					for iBlob = 0; iBlob < nBlob; iBlob++ {
						*(*uint8)(unsafe.Pointer(bp + 2 /* &zChar[0] */ + uintptr(0))) = uint8(*(*int8)(unsafe.Pointer(ts + 2743 /* "0123456789abcdef" */ + uintptr((int32(*(*uint8)(unsafe.Pointer(aBlob + uintptr(iBlob)))) >> 4)))))
						*(*uint8)(unsafe.Pointer(bp + 2 /* &zChar[0] */ + uintptr(1))) = uint8(*(*int8)(unsafe.Pointer(ts + 2743 /* "0123456789abcdef" */ + uintptr((int32(*(*uint8)(unsafe.Pointer(aBlob + uintptr(iBlob)))) & 15)))))
						HashUpdate(tls, bp+2 /* &zChar[0] */, uint32(2))
					}
					*(*u64)(unsafe.Pointer(uintptr(unsafe.Pointer(&g)) + 88 /* &.nResByte */)) += (u64((nBlob * 2) + 2))
				} else {
					HashUpdate(tls, z, uint32(len))
					*(*u64)(unsafe.Pointer(uintptr(unsafe.Pointer(&g)) + 88 /* &.nResByte */)) += (u64(len + 2))
				}
			}
			if (uint32(g.nResult + len)) < (uint32(unsafe.Sizeof([3000]int8{})) - uint32(2)) {
				if g.nResult > 0 {
					*(*int8)(unsafe.Pointer((uintptr(unsafe.Pointer(&g)) + 100 /* &.zResult */) + uintptr(libc.PostIncInt32(&g.nResult, 1)))) = int8(' ')
				}
				libc.Xmemcpy(tls, ((uintptr(unsafe.Pointer(&g)) + 100 /* &.zResult */) + uintptr(g.nResult)), z, (uint32(len + 1)))
				*(*int32)(unsafe.Pointer(uintptr(unsafe.Pointer(&g)) + 96 /* &.nResult */)) += (len)
			}
		}
	}
	if g.bReprepare != 0 {
		// var pNew uintptr at bp+4, 4

		sqlite3.Xsqlite3_prepare_v2(tls, g.db, sqlite3.Xsqlite3_sql(tls, g.pStmt), -1, bp+4 /* &pNew */, uintptr(0))
		sqlite3.Xsqlite3_finalize(tls, g.pStmt)
		g.pStmt = *(*uintptr)(unsafe.Pointer(bp + 4 /* pNew */))
	} else {
		sqlite3.Xsqlite3_reset(tls, g.pStmt)
	}
	speedtest1_shrink_memory(tls)
}

// The sqlite3_trace() callback function
func traceCallback(tls *libc.TLS, NotUsed uintptr, zSql uintptr) { /* speedtest1.c:599:13: */
	bp := tls.Alloc(24)
	defer tls.Free(24)

	var n int32 = int32(libc.Xstrlen(tls, zSql))
	for (n > 0) && ((int32(*(*int8)(unsafe.Pointer(zSql + uintptr((n - 1))))) == ';') || (libc.Xisspace(tls, int32(uint8(*(*int8)(unsafe.Pointer(zSql + uintptr((n - 1))))))) != 0)) {
		n--
	}
	libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+2652 /* "%.*s;\n" */, libc.VaList(bp, n, zSql))
}

// Substitute random() function that gives the same random
// sequence on each run, for repeatability.
func randomFunc(tls *libc.TLS, context uintptr, NotUsed int32, NotUsed2 uintptr) { /* speedtest1.c:608:13: */
	sqlite3.Xsqlite3_result_int64(tls, context, sqlite3_int64(speedtest1_random(tls)))
}

// Estimate the square root of an integer
func est_square_root(tls *libc.TLS, x int32) int32 { /* speedtest1.c:617:12: */
	var y0 int32 = (x / 2)
	var y1 int32
	var n int32
	for n = 0; (y0 > 0) && (n < 10); n++ {
		y1 = ((y0 + (x / y0)) / 2)
		if y1 == y0 {
			break
		}
		y0 = y1
	}
	return y0
}

// The main and default testset
func testset_main(tls *libc.TLS) { /* speedtest1.c:694:6: */
	bp := tls.Alloc(2968)
	defer tls.Free(2968)

	var i int32    // Loop counter
	var n int32    // iteration count
	var sz int32   // Size of the tables
	var maxb int32 // Maximum swizzled value
	var x1 uint32 = uint32(0)
	var x2 uint32 = uint32(0) // Parameters
	var len int32 = 0         // Length of the zNum[] string
	// var zNum [2000]int8 at bp+968, 2000
	// A number name

	sz = libc.AssignInt32(&n, (g.szTest * 500))
	*(*int8)(unsafe.Pointer(bp + 968 /* &zNum[0] */ + uintptr(0))) = int8(0)
	maxb = int32(roundup_allones(tls, uint32(sz)))
	speedtest1_begin_test(tls, 100, ts+2760 /* "%d INSERTs into ..." */, libc.VaList(bp, n))
	speedtest1_exec(tls, ts+2796 /* "BEGIN" */, 0)
	speedtest1_exec(tls, ts+2802, /* "CREATE%s TABLE t..." */
		libc.VaList(bp+16, isTemp(tls, 9), g.zNN, g.zNN, g.zNN))
	speedtest1_prepare(tls, ts+2860 /* "INSERT INTO t1 V..." */, libc.VaList(bp+56, n))
	for i = 1; i <= n; i++ {
		x1 = swizzle(tls, uint32(i), uint32(maxb))
		speedtest1_numbername(tls, x1, bp+968 /* &zNum[0] */, int32(unsafe.Sizeof([2000]int8{})))
		sqlite3.Xsqlite3_bind_int64(tls, g.pStmt, 1, sqlite3_int64(x1))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 2, i)
		sqlite3.Xsqlite3_bind_text(tls, g.pStmt, 3, bp+968 /* &zNum[0] */, -1, uintptr(0))
		speedtest1_run(tls)
	}
	speedtest1_exec(tls, ts+2906 /* "COMMIT" */, 0)
	speedtest1_end_test(tls)

	n = sz
	speedtest1_begin_test(tls, 110, ts+2913 /* "%d ordered INSER..." */, libc.VaList(bp+72, n))
	speedtest1_exec(tls, ts+2796 /* "BEGIN" */, 0)
	speedtest1_exec(tls,
		ts+2950, /* "CREATE%s TABLE t..." */
		libc.VaList(bp+88, isTemp(tls, 5), g.zNN, g.zPK, g.zNN, g.zNN, g.zWR))
	speedtest1_prepare(tls, ts+3013 /* "INSERT INTO t2 V..." */, libc.VaList(bp+144, n))
	for i = 1; i <= n; i++ {
		x1 = swizzle(tls, uint32(i), uint32(maxb))
		speedtest1_numbername(tls, x1, bp+968 /* &zNum[0] */, int32(unsafe.Sizeof([2000]int8{})))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, i)
		sqlite3.Xsqlite3_bind_int64(tls, g.pStmt, 2, sqlite3_int64(x1))
		sqlite3.Xsqlite3_bind_text(tls, g.pStmt, 3, bp+968 /* &zNum[0] */, -1, uintptr(0))
		speedtest1_run(tls)
	}
	speedtest1_exec(tls, ts+2906 /* "COMMIT" */, 0)
	speedtest1_end_test(tls)

	n = sz
	speedtest1_begin_test(tls, 120, ts+3058 /* "%d unordered INS..." */, libc.VaList(bp+160, n))
	speedtest1_exec(tls, ts+2796 /* "BEGIN" */, 0)
	speedtest1_exec(tls,
		ts+3097, /* "CREATE%s TABLE t..." */
		libc.VaList(bp+176, isTemp(tls, 3), g.zNN, g.zPK, g.zNN, g.zNN, g.zWR))
	speedtest1_prepare(tls, ts+3160 /* "INSERT INTO t3 V..." */, libc.VaList(bp+232, n))
	for i = 1; i <= n; i++ {
		x1 = swizzle(tls, uint32(i), uint32(maxb))
		speedtest1_numbername(tls, x1, bp+968 /* &zNum[0] */, int32(unsafe.Sizeof([2000]int8{})))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 2, i)
		sqlite3.Xsqlite3_bind_int64(tls, g.pStmt, 1, sqlite3_int64(x1))
		sqlite3.Xsqlite3_bind_text(tls, g.pStmt, 3, bp+968 /* &zNum[0] */, -1, uintptr(0))
		speedtest1_run(tls)
	}
	speedtest1_exec(tls, ts+2906 /* "COMMIT" */, 0)
	speedtest1_end_test(tls)

	n = 25
	speedtest1_begin_test(tls, 130, ts+3205 /* "%d SELECTS, nume..." */, libc.VaList(bp+248, n))
	speedtest1_exec(tls, ts+2796 /* "BEGIN" */, 0)
	speedtest1_prepare(tls,

		ts+3244 /* "SELECT count(*),..." */, libc.VaList(bp+264, n))
	for i = 1; i <= n; i++ {
		if ((i - 1) % g.nRepeat) == 0 {
			x1 = (speedtest1_random(tls) % uint32(maxb))
			x2 = (((speedtest1_random(tls) % uint32(10)) + (uint32(sz / 5000))) + x1)
		}
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, int32(x1))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 2, int32(x2))
		speedtest1_run(tls)
	}
	speedtest1_exec(tls, ts+2906 /* "COMMIT" */, 0)
	speedtest1_end_test(tls)

	n = 10
	speedtest1_begin_test(tls, 140, ts+3349 /* "%d SELECTS, LIKE..." */, libc.VaList(bp+280, n))
	speedtest1_exec(tls, ts+2796 /* "BEGIN" */, 0)
	speedtest1_prepare(tls,

		ts+3377 /* "SELECT count(*),..." */, libc.VaList(bp+296, n))
	for i = 1; i <= n; i++ {
		if ((i - 1) % g.nRepeat) == 0 {
			x1 = (speedtest1_random(tls) % uint32(maxb))
			*(*int8)(unsafe.Pointer(bp + 968 /* &zNum[0] */ + uintptr(0))) = int8('%')
			len = speedtest1_numbername(tls, uint32(i), (bp + 968 /* &zNum[0] */ + uintptr(1)), (int32(uint32(unsafe.Sizeof([2000]int8{})) - uint32(2))))
			*(*int8)(unsafe.Pointer(bp + 968 /* &zNum[0] */ + uintptr(len))) = int8('%')
			*(*int8)(unsafe.Pointer(bp + 968 /* &zNum[0] */ + uintptr((len + 1)))) = int8(0)
		}
		sqlite3.Xsqlite3_bind_text(tls, g.pStmt, 1, bp+968 /* &zNum[0] */, (len + 1), uintptr(0))
		speedtest1_run(tls)
	}
	speedtest1_exec(tls, ts+2906 /* "COMMIT" */, 0)
	speedtest1_end_test(tls)

	n = 10
	speedtest1_begin_test(tls, 142, ts+3472 /* "%d SELECTS w/ORD..." */, libc.VaList(bp+312, n))
	speedtest1_exec(tls, ts+2796 /* "BEGIN" */, 0)
	speedtest1_prepare(tls,

		ts+3505 /* "SELECT a, b, c F..." */, libc.VaList(bp+328, n))
	for i = 1; i <= n; i++ {
		if ((i - 1) % g.nRepeat) == 0 {
			x1 = (speedtest1_random(tls) % uint32(maxb))
			*(*int8)(unsafe.Pointer(bp + 968 /* &zNum[0] */ + uintptr(0))) = int8('%')
			len = speedtest1_numbername(tls, uint32(i), (bp + 968 /* &zNum[0] */ + uintptr(1)), (int32(uint32(unsafe.Sizeof([2000]int8{})) - uint32(2))))
			*(*int8)(unsafe.Pointer(bp + 968 /* &zNum[0] */ + uintptr(len))) = int8('%')
			*(*int8)(unsafe.Pointer(bp + 968 /* &zNum[0] */ + uintptr((len + 1)))) = int8(0)
		}
		sqlite3.Xsqlite3_bind_text(tls, g.pStmt, 1, bp+968 /* &zNum[0] */, (len + 1), uintptr(0))
		speedtest1_run(tls)
	}
	speedtest1_exec(tls, ts+2906 /* "COMMIT" */, 0)
	speedtest1_end_test(tls)

	n = 10 // g.szTest/5;
	speedtest1_begin_test(tls, 145, ts+3569 /* "%d SELECTS w/ORD..." */, libc.VaList(bp+344, n))
	speedtest1_exec(tls, ts+2796 /* "BEGIN" */, 0)
	speedtest1_prepare(tls,

		ts+3612 /* "SELECT a, b, c F..." */, libc.VaList(bp+360, n))
	for i = 1; i <= n; i++ {
		if ((i - 1) % g.nRepeat) == 0 {
			x1 = (speedtest1_random(tls) % uint32(maxb))
			*(*int8)(unsafe.Pointer(bp + 968 /* &zNum[0] */ + uintptr(0))) = int8('%')
			len = speedtest1_numbername(tls, uint32(i), (bp + 968 /* &zNum[0] */ + uintptr(1)), (int32(uint32(unsafe.Sizeof([2000]int8{})) - uint32(2))))
			*(*int8)(unsafe.Pointer(bp + 968 /* &zNum[0] */ + uintptr(len))) = int8('%')
			*(*int8)(unsafe.Pointer(bp + 968 /* &zNum[0] */ + uintptr((len + 1)))) = int8(0)
		}
		sqlite3.Xsqlite3_bind_text(tls, g.pStmt, 1, bp+968 /* &zNum[0] */, (len + 1), uintptr(0))
		speedtest1_run(tls)
	}
	speedtest1_exec(tls, ts+2906 /* "COMMIT" */, 0)
	speedtest1_end_test(tls)

	speedtest1_begin_test(tls, 150, ts+3685 /* "CREATE INDEX fiv..." */, 0)
	speedtest1_exec(tls, ts+3709 /* "BEGIN;" */, 0)
	speedtest1_exec(tls, ts+3716 /* "CREATE UNIQUE IN..." */, 0)
	speedtest1_exec(tls, ts+3750 /* "CREATE INDEX t1c..." */, 0)
	speedtest1_exec(tls, ts+3777 /* "CREATE UNIQUE IN..." */, 0)
	speedtest1_exec(tls, ts+3811 /* "CREATE INDEX t2c..." */, 0)
	speedtest1_exec(tls, ts+3843 /* "CREATE INDEX t3b..." */, 0)
	speedtest1_exec(tls, ts+3873 /* "COMMIT;" */, 0)
	speedtest1_end_test(tls)

	n = (sz / 5)
	speedtest1_begin_test(tls, 160, ts+3881 /* "%d SELECTS, nume..." */, libc.VaList(bp+376, n))
	speedtest1_exec(tls, ts+2796 /* "BEGIN" */, 0)
	speedtest1_prepare(tls,

		ts+3918 /* "SELECT count(*),..." */, libc.VaList(bp+392, n))
	for i = 1; i <= n; i++ {
		if ((i - 1) % g.nRepeat) == 0 {
			x1 = (speedtest1_random(tls) % uint32(maxb))
			x2 = (((speedtest1_random(tls) % uint32(10)) + (uint32(sz / 5000))) + x1)
		}
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, int32(x1))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 2, int32(x2))
		speedtest1_run(tls)
	}
	speedtest1_exec(tls, ts+2906 /* "COMMIT" */, 0)
	speedtest1_end_test(tls)

	n = (sz / 5)
	speedtest1_begin_test(tls, 161, ts+4023 /* "%d SELECTS, nume..." */, libc.VaList(bp+408, n))
	speedtest1_exec(tls, ts+2796 /* "BEGIN" */, 0)
	speedtest1_prepare(tls,

		ts+4055 /* "SELECT count(*),..." */, libc.VaList(bp+424, n))
	for i = 1; i <= n; i++ {
		if ((i - 1) % g.nRepeat) == 0 {
			x1 = (speedtest1_random(tls) % uint32(maxb))
			x2 = (((speedtest1_random(tls) % uint32(10)) + (uint32(sz / 5000))) + x1)
		}
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, int32(x1))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 2, int32(x2))
		speedtest1_run(tls)
	}
	speedtest1_exec(tls, ts+2906 /* "COMMIT" */, 0)
	speedtest1_end_test(tls)

	n = (sz / 5)
	speedtest1_begin_test(tls, 170, ts+4160 /* "%d SELECTS, text..." */, libc.VaList(bp+440, n))
	speedtest1_exec(tls, ts+2796 /* "BEGIN" */, 0)
	speedtest1_prepare(tls,

		ts+4194 /* "SELECT count(*),..." */, libc.VaList(bp+456, n))
	for i = 1; i <= n; i++ {
		if ((i - 1) % g.nRepeat) == 0 {
			x1 = swizzle(tls, uint32(i), uint32(maxb))
			len = speedtest1_numbername(tls, x1, bp+968 /* &zNum[0] */, (int32(uint32(unsafe.Sizeof([2000]int8{})) - uint32(1))))
		}
		sqlite3.Xsqlite3_bind_text(tls, g.pStmt, 1, bp+968 /* &zNum[0] */, len, uintptr(0))
		speedtest1_run(tls)
	}
	speedtest1_exec(tls, ts+2906 /* "COMMIT" */, 0)
	speedtest1_end_test(tls)

	n = sz
	speedtest1_begin_test(tls, 180, ts+4306 /* "%d INSERTS with ..." */, libc.VaList(bp+472, n))
	speedtest1_exec(tls, ts+2796 /* "BEGIN" */, 0)
	speedtest1_exec(tls,

		ts+4336, /* "CREATE%s TABLE t..." */
		libc.VaList(bp+488, isTemp(tls, 1), g.zNN, g.zPK, g.zNN, g.zNN, g.zWR))
	speedtest1_exec(tls, ts+4407 /* "CREATE INDEX t4b..." */, 0)
	speedtest1_exec(tls, ts+4433 /* "CREATE INDEX t4c..." */, 0)
	speedtest1_exec(tls, ts+4459 /* "INSERT INTO t4 S..." */, 0)
	speedtest1_exec(tls, ts+2906 /* "COMMIT" */, 0)
	speedtest1_end_test(tls)

	n = sz
	speedtest1_begin_test(tls, 190, ts+4491 /* "DELETE and REFIL..." */, libc.VaList(bp+544, n))
	speedtest1_exec(tls, ts+4519 /* "DELETE FROM t2;" */, 0)
	speedtest1_exec(tls, ts+4535 /* "INSERT INTO t2 S..." */, 0)
	speedtest1_end_test(tls)

	speedtest1_begin_test(tls, 200, ts+4568 /* "VACUUM" */, 0)
	speedtest1_exec(tls, ts+4568 /* "VACUUM" */, 0)
	speedtest1_end_test(tls)

	speedtest1_begin_test(tls, 210, ts+4575 /* "ALTER TABLE ADD ..." */, 0)
	speedtest1_exec(tls, ts+4609 /* "ALTER TABLE t2 A..." */, 0)
	speedtest1_exec(tls, ts+4649 /* "SELECT sum(d) FR..." */, 0)
	speedtest1_end_test(tls)

	n = (sz / 5)
	speedtest1_begin_test(tls, 230, ts+4671 /* "%d UPDATES, nume..." */, libc.VaList(bp+560, n))
	speedtest1_exec(tls, ts+2796 /* "BEGIN" */, 0)
	speedtest1_prepare(tls,
		ts+4708 /* "UPDATE t2 SET d=..." */, libc.VaList(bp+576, n))
	for i = 1; i <= n; i++ {
		x1 = (speedtest1_random(tls) % uint32(maxb))
		x2 = (((speedtest1_random(tls) % uint32(10)) + (uint32(sz / 5000))) + x1)
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, int32(x1))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 2, int32(x2))
		speedtest1_run(tls)
	}
	speedtest1_exec(tls, ts+2906 /* "COMMIT" */, 0)
	speedtest1_end_test(tls)

	n = sz
	speedtest1_begin_test(tls, 240, ts+4767 /* "%d UPDATES of in..." */, libc.VaList(bp+592, n))
	speedtest1_exec(tls, ts+2796 /* "BEGIN" */, 0)
	speedtest1_prepare(tls,
		ts+4797 /* "UPDATE t2 SET d=..." */, libc.VaList(bp+608, n))
	for i = 1; i <= n; i++ {
		x1 = ((speedtest1_random(tls) % uint32(sz)) + uint32(1))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, int32(x1))
		speedtest1_run(tls)
	}
	speedtest1_exec(tls, ts+2906 /* "COMMIT" */, 0)
	speedtest1_end_test(tls)

	speedtest1_begin_test(tls, 250, ts+4841 /* "One big UPDATE o..." */, libc.VaList(bp+624, sz))
	speedtest1_exec(tls, ts+4882 /* "UPDATE t2 SET d=..." */, 0)
	speedtest1_end_test(tls)

	speedtest1_begin_test(tls, 260, ts+4902 /* "Query added colu..." */, 0)
	speedtest1_exec(tls, ts+4649 /* "SELECT sum(d) FR..." */, 0)
	speedtest1_end_test(tls)

	n = (sz / 5)
	speedtest1_begin_test(tls, 270, ts+4935 /* "%d DELETEs, nume..." */, libc.VaList(bp+640, n))
	speedtest1_exec(tls, ts+2796 /* "BEGIN" */, 0)
	speedtest1_prepare(tls,
		ts+4972 /* "DELETE FROM t2 W..." */, libc.VaList(bp+656, n))
	for i = 1; i <= n; i++ {
		x1 = ((speedtest1_random(tls) % uint32(maxb)) + uint32(1))
		x2 = (((speedtest1_random(tls) % uint32(10)) + (uint32(sz / 5000))) + x1)
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, int32(x1))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 2, int32(x2))
		speedtest1_run(tls)
	}
	speedtest1_exec(tls, ts+2906 /* "COMMIT" */, 0)
	speedtest1_end_test(tls)

	n = sz
	speedtest1_begin_test(tls, 280, ts+5026 /* "%d DELETEs of in..." */, libc.VaList(bp+672, n))
	speedtest1_exec(tls, ts+2796 /* "BEGIN" */, 0)
	speedtest1_prepare(tls,
		ts+5056 /* "DELETE FROM t3 W..." */, libc.VaList(bp+688, n))
	for i = 1; i <= n; i++ {
		x1 = ((speedtest1_random(tls) % uint32(sz)) + uint32(1))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, int32(x1))
		speedtest1_run(tls)
	}
	speedtest1_exec(tls, ts+2906 /* "COMMIT" */, 0)
	speedtest1_end_test(tls)

	speedtest1_begin_test(tls, 290, ts+5095 /* "Refill two %d-ro..." */, libc.VaList(bp+704, sz))
	speedtest1_exec(tls, ts+5134 /* "REPLACE INTO t2(..." */, 0)
	speedtest1_exec(tls, ts+5178 /* "REPLACE INTO t3(..." */, 0)
	speedtest1_end_test(tls)

	speedtest1_begin_test(tls, 300, ts+5222 /* "Refill a %d-row ..." */, libc.VaList(bp+720, sz))
	speedtest1_exec(tls, ts+4519 /* "DELETE FROM t2;" */, 0)
	speedtest1_exec(tls,
		ts+5263 /* "INSERT INTO t2(a..." */, 0)
	speedtest1_exec(tls,
		ts+5328 /* "INSERT INTO t2(a..." */, 0)
	speedtest1_end_test(tls)

	n = (sz / 5)
	speedtest1_begin_test(tls, 310, ts+5393 /* "%d four-ways joi..." */, libc.VaList(bp+736, n))
	speedtest1_exec(tls, ts+2796 /* "BEGIN" */, 0)
	speedtest1_prepare(tls,

		ts+5412 /* "SELECT t1.c FROM..." */, 0)
	for i = 1; i <= n; i++ {
		x1 = ((speedtest1_random(tls) % uint32(sz)) + uint32(1))
		x2 = (((speedtest1_random(tls) % uint32(10)) + x1) + uint32(4))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, int32(x1))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 2, int32(x2))
		speedtest1_run(tls)
	}
	speedtest1_exec(tls, ts+2906 /* "COMMIT" */, 0)
	speedtest1_end_test(tls)

	speedtest1_begin_test(tls, 320, ts+5525 /* "subquery in resu..." */, libc.VaList(bp+752, n))
	speedtest1_prepare(tls,

		ts+5548 /* "SELECT sum(a), m..." */, 0)
	sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, (est_square_root(tls, g.szTest) * 50))
	speedtest1_run(tls)
	speedtest1_end_test(tls)

	sz = libc.AssignInt32(&n, (g.szTest * 700))
	*(*int8)(unsafe.Pointer(bp + 968 /* &zNum[0] */ + uintptr(0))) = int8(0)
	maxb = int32(roundup_allones(tls, (uint32(sz / 3))))
	speedtest1_begin_test(tls, 400, ts+5666 /* "%d REPLACE ops o..." */, libc.VaList(bp+768, n))
	speedtest1_exec(tls, ts+2796 /* "BEGIN" */, 0)
	speedtest1_exec(tls, ts+5691, /* "CREATE%s TABLE t..." */
		libc.VaList(bp+784, isTemp(tls, 9), g.zNN))
	speedtest1_prepare(tls, ts+5739 /* "REPLACE INTO t5 ..." */, libc.VaList(bp+808, n))
	for i = 1; i <= n; i++ {
		x1 = swizzle(tls, uint32(i), uint32(maxb))
		speedtest1_numbername(tls, uint32(i), bp+968 /* &zNum[0] */, int32(unsafe.Sizeof([2000]int8{})))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, int32(sqlite3_int64(x1)))
		sqlite3.Xsqlite3_bind_text(tls, g.pStmt, 2, bp+968 /* &zNum[0] */, -1, uintptr(0))
		speedtest1_run(tls)
	}
	speedtest1_exec(tls, ts+2906 /* "COMMIT" */, 0)
	speedtest1_end_test(tls)
	speedtest1_begin_test(tls, 410, ts+5783 /* "%d SELECTS on an..." */, libc.VaList(bp+824, n))
	speedtest1_prepare(tls, ts+5804 /* "SELECT b FROM t5..." */, libc.VaList(bp+840, n))
	for i = 1; i <= n; i++ {
		x1 = swizzle(tls, uint32(i), uint32(maxb))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, int32(sqlite3_int64(x1)))
		speedtest1_run(tls)
	}
	speedtest1_end_test(tls)

	sz = libc.AssignInt32(&n, (g.szTest * 700))
	*(*int8)(unsafe.Pointer(bp + 968 /* &zNum[0] */ + uintptr(0))) = int8(0)
	maxb = int32(roundup_allones(tls, (uint32(sz / 3))))
	speedtest1_begin_test(tls, 500, ts+5846 /* "%d REPLACE on TE..." */, libc.VaList(bp+856, n))
	speedtest1_exec(tls, ts+2796 /* "BEGIN" */, 0)
	speedtest1_exec(tls, ts+5868, /* "CREATE%s TABLE t..." */
		libc.VaList(bp+872, isTemp(tls, 9), g.zNN,
			func() uintptr {
				if sqlite3.Xsqlite3_libversion_number(tls) >= 3008002 {
					return ts + 5915 /* "WITHOUT ROWID" */
				}
				return ts + 2152 /* "" */
			}()))
	speedtest1_prepare(tls, ts+5929 /* "REPLACE INTO t6 ..." */, libc.VaList(bp+904, n))
	for i = 1; i <= n; i++ {
		x1 = swizzle(tls, uint32(i), uint32(maxb))
		speedtest1_numbername(tls, x1, bp+968 /* &zNum[0] */, int32(unsafe.Sizeof([2000]int8{})))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 2, i)
		sqlite3.Xsqlite3_bind_text(tls, g.pStmt, 1, bp+968 /* &zNum[0] */, -1, uintptr(0))
		speedtest1_run(tls)
	}
	speedtest1_exec(tls, ts+2906 /* "COMMIT" */, 0)
	speedtest1_end_test(tls)
	speedtest1_begin_test(tls, 510, ts+5973 /* "%d SELECTS on a ..." */, libc.VaList(bp+920, n))
	speedtest1_prepare(tls, ts+5997 /* "SELECT b FROM t6..." */, libc.VaList(bp+936, n))
	for i = 1; i <= n; i++ {
		x1 = swizzle(tls, uint32(i), uint32(maxb))
		speedtest1_numbername(tls, x1, bp+968 /* &zNum[0] */, int32(unsafe.Sizeof([2000]int8{})))
		sqlite3.Xsqlite3_bind_text(tls, g.pStmt, 1, bp+968 /* &zNum[0] */, -1, uintptr(0))
		speedtest1_run(tls)
	}
	speedtest1_end_test(tls)
	speedtest1_begin_test(tls, 520, ts+6039 /* "%d SELECT DISTIN..." */, libc.VaList(bp+952, n))
	speedtest1_exec(tls, ts+6058 /* "SELECT DISTINCT ..." */, 0)
	speedtest1_exec(tls, ts+6085 /* "SELECT DISTINCT ..." */, 0)
	speedtest1_end_test(tls)

	speedtest1_begin_test(tls, 980, ts+6112 /* "PRAGMA integrity..." */, 0)
	speedtest1_exec(tls, ts+6112 /* "PRAGMA integrity..." */, 0)
	speedtest1_end_test(tls)

	speedtest1_begin_test(tls, 990, ts+6135 /* "ANALYZE" */, 0)
	speedtest1_exec(tls, ts+6135 /* "ANALYZE" */, 0)
	speedtest1_end_test(tls)
}

// A testset for common table expressions.  This exercises code
// for views, subqueries, co-routines, etc.
func testset_cte(tls *libc.TLS) { /* speedtest1.c:1144:6: */
	bp := tls.Alloc(56)
	defer tls.Free(56)

	var zPuz uintptr
	var rSpacing float64
	var nElem int32

	if g.szTest < 25 {
		zPuz = azPuzzle[0]
	} else if g.szTest < 70 {
		zPuz = azPuzzle[1]
	} else {
		zPuz = azPuzzle[2]
	}
	speedtest1_begin_test(tls, 100, ts+6143 /* "Sudoku with recu..." */, 0)
	speedtest1_prepare(tls,

		ts+6174 /* "WITH RECURSIVE\n ..." */, 0)
	sqlite3.Xsqlite3_bind_text(tls, g.pStmt, 1, zPuz, -1, uintptr(0))
	speedtest1_run(tls)
	speedtest1_end_test(tls)

	speedtest1_begin_test(tls, 200, ts+6978 /* "Sudoku with VALU..." */, 0)
	speedtest1_prepare(tls,

		ts+7006 /* "WITH RECURSIVE\n ..." */, 0)
	sqlite3.Xsqlite3_bind_text(tls, g.pStmt, 1, zPuz, -1, uintptr(0))
	speedtest1_run(tls)
	speedtest1_end_test(tls)

	rSpacing = (5.0 / float64(g.szTest))
	speedtest1_begin_test(tls, 300, ts+7818 /* "Mandelbrot Set w..." */, libc.VaList(bp, rSpacing))
	speedtest1_prepare(tls,

		ts+7849 /* "WITH RECURSIVE \n..." */, 0)
	sqlite3.Xsqlite3_bind_double(tls, g.pStmt, 1, (rSpacing * .05))
	sqlite3.Xsqlite3_bind_double(tls, g.pStmt, 2, rSpacing)
	speedtest1_run(tls)
	speedtest1_end_test(tls)

	nElem = (10000 * g.szTest)
	speedtest1_begin_test(tls, 400, ts+8445 /* "EXCEPT operator ..." */, libc.VaList(bp+16, nElem))
	speedtest1_prepare(tls,

		ts+8482, /* "WITH RECURSIVE \n..." */
		libc.VaList(bp+32, nElem, nElem))
	speedtest1_run(tls)
	speedtest1_end_test(tls)
}

var azPuzzle = [3]uintptr{
	// Easy

	ts + 8713, /* "534...9..67.195...." */

	// Medium

	ts + 8795, /* "53....9..6..195...." */

	// Hard

	ts + 8877, /* "53.......6..195...." */
} /* speedtest1.c:1145:21 */

// Compute a pseudo-random floating point ascii number.
func speedtest1_random_ascii_fp(tls *libc.TLS, zFP uintptr) { /* speedtest1.c:1297:6: */
	bp := tls.Alloc(32)
	defer tls.Free(32)

	var x int32 = int32(speedtest1_random(tls))
	var y int32 = int32(speedtest1_random(tls))
	var z int32
	z = (y % 10)
	if z < 0 {
		z = -z
	}
	y = y / (10)
	sqlite3.Xsqlite3_snprintf(tls, 100, zFP, ts+8959 /* "%d.%de%d" */, libc.VaList(bp, y, z, (x%200)))
}

// A testset for floating-point numbers.
func testset_fp(tls *libc.TLS) { /* speedtest1.c:1310:6: */
	bp := tls.Alloc(328)
	defer tls.Free(328)

	var n int32
	var i int32
	// var zFP1 [100]int8 at bp+128, 100

	// var zFP2 [100]int8 at bp+228, 100

	n = (g.szTest * 5000)
	speedtest1_begin_test(tls, 100, ts+8968 /* "Fill a table wit..." */, libc.VaList(bp, (n*2)))
	speedtest1_exec(tls, ts+2796 /* "BEGIN" */, 0)
	speedtest1_exec(tls, ts+8999, /* "CREATE%s TABLE t..." */
		libc.VaList(bp+16, isTemp(tls, 1), g.zNN, g.zNN))
	speedtest1_prepare(tls, ts+9040 /* "INSERT INTO t1 V..." */, libc.VaList(bp+48, n))
	for i = 1; i <= n; i++ {
		speedtest1_random_ascii_fp(tls, bp+128 /* &zFP1[0] */)
		speedtest1_random_ascii_fp(tls, bp+228 /* &zFP2[0] */)
		sqlite3.Xsqlite3_bind_text(tls, g.pStmt, 1, bp+128 /* &zFP1[0] */, -1, uintptr(0))
		sqlite3.Xsqlite3_bind_text(tls, g.pStmt, 2, bp+228 /* &zFP2[0] */, -1, uintptr(0))
		speedtest1_run(tls)
	}
	speedtest1_exec(tls, ts+2906 /* "COMMIT" */, 0)
	speedtest1_end_test(tls)

	n = ((g.szTest / 25) + 2)
	speedtest1_begin_test(tls, 110, ts+9082 /* "%d range queries" */, libc.VaList(bp+64, n))
	speedtest1_prepare(tls, ts+9099 /* "SELECT sum(b) FR..." */, 0)
	for i = 1; i <= n; i++ {
		speedtest1_random_ascii_fp(tls, bp+128 /* &zFP1[0] */)
		speedtest1_random_ascii_fp(tls, bp+228 /* &zFP2[0] */)
		sqlite3.Xsqlite3_bind_text(tls, g.pStmt, 1, bp+128 /* &zFP1[0] */, -1, uintptr(0))
		sqlite3.Xsqlite3_bind_text(tls, g.pStmt, 2, bp+228 /* &zFP2[0] */, -1, uintptr(0))
		speedtest1_run(tls)
	}
	speedtest1_end_test(tls)

	speedtest1_begin_test(tls, 120, ts+9147 /* "CREATE INDEX thr..." */, 0)
	speedtest1_exec(tls, ts+3709 /* "BEGIN;" */, 0)
	speedtest1_exec(tls, ts+9172 /* "CREATE INDEX t1a..." */, 0)
	speedtest1_exec(tls, ts+9199 /* "CREATE INDEX t1b..." */, 0)
	speedtest1_exec(tls, ts+9226 /* "CREATE INDEX t1a..." */, 0)
	speedtest1_exec(tls, ts+3873 /* "COMMIT;" */, 0)
	speedtest1_end_test(tls)

	n = ((g.szTest / 3) + 2)
	speedtest1_begin_test(tls, 130, ts+9256 /* "%d indexed range..." */, libc.VaList(bp+80, n))
	speedtest1_prepare(tls, ts+9099 /* "SELECT sum(b) FR..." */, 0)
	for i = 1; i <= n; i++ {
		speedtest1_random_ascii_fp(tls, bp+128 /* &zFP1[0] */)
		speedtest1_random_ascii_fp(tls, bp+228 /* &zFP2[0] */)
		sqlite3.Xsqlite3_bind_text(tls, g.pStmt, 1, bp+128 /* &zFP1[0] */, -1, uintptr(0))
		sqlite3.Xsqlite3_bind_text(tls, g.pStmt, 2, bp+228 /* &zFP2[0] */, -1, uintptr(0))
		speedtest1_run(tls)
	}
	speedtest1_end_test(tls)

	n = (g.szTest * 5000)
	speedtest1_begin_test(tls, 140, ts+9281 /* "%d calls to roun..." */, libc.VaList(bp+96, n))
	speedtest1_exec(tls, ts+9301 /* "SELECT sum(round..." */, 0)
	speedtest1_end_test(tls)

	speedtest1_begin_test(tls, 150, ts+9344 /* "%d printf() call..." */, libc.VaList(bp+112, (n*4)))
	speedtest1_exec(tls,

		ts+9362 /* "WITH c(fmt) AS (..." */, 0)
	speedtest1_end_test(tls)
}

// Generate two numbers between 1 and mx.  The first number is less than
// the second.  Usually the numbers are near each other but can sometimes
// be far apart.
func twoCoords(tls *libc.TLS, p1 int32, p2 int32, mx uint32, pX0 uintptr, pX1 uintptr) { /* speedtest1.c:1383:13: */
	var d uint32
	var x0 uint32
	var x1 uint32
	var span uint32

	span = ((mx / uint32(100)) + uint32(1))
	if (speedtest1_random(tls) % uint32(3)) == uint32(0) {
		span = span * (uint32(p1))
	}
	if (speedtest1_random(tls) % uint32(p2)) == uint32(0) {
		span = (mx / uint32(2))
	}
	d = ((speedtest1_random(tls) % span) + uint32(1))
	x0 = ((speedtest1_random(tls) % (mx - d)) + uint32(1))
	x1 = (x0 + d)
	*(*uint32)(unsafe.Pointer(pX0)) = x0
	*(*uint32)(unsafe.Pointer(pX1)) = x1
}

// The following routine is an R-Tree geometry callback.  It returns
// true if the object overlaps a slice on the Y coordinate between the
// two values given as arguments.  In other words
//
//     SELECT count(*) FROM rt1 WHERE id MATCH xslice(10,20);
//
// Is the same as saying:
//
//     SELECT count(*) FROM rt1 WHERE y1>=10 AND y0<=20;
func xsliceGeometryCallback(tls *libc.TLS, p uintptr, nCoord int32, aCoord uintptr, pRes uintptr) int32 { /* speedtest1.c:1412:12: */
	*(*int32)(unsafe.Pointer(pRes)) = (libc.Bool32((*(*float64)(unsafe.Pointer(aCoord + uintptr(3)*8)) >= *(*sqlite3_rtree_dbl)(unsafe.Pointer((*sqlite3_rtree_geometry)(unsafe.Pointer(p)).aParam + uintptr(0)*8))) && (*(*float64)(unsafe.Pointer(aCoord + uintptr(2)*8)) <= *(*sqlite3_rtree_dbl)(unsafe.Pointer((*sqlite3_rtree_geometry)(unsafe.Pointer(p)).aParam + uintptr(1)*8)))))
	return 0
}

// A testset for the R-Tree virtual table
func testset_rtree(tls *libc.TLS, p1 int32, p2 int32) { /* speedtest1.c:1427:6: */
	bp := tls.Alloc(328)
	defer tls.Free(328)

	var i uint32
	var n uint32
	var mxCoord uint32
	// var x0 uint32 at bp+304, 4

	// var x1 uint32 at bp+308, 4

	// var y0 uint32 at bp+312, 4

	// var y1 uint32 at bp+316, 4

	// var z0 uint32 at bp+320, 4

	// var z1 uint32 at bp+324, 4

	var iStep uint32
	var mxRowid uint32
	var aCheck uintptr = sqlite3.Xsqlite3_malloc(tls, (int32((uint32(unsafe.Sizeof(int32(0))) * uint32(g.szTest)) * uint32(500))))

	mxCoord = uint32(15000)
	mxRowid = libc.AssignUint32(&n, (uint32(g.szTest * 500)))
	speedtest1_begin_test(tls, 100, ts+9457 /* "%d INSERTs into ..." */, libc.VaList(bp, n))
	speedtest1_exec(tls, ts+2796 /* "BEGIN" */, 0)
	speedtest1_exec(tls, ts+9483 /* "CREATE VIRTUAL T..." */, 0)
	speedtest1_prepare(tls,
		ts+9542 /* "INSERT INTO rt1(..." */, 0)
	for i = uint32(1); i <= n; i++ {
		twoCoords(tls, p1, p2, mxCoord, bp+304 /* &x0 */, bp+308 /* &x1 */)
		twoCoords(tls, p1, p2, mxCoord, bp+312 /* &y0 */, bp+316 /* &y1 */)
		twoCoords(tls, p1, p2, mxCoord, bp+320 /* &z0 */, bp+324 /* &z1 */)
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, int32(i))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 2, int32(*(*uint32)(unsafe.Pointer(bp + 304 /* x0 */))))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 3, int32(*(*uint32)(unsafe.Pointer(bp + 308 /* x1 */))))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 4, int32(*(*uint32)(unsafe.Pointer(bp + 312 /* y0 */))))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 5, int32(*(*uint32)(unsafe.Pointer(bp + 316 /* y1 */))))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 6, int32(*(*uint32)(unsafe.Pointer(bp + 320 /* z0 */))))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 7, int32(*(*uint32)(unsafe.Pointer(bp + 324 /* z1 */))))
		speedtest1_run(tls)
	}
	speedtest1_exec(tls, ts+2906 /* "COMMIT" */, 0)
	speedtest1_end_test(tls)

	speedtest1_begin_test(tls, 101, ts+9608 /* "Copy from rtree ..." */, 0)
	speedtest1_exec(tls, ts+9643 /* "CREATE TABLE t1(..." */, 0)
	speedtest1_exec(tls, ts+9701 /* "INSERT INTO t1 S..." */, 0)
	speedtest1_end_test(tls)

	n = (uint32(g.szTest * 200))
	speedtest1_begin_test(tls, 110, ts+9734 /* "%d one-dimension..." */, libc.VaList(bp+16, n))
	speedtest1_prepare(tls, ts+9777 /* "SELECT count(*) ..." */, 0)
	iStep = (mxCoord / n)
	for i = uint32(0); i < n; i++ {
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, (int32(i * iStep)))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 2, (int32((i + uint32(1)) * iStep)))
		speedtest1_run(tls)
		*(*int32)(unsafe.Pointer(aCheck + uintptr(i)*4)) = libc.Xatoi(tls, uintptr(unsafe.Pointer(&g))+100 /* &.zResult */)
	}
	speedtest1_end_test(tls)

	if g.bVerify != 0 {
		n = (uint32(g.szTest * 200))
		speedtest1_begin_test(tls, 111, ts+9826 /* "Verify result fr..." */, 0)
		speedtest1_prepare(tls, ts+9873 /* "SELECT count(*) ..." */, 0)
		iStep = (mxCoord / n)
		for i = uint32(0); i < n; i++ {
			sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, (int32(i * iStep)))
			sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 2, (int32((i + uint32(1)) * iStep)))
			speedtest1_run(tls)
			if *(*int32)(unsafe.Pointer(aCheck + uintptr(i)*4)) != libc.Xatoi(tls, uintptr(unsafe.Pointer(&g))+100 /* &.zResult */) {
				fatal_error(tls, ts+9921, /* "Count disagree s..." */
					libc.VaList(bp+32, i, (i*iStep), ((i+uint32(1))*iStep), *(*int32)(unsafe.Pointer(aCheck + uintptr(i)*4)), libc.Xatoi(tls, uintptr(unsafe.Pointer(&g))+100 /* &.zResult */)))
			}
		}
		speedtest1_end_test(tls)
	}

	n = (uint32(g.szTest * 200))
	speedtest1_begin_test(tls, 120, ts+9963 /* "%d one-dimension..." */, libc.VaList(bp+80, n))
	speedtest1_prepare(tls, ts+10004 /* "SELECT count(*) ..." */, 0)
	iStep = (mxCoord / n)
	for i = uint32(0); i < n; i++ {
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, (int32(i * iStep)))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 2, (int32((i + uint32(1)) * iStep)))
		speedtest1_run(tls)
		*(*int32)(unsafe.Pointer(aCheck + uintptr(i)*4)) = libc.Xatoi(tls, uintptr(unsafe.Pointer(&g))+100 /* &.zResult */)
	}
	speedtest1_end_test(tls)

	if g.bVerify != 0 {
		n = (uint32(g.szTest * 200))
		speedtest1_begin_test(tls, 121, ts+10053 /* "Verify result fr..." */, 0)
		speedtest1_prepare(tls, ts+10098 /* "SELECT count(*) ..." */, 0)
		iStep = (mxCoord / n)
		for i = uint32(0); i < n; i++ {
			sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, (int32(i * iStep)))
			sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 2, (int32((i + uint32(1)) * iStep)))
			speedtest1_run(tls)
			if *(*int32)(unsafe.Pointer(aCheck + uintptr(i)*4)) != libc.Xatoi(tls, uintptr(unsafe.Pointer(&g))+100 /* &.zResult */) {
				fatal_error(tls, ts+9921, /* "Count disagree s..." */
					libc.VaList(bp+96, i, (i*iStep), ((i+uint32(1))*iStep), *(*int32)(unsafe.Pointer(aCheck + uintptr(i)*4)), libc.Xatoi(tls, uintptr(unsafe.Pointer(&g))+100 /* &.zResult */)))
			}
		}
		speedtest1_end_test(tls)
	}

	n = (uint32(g.szTest * 200))
	speedtest1_begin_test(tls, 125, ts+10146 /* "%d custom geomet..." */, libc.VaList(bp+144, n))
	sqlite3.Xsqlite3_rtree_geometry_callback(tls, g.db, ts+10182 /* "xslice" */, *(*uintptr)(unsafe.Pointer(&struct {
		f func(*libc.TLS, uintptr, int32, uintptr, uintptr) int32
	}{xsliceGeometryCallback})), uintptr(0))
	speedtest1_prepare(tls, ts+10189 /* "SELECT count(*) ..." */, 0)
	iStep = (mxCoord / n)
	for i = uint32(0); i < n; i++ {
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, (int32(i * iStep)))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 2, (int32((i + uint32(1)) * iStep)))
		speedtest1_run(tls)
		if *(*int32)(unsafe.Pointer(aCheck + uintptr(i)*4)) != libc.Xatoi(tls, uintptr(unsafe.Pointer(&g))+100 /* &.zResult */) {
			fatal_error(tls, ts+9921, /* "Count disagree s..." */
				libc.VaList(bp+160, i, (i*iStep), ((i+uint32(1))*iStep), *(*int32)(unsafe.Pointer(aCheck + uintptr(i)*4)), libc.Xatoi(tls, uintptr(unsafe.Pointer(&g))+100 /* &.zResult */)))
		}
	}
	speedtest1_end_test(tls)

	n = (uint32(g.szTest * 400))
	speedtest1_begin_test(tls, 130, ts+10243 /* "%d three-dimensi..." */, libc.VaList(bp+208, n))
	speedtest1_prepare(tls,
		ts+10286 /* "SELECT count(*) ..." */, 0)
	iStep = (mxCoord / n)
	for i = uint32(0); i < n; i++ {
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, (int32(i * iStep)))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 2, (int32((i + uint32(1)) * iStep)))
		speedtest1_run(tls)
		*(*int32)(unsafe.Pointer(aCheck + uintptr(i)*4)) = libc.Xatoi(tls, uintptr(unsafe.Pointer(&g))+100 /* &.zResult */)
	}
	speedtest1_end_test(tls)

	n = (uint32(g.szTest * 500))
	speedtest1_begin_test(tls, 140, ts+10379 /* "%d rowid queries" */, libc.VaList(bp+224, n))
	speedtest1_prepare(tls, ts+10396 /* "SELECT * FROM rt..." */, 0)
	for i = uint32(1); i <= n; i++ {
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, int32(i))
		speedtest1_run(tls)
	}
	speedtest1_end_test(tls)

	n = (uint32(g.szTest * 50))
	speedtest1_begin_test(tls, 150, ts+10426 /* "%d UPDATEs using..." */, libc.VaList(bp+240, n))
	speedtest1_prepare(tls, ts+10449 /* "UPDATE rt1 SET x..." */, 0)
	for i = uint32(1); i <= n; i++ {
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, (int32(((i * uint32(251)) % mxRowid) + uint32(1))))
		speedtest1_run(tls)
	}
	speedtest1_end_test(tls)

	n = (uint32(g.szTest * 5))
	speedtest1_begin_test(tls, 155, ts+10497 /* "%d UPDATEs using..." */, libc.VaList(bp+256, n))
	speedtest1_prepare(tls,
		ts+10538 /* "UPDATE rt1 SET x..." */, 0)
	iStep = (mxCoord / n)
	for i = uint32(0); i < n; i++ {
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, (int32(i * iStep)))
		speedtest1_run(tls)
		*(*int32)(unsafe.Pointer(aCheck + uintptr(i)*4)) = libc.Xatoi(tls, uintptr(unsafe.Pointer(&g))+100 /* &.zResult */)
	}
	speedtest1_end_test(tls)

	n = (uint32(g.szTest * 50))
	speedtest1_begin_test(tls, 160, ts+10600 /* "%d DELETEs using..." */, libc.VaList(bp+272, n))
	speedtest1_prepare(tls, ts+10623 /* "DELETE FROM rt1 ..." */, 0)
	for i = uint32(1); i <= n; i++ {
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, (int32(((i * uint32(257)) % mxRowid) + uint32(1))))
		speedtest1_run(tls)
	}
	speedtest1_end_test(tls)

	n = (uint32(g.szTest * 5))
	speedtest1_begin_test(tls, 165, ts+10651 /* "%d DELETEs using..." */, libc.VaList(bp+288, n))
	speedtest1_prepare(tls, ts+10692 /* "DELETE FROM rt1 ..." */, 0)
	iStep = (mxCoord / n)
	for i = uint32(0); i < n; i++ {
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, (int32(i * iStep)))
		speedtest1_run(tls)
		*(*int32)(unsafe.Pointer(aCheck + uintptr(i)*4)) = libc.Xatoi(tls, uintptr(unsafe.Pointer(&g))+100 /* &.zResult */)
	}
	speedtest1_end_test(tls)

	speedtest1_begin_test(tls, 170, ts+10734 /* "Restore deleted ..." */, 0)
	speedtest1_exec(tls, ts+10781 /* "INSERT OR IGNORE..." */, 0)
	speedtest1_end_test(tls)
}

// A testset that does key/value storage on tables with many columns.
// This is the kind of workload generated by ORMs such as CoreData.
func testset_orm(tls *libc.TLS) { /* speedtest1.c:1612:6: */
	bp := tls.Alloc(2032)
	defer tls.Free(2032)

	var i uint32
	var j uint32
	var n uint32
	var nRow uint32
	var x1 uint32
	var len uint32
	// var zNum [2000]int8 at bp+32, 2000

	nRow = libc.AssignUint32(&n, (uint32(g.szTest * 250)))
	speedtest1_begin_test(tls, 100, ts+10824 /* "Fill %d rows" */, libc.VaList(bp, n))
	speedtest1_exec(tls,

		ts+10837 /* "BEGIN;CREATE TAB..." */, 0)
	speedtest1_prepare(tls,

		ts+14737 /* "INSERT INTO ZLOO..." */, 0)
	for i = uint32(0); i < n; i++ {
		x1 = speedtest1_random(tls)
		speedtest1_numbername(tls, (x1 % uint32(1000)), bp+32 /* &zNum[0] */, int32(unsafe.Sizeof([2000]int8{})))
		len = uint32(int32(libc.Xstrlen(tls, bp+32 /* &zNum[0] */)))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, (int32(i ^ uint32(0xf))))
		for j = uint32(0); zType[j] != 0; j++ {
			switch int32(zType[j]) {
			case 'I':
				fallthrough
			case 'T':
				sqlite3.Xsqlite3_bind_int64(tls, g.pStmt, (int32(j + uint32(2))), int64(x1))
				break
			case 'F':
				sqlite3.Xsqlite3_bind_double(tls, g.pStmt, (int32(j + uint32(2))), float64(x1))
				break
			case 'V':
				fallthrough
			case 'B':
				sqlite3.Xsqlite3_bind_text64(tls, g.pStmt, (int32(j + uint32(2))), bp+32 /* &zNum[0] */, uint64(len),
					uintptr(0), uint8(1))
				break
			}
		}
		speedtest1_run(tls)
	}
	speedtest1_exec(tls, ts+3873 /* "COMMIT;" */, 0)
	speedtest1_end_test(tls)

	n = (uint32(g.szTest * 250))
	speedtest1_begin_test(tls, 110, ts+17981 /* "Query %d rows by..." */, libc.VaList(bp+16, n))
	speedtest1_prepare(tls,

		ts+18004 /* "SELECT ZCYANBASE..." */, 0)
	for i = uint32(0); i < n; i++ {
		x1 = (speedtest1_random(tls) % nRow)
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, int32(x1))
		speedtest1_run(tls)
	}
	speedtest1_end_test(tls)
}

var zType = *(*[120]int8)(unsafe.Pointer(ts + 20757 /* "IBBIIITIVVITBTBF..." */)) /* speedtest1.c:1617:21 */

//
func testset_trigger(tls *libc.TLS) { /* speedtest1.c:1879:6: */
	bp := tls.Alloc(2064)
	defer tls.Free(2064)

	var jj int32
	var ii int32
	// var zNum [2000]int8 at bp+64, 2000
	// A number name

	var NROW int32 = (500 * g.szTest)
	var NROW2 int32 = (100 * g.szTest)

	speedtest1_exec(tls,

		ts+20877 /* "BEGIN;CREATE TAB..." */, 0)
	for jj = 1; jj <= 3; jj++ {
		speedtest1_prepare(tls, ts+21205 /* "INSERT INTO t%d ..." */, libc.VaList(bp, jj))
		for ii = 0; ii < NROW; ii++ {
			var x1 int32 = (int32(speedtest1_random(tls) % uint32(NROW)))
			speedtest1_numbername(tls, uint32(x1), bp+64 /* &zNum[0] */, int32(unsafe.Sizeof([2000]int8{})))
			sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, x1)
			sqlite3.Xsqlite3_bind_text(tls, g.pStmt, 2, bp+64 /* &zNum[0] */, -1, uintptr(0))
			speedtest1_run(tls)
		}
	}
	speedtest1_exec(tls,

		ts+21240 /* "CREATE INDEX i1 ..." */, 0)

	speedtest1_begin_test(tls, 100, ts+21323 /* "speed4p-join1" */, 0)
	speedtest1_prepare(tls,
		ts+21337 /* "SELECT * FROM t1..." */, 0)
	speedtest1_run(tls)
	speedtest1_end_test(tls)

	speedtest1_begin_test(tls, 110, ts+21404 /* "speed4p-join2" */, 0)
	speedtest1_prepare(tls,
		ts+21418 /* "SELECT * FROM t1..." */, 0)
	speedtest1_run(tls)
	speedtest1_end_test(tls)

	speedtest1_begin_test(tls, 120, ts+21477 /* "speed4p-view1" */, 0)
	for jj = 1; jj <= 3; jj++ {
		speedtest1_prepare(tls, ts+21491 /* "SELECT * FROM v%..." */, libc.VaList(bp+16, jj))
		for ii = 0; ii < NROW2; ii = ii + (3) {
			sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, (ii * 3))
			speedtest1_run(tls)
		}
	}
	speedtest1_end_test(tls)

	speedtest1_begin_test(tls, 130, ts+21525 /* "speed4p-table1" */, 0)
	for jj = 1; jj <= 3; jj++ {
		speedtest1_prepare(tls, ts+21540 /* "SELECT * FROM t%..." */, libc.VaList(bp+32, jj))
		for ii = 0; ii < NROW2; ii = ii + (3) {
			sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, (ii * 3))
			speedtest1_run(tls)
		}
	}
	speedtest1_end_test(tls)

	speedtest1_begin_test(tls, 140, ts+21525 /* "speed4p-table1" */, 0)
	for jj = 1; jj <= 3; jj++ {
		speedtest1_prepare(tls, ts+21540 /* "SELECT * FROM t%..." */, libc.VaList(bp+48, jj))
		for ii = 0; ii < NROW2; ii = ii + (3) {
			sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, (ii * 3))
			speedtest1_run(tls)
		}
	}
	speedtest1_end_test(tls)

	speedtest1_begin_test(tls, 150, ts+21574 /* "speed4p-subselec..." */, 0)
	speedtest1_prepare(tls,

		ts+21593 /* "SELECT (SELECT t..." */, 0)
	for jj = 0; jj < NROW2; jj++ {
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, (jj * 3))
		speedtest1_run(tls)
	}
	speedtest1_end_test(tls)

	speedtest1_begin_test(tls, 160, ts+21708 /* "speed4p-rowid-up..." */, 0)
	speedtest1_exec(tls, ts+2796 /* "BEGIN" */, 0)
	speedtest1_prepare(tls, ts+21729 /* "UPDATE t1 SET i=..." */, 0)
	for jj = 0; jj < NROW2; jj++ {
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, jj)
		speedtest1_run(tls)
	}
	speedtest1_exec(tls, ts+2906 /* "COMMIT" */, 0)
	speedtest1_end_test(tls)

	speedtest1_exec(tls, ts+21764 /* "CREATE TABLE t5(..." */, 0)
	speedtest1_begin_test(tls, 170, ts+21812 /* "speed4p-insert-i..." */, 0)
	speedtest1_exec(tls, ts+21834 /* "INSERT OR IGNORE..." */, 0)
	speedtest1_end_test(tls)

	speedtest1_exec(tls,

		ts+21879 /* "CREATE TABLE log..." */, 0)

	speedtest1_begin_test(tls, 180, ts+22369 /* "speed4p-trigger1" */, 0)
	speedtest1_prepare(tls, ts+22386 /* "INSERT INTO t4 V..." */, 0)
	for jj = 0; jj < NROW2; jj++ {
		speedtest1_numbername(tls, uint32(jj), bp+64 /* &zNum[0] */, int32(unsafe.Sizeof([2000]int8{})))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, jj)
		sqlite3.Xsqlite3_bind_text(tls, g.pStmt, 2, bp+64 /* &zNum[0] */, -1, uintptr(0))
		speedtest1_run(tls)
	}
	speedtest1_end_test(tls)

	// Note: Of the queries, only half actually update a row. This property
	// was copied over from speed4p.test, where it was probably introduced
	// inadvertantly.
	speedtest1_begin_test(tls, 190, ts+22422 /* "speed4p-trigger2" */, 0)
	speedtest1_prepare(tls, ts+22439 /* "UPDATE t4 SET i ..." */, 0)
	for jj = 1; jj <= (NROW2 * 2); jj = jj + (2) {
		speedtest1_numbername(tls, (uint32(jj * 2)), bp+64 /* &zNum[0] */, int32(unsafe.Sizeof([2000]int8{})))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, (jj * 2))
		sqlite3.Xsqlite3_bind_text(tls, g.pStmt, 2, bp+64 /* &zNum[0] */, -1, uintptr(0))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 3, jj)
		speedtest1_run(tls)
	}
	speedtest1_end_test(tls)

	// Note: Same again.
	speedtest1_begin_test(tls, 200, ts+22485 /* "speed4p-trigger3" */, 0)
	speedtest1_prepare(tls, ts+22502 /* "DELETE FROM t4 W..." */, 0)
	for jj = 1; jj <= (NROW2 * 2); jj = jj + (2) {
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, (jj * 2))
		speedtest1_run(tls)
	}
	speedtest1_end_test(tls)
	speedtest1_exec(tls, ts+2906 /* "COMMIT" */, 0)

	// The following block contains the same tests as the above block that
	// tests triggers, with one crucial difference: no triggers are defined.
	// So the difference in speed between these tests and the preceding ones
	// is the amount of time taken to compile and execute the trigger programs.
	speedtest1_exec(tls,

		ts+22534 /* "DROP TABLE t4;DR..." */, 0)
	speedtest1_begin_test(tls, 210, ts+22639 /* "speed4p-notrigge..." */, 0)
	speedtest1_prepare(tls, ts+22386 /* "INSERT INTO t4 V..." */, 0)
	for jj = 0; jj < NROW2; jj++ {
		speedtest1_numbername(tls, uint32(jj), bp+64 /* &zNum[0] */, int32(unsafe.Sizeof([2000]int8{})))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, jj)
		sqlite3.Xsqlite3_bind_text(tls, g.pStmt, 2, bp+64 /* &zNum[0] */, -1, uintptr(0))
		speedtest1_run(tls)
	}
	speedtest1_end_test(tls)
	speedtest1_begin_test(tls, 210, ts+22658 /* "speed4p-notrigge..." */, 0)
	speedtest1_prepare(tls, ts+22439 /* "UPDATE t4 SET i ..." */, 0)
	for jj = 1; jj <= (NROW2 * 2); jj = jj + (2) {
		speedtest1_numbername(tls, (uint32(jj * 2)), bp+64 /* &zNum[0] */, int32(unsafe.Sizeof([2000]int8{})))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, (jj * 2))
		sqlite3.Xsqlite3_bind_text(tls, g.pStmt, 2, bp+64 /* &zNum[0] */, -1, uintptr(0))
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 3, jj)
		speedtest1_run(tls)
	}
	speedtest1_end_test(tls)
	speedtest1_begin_test(tls, 220, ts+22677 /* "speed4p-notrigge..." */, 0)
	speedtest1_prepare(tls, ts+22502 /* "DELETE FROM t4 W..." */, 0)
	for jj = 1; jj <= (NROW2 * 2); jj = jj + (2) {
		sqlite3.Xsqlite3_bind_int(tls, g.pStmt, 1, (jj * 2))
		speedtest1_run(tls)
	}
	speedtest1_end_test(tls)
	speedtest1_exec(tls, ts+2906 /* "COMMIT" */, 0)
}

// A testset used for debugging speedtest1 itself.
func testset_debug1(tls *libc.TLS) { /* speedtest1.c:2081:6: */
	bp := tls.Alloc(2040)
	defer tls.Free(2040)

	var i uint32
	var n uint32
	var x1 uint32
	var x2 uint32
	// var zNum [2000]int8 at bp+40, 2000
	// A number name

	n = uint32(g.szTest)
	for i = uint32(1); i <= n; i++ {
		x1 = swizzle(tls, i, n)
		x2 = swizzle(tls, x1, n)
		speedtest1_numbername(tls, x1, bp+40 /* &zNum[0] */, int32(unsafe.Sizeof([2000]int8{})))
		libc.Xprintf(tls, ts+22696 /* "%5d %5d %5d %s\n" */, libc.VaList(bp, i, x1, x2, bp+40 /* &zNum[0] */))
	}
}

func xCompileOptions(tls *libc.TLS, pCtx uintptr, nVal int32, azVal uintptr, azCol uintptr) int32 { /* speedtest1.c:2138:12: */
	bp := tls.Alloc(16)
	defer tls.Free(16)

	libc.Xprintf(tls, ts+22712 /* "-- Compile optio..." */, libc.VaList(bp, *(*uintptr)(unsafe.Pointer(azVal + uintptr(0)*4))))
	return 0
}

func main1(tls *libc.TLS, argc int32, argv uintptr) int32 { /* speedtest1.c:2143:5: */
	bp := tls.Alloc(1016)
	defer tls.Free(1016)

	var doAutovac int32 = 0   // True for --autovacuum
	var cacheSize int32 = 0   // Desired cache size.  0 means default
	var doExclusive int32 = 0 // True for --exclusive
	var nHeap int32 = 0
	var mnHeap int32 = 0            // Heap size from --heap
	var doIncrvac int32 = 0         // True for --incrvacuum
	var zJMode uintptr = uintptr(0) // Journal mode
	var zKey uintptr = uintptr(0)   // Encryption key
	var nLook int32 = -1
	var szLook int32 = 0   // --lookaside configuration
	var noSync int32 = 0   // True for --nosync
	var pageSize int32 = 0 // Desired page size.  0 means default
	var nPCache int32 = 0
	var szPCache int32 = 0             // --pcache configuration
	var doPCache int32 = 0             // True if --pcache is seen
	var showStats int32 = 0            // True for --stats
	var nThread int32 = 0              // --threads value
	var mmapSize int32 = 0             // How big of a memory map to use
	var memDb int32 = 0                // --memdb.  Use an in-memory database
	var zTSet uintptr = ts + 22735     /* "main" */ // Which --testset torun
	var doTrace int32 = 0              // True for --trace
	var zEncoding uintptr = uintptr(0) // --utf16be or --utf16le
	var zDbName uintptr = uintptr(0)   // Name of the test database

	var pHeap uintptr = uintptr(0)   // Allocated heap space
	var pLook uintptr = uintptr(0)   // Allocated lookaside space
	var pPCache uintptr = uintptr(0) // Allocated storage for pcache
	// var iCur int32 at bp+1008, 4

	// var iHi int32 at bp+1012, 4
	// Stats values, current and "highwater"
	var i int32  // Loop counter
	var rc int32 // API return code

	// Display the version of SQLite being tested
	libc.Xprintf(tls, ts+22740, /* "-- Speedtest1 fo..." */
		libc.VaList(bp, sqlite3.Xsqlite3_libversion(tls), sqlite3.Xsqlite3_sourceid(tls)))

	// Process command-line arguments
	g.zWR = ts + 2152  /* "" */
	g.zNN = ts + 2152  /* "" */
	g.zPK = ts + 22775 /* "UNIQUE" */
	g.szTest = 100
	g.nRepeat = 1
	for i = 1; i < argc; i++ {
		var z uintptr = *(*uintptr)(unsafe.Pointer(argv + uintptr(i)*4))
		if int32(*(*int8)(unsafe.Pointer(z + uintptr(0)))) == '-' {
			for ok := true; ok; ok = (int32(*(*int8)(unsafe.Pointer(z + uintptr(0)))) == '-') {
				z++
			}
			if libc.Xstrcmp(tls, z, ts+22782 /* "autovacuum" */) == 0 {
				doAutovac = 1
			} else if libc.Xstrcmp(tls, z, ts+22793 /* "cachesize" */) == 0 {
				if i >= (argc - 1) {
					fatal_error(tls, ts+22803 /* "missing argument..." */, libc.VaList(bp+24, *(*uintptr)(unsafe.Pointer(argv + uintptr(i)*4))))
				}
				i++
				cacheSize = integerValue(tls, *(*uintptr)(unsafe.Pointer(argv + uintptr(i)*4)))
			} else if libc.Xstrcmp(tls, z, ts+22827 /* "exclusive" */) == 0 {
				doExclusive = 1
			} else if libc.Xstrcmp(tls, z, ts+22837 /* "checkpoint" */) == 0 {
				g.doCheckpoint = 1
			} else if libc.Xstrcmp(tls, z, ts+22848 /* "explain" */) == 0 {
				g.bSqlOnly = 1
				g.bExplain = 1
			} else if libc.Xstrcmp(tls, z, ts+22856 /* "heap" */) == 0 {
				if i >= (argc - 2) {
					fatal_error(tls, ts+22861 /* "missing argument..." */, libc.VaList(bp+40, *(*uintptr)(unsafe.Pointer(argv + uintptr(i)*4))))
				}
				nHeap = integerValue(tls, *(*uintptr)(unsafe.Pointer(argv + uintptr((i+1))*4)))
				mnHeap = integerValue(tls, *(*uintptr)(unsafe.Pointer(argv + uintptr((i+2))*4)))
				i = i + (2)
			} else if libc.Xstrcmp(tls, z, ts+22886 /* "incrvacuum" */) == 0 {
				doIncrvac = 1
			} else if libc.Xstrcmp(tls, z, ts+22897 /* "journal" */) == 0 {
				if i >= (argc - 1) {
					fatal_error(tls, ts+22803 /* "missing argument..." */, libc.VaList(bp+56, *(*uintptr)(unsafe.Pointer(argv + uintptr(i)*4))))
				}
				zJMode = *(*uintptr)(unsafe.Pointer(argv + uintptr(libc.PreIncInt32(&i, 1))*4))
			} else if libc.Xstrcmp(tls, z, ts+22905 /* "key" */) == 0 {
				if i >= (argc - 1) {
					fatal_error(tls, ts+22803 /* "missing argument..." */, libc.VaList(bp+72, *(*uintptr)(unsafe.Pointer(argv + uintptr(i)*4))))
				}
				zKey = *(*uintptr)(unsafe.Pointer(argv + uintptr(libc.PreIncInt32(&i, 1))*4))
			} else if libc.Xstrcmp(tls, z, ts+22909 /* "lookaside" */) == 0 {
				if i >= (argc - 2) {
					fatal_error(tls, ts+22861 /* "missing argument..." */, libc.VaList(bp+88, *(*uintptr)(unsafe.Pointer(argv + uintptr(i)*4))))
				}
				nLook = integerValue(tls, *(*uintptr)(unsafe.Pointer(argv + uintptr((i+1))*4)))
				szLook = integerValue(tls, *(*uintptr)(unsafe.Pointer(argv + uintptr((i+2))*4)))
				i = i + (2)
			} else if libc.Xstrcmp(tls, z, ts+22919 /* "memdb" */) == 0 {
				memDb = 1
			} else if libc.Xstrcmp(tls, z, ts+22925 /* "multithread" */) == 0 {
				sqlite3.Xsqlite3_config(tls, 2, 0)
			} else if libc.Xstrcmp(tls, z, ts+22937 /* "nomemstat" */) == 0 {
				sqlite3.Xsqlite3_config(tls, 9, libc.VaList(bp+104, 0))
			} else if libc.Xstrcmp(tls, z, ts+22947 /* "mmap" */) == 0 {
				if i >= (argc - 1) {
					fatal_error(tls, ts+22803 /* "missing argument..." */, libc.VaList(bp+120, *(*uintptr)(unsafe.Pointer(argv + uintptr(i)*4))))
				}
				mmapSize = integerValue(tls, *(*uintptr)(unsafe.Pointer(argv + uintptr(libc.PreIncInt32(&i, 1))*4)))
			} else if libc.Xstrcmp(tls, z, ts+22952 /* "nosync" */) == 0 {
				noSync = 1
			} else if libc.Xstrcmp(tls, z, ts+22959 /* "notnull" */) == 0 {
				g.zNN = ts + 22967 /* "NOT NULL" */
			} else if libc.Xstrcmp(tls, z, ts+22976 /* "output" */) == 0 {
				if i >= (argc - 1) {
					fatal_error(tls, ts+22803 /* "missing argument..." */, libc.VaList(bp+136, *(*uintptr)(unsafe.Pointer(argv + uintptr(i)*4))))
				}
				i++
				if libc.Xstrcmp(tls, *(*uintptr)(unsafe.Pointer(argv + uintptr(i)*4)), ts+22983 /* "-" */) == 0 {
					g.hashFile = libc.X__acrt_iob_func(tls, uint32(1))
				} else {
					g.hashFile = libc.Xfopen(tls, *(*uintptr)(unsafe.Pointer(argv + uintptr(i)*4)), ts+22985 /* "wb" */)
					if g.hashFile == uintptr(0) {
						fatal_error(tls, ts+22988 /* "cannot open \"%s\"..." */, libc.VaList(bp+152, *(*uintptr)(unsafe.Pointer(argv + uintptr(i)*4))))
					}
				}
			} else if libc.Xstrcmp(tls, z, ts+23018 /* "pagesize" */) == 0 {
				if i >= (argc - 1) {
					fatal_error(tls, ts+22803 /* "missing argument..." */, libc.VaList(bp+168, *(*uintptr)(unsafe.Pointer(argv + uintptr(i)*4))))
				}
				pageSize = integerValue(tls, *(*uintptr)(unsafe.Pointer(argv + uintptr(libc.PreIncInt32(&i, 1))*4)))
			} else if libc.Xstrcmp(tls, z, ts+23027 /* "pcache" */) == 0 {
				if i >= (argc - 2) {
					fatal_error(tls, ts+22861 /* "missing argument..." */, libc.VaList(bp+184, *(*uintptr)(unsafe.Pointer(argv + uintptr(i)*4))))
				}
				nPCache = integerValue(tls, *(*uintptr)(unsafe.Pointer(argv + uintptr((i+1))*4)))
				szPCache = integerValue(tls, *(*uintptr)(unsafe.Pointer(argv + uintptr((i+2))*4)))
				doPCache = 1
				i = i + (2)
			} else if libc.Xstrcmp(tls, z, ts+23034 /* "primarykey" */) == 0 {
				g.zPK = ts + 23045 /* "PRIMARY KEY" */
			} else if libc.Xstrcmp(tls, z, ts+23057 /* "repeat" */) == 0 {
				if i >= (argc - 1) {
					fatal_error(tls, ts+22861 /* "missing argument..." */, libc.VaList(bp+200, *(*uintptr)(unsafe.Pointer(argv + uintptr(i)*4))))
				}
				g.nRepeat = integerValue(tls, *(*uintptr)(unsafe.Pointer(argv + uintptr((i+1))*4)))
				i = i + (1)
			} else if libc.Xstrcmp(tls, z, ts+23064 /* "reprepare" */) == 0 {
				g.bReprepare = 1
			} else if libc.Xstrcmp(tls, z, ts+23074 /* "serialized" */) == 0 {
				sqlite3.Xsqlite3_config(tls, 3, 0)
			} else if libc.Xstrcmp(tls, z, ts+23085 /* "singlethread" */) == 0 {
				sqlite3.Xsqlite3_config(tls, 1, 0)
			} else if libc.Xstrcmp(tls, z, ts+23098 /* "sqlonly" */) == 0 {
				g.bSqlOnly = 1
			} else if libc.Xstrcmp(tls, z, ts+23106 /* "shrink-memory" */) == 0 {
				g.bMemShrink = 1
			} else if libc.Xstrcmp(tls, z, ts+23120 /* "size" */) == 0 {
				if i >= (argc - 1) {
					fatal_error(tls, ts+22803 /* "missing argument..." */, libc.VaList(bp+216, *(*uintptr)(unsafe.Pointer(argv + uintptr(i)*4))))
				}
				g.szTest = integerValue(tls, *(*uintptr)(unsafe.Pointer(argv + uintptr(libc.PreIncInt32(&i, 1))*4)))
			} else if libc.Xstrcmp(tls, z, ts+23125 /* "stats" */) == 0 {
				showStats = 1
			} else if libc.Xstrcmp(tls, z, ts+23131 /* "temp" */) == 0 {
				if i >= (argc - 1) {
					fatal_error(tls, ts+22803 /* "missing argument..." */, libc.VaList(bp+232, *(*uintptr)(unsafe.Pointer(argv + uintptr(i)*4))))
				}
				i++
				if ((int32(*(*int8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(argv + uintptr(i)*4)) + uintptr(0)))) < '0') || (int32(*(*int8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(argv + uintptr(i)*4)) + uintptr(0)))) > '9')) || (int32(*(*int8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(argv + uintptr(i)*4)) + uintptr(1)))) != 0) {
					fatal_error(tls, ts+23136 /* "argument to --te..." */, 0)
				}
				g.eTemp = (int32(*(*int8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(argv + uintptr(i)*4)) + uintptr(0)))) - '0')
			} else if libc.Xstrcmp(tls, z, ts+23189 /* "testset" */) == 0 {
				if i >= (argc - 1) {
					fatal_error(tls, ts+22803 /* "missing argument..." */, libc.VaList(bp+248, *(*uintptr)(unsafe.Pointer(argv + uintptr(i)*4))))
				}
				zTSet = *(*uintptr)(unsafe.Pointer(argv + uintptr(libc.PreIncInt32(&i, 1))*4))
			} else if libc.Xstrcmp(tls, z, ts+23197 /* "trace" */) == 0 {
				doTrace = 1
			} else if libc.Xstrcmp(tls, z, ts+23203 /* "threads" */) == 0 {
				if i >= (argc - 1) {
					fatal_error(tls, ts+22803 /* "missing argument..." */, libc.VaList(bp+264, *(*uintptr)(unsafe.Pointer(argv + uintptr(i)*4))))
				}
				nThread = integerValue(tls, *(*uintptr)(unsafe.Pointer(argv + uintptr(libc.PreIncInt32(&i, 1))*4)))
			} else if libc.Xstrcmp(tls, z, ts+23211 /* "utf16le" */) == 0 {
				zEncoding = ts + 23211 /* "utf16le" */
			} else if libc.Xstrcmp(tls, z, ts+23219 /* "utf16be" */) == 0 {
				zEncoding = ts + 23219 /* "utf16be" */
			} else if libc.Xstrcmp(tls, z, ts+23227 /* "verify" */) == 0 {
				g.bVerify = 1
				HashInit(tls)
			} else if libc.Xstrcmp(tls, z, ts+23234 /* "without-rowid" */) == 0 {
				g.zWR = ts + 5915  /* "WITHOUT ROWID" */
				g.zPK = ts + 23045 /* "PRIMARY KEY" */
			} else if (libc.Xstrcmp(tls, z, ts+23248 /* "help" */) == 0) || (libc.Xstrcmp(tls, z, ts+23253 /* "?" */) == 0) {
				libc.Xprintf(tls, uintptr(unsafe.Pointer(&zHelp)), libc.VaList(bp+280, *(*uintptr)(unsafe.Pointer(argv + uintptr(0)*4))))
				libc.Xexit(tls, 0)
			} else {
				fatal_error(tls, ts+23255, /* "unknown option: ..." */
					libc.VaList(bp+296, *(*uintptr)(unsafe.Pointer(argv + uintptr(i)*4)), *(*uintptr)(unsafe.Pointer(argv + uintptr(0)*4))))
			}
		} else if zDbName == uintptr(0) {
			zDbName = *(*uintptr)(unsafe.Pointer(argv + uintptr(i)*4))
		} else {
			fatal_error(tls, ts+23296, /* "surplus argument..." */
				libc.VaList(bp+320, *(*uintptr)(unsafe.Pointer(argv + uintptr(i)*4)), *(*uintptr)(unsafe.Pointer(argv + uintptr(0)*4))))
		}
	}
	if zDbName != uintptr(0) {
		libc.Xunlink(tls, zDbName)
	}
	if nHeap > 0 {
		pHeap = libc.Xmalloc(tls, uint32(nHeap))
		if pHeap == uintptr(0) {
			fatal_error(tls, ts+23339 /* "cannot allocate ..." */, libc.VaList(bp+344, nHeap))
		}
		rc = sqlite3.Xsqlite3_config(tls, 8, libc.VaList(bp+360, pHeap, nHeap, mnHeap))
		if rc != 0 {
			fatal_error(tls, ts+23369 /* "heap configurati..." */, libc.VaList(bp+392, rc))
		}
	}
	if doPCache != 0 {
		if (nPCache > 0) && (szPCache > 0) {
			pPCache = libc.Xmalloc(tls, (uint32(sqlite3_int64(nPCache) * sqlite3_int64(szPCache))))
			if pPCache == uintptr(0) {
				fatal_error(tls, ts+23400, /* "cannot allocate ..." */
					libc.VaList(bp+408, (sqlite3_int64(nPCache)*sqlite3_int64(szPCache))))
			}
		}
		rc = sqlite3.Xsqlite3_config(tls, 7, libc.VaList(bp+424, pPCache, szPCache, nPCache))
		if rc != 0 {
			fatal_error(tls, ts+23434 /* "pcache configura..." */, libc.VaList(bp+456, rc))
		}
	}
	if nLook >= 0 {
		sqlite3.Xsqlite3_config(tls, 13, libc.VaList(bp+472, 0, 0))
	}
	sqlite3.Xsqlite3_initialize(tls)

	// Open the database and the input file
	if sqlite3.Xsqlite3_open(tls, func() uintptr {
		if memDb != 0 {
			return ts + 23467 /* ":memory:" */
		}
		return zDbName
	}(), (uintptr(unsafe.Pointer(&g)) /* &.db */)) != 0 {
		fatal_error(tls, ts+23476 /* "Cannot open data..." */, libc.VaList(bp+496, zDbName))
	}
	if (nLook > 0) && (szLook > 0) {
		pLook = libc.Xmalloc(tls, (uint32(nLook * szLook)))
		rc = sqlite3.Xsqlite3_db_config(tls, g.db, 1001, libc.VaList(bp+512, pLook, szLook, nLook))
		if rc != 0 {
			fatal_error(tls, ts+23507 /* "lookaside config..." */, libc.VaList(bp+544, rc))
		}
	}

	// Set database connection options
	sqlite3.Xsqlite3_create_function(tls, g.db, ts+23543 /* "random" */, 0, 1, uintptr(0), *(*uintptr)(unsafe.Pointer(&struct {
		f func(*libc.TLS, uintptr, int32, uintptr)
	}{randomFunc})), uintptr(0), uintptr(0))
	if doTrace != 0 {
		sqlite3.Xsqlite3_trace(tls, g.db, *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr)
		}{traceCallback})), uintptr(0))
	}
	if memDb > 0 {
		speedtest1_exec(tls, ts+23550 /* "PRAGMA temp_stor..." */, 0)
	}
	if mmapSize > 0 {
		speedtest1_exec(tls, ts+23575 /* "PRAGMA mmap_size..." */, libc.VaList(bp+560, mmapSize))
	}
	speedtest1_exec(tls, ts+23595 /* "PRAGMA threads=%..." */, libc.VaList(bp+576, nThread))
	if zKey != 0 {
		speedtest1_exec(tls, ts+23613 /* "PRAGMA key('%s')" */, libc.VaList(bp+592, zKey))
	}
	if zEncoding != 0 {
		speedtest1_exec(tls, ts+23630 /* "PRAGMA encoding=..." */, libc.VaList(bp+608, zEncoding))
	}
	if doAutovac != 0 {
		speedtest1_exec(tls, ts+23649 /* "PRAGMA auto_vacu..." */, 0)
	} else if doIncrvac != 0 {
		speedtest1_exec(tls, ts+23673 /* "PRAGMA auto_vacu..." */, 0)
	}
	if pageSize != 0 {
		speedtest1_exec(tls, ts+23704 /* "PRAGMA page_size..." */, libc.VaList(bp+624, pageSize))
	}
	if cacheSize != 0 {
		speedtest1_exec(tls, ts+23724 /* "PRAGMA cache_siz..." */, libc.VaList(bp+640, cacheSize))
	}
	if noSync != 0 {
		speedtest1_exec(tls, ts+23745 /* "PRAGMA synchrono..." */, 0)
	}
	if doExclusive != 0 {
		speedtest1_exec(tls, ts+23768 /* "PRAGMA locking_m..." */, 0)
	}
	if zJMode != 0 {
		speedtest1_exec(tls, ts+23798 /* "PRAGMA journal_m..." */, libc.VaList(bp+656, zJMode))
	}

	if g.bExplain != 0 {
		libc.Xprintf(tls, ts+23821 /* ".explain\n.echo o..." */, 0)
	}
	for ok1 := true; ok1; ok1 = *(*int8)(unsafe.Pointer(zTSet + uintptr(0))) != 0 {
		var zThisTest uintptr = zTSet
		var zComma uintptr = libc.Xstrchr(tls, zThisTest, ',')
		if zComma != 0 {
			*(*int8)(unsafe.Pointer(zComma)) = int8(0)
			zTSet = (zComma + uintptr(1))
		} else {
			zTSet = ts + 2152 /* "" */
		}
		if (g.iTotal > int64(0)) || (zComma != uintptr(0)) {
			libc.Xprintf(tls, ts+23840 /* "       Begin tes..." */, libc.VaList(bp+672, zThisTest))
		}
		if libc.Xstrcmp(tls, zThisTest, ts+22735 /* "main" */) == 0 {
			testset_main(tls)
		} else if libc.Xstrcmp(tls, zThisTest, ts+23867 /* "debug1" */) == 0 {
			testset_debug1(tls)
		} else if libc.Xstrcmp(tls, zThisTest, ts+23874 /* "orm" */) == 0 {
			testset_orm(tls)
		} else if libc.Xstrcmp(tls, zThisTest, ts+23878 /* "cte" */) == 0 {
			testset_cte(tls)
		} else if libc.Xstrcmp(tls, zThisTest, ts+23882 /* "fp" */) == 0 {
			testset_fp(tls)
		} else if libc.Xstrcmp(tls, zThisTest, ts+23885 /* "trigger" */) == 0 {
			testset_trigger(tls)
		} else if libc.Xstrcmp(tls, zThisTest, ts+23893 /* "rtree" */) == 0 {
			testset_rtree(tls, 6, 147)
		} else {
			fatal_error(tls,
				ts+23899, /* "unknown testset:..." */
				libc.VaList(bp+688, zThisTest))
		}
		if *(*int8)(unsafe.Pointer(zTSet + uintptr(0))) != 0 {
			var zSql uintptr
			var zObj uintptr
			speedtest1_begin_test(tls, 999, ts+23968 /* "Reset the databa..." */, 0)
			for 1 != 0 {
				zObj = speedtest1_once(tls,

					ts+23987 /* "SELECT name FROM..." */, 0)
				if zObj == uintptr(0) {
					break
				}
				zSql = sqlite3.Xsqlite3_mprintf(tls, ts+24057 /* "DROP TABLE main...." */, libc.VaList(bp+704, zObj))
				speedtest1_exec(tls, zSql, 0)
				sqlite3.Xsqlite3_free(tls, zSql)
				sqlite3.Xsqlite3_free(tls, zObj)
			}
			for 1 != 0 {
				zObj = speedtest1_once(tls,

					ts+24078 /* "SELECT name FROM..." */, 0)
				if zObj == uintptr(0) {
					break
				}
				zSql = sqlite3.Xsqlite3_mprintf(tls, ts+24057 /* "DROP TABLE main...." */, libc.VaList(bp+720, zObj))
				speedtest1_exec(tls, zSql, 0)
				sqlite3.Xsqlite3_free(tls, zSql)
				sqlite3.Xsqlite3_free(tls, zObj)
			}
			speedtest1_end_test(tls)
		}
	}
	speedtest1_final(tls)

	if showStats != 0 {
		sqlite3.Xsqlite3_exec(tls, g.db, ts+24148 /* "PRAGMA compile_o..." */, *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, int32, uintptr, uintptr) int32
		}{xCompileOptions})), uintptr(0), uintptr(0))
	}

	// Database connection statistics printed after both prepared statements
	// have been finalized
	if showStats != 0 {
		sqlite3.Xsqlite3_db_status(tls, g.db, 0, bp+1008 /* &iCur */, bp+1012 /* &iHi */, 0)
		libc.Xprintf(tls, ts+24171 /* "-- Lookaside Slo..." */, libc.VaList(bp+736, *(*int32)(unsafe.Pointer(bp + 1008 /* iCur */)), *(*int32)(unsafe.Pointer(bp + 1012 /* iHi */))))
		sqlite3.Xsqlite3_db_status(tls, g.db, 4, bp+1008 /* &iCur */, bp+1012 /* &iHi */, 0)
		libc.Xprintf(tls, ts+24216 /* "-- Successful lo..." */, libc.VaList(bp+760, *(*int32)(unsafe.Pointer(bp + 1012 /* iHi */))))
		sqlite3.Xsqlite3_db_status(tls, g.db, 5, bp+1008 /* &iCur */, bp+1012 /* &iHi */, 0)
		libc.Xprintf(tls, ts+24252 /* "-- Lookaside siz..." */, libc.VaList(bp+776, *(*int32)(unsafe.Pointer(bp + 1012 /* iHi */))))
		sqlite3.Xsqlite3_db_status(tls, g.db, 6, bp+1008 /* &iCur */, bp+1012 /* &iHi */, 0)
		libc.Xprintf(tls, ts+24288 /* "-- Lookaside OOM..." */, libc.VaList(bp+792, *(*int32)(unsafe.Pointer(bp + 1012 /* iHi */))))
		sqlite3.Xsqlite3_db_status(tls, g.db, 1, bp+1008 /* &iCur */, bp+1012 /* &iHi */, 0)
		libc.Xprintf(tls, ts+24324 /* "-- Pager Heap Us..." */, libc.VaList(bp+808, *(*int32)(unsafe.Pointer(bp + 1008 /* iCur */))))
		sqlite3.Xsqlite3_db_status(tls, g.db, 7, bp+1008 /* &iCur */, bp+1012 /* &iHi */, 1)
		libc.Xprintf(tls, ts+24366 /* "-- Page cache hi..." */, libc.VaList(bp+824, *(*int32)(unsafe.Pointer(bp + 1008 /* iCur */))))
		sqlite3.Xsqlite3_db_status(tls, g.db, 8, bp+1008 /* &iCur */, bp+1012 /* &iHi */, 1)
		libc.Xprintf(tls, ts+24402 /* "-- Page cache mi..." */, libc.VaList(bp+840, *(*int32)(unsafe.Pointer(bp + 1008 /* iCur */))))
		sqlite3.Xsqlite3_db_status(tls, g.db, 9, bp+1008 /* &iCur */, bp+1012 /* &iHi */, 1)
		libc.Xprintf(tls, ts+24438 /* "-- Page cache wr..." */, libc.VaList(bp+856, *(*int32)(unsafe.Pointer(bp + 1008 /* iCur */))))
		sqlite3.Xsqlite3_db_status(tls, g.db, 2, bp+1008 /* &iCur */, bp+1012 /* &iHi */, 0)
		libc.Xprintf(tls, ts+24474 /* "-- Schema Heap U..." */, libc.VaList(bp+872, *(*int32)(unsafe.Pointer(bp + 1008 /* iCur */))))
		sqlite3.Xsqlite3_db_status(tls, g.db, 3, bp+1008 /* &iCur */, bp+1012 /* &iHi */, 0)
		libc.Xprintf(tls, ts+24516 /* "-- Statement Hea..." */, libc.VaList(bp+888, *(*int32)(unsafe.Pointer(bp + 1008 /* iCur */))))
	}

	sqlite3.Xsqlite3_close(tls, g.db)

	// Global memory usage statistics printed after the database connection
	// has closed.  Memory usage should be zero at this point.
	if showStats != 0 {
		sqlite3.Xsqlite3_status(tls, 0, bp+1008 /* &iCur */, bp+1012 /* &iHi */, 0)
		libc.Xprintf(tls, ts+24558 /* "-- Memory Used (..." */, libc.VaList(bp+904, *(*int32)(unsafe.Pointer(bp + 1008 /* iCur */)), *(*int32)(unsafe.Pointer(bp + 1012 /* iHi */))))
		sqlite3.Xsqlite3_status(tls, 9, bp+1008 /* &iCur */, bp+1012 /* &iHi */, 0)
		libc.Xprintf(tls, ts+24603 /* "-- Outstanding A..." */, libc.VaList(bp+928, *(*int32)(unsafe.Pointer(bp + 1008 /* iCur */)), *(*int32)(unsafe.Pointer(bp + 1012 /* iHi */))))
		sqlite3.Xsqlite3_status(tls, 2, bp+1008 /* &iCur */, bp+1012 /* &iHi */, 0)
		libc.Xprintf(tls, ts+24648 /* "-- Pcache Overfl..." */, libc.VaList(bp+952, *(*int32)(unsafe.Pointer(bp + 1008 /* iCur */)), *(*int32)(unsafe.Pointer(bp + 1012 /* iHi */))))
		sqlite3.Xsqlite3_status(tls, 5, bp+1008 /* &iCur */, bp+1012 /* &iHi */, 0)
		libc.Xprintf(tls, ts+24693 /* "-- Largest Alloc..." */, libc.VaList(bp+976, *(*int32)(unsafe.Pointer(bp + 1012 /* iHi */))))
		sqlite3.Xsqlite3_status(tls, 7, bp+1008 /* &iCur */, bp+1012 /* &iHi */, 0)
		libc.Xprintf(tls, ts+24735 /* "-- Largest Pcach..." */, libc.VaList(bp+992, *(*int32)(unsafe.Pointer(bp + 1012 /* iHi */))))
	}

	// Release memory
	libc.Xfree(tls, pLook)
	libc.Xfree(tls, pPCache)
	libc.Xfree(tls, pHeap)
	return 0
}

var ts1 = "Usage: %s [--options] DATABASE\nOptions:\n  --autovacuum        Enable AUTOVACUUM mode\n  --cachesize N       Set the cache size to N\n  --checkpoint        Run PRAGMA wal_checkpoint after each test case\n  --exclusive         Enable locking_mode=EXCLUSIVE\n  --explain           Like --sqlonly but with added EXPLAIN keywords\n  --heap SZ MIN       Memory allocator uses SZ bytes & min allocation MIN\n  --incrvacuum        Enable incremenatal vacuum mode\n  --journal M         Set the journal_mode to M\n  --key KEY           Set the encryption key to KEY\n  --lookaside N SZ    Configure lookaside for N slots of SZ bytes each\n  --memdb             Use an in-memory database\n  --mmap SZ           MMAP the first SZ bytes of the database file\n  --multithread       Set multithreaded mode\n  --nomemstat         Disable memory statistics\n  --nosync            Set PRAGMA synchronous=OFF\n  --notnull           Add NOT NULL constraints to table columns\n  --output FILE       Store SQL output in FILE\n  --pagesize N        Set the page size to N\n  --pcache N SZ       Configure N pages of pagecache each of size SZ bytes\n  --primarykey        Use PRIMARY KEY instead of UNIQUE where appropriate\n  --repeat N          Repeat each SELECT N times (default: 1)\n  --reprepare         Reprepare each statement upon every invocation\n  --serialized        Set serialized threading mode\n  --singlethread      Set single-threaded mode - disables all mutexing\n  --sqlonly           No-op.  Only show the SQL that would have been run.\n  --shrink-memory     Invoke sqlite3_db_release_memory() frequently.\n  --size N            Relative test size.  Default=100\n  --stats             Show statistics at the end\n  --temp N            N from 0 to 9.  0: no temp table. 9: all temp tables\n  --testset T         Run test-set T (main, cte, rtree, orm, fp, debug)\n  --trace             Turn on SQL tracing\n  --threads N         Use up to N threads for sorting\n  --utf16be           Set text encoding to UTF-16BE\n  --utf16le           Set text encoding to UTF-16LE\n  --verify            Run additional verification steps.\n  --without-rowid     Use WITHOUT ROWID where appropriate\n\x00 TEMP\x00\x00parameter too large - max 2147483648\x00KiB\x00MiB\x00GiB\x00KB\x00MB\x00GB\x00K\x00M\x00G\x00 billion\x00 million\x00 thousand\x00%s hundred\x00%s\x00zero\x00one\x00two\x00three\x00four\x00five\x00six\x00seven\x00eight\x00nine\x00ten\x00eleven\x00twelve\x00thirteen\x00fourteen\x00fifteen\x00sixteen\x00seventeen\x00eighteen\x00nineteen\x00twenty\x00thirty\x00forty\x00fifty\x00sixty\x00seventy\x00eighty\x00ninety\x00.......................................................................\x00/* %4d - %s%.*s */\n\x00%4d - %s%.*s \x00PRAGMA wal_checkpoint;\x00%4d.%03ds\n\x00       TOTAL%.*s %4d.%03ds\n\x00Verification Hash: %llu \x00\n\x00%02x\x00EXPLAIN \x00%.*s;\n\x00CREATE *\x00DROP *\x00ALTER *\x00SQL error: %s\n%s\n\x00exec error: %s\n\x00SQL error: %s\n\x00nil\x00-IFTBN\x000123456789abcdef\x00%d INSERTs into table with no index\x00BEGIN\x00CREATE%s TABLE t1(a INTEGER %s, b INTEGER %s, c TEXT %s);\x00INSERT INTO t1 VALUES(?1,?2,?3); --  %d times\x00COMMIT\x00%d ordered INSERTS with one index/PK\x00CREATE%s TABLE t2(a INTEGER %s %s, b INTEGER %s, c TEXT %s) %s\x00INSERT INTO t2 VALUES(?1,?2,?3); -- %d times\x00%d unordered INSERTS with one index/PK\x00CREATE%s TABLE t3(a INTEGER %s %s, b INTEGER %s, c TEXT %s) %s\x00INSERT INTO t3 VALUES(?1,?2,?3); -- %d times\x00%d SELECTS, numeric BETWEEN, unindexed\x00SELECT count(*), avg(b), sum(length(c)), group_concat(c) FROM t1\n WHERE b BETWEEN ?1 AND ?2; -- %d times\x00%d SELECTS, LIKE, unindexed\x00SELECT count(*), avg(b), sum(length(c)), group_concat(c) FROM t1\n WHERE c LIKE ?1; -- %d times\x00%d SELECTS w/ORDER BY, unindexed\x00SELECT a, b, c FROM t1 WHERE c LIKE ?1\n ORDER BY a; -- %d times\x00%d SELECTS w/ORDER BY and LIMIT, unindexed\x00SELECT a, b, c FROM t1 WHERE c LIKE ?1\n ORDER BY a LIMIT 10; -- %d times\x00CREATE INDEX five times\x00BEGIN;\x00CREATE UNIQUE INDEX t1b ON t1(b);\x00CREATE INDEX t1c ON t1(c);\x00CREATE UNIQUE INDEX t2b ON t2(b);\x00CREATE INDEX t2c ON t2(c DESC);\x00CREATE INDEX t3bc ON t3(b,c);\x00COMMIT;\x00%d SELECTS, numeric BETWEEN, indexed\x00SELECT count(*), avg(b), sum(length(c)), group_concat(a) FROM t1\n WHERE b BETWEEN ?1 AND ?2; -- %d times\x00%d SELECTS, numeric BETWEEN, PK\x00SELECT count(*), avg(b), sum(length(c)), group_concat(a) FROM t2\n WHERE a BETWEEN ?1 AND ?2; -- %d times\x00%d SELECTS, text BETWEEN, indexed\x00SELECT count(*), avg(b), sum(length(c)), group_concat(a) FROM t1\n WHERE c BETWEEN ?1 AND (?1||'~'); -- %d times\x00%d INSERTS with three indexes\x00CREATE%s TABLE t4(\n  a INTEGER %s %s,\n  b INTEGER %s,\n  c TEXT %s\n) %s\x00CREATE INDEX t4b ON t4(b)\x00CREATE INDEX t4c ON t4(c)\x00INSERT INTO t4 SELECT * FROM t1\x00DELETE and REFILL one table\x00DELETE FROM t2;\x00INSERT INTO t2 SELECT * FROM t1;\x00VACUUM\x00ALTER TABLE ADD COLUMN, and query\x00ALTER TABLE t2 ADD COLUMN d DEFAULT 123\x00SELECT sum(d) FROM t2\x00%d UPDATES, numeric BETWEEN, indexed\x00UPDATE t2 SET d=b*2 WHERE b BETWEEN ?1 AND ?2; -- %d times\x00%d UPDATES of individual rows\x00UPDATE t2 SET d=b*3 WHERE a=?1; -- %d times\x00One big UPDATE of the whole %d-row table\x00UPDATE t2 SET d=b*4\x00Query added column after filling\x00%d DELETEs, numeric BETWEEN, indexed\x00DELETE FROM t2 WHERE b BETWEEN ?1 AND ?2; -- %d times\x00%d DELETEs of individual rows\x00DELETE FROM t3 WHERE a=?1; -- %d times\x00Refill two %d-row tables using REPLACE\x00REPLACE INTO t2(a,b,c) SELECT a,b,c FROM t1\x00REPLACE INTO t3(a,b,c) SELECT a,b,c FROM t1\x00Refill a %d-row table using (b&1)==(a&1)\x00INSERT INTO t2(a,b,c)\n SELECT a,b,c FROM t1  WHERE (b&1)==(a&1);\x00INSERT INTO t2(a,b,c)\n SELECT a,b,c FROM t1  WHERE (b&1)<>(a&1);\x00%d four-ways joins\x00SELECT t1.c FROM t1, t2, t3, t4\n WHERE t4.a BETWEEN ?1 AND ?2\n   AND t3.a=t4.b\n   AND t2.a=t3.b\n   AND t1.c=t2.c\x00subquery in result set\x00SELECT sum(a), max(c),\n       avg((SELECT a FROM t2 WHERE 5+t2.b=t1.b) AND rowid<?1), max(c)\n FROM t1 WHERE rowid<?1;\x00%d REPLACE ops on an IPK\x00CREATE%s TABLE t5(a INTEGER PRIMARY KEY, b %s);\x00REPLACE INTO t5 VALUES(?1,?2); --  %d times\x00%d SELECTS on an IPK\x00SELECT b FROM t5 WHERE a=?1; --  %d times\x00%d REPLACE on TEXT PK\x00CREATE%s TABLE t6(a TEXT PRIMARY KEY, b %s)%s;\x00WITHOUT ROWID\x00REPLACE INTO t6 VALUES(?1,?2); --  %d times\x00%d SELECTS on a TEXT PK\x00SELECT b FROM t6 WHERE a=?1; --  %d times\x00%d SELECT DISTINCT\x00SELECT DISTINCT b FROM t5;\x00SELECT DISTINCT b FROM t6;\x00PRAGMA integrity_check\x00ANALYZE\x00Sudoku with recursive 'digits'\x00WITH RECURSIVE\n  input(sud) AS (VALUES(?1)),\n  digits(z,lp) AS (\n    VALUES('1', 1)\n    UNION ALL\n    SELECT CAST(lp+1 AS TEXT), lp+1 FROM digits WHERE lp<9\n  ),\n  x(s, ind) AS (\n    SELECT sud, instr(sud, '.') FROM input\n    UNION ALL\n    SELECT\n      substr(s, 1, ind-1) || z || substr(s, ind+1),\n      instr( substr(s, 1, ind-1) || z || substr(s, ind+1), '.' )\n     FROM x, digits AS z\n    WHERE ind>0\n      AND NOT EXISTS (\n            SELECT 1\n              FROM digits AS lp\n             WHERE z.z = substr(s, ((ind-1)/9)*9 + lp, 1)\n                OR z.z = substr(s, ((ind-1)%%9) + (lp-1)*9 + 1, 1)\n                OR z.z = substr(s, (((ind-1)/3) %% 3) * 3\n                        + ((ind-1)/27) * 27 + lp\n                        + ((lp-1) / 3) * 6, 1)\n         )\n  )\nSELECT s FROM x WHERE ind=0;\x00Sudoku with VALUES 'digits'\x00WITH RECURSIVE\n  input(sud) AS (VALUES(?1)),\n  digits(z,lp) AS (VALUES('1',1),('2',2),('3',3),('4',4),('5',5),\n                         ('6',6),('7',7),('8',8),('9',9)),\n  x(s, ind) AS (\n    SELECT sud, instr(sud, '.') FROM input\n    UNION ALL\n    SELECT\n      substr(s, 1, ind-1) || z || substr(s, ind+1),\n      instr( substr(s, 1, ind-1) || z || substr(s, ind+1), '.' )\n     FROM x, digits AS z\n    WHERE ind>0\n      AND NOT EXISTS (\n            SELECT 1\n              FROM digits AS lp\n             WHERE z.z = substr(s, ((ind-1)/9)*9 + lp, 1)\n                OR z.z = substr(s, ((ind-1)%%9) + (lp-1)*9 + 1, 1)\n                OR z.z = substr(s, (((ind-1)/3) %% 3) * 3\n                        + ((ind-1)/27) * 27 + lp\n                        + ((lp-1) / 3) * 6, 1)\n         )\n  )\nSELECT s FROM x WHERE ind=0;\x00Mandelbrot Set with spacing=%f\x00WITH RECURSIVE \n  xaxis(x) AS (VALUES(-2.0) UNION ALL SELECT x+?1 FROM xaxis WHERE x<1.2),\n  yaxis(y) AS (VALUES(-1.0) UNION ALL SELECT y+?2 FROM yaxis WHERE y<1.0),\n  m(iter, cx, cy, x, y) AS (\n    SELECT 0, x, y, 0.0, 0.0 FROM xaxis, yaxis\n    UNION ALL\n    SELECT iter+1, cx, cy, x*x-y*y + cx, 2.0*x*y + cy FROM m \n     WHERE (x*x + y*y) < 4.0 AND iter<28\n  ),\n  m2(iter, cx, cy) AS (\n    SELECT max(iter), cx, cy FROM m GROUP BY cx, cy\n  ),\n  a(t) AS (\n    SELECT group_concat( substr(' .+*#', 1+min(iter/7,4), 1), '') \n    FROM m2 GROUP BY cy\n  )\nSELECT group_concat(rtrim(t),x'0a') FROM a;\x00EXCEPT operator on %d-element tables\x00WITH RECURSIVE \n  t1(x) AS (VALUES(2) UNION ALL SELECT x+2 FROM t1 WHERE x<%d),\n  t2(y) AS (VALUES(3) UNION ALL SELECT y+3 FROM t2 WHERE y<%d)\nSELECT count(x), avg(x) FROM (\n  SELECT x FROM t1 EXCEPT SELECT y FROM t2 ORDER BY 1\n);\x00534...9..67.195....98....6.8...6...34..8.3..1....2...6.6....28....419..5...28..79\x0053....9..6..195....98....6.8...6...34..8.3..1....2...6.6....28....419..5....8..79\x0053.......6..195....98....6.8...6...34..8.3..1....2...6.6....28....419..5....8..79\x00%d.%de%d\x00Fill a table with %d FP values\x00CREATE%s TABLE t1(a REAL %s, b REAL %s);\x00INSERT INTO t1 VALUES(?1,?2); -- %d times\x00%d range queries\x00SELECT sum(b) FROM t1 WHERE a BETWEEN ?1 AND ?2\x00CREATE INDEX three times\x00CREATE INDEX t1a ON t1(a);\x00CREATE INDEX t1b ON t1(b);\x00CREATE INDEX t1ab ON t1(a,b);\x00%d indexed range queries\x00%d calls to round()\x00SELECT sum(round(a,2)+round(b,4)) FROM t1;\x00%d printf() calls\x00WITH c(fmt) AS (VALUES('%%g'),('%%e'),('%%!g'),('%%.20f'))SELECT sum(printf(fmt,a)) FROM t1, c\x00%d INSERTs into an r-tree\x00CREATE VIRTUAL TABLE rt1 USING rtree(id,x0,x1,y0,y1,z0,z1)\x00INSERT INTO rt1(id,x0,x1,y0,y1,z0,z1)VALUES(?1,?2,?3,?4,?5,?6,?7)\x00Copy from rtree to a regular table\x00CREATE TABLE t1(id INTEGER PRIMARY KEY,x0,x1,y0,y1,z0,z1)\x00INSERT INTO t1 SELECT * FROM rt1\x00%d one-dimensional intersect slice queries\x00SELECT count(*) FROM rt1 WHERE x0>=?1 AND x1<=?2\x00Verify result from 1-D intersect slice queries\x00SELECT count(*) FROM t1 WHERE x0>=?1 AND x1<=?2\x00Count disagree step %d: %d..%d.  %d vs %d\x00%d one-dimensional overlap slice queries\x00SELECT count(*) FROM rt1 WHERE y1>=?1 AND y0<=?2\x00Verify result from 1-D overlap slice queries\x00SELECT count(*) FROM t1 WHERE y1>=?1 AND y0<=?2\x00%d custom geometry callback queries\x00xslice\x00SELECT count(*) FROM rt1 WHERE id MATCH xslice(?1,?2)\x00%d three-dimensional intersect box queries\x00SELECT count(*) FROM rt1 WHERE x1>=?1 AND x0<=?2 AND y1>=?1 AND y0<=?2 AND z1>=?1 AND z0<=?2\x00%d rowid queries\x00SELECT * FROM rt1 WHERE id=?1\x00%d UPDATEs using rowid\x00UPDATE rt1 SET x0=x0+100, x1=x1+100 WHERE id=?1\x00%d UPDATEs using one-dimensional overlap\x00UPDATE rt1 SET x0=x0-100, x1=x1-100 WHERE y1>=?1 AND y0<=?1+5\x00%d DELETEs using rowid\x00DELETE FROM rt1 WHERE id=?1\x00%d DELETEs using one-dimensional overlap\x00DELETE FROM rt1 WHERE y1>=?1 AND y0<=?1+5\x00Restore deleted entries using INSERT OR IGNORE\x00INSERT OR IGNORE INTO rt1 SELECT * FROM t1\x00Fill %d rows\x00BEGIN;CREATE TABLE ZLOOKSLIKECOREDATA (  ZPK INTEGER PRIMARY KEY,  ZTERMFITTINGHOUSINGCOMMAND INTEGER,  ZBRIEFGOBYDODGERHEIGHT BLOB,  ZCAPABLETRIPDOORALMOND BLOB,  ZDEPOSITPAIRCOLLEGECOMET INTEGER,  ZFRAMEENTERSIMPLEMOUTH INTEGER,  ZHOPEFULGATEHOLECHALK INTEGER,  ZSLEEPYUSERGRANDBOWL TIMESTAMP,  ZDEWPEACHCAREERCELERY INTEGER,  ZHANGERLITHIUMDINNERMEET VARCHAR,  ZCLUBRELEASELIZARDADVICE VARCHAR,  ZCHARGECLICKHUMANEHIRE INTEGER,  ZFINGERDUEPIZZAOPTION TIMESTAMP,  ZFLYINGDOCTORTABLEMELODY BLOB,  ZLONGFINLEAVEIMAGEOIL TIMESTAMP,  ZFAMILYVISUALOWNERMATTER BLOB,  ZGOLDYOUNGINITIALNOSE FLOAT,  ZCAUSESALAMITERMCYAN BLOB,  ZSPREADMOTORBISCUITBACON FLOAT,  ZGIFTICEFISHGLUEHAIR INTEGER,  ZNOTICEPEARPOLICYJUICE TIMESTAMP,  ZBANKBUFFALORECOVERORBIT TIMESTAMP,  ZLONGDIETESSAYNATURE FLOAT,  ZACTIONRANGEELEGANTNEUTRON BLOB,  ZCADETBRIGHTPLANETBANK TIMESTAMP,  ZAIRFORGIVEHEADFROG BLOB,  ZSHARKJUSTFRUITMOVIE VARCHAR,  ZFARMERMORNINGMIRRORCONCERN BLOB,  ZWOODPOETRYCOBBLERBENCH VARCHAR,  ZHAFNIUMSCRIPTSALADMOTOR INTEGER,  ZPROBLEMCLUBPOPOVERJELLY FLOAT,  ZEIGHTLEADERWORKERMOST TIMESTAMP,  ZGLASSRESERVEBARIUMMEAL BLOB,  ZCLAMBITARUGULAFAJITA BLOB,  ZDECADEJOYOUSWAVEHABIT FLOAT,  ZCOMPANYSUMMERFIBERELF INTEGER,  ZTREATTESTQUILLCHARGE TIMESTAMP,  ZBROWBALANCEKEYCHOWDER FLOAT,  ZPEACHCOPPERDINNERLAKE FLOAT,  ZDRYWALLBEYONDBROWNBOWL VARCHAR,  ZBELLYCRASHITEMLACK BLOB,  ZTENNISCYCLEBILLOFFICER INTEGER,  ZMALLEQUIPTHANKSGLUE FLOAT,  ZMISSREPLYHUMANLIVING INTEGER,  ZKIWIVISUALPRIDEAPPLE VARCHAR,  ZWISHHITSKINMOTOR BLOB,  ZCALMRACCOONPROGRAMDEBIT VARCHAR,  ZSHINYASSISTLIVINGCRAB VARCHAR,  ZRESOLVEWRISTWRAPAPPLE VARCHAR,  ZAPPEALSIMPLESECONDHOUSING BLOB,  ZCORNERANCHORTAPEDIVER TIMESTAMP,  ZMEMORYREQUESTSOURCEBIG VARCHAR,  ZTRYFACTKEEPMILK TIMESTAMP,  ZDIVERPAINTLEATHEREASY INTEGER,  ZSORTMISTYQUOTECABBAGE BLOB,  ZTUNEGASBUFFALOCAPITAL BLOB,  ZFILLSTOPLAWJOYFUL FLOAT,  ZSTEELCAREFULPLATENUMBER FLOAT,  ZGIVEVIVIDDIVINEMEANING INTEGER,  ZTREATPACKFUTURECONVERT VARCHAR,  ZCALMLYGEMFINISHEFFECT INTEGER,  ZCABBAGESOCKEASEMINUTE BLOB,  ZPLANETFAMILYPUREMEMORY TIMESTAMP,  ZMERRYCRACKTRAINLEADER BLOB,  ZMINORWAYPAPERCLASSY TIMESTAMP,  ZEAGLELINEMINEMAIL VARCHAR,  ZRESORTYARDGREENLET TIMESTAMP,  ZYARDOREGANOVIVIDJEWEL TIMESTAMP,  ZPURECAKEVIVIDNEATLY FLOAT,  ZASKCONTACTMONITORFUN TIMESTAMP,  ZMOVEWHOGAMMAINCH VARCHAR,  ZLETTUCEBIRDMEETDEBATE TIMESTAMP,  ZGENENATURALHEARINGKITE VARCHAR,  ZMUFFINDRYERDRAWFORTUNE FLOAT,  ZGRAYSURVEYWIRELOVE FLOAT,  ZPLIERSPRINTASKOREGANO INTEGER,  ZTRAVELDRIVERCONTESTLILY INTEGER,  ZHUMORSPICESANDKIDNEY TIMESTAMP,  ZARSENICSAMPLEWAITMUON INTEGER,  ZLACEADDRESSGROUNDCAREFUL FLOAT,  ZBAMBOOMESSWASABIEVENING BLOB,  ZONERELEASEAVERAGENURSE INTEGER,  ZRADIANTWHENTRYCARD TIMESTAMP,  ZREWARDINSIDEMANGOINTENSE FLOAT,  ZNEATSTEWPARTIRON TIMESTAMP,  ZOUTSIDEPEAHENCOUNTICE TIMESTAMP,  ZCREAMEVENINGLIPBRANCH FLOAT,  ZWHALEMATHAVOCADOCOPPER FLOAT,  ZLIFEUSELEAFYBELL FLOAT,  ZWEALTHLINENGLEEFULDAY VARCHAR,  ZFACEINVITETALKGOLD BLOB,  ZWESTAMOUNTAFFECTHEARING INTEGER,  ZDELAYOUTCOMEHORNAGENCY INTEGER,  ZBIGTHINKCONVERTECONOMY BLOB,  ZBASEGOUDAREGULARFORGIVE TIMESTAMP,  ZPATTERNCLORINEGRANDCOLBY TIMESTAMP,  ZCYANBASEFEEDADROIT INTEGER,  ZCARRYFLOORMINNOWDRAGON TIMESTAMP,  ZIMAGEPENCILOTHERBOTTOM FLOAT,  ZXENONFLIGHTPALEAPPLE TIMESTAMP,  ZHERRINGJOKEFEATUREHOPEFUL FLOAT,  ZCAPYEARLYRIVETBRUSH FLOAT,  ZAGEREEDFROGBASKET VARCHAR,  ZUSUALBODYHALIBUTDIAMOND VARCHAR,  ZFOOTTAPWORDENTRY VARCHAR,  ZDISHKEEPBLESTMONITOR FLOAT,  ZBROADABLESOLIDCASUAL INTEGER,  ZSQUAREGLEEFULCHILDLIGHT INTEGER,  ZHOLIDAYHEADPONYDETAIL INTEGER,  ZGENERALRESORTSKYOPEN TIMESTAMP,  ZGLADSPRAYKIDNEYGUPPY VARCHAR,  ZSWIMHEAVYMENTIONKIND BLOB,  ZMESSYSULFURDREAMFESTIVE BLOB,  ZSKYSKYCLASSICBRIEF VARCHAR,  ZDILLASKHOKILEMON FLOAT,  ZJUNIORSHOWPRESSNOVA FLOAT,  ZSIZETOEAWARDFRESH TIMESTAMP,  ZKEYFAILAPRICOTMETAL VARCHAR,  ZHANDYREPAIRPROTONAIRPORT VARCHAR,  ZPOSTPROTEINHANDLEACTOR BLOB);\x00INSERT INTO ZLOOKSLIKECOREDATA(ZPK,ZAIRFORGIVEHEADFROG,ZGIFTICEFISHGLUEHAIR,ZDELAYOUTCOMEHORNAGENCY,ZSLEEPYUSERGRANDBOWL,ZGLASSRESERVEBARIUMMEAL,ZBRIEFGOBYDODGERHEIGHT,ZBAMBOOMESSWASABIEVENING,ZFARMERMORNINGMIRRORCONCERN,ZTREATPACKFUTURECONVERT,ZCAUSESALAMITERMCYAN,ZCALMRACCOONPROGRAMDEBIT,ZHOLIDAYHEADPONYDETAIL,ZWOODPOETRYCOBBLERBENCH,ZHAFNIUMSCRIPTSALADMOTOR,ZUSUALBODYHALIBUTDIAMOND,ZOUTSIDEPEAHENCOUNTICE,ZDIVERPAINTLEATHEREASY,ZWESTAMOUNTAFFECTHEARING,ZSIZETOEAWARDFRESH,ZDEWPEACHCAREERCELERY,ZSTEELCAREFULPLATENUMBER,ZCYANBASEFEEDADROIT,ZCALMLYGEMFINISHEFFECT,ZHANDYREPAIRPROTONAIRPORT,ZGENENATURALHEARINGKITE,ZBROADABLESOLIDCASUAL,ZPOSTPROTEINHANDLEACTOR,ZLACEADDRESSGROUNDCAREFUL,ZIMAGEPENCILOTHERBOTTOM,ZPROBLEMCLUBPOPOVERJELLY,ZPATTERNCLORINEGRANDCOLBY,ZNEATSTEWPARTIRON,ZAPPEALSIMPLESECONDHOUSING,ZMOVEWHOGAMMAINCH,ZTENNISCYCLEBILLOFFICER,ZSHARKJUSTFRUITMOVIE,ZKEYFAILAPRICOTMETAL,ZCOMPANYSUMMERFIBERELF,ZTERMFITTINGHOUSINGCOMMAND,ZRESORTYARDGREENLET,ZCABBAGESOCKEASEMINUTE,ZSQUAREGLEEFULCHILDLIGHT,ZONERELEASEAVERAGENURSE,ZBIGTHINKCONVERTECONOMY,ZPLIERSPRINTASKOREGANO,ZDECADEJOYOUSWAVEHABIT,ZDRYWALLBEYONDBROWNBOWL,ZCLUBRELEASELIZARDADVICE,ZWHALEMATHAVOCADOCOPPER,ZBELLYCRASHITEMLACK,ZLETTUCEBIRDMEETDEBATE,ZCAPABLETRIPDOORALMOND,ZRADIANTWHENTRYCARD,ZCAPYEARLYRIVETBRUSH,ZAGEREEDFROGBASKET,ZSWIMHEAVYMENTIONKIND,ZTRAVELDRIVERCONTESTLILY,ZGLADSPRAYKIDNEYGUPPY,ZBANKBUFFALORECOVERORBIT,ZFINGERDUEPIZZAOPTION,ZCLAMBITARUGULAFAJITA,ZLONGFINLEAVEIMAGEOIL,ZLONGDIETESSAYNATURE,ZJUNIORSHOWPRESSNOVA,ZHOPEFULGATEHOLECHALK,ZDEPOSITPAIRCOLLEGECOMET,ZWEALTHLINENGLEEFULDAY,ZFILLSTOPLAWJOYFUL,ZTUNEGASBUFFALOCAPITAL,ZGRAYSURVEYWIRELOVE,ZCORNERANCHORTAPEDIVER,ZREWARDINSIDEMANGOINTENSE,ZCADETBRIGHTPLANETBANK,ZPLANETFAMILYPUREMEMORY,ZTREATTESTQUILLCHARGE,ZCREAMEVENINGLIPBRANCH,ZSKYSKYCLASSICBRIEF,ZARSENICSAMPLEWAITMUON,ZBROWBALANCEKEYCHOWDER,ZFLYINGDOCTORTABLEMELODY,ZHANGERLITHIUMDINNERMEET,ZNOTICEPEARPOLICYJUICE,ZSHINYASSISTLIVINGCRAB,ZLIFEUSELEAFYBELL,ZFACEINVITETALKGOLD,ZGENERALRESORTSKYOPEN,ZPURECAKEVIVIDNEATLY,ZKIWIVISUALPRIDEAPPLE,ZMESSYSULFURDREAMFESTIVE,ZCHARGECLICKHUMANEHIRE,ZHERRINGJOKEFEATUREHOPEFUL,ZYARDOREGANOVIVIDJEWEL,ZFOOTTAPWORDENTRY,ZWISHHITSKINMOTOR,ZBASEGOUDAREGULARFORGIVE,ZMUFFINDRYERDRAWFORTUNE,ZACTIONRANGEELEGANTNEUTRON,ZTRYFACTKEEPMILK,ZPEACHCOPPERDINNERLAKE,ZFRAMEENTERSIMPLEMOUTH,ZMERRYCRACKTRAINLEADER,ZMEMORYREQUESTSOURCEBIG,ZCARRYFLOORMINNOWDRAGON,ZMINORWAYPAPERCLASSY,ZDILLASKHOKILEMON,ZRESOLVEWRISTWRAPAPPLE,ZASKCONTACTMONITORFUN,ZGIVEVIVIDDIVINEMEANING,ZEIGHTLEADERWORKERMOST,ZMISSREPLYHUMANLIVING,ZXENONFLIGHTPALEAPPLE,ZSORTMISTYQUOTECABBAGE,ZEAGLELINEMINEMAIL,ZFAMILYVISUALOWNERMATTER,ZSPREADMOTORBISCUITBACON,ZDISHKEEPBLESTMONITOR,ZMALLEQUIPTHANKSGLUE,ZGOLDYOUNGINITIALNOSE,ZHUMORSPICESANDKIDNEY)VALUES(?1,?26,?20,?93,?8,?33,?3,?81,?28,?60,?18,?47,?109,?29,?30,?104,?86,?54,?92,?117,?9,?58,?97,?61,?119,?73,?107,?120,?80,?99,?31,?96,?85,?50,?71,?42,?27,?118,?36,?2,?67,?62,?108,?82,?94,?76,?35,?40,?11,?88,?41,?72,?4,?83,?102,?103,?112,?77,?111,?22,?13,?34,?15,?23,?116,?7,?5,?90,?57,?56,?75,?51,?84,?25,?63,?37,?87,?114,?79,?38,?14,?10,?21,?48,?89,?91,?110,?69,?45,?113,?12,?101,?68,?105,?46,?95,?74,?24,?53,?39,?6,?64,?52,?98,?65,?115,?49,?70,?59,?32,?44,?100,?55,?66,?16,?19,?106,?43,?17,?78);\x00Query %d rows by rowid\x00SELECT ZCYANBASEFEEDADROIT,ZJUNIORSHOWPRESSNOVA,ZCAUSESALAMITERMCYAN,ZHOPEFULGATEHOLECHALK,ZHUMORSPICESANDKIDNEY,ZSWIMHEAVYMENTIONKIND,ZMOVEWHOGAMMAINCH,ZAPPEALSIMPLESECONDHOUSING,ZHAFNIUMSCRIPTSALADMOTOR,ZNEATSTEWPARTIRON,ZLONGFINLEAVEIMAGEOIL,ZDEWPEACHCAREERCELERY,ZXENONFLIGHTPALEAPPLE,ZCALMRACCOONPROGRAMDEBIT,ZUSUALBODYHALIBUTDIAMOND,ZTRYFACTKEEPMILK,ZWEALTHLINENGLEEFULDAY,ZLONGDIETESSAYNATURE,ZLIFEUSELEAFYBELL,ZTREATPACKFUTURECONVERT,ZMEMORYREQUESTSOURCEBIG,ZYARDOREGANOVIVIDJEWEL,ZDEPOSITPAIRCOLLEGECOMET,ZSLEEPYUSERGRANDBOWL,ZBRIEFGOBYDODGERHEIGHT,ZCLUBRELEASELIZARDADVICE,ZCAPABLETRIPDOORALMOND,ZDRYWALLBEYONDBROWNBOWL,ZASKCONTACTMONITORFUN,ZKIWIVISUALPRIDEAPPLE,ZNOTICEPEARPOLICYJUICE,ZPEACHCOPPERDINNERLAKE,ZSTEELCAREFULPLATENUMBER,ZGLADSPRAYKIDNEYGUPPY,ZCOMPANYSUMMERFIBERELF,ZTENNISCYCLEBILLOFFICER,ZIMAGEPENCILOTHERBOTTOM,ZWESTAMOUNTAFFECTHEARING,ZDIVERPAINTLEATHEREASY,ZSKYSKYCLASSICBRIEF,ZMESSYSULFURDREAMFESTIVE,ZMERRYCRACKTRAINLEADER,ZBROADABLESOLIDCASUAL,ZGLASSRESERVEBARIUMMEAL,ZTUNEGASBUFFALOCAPITAL,ZBANKBUFFALORECOVERORBIT,ZTREATTESTQUILLCHARGE,ZBAMBOOMESSWASABIEVENING,ZREWARDINSIDEMANGOINTENSE,ZEAGLELINEMINEMAIL,ZCALMLYGEMFINISHEFFECT,ZKEYFAILAPRICOTMETAL,ZFINGERDUEPIZZAOPTION,ZCADETBRIGHTPLANETBANK,ZGOLDYOUNGINITIALNOSE,ZMISSREPLYHUMANLIVING,ZEIGHTLEADERWORKERMOST,ZFRAMEENTERSIMPLEMOUTH,ZBIGTHINKCONVERTECONOMY,ZFACEINVITETALKGOLD,ZPOSTPROTEINHANDLEACTOR,ZHERRINGJOKEFEATUREHOPEFUL,ZCABBAGESOCKEASEMINUTE,ZMUFFINDRYERDRAWFORTUNE,ZPROBLEMCLUBPOPOVERJELLY,ZGIVEVIVIDDIVINEMEANING,ZGENENATURALHEARINGKITE,ZGENERALRESORTSKYOPEN,ZLETTUCEBIRDMEETDEBATE,ZBASEGOUDAREGULARFORGIVE,ZCHARGECLICKHUMANEHIRE,ZPLANETFAMILYPUREMEMORY,ZMINORWAYPAPERCLASSY,ZCAPYEARLYRIVETBRUSH,ZSIZETOEAWARDFRESH,ZARSENICSAMPLEWAITMUON,ZSQUAREGLEEFULCHILDLIGHT,ZSHINYASSISTLIVINGCRAB,ZCORNERANCHORTAPEDIVER,ZDECADEJOYOUSWAVEHABIT,ZTRAVELDRIVERCONTESTLILY,ZFLYINGDOCTORTABLEMELODY,ZSHARKJUSTFRUITMOVIE,ZFAMILYVISUALOWNERMATTER,ZFARMERMORNINGMIRRORCONCERN,ZGIFTICEFISHGLUEHAIR,ZOUTSIDEPEAHENCOUNTICE,ZSPREADMOTORBISCUITBACON,ZWISHHITSKINMOTOR,ZHOLIDAYHEADPONYDETAIL,ZWOODPOETRYCOBBLERBENCH,ZAIRFORGIVEHEADFROG,ZBROWBALANCEKEYCHOWDER,ZDISHKEEPBLESTMONITOR,ZCLAMBITARUGULAFAJITA,ZPLIERSPRINTASKOREGANO,ZRADIANTWHENTRYCARD,ZDELAYOUTCOMEHORNAGENCY,ZPURECAKEVIVIDNEATLY,ZPATTERNCLORINEGRANDCOLBY,ZHANDYREPAIRPROTONAIRPORT,ZAGEREEDFROGBASKET,ZSORTMISTYQUOTECABBAGE,ZFOOTTAPWORDENTRY,ZRESOLVEWRISTWRAPAPPLE,ZDILLASKHOKILEMON,ZFILLSTOPLAWJOYFUL,ZACTIONRANGEELEGANTNEUTRON,ZRESORTYARDGREENLET,ZCREAMEVENINGLIPBRANCH,ZWHALEMATHAVOCADOCOPPER,ZGRAYSURVEYWIRELOVE,ZBELLYCRASHITEMLACK,ZHANGERLITHIUMDINNERMEET,ZCARRYFLOORMINNOWDRAGON,ZMALLEQUIPTHANKSGLUE,ZTERMFITTINGHOUSINGCOMMAND,ZONERELEASEAVERAGENURSE,ZLACEADDRESSGROUNDCAREFUL FROM ZLOOKSLIKECOREDATA WHERE ZPK=?1;\x00IBBIIITIVVITBTBFBFITTFBTBVBVIFTBBFITFFVBIFIVBVVVBTVTIBBFFIVIBTBTVTTFTVTVFFIITIFBITFTTFFFVBIIBTTITFTFFVVVFIIITVBBVFFTVVB\x00BEGIN;CREATE TABLE t1(rowid INTEGER PRIMARY KEY, i INTEGER, t TEXT);CREATE TABLE t2(rowid INTEGER PRIMARY KEY, i INTEGER, t TEXT);CREATE TABLE t3(rowid INTEGER PRIMARY KEY, i INTEGER, t TEXT);CREATE VIEW v1 AS SELECT rowid, i, t FROM t1;CREATE VIEW v2 AS SELECT rowid, i, t FROM t2;CREATE VIEW v3 AS SELECT rowid, i, t FROM t3;\x00INSERT INTO t%d VALUES(NULL,?1,?2)\x00CREATE INDEX i1 ON t1(t);CREATE INDEX i2 ON t2(t);CREATE INDEX i3 ON t3(t);COMMIT;\x00speed4p-join1\x00SELECT * FROM t1, t2, t3 WHERE t1.oid = t2.oid AND t2.oid = t3.oid\x00speed4p-join2\x00SELECT * FROM t1, t2, t3 WHERE t1.t = t2.t AND t2.t = t3.t\x00speed4p-view1\x00SELECT * FROM v%d WHERE rowid = ?\x00speed4p-table1\x00SELECT * FROM t%d WHERE rowid = ?\x00speed4p-subselect1\x00SELECT (SELECT t FROM t1 WHERE rowid = ?1),(SELECT t FROM t2 WHERE rowid = ?1),(SELECT t FROM t3 WHERE rowid = ?1)\x00speed4p-rowid-update\x00UPDATE t1 SET i=i+1 WHERE rowid=?1\x00CREATE TABLE t5(t TEXT PRIMARY KEY, i INTEGER);\x00speed4p-insert-ignore\x00INSERT OR IGNORE INTO t5 SELECT t, i FROM t1\x00CREATE TABLE log(op TEXT, r INTEGER, i INTEGER, t TEXT);CREATE TABLE t4(rowid INTEGER PRIMARY KEY, i INTEGER, t TEXT);CREATE TRIGGER t4_trigger1 AFTER INSERT ON t4 BEGIN  INSERT INTO log VALUES('INSERT INTO t4', new.rowid, new.i, new.t);END;CREATE TRIGGER t4_trigger2 AFTER UPDATE ON t4 BEGIN  INSERT INTO log VALUES('UPDATE OF t4', new.rowid, new.i, new.t);END;CREATE TRIGGER t4_trigger3 AFTER DELETE ON t4 BEGIN  INSERT INTO log VALUES('DELETE OF t4', old.rowid, old.i, old.t);END;BEGIN;\x00speed4p-trigger1\x00INSERT INTO t4 VALUES(NULL, ?1, ?2)\x00speed4p-trigger2\x00UPDATE t4 SET i = ?1, t = ?2 WHERE rowid = ?3\x00speed4p-trigger3\x00DELETE FROM t4 WHERE rowid = ?1\x00DROP TABLE t4;DROP TABLE log;VACUUM;CREATE TABLE t4(rowid INTEGER PRIMARY KEY, i INTEGER, t TEXT);BEGIN;\x00speed4p-notrigger1\x00speed4p-notrigger2\x00speed4p-notrigger3\x00%5d %5d %5d %s\n\x00-- Compile option: %s\n\x00main\x00-- Speedtest1 for SQLite %s %.48s\n\x00UNIQUE\x00autovacuum\x00cachesize\x00missing argument on %s\n\x00exclusive\x00checkpoint\x00explain\x00heap\x00missing arguments on %s\n\x00incrvacuum\x00journal\x00key\x00lookaside\x00memdb\x00multithread\x00nomemstat\x00mmap\x00nosync\x00notnull\x00NOT NULL\x00output\x00-\x00wb\x00cannot open \"%s\" for writing\n\x00pagesize\x00pcache\x00primarykey\x00PRIMARY KEY\x00repeat\x00reprepare\x00serialized\x00singlethread\x00sqlonly\x00shrink-memory\x00size\x00stats\x00temp\x00argument to --temp should be integer between 0 and 9\x00testset\x00trace\x00threads\x00utf16le\x00utf16be\x00verify\x00without-rowid\x00help\x00?\x00unknown option: %s\nUse \"%s -?\" for help\n\x00surplus argument: %s\nUse \"%s -?\" for help\n\x00cannot allocate %d-byte heap\n\x00heap configuration failed: %d\n\x00cannot allocate %lld-byte pcache\n\x00pcache configuration failed: %d\n\x00:memory:\x00Cannot open database file: %s\n\x00lookaside configuration failed: %d\n\x00random\x00PRAGMA temp_store=memory\x00PRAGMA mmap_size=%d\x00PRAGMA threads=%d\x00PRAGMA key('%s')\x00PRAGMA encoding=%s\x00PRAGMA auto_vacuum=FULL\x00PRAGMA auto_vacuum=INCREMENTAL\x00PRAGMA page_size=%d\x00PRAGMA cache_size=%d\x00PRAGMA synchronous=OFF\x00PRAGMA locking_mode=EXCLUSIVE\x00PRAGMA journal_mode=%s\x00.explain\n.echo on\n\x00       Begin testset \"%s\"\n\x00debug1\x00orm\x00cte\x00fp\x00trigger\x00rtree\x00unknown testset: \"%s\"\nChoices: cte debug1 fp main orm rtree trigger\n\x00Reset the database\x00SELECT name FROM main.sqlite_master WHERE sql LIKE 'CREATE %%TABLE%%'\x00DROP TABLE main.\"%w\"\x00SELECT name FROM temp.sqlite_master WHERE sql LIKE 'CREATE %%TABLE%%'\x00PRAGMA compile_options\x00-- Lookaside Slots Used:        %d (max %d)\n\x00-- Successful lookasides:       %d\n\x00-- Lookaside size faults:       %d\n\x00-- Lookaside OOM faults:        %d\n\x00-- Pager Heap Usage:            %d bytes\n\x00-- Page cache hits:             %d\n\x00-- Page cache misses:           %d\n\x00-- Page cache writes:           %d\n\x00-- Schema Heap Usage:           %d bytes\n\x00-- Statement Heap Usage:        %d bytes\n\x00-- Memory Used (bytes):         %d (max %d)\n\x00-- Outstanding Allocations:     %d (max %d)\n\x00-- Pcache Overflow Bytes:       %d (max %d)\n\x00-- Largest Allocation:          %d bytes\n\x00-- Largest Pcache Allocation:   %d bytes\n\x00"
var ts = (*reflect.StringHeader)(unsafe.Pointer(&ts1)).Data
