// this file was auto-generated by internal/cmd/gentypes/main.go: DO NOT EDIT

package jwa_test

import (
	"testing"

	"github.com/lestrrat-go/jwx/jwa"
	"github.com/stretchr/testify/assert"
)

func TestKeyType(t *testing.T) {
	t.Parallel()
	t.Run(`accept jwa constant EC`, func(t *testing.T) {
		t.Parallel()
		var dst jwa.KeyType
		if !assert.NoError(t, dst.Accept(jwa.EC), `accept is successful`) {
			return
		}
		if !assert.Equal(t, jwa.EC, dst, `accepted value should be equal to constant`) {
			return
		}
	})
	t.Run(`accept the string EC`, func(t *testing.T) {
		t.Parallel()
		var dst jwa.KeyType
		if !assert.NoError(t, dst.Accept("EC"), `accept is successful`) {
			return
		}
		if !assert.Equal(t, jwa.EC, dst, `accepted value should be equal to constant`) {
			return
		}
	})
	t.Run(`accept fmt.Stringer for EC`, func(t *testing.T) {
		t.Parallel()
		var dst jwa.KeyType
		if !assert.NoError(t, dst.Accept(stringer{src: "EC"}), `accept is successful`) {
			return
		}
		if !assert.Equal(t, jwa.EC, dst, `accepted value should be equal to constant`) {
			return
		}
	})
	t.Run(`stringification for EC`, func(t *testing.T) {
		t.Parallel()
		if !assert.Equal(t, "EC", jwa.EC.String(), `stringified value matches`) {
			return
		}
	})
	t.Run(`accept jwa constant OKP`, func(t *testing.T) {
		t.Parallel()
		var dst jwa.KeyType
		if !assert.NoError(t, dst.Accept(jwa.OKP), `accept is successful`) {
			return
		}
		if !assert.Equal(t, jwa.OKP, dst, `accepted value should be equal to constant`) {
			return
		}
	})
	t.Run(`accept the string OKP`, func(t *testing.T) {
		t.Parallel()
		var dst jwa.KeyType
		if !assert.NoError(t, dst.Accept("OKP"), `accept is successful`) {
			return
		}
		if !assert.Equal(t, jwa.OKP, dst, `accepted value should be equal to constant`) {
			return
		}
	})
	t.Run(`accept fmt.Stringer for OKP`, func(t *testing.T) {
		t.Parallel()
		var dst jwa.KeyType
		if !assert.NoError(t, dst.Accept(stringer{src: "OKP"}), `accept is successful`) {
			return
		}
		if !assert.Equal(t, jwa.OKP, dst, `accepted value should be equal to constant`) {
			return
		}
	})
	t.Run(`stringification for OKP`, func(t *testing.T) {
		t.Parallel()
		if !assert.Equal(t, "OKP", jwa.OKP.String(), `stringified value matches`) {
			return
		}
	})
	t.Run(`accept jwa constant OctetSeq`, func(t *testing.T) {
		t.Parallel()
		var dst jwa.KeyType
		if !assert.NoError(t, dst.Accept(jwa.OctetSeq), `accept is successful`) {
			return
		}
		if !assert.Equal(t, jwa.OctetSeq, dst, `accepted value should be equal to constant`) {
			return
		}
	})
	t.Run(`accept the string oct`, func(t *testing.T) {
		t.Parallel()
		var dst jwa.KeyType
		if !assert.NoError(t, dst.Accept("oct"), `accept is successful`) {
			return
		}
		if !assert.Equal(t, jwa.OctetSeq, dst, `accepted value should be equal to constant`) {
			return
		}
	})
	t.Run(`accept fmt.Stringer for oct`, func(t *testing.T) {
		t.Parallel()
		var dst jwa.KeyType
		if !assert.NoError(t, dst.Accept(stringer{src: "oct"}), `accept is successful`) {
			return
		}
		if !assert.Equal(t, jwa.OctetSeq, dst, `accepted value should be equal to constant`) {
			return
		}
	})
	t.Run(`stringification for oct`, func(t *testing.T) {
		t.Parallel()
		if !assert.Equal(t, "oct", jwa.OctetSeq.String(), `stringified value matches`) {
			return
		}
	})
	t.Run(`accept jwa constant RSA`, func(t *testing.T) {
		t.Parallel()
		var dst jwa.KeyType
		if !assert.NoError(t, dst.Accept(jwa.RSA), `accept is successful`) {
			return
		}
		if !assert.Equal(t, jwa.RSA, dst, `accepted value should be equal to constant`) {
			return
		}
	})
	t.Run(`accept the string RSA`, func(t *testing.T) {
		t.Parallel()
		var dst jwa.KeyType
		if !assert.NoError(t, dst.Accept("RSA"), `accept is successful`) {
			return
		}
		if !assert.Equal(t, jwa.RSA, dst, `accepted value should be equal to constant`) {
			return
		}
	})
	t.Run(`accept fmt.Stringer for RSA`, func(t *testing.T) {
		t.Parallel()
		var dst jwa.KeyType
		if !assert.NoError(t, dst.Accept(stringer{src: "RSA"}), `accept is successful`) {
			return
		}
		if !assert.Equal(t, jwa.RSA, dst, `accepted value should be equal to constant`) {
			return
		}
	})
	t.Run(`stringification for RSA`, func(t *testing.T) {
		t.Parallel()
		if !assert.Equal(t, "RSA", jwa.RSA.String(), `stringified value matches`) {
			return
		}
	})
	t.Run(`do not accept invalid constant InvalidKeyType`, func(t *testing.T) {
		t.Parallel()
		var dst jwa.KeyType
		if !assert.Error(t, dst.Accept(jwa.InvalidKeyType), `accept should fail`) {
			return
		}
	})
	t.Run(`bail out on random integer value`, func(t *testing.T) {
		t.Parallel()
		var dst jwa.KeyType
		if !assert.Error(t, dst.Accept(1), `accept should fail`) {
			return
		}
	})
	t.Run(`do not accept invalid (totally made up) string value`, func(t *testing.T) {
		t.Parallel()
		var dst jwa.KeyType
		if !assert.Error(t, dst.Accept(`totallyInvfalidValue`), `accept should fail`) {
			return
		}
	})
	t.Run(`check list of elements`, func(t *testing.T) {
		t.Parallel()
		var expected = map[jwa.KeyType]struct{}{
			jwa.EC:       {},
			jwa.OKP:      {},
			jwa.OctetSeq: {},
			jwa.RSA:      {},
		}
		for _, v := range jwa.KeyTypes() {
			if _, ok := expected[v]; !assert.True(t, ok, `%s should be in the expected list`, v) {
				return
			}
			delete(expected, v)
		}
		if !assert.Len(t, expected, 0) {
			return
		}
	})
}
