// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/run/v2/build.proto

package runpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for submitting a Build.
type SubmitBuildRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location to build in. Location must be a region,
	// e.g., 'us-central1' or 'global' if the global builder is to be used.
	// Format:
	// `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Location of source.
	//
	// Types that are assignable to Source:
	//
	//	*SubmitBuildRequest_StorageSource
	Source isSubmitBuildRequest_Source `protobuf_oneof:"source"`
	// Required. Artifact Registry URI to store the built image.
	ImageUri string `protobuf:"bytes,3,opt,name=image_uri,json=imageUri,proto3" json:"image_uri,omitempty"`
	// Build type must be one of the following.
	//
	// Types that are assignable to BuildType:
	//
	//	*SubmitBuildRequest_BuildpackBuild
	//	*SubmitBuildRequest_DockerBuild_
	BuildType isSubmitBuildRequest_BuildType `protobuf_oneof:"build_type"`
	// Optional. The service account to use for the build. If not set, the default
	// Cloud Build service account for the project will be used.
	ServiceAccount string `protobuf:"bytes,6,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Optional. Name of the Cloud Build Custom Worker Pool that should be used to
	// build the function. The format of this field is
	// `projects/{project}/locations/{region}/workerPools/{workerPool}` where
	// `{project}` and `{region}` are the project id and region respectively where
	// the worker pool is defined and `{workerPool}` is the short name of the
	// worker pool.
	WorkerPool string `protobuf:"bytes,7,opt,name=worker_pool,json=workerPool,proto3" json:"worker_pool,omitempty"`
	// Optional. Additional tags to annotate the build.
	Tags []string `protobuf:"bytes,8,rep,name=tags,proto3" json:"tags,omitempty"`
}

func (x *SubmitBuildRequest) Reset() {
	*x = SubmitBuildRequest{}
	mi := &file_google_cloud_run_v2_build_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SubmitBuildRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubmitBuildRequest) ProtoMessage() {}

func (x *SubmitBuildRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_build_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubmitBuildRequest.ProtoReflect.Descriptor instead.
func (*SubmitBuildRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_build_proto_rawDescGZIP(), []int{0}
}

func (x *SubmitBuildRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (m *SubmitBuildRequest) GetSource() isSubmitBuildRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *SubmitBuildRequest) GetStorageSource() *StorageSource {
	if x, ok := x.GetSource().(*SubmitBuildRequest_StorageSource); ok {
		return x.StorageSource
	}
	return nil
}

func (x *SubmitBuildRequest) GetImageUri() string {
	if x != nil {
		return x.ImageUri
	}
	return ""
}

func (m *SubmitBuildRequest) GetBuildType() isSubmitBuildRequest_BuildType {
	if m != nil {
		return m.BuildType
	}
	return nil
}

func (x *SubmitBuildRequest) GetBuildpackBuild() *SubmitBuildRequest_BuildpacksBuild {
	if x, ok := x.GetBuildType().(*SubmitBuildRequest_BuildpackBuild); ok {
		return x.BuildpackBuild
	}
	return nil
}

func (x *SubmitBuildRequest) GetDockerBuild() *SubmitBuildRequest_DockerBuild {
	if x, ok := x.GetBuildType().(*SubmitBuildRequest_DockerBuild_); ok {
		return x.DockerBuild
	}
	return nil
}

func (x *SubmitBuildRequest) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *SubmitBuildRequest) GetWorkerPool() string {
	if x != nil {
		return x.WorkerPool
	}
	return ""
}

func (x *SubmitBuildRequest) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

type isSubmitBuildRequest_Source interface {
	isSubmitBuildRequest_Source()
}

type SubmitBuildRequest_StorageSource struct {
	// Required. Source for the build.
	StorageSource *StorageSource `protobuf:"bytes,2,opt,name=storage_source,json=storageSource,proto3,oneof"`
}

func (*SubmitBuildRequest_StorageSource) isSubmitBuildRequest_Source() {}

type isSubmitBuildRequest_BuildType interface {
	isSubmitBuildRequest_BuildType()
}

type SubmitBuildRequest_BuildpackBuild struct {
	// Build the source using Buildpacks.
	BuildpackBuild *SubmitBuildRequest_BuildpacksBuild `protobuf:"bytes,4,opt,name=buildpack_build,json=buildpackBuild,proto3,oneof"`
}

type SubmitBuildRequest_DockerBuild_ struct {
	// Build the source using Docker. This means the source has a Dockerfile.
	DockerBuild *SubmitBuildRequest_DockerBuild `protobuf:"bytes,5,opt,name=docker_build,json=dockerBuild,proto3,oneof"`
}

func (*SubmitBuildRequest_BuildpackBuild) isSubmitBuildRequest_BuildType() {}

func (*SubmitBuildRequest_DockerBuild_) isSubmitBuildRequest_BuildType() {}

// Response message for submitting a Build.
type SubmitBuildResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud Build operation to be polled via CloudBuild API.
	BuildOperation *longrunningpb.Operation `protobuf:"bytes,1,opt,name=build_operation,json=buildOperation,proto3" json:"build_operation,omitempty"`
	// URI of the base builder image in Artifact Registry being used in the build.
	// Used to opt into automatic base image updates.
	BaseImageUri string `protobuf:"bytes,2,opt,name=base_image_uri,json=baseImageUri,proto3" json:"base_image_uri,omitempty"`
	// Warning message for the base image.
	BaseImageWarning string `protobuf:"bytes,3,opt,name=base_image_warning,json=baseImageWarning,proto3" json:"base_image_warning,omitempty"`
}

func (x *SubmitBuildResponse) Reset() {
	*x = SubmitBuildResponse{}
	mi := &file_google_cloud_run_v2_build_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SubmitBuildResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubmitBuildResponse) ProtoMessage() {}

func (x *SubmitBuildResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_build_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubmitBuildResponse.ProtoReflect.Descriptor instead.
func (*SubmitBuildResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_build_proto_rawDescGZIP(), []int{1}
}

func (x *SubmitBuildResponse) GetBuildOperation() *longrunningpb.Operation {
	if x != nil {
		return x.BuildOperation
	}
	return nil
}

func (x *SubmitBuildResponse) GetBaseImageUri() string {
	if x != nil {
		return x.BaseImageUri
	}
	return ""
}

func (x *SubmitBuildResponse) GetBaseImageWarning() string {
	if x != nil {
		return x.BaseImageWarning
	}
	return ""
}

// Location of the source in an archive file in Google Cloud Storage.
type StorageSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Google Cloud Storage bucket containing the source (see
	// [Bucket Name
	// Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. Google Cloud Storage object containing the source.
	//
	// This object must be a gzipped archive file (`.tar.gz`) containing source to
	// build.
	Object string `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// Optional. Google Cloud Storage generation for the object. If the generation
	// is omitted, the latest generation will be used.
	Generation int64 `protobuf:"varint,3,opt,name=generation,proto3" json:"generation,omitempty"`
}

func (x *StorageSource) Reset() {
	*x = StorageSource{}
	mi := &file_google_cloud_run_v2_build_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StorageSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageSource) ProtoMessage() {}

func (x *StorageSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_build_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageSource.ProtoReflect.Descriptor instead.
func (*StorageSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_build_proto_rawDescGZIP(), []int{2}
}

func (x *StorageSource) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *StorageSource) GetObject() string {
	if x != nil {
		return x.Object
	}
	return ""
}

func (x *StorageSource) GetGeneration() int64 {
	if x != nil {
		return x.Generation
	}
	return 0
}

// Build the source using Docker. This means the source has a Dockerfile.
type SubmitBuildRequest_DockerBuild struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SubmitBuildRequest_DockerBuild) Reset() {
	*x = SubmitBuildRequest_DockerBuild{}
	mi := &file_google_cloud_run_v2_build_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SubmitBuildRequest_DockerBuild) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubmitBuildRequest_DockerBuild) ProtoMessage() {}

func (x *SubmitBuildRequest_DockerBuild) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_build_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubmitBuildRequest_DockerBuild.ProtoReflect.Descriptor instead.
func (*SubmitBuildRequest_DockerBuild) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_build_proto_rawDescGZIP(), []int{0, 0}
}

// Build the source using Buildpacks.
type SubmitBuildRequest_BuildpacksBuild struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The runtime name, e.g. 'go113'. Leave blank for generic builds.
	//
	// Deprecated: Marked as deprecated in google/cloud/run/v2/build.proto.
	Runtime string `protobuf:"bytes,1,opt,name=runtime,proto3" json:"runtime,omitempty"`
	// Optional. Name of the function target if the source is a function source.
	// Required for function builds.
	FunctionTarget string `protobuf:"bytes,2,opt,name=function_target,json=functionTarget,proto3" json:"function_target,omitempty"`
	// Optional. cache_image_uri is the GCR/AR URL where the cache image will be
	// stored. cache_image_uri is optional and omitting it will disable caching.
	// This URL must be stable across builds. It is used to derive a
	// build-specific temporary URL by substituting the tag with the build ID.
	// The build will clean up the temporary image on a best-effort basis.
	CacheImageUri string `protobuf:"bytes,3,opt,name=cache_image_uri,json=cacheImageUri,proto3" json:"cache_image_uri,omitempty"`
	// Optional. The base image to use for the build.
	BaseImage string `protobuf:"bytes,4,opt,name=base_image,json=baseImage,proto3" json:"base_image,omitempty"`
	// Optional. User-provided build-time environment variables.
	EnvironmentVariables map[string]string `protobuf:"bytes,5,rep,name=environment_variables,json=environmentVariables,proto3" json:"environment_variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Whether or not the application container will be enrolled in
	// automatic base image updates. When true, the application will be built on
	// a scratch base image, so the base layers can be appended at run time.
	EnableAutomaticUpdates bool `protobuf:"varint,6,opt,name=enable_automatic_updates,json=enableAutomaticUpdates,proto3" json:"enable_automatic_updates,omitempty"`
	// Optional. project_descriptor stores the path to the project descriptor
	// file. When empty, it means that there is no project descriptor file in
	// the source.
	ProjectDescriptor string `protobuf:"bytes,7,opt,name=project_descriptor,json=projectDescriptor,proto3" json:"project_descriptor,omitempty"`
}

func (x *SubmitBuildRequest_BuildpacksBuild) Reset() {
	*x = SubmitBuildRequest_BuildpacksBuild{}
	mi := &file_google_cloud_run_v2_build_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SubmitBuildRequest_BuildpacksBuild) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubmitBuildRequest_BuildpacksBuild) ProtoMessage() {}

func (x *SubmitBuildRequest_BuildpacksBuild) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_build_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubmitBuildRequest_BuildpacksBuild.ProtoReflect.Descriptor instead.
func (*SubmitBuildRequest_BuildpacksBuild) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_build_proto_rawDescGZIP(), []int{0, 1}
}

// Deprecated: Marked as deprecated in google/cloud/run/v2/build.proto.
func (x *SubmitBuildRequest_BuildpacksBuild) GetRuntime() string {
	if x != nil {
		return x.Runtime
	}
	return ""
}

func (x *SubmitBuildRequest_BuildpacksBuild) GetFunctionTarget() string {
	if x != nil {
		return x.FunctionTarget
	}
	return ""
}

func (x *SubmitBuildRequest_BuildpacksBuild) GetCacheImageUri() string {
	if x != nil {
		return x.CacheImageUri
	}
	return ""
}

func (x *SubmitBuildRequest_BuildpacksBuild) GetBaseImage() string {
	if x != nil {
		return x.BaseImage
	}
	return ""
}

func (x *SubmitBuildRequest_BuildpacksBuild) GetEnvironmentVariables() map[string]string {
	if x != nil {
		return x.EnvironmentVariables
	}
	return nil
}

func (x *SubmitBuildRequest_BuildpacksBuild) GetEnableAutomaticUpdates() bool {
	if x != nil {
		return x.EnableAutomaticUpdates
	}
	return false
}

func (x *SubmitBuildRequest_BuildpacksBuild) GetProjectDescriptor() string {
	if x != nil {
		return x.ProjectDescriptor
	}
	return ""
}

var File_google_cloud_run_v2_build_proto protoreflect.FileDescriptor

var file_google_cloud_run_v2_build_proto_rawDesc = []byte{
	0x0a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x75, 0x6e, 0x2f, 0x76, 0x32, 0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa0,
	0x08, 0x0a, 0x12, 0x53, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x50, 0x0a, 0x0e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x69, 0x6d,
	0x61, 0x67, 0x65, 0x55, 0x72, 0x69, 0x12, 0x62, 0x0a, 0x0f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x70,
	0x61, 0x63, 0x6b, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x75, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x42, 0x75, 0x69, 0x6c,
	0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x70, 0x61,
	0x63, 0x6b, 0x73, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x48, 0x01, 0x52, 0x0e, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x70, 0x61, 0x63, 0x6b, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x12, 0x58, 0x0a, 0x0c, 0x64, 0x6f,
	0x63, 0x6b, 0x65, 0x72, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x42, 0x75, 0x69,
	0x6c, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x44, 0x6f, 0x63, 0x6b, 0x65, 0x72,
	0x42, 0x75, 0x69, 0x6c, 0x64, 0x48, 0x01, 0x52, 0x0b, 0x64, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x42,
	0x75, 0x69, 0x6c, 0x64, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x52, 0x0a, 0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x6f,
	0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x2b, 0x0a,
	0x29, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x75, 0x69, 0x6c, 0x64,
	0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x0a, 0x77, 0x6f, 0x72, 0x6b,
	0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x08,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x1a,
	0x0d, 0x0a, 0x0b, 0x44, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x1a, 0xf8,
	0x03, 0x0a, 0x0f, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x70, 0x61, 0x63, 0x6b, 0x73, 0x42, 0x75, 0x69,
	0x6c, 0x64, 0x12, 0x1c, 0x0a, 0x07, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x07, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x12, 0x2c, 0x0a, 0x0f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e,
	0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x2b,
	0x0a, 0x0f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x63, 0x61,
	0x63, 0x68, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x55, 0x72, 0x69, 0x12, 0x22, 0x0a, 0x0a, 0x62,
	0x61, 0x73, 0x65, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x62, 0x61, 0x73, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12,
	0x8b, 0x01, 0x0a, 0x15, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x75, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x42, 0x75, 0x69, 0x6c,
	0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x70, 0x61,
	0x63, 0x6b, 0x73, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x3d, 0x0a,
	0x18, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69,
	0x63, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x75, 0x74, 0x6f,
	0x6d, 0x61, 0x74, 0x69, 0x63, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x12, 0x32, 0x0a, 0x12,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x6f, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72,
	0x1a, 0x47, 0x0a, 0x19, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x56,
	0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x42, 0x0c, 0x0a, 0x0a, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x22, 0xb1, 0x01, 0x0a, 0x13, 0x53, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x42, 0x75, 0x69, 0x6c,
	0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x0f, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x24, 0x0a, 0x0e, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x62, 0x61, 0x73, 0x65, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x55, 0x72, 0x69, 0x12, 0x2c, 0x0a, 0x12, 0x62, 0x61, 0x73, 0x65, 0x5f,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x10, 0x62, 0x61, 0x73, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x57, 0x61,
	0x72, 0x6e, 0x69, 0x6e, 0x67, 0x22, 0x6e, 0x0a, 0x0d, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x12, 0x23, 0x0a, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x32, 0xf1, 0x01, 0x0a, 0x06, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x73,
	0x12, 0x9e, 0x01, 0x0a, 0x0b, 0x53, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x42, 0x75, 0x69, 0x6c, 0x64,
	0x12, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x42, 0x75, 0x69,
	0x6c, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x2e,
	0x53, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x3c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x3a, 0x01, 0x2a, 0x22, 0x31,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x73, 0x3a, 0x73, 0x75, 0x62, 0x6d, 0x69,
	0x74, 0x1a, 0x46, 0xca, 0x41, 0x12, 0x72, 0x75, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xc3, 0x01, 0xea, 0x41, 0x6e, 0x0a,
	0x29, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x75, 0x69, 0x6c, 0x64,
	0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x41, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f,
	0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x7d, 0x0a, 0x17, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x42, 0x0a, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x29, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x72, 0x75, 0x6e, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x32, 0x2f, 0x72, 0x75, 0x6e, 0x70, 0x62, 0x3b, 0x72, 0x75, 0x6e, 0x70, 0x62, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_run_v2_build_proto_rawDescOnce sync.Once
	file_google_cloud_run_v2_build_proto_rawDescData = file_google_cloud_run_v2_build_proto_rawDesc
)

func file_google_cloud_run_v2_build_proto_rawDescGZIP() []byte {
	file_google_cloud_run_v2_build_proto_rawDescOnce.Do(func() {
		file_google_cloud_run_v2_build_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_run_v2_build_proto_rawDescData)
	})
	return file_google_cloud_run_v2_build_proto_rawDescData
}

var file_google_cloud_run_v2_build_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_cloud_run_v2_build_proto_goTypes = []any{
	(*SubmitBuildRequest)(nil),                 // 0: google.cloud.run.v2.SubmitBuildRequest
	(*SubmitBuildResponse)(nil),                // 1: google.cloud.run.v2.SubmitBuildResponse
	(*StorageSource)(nil),                      // 2: google.cloud.run.v2.StorageSource
	(*SubmitBuildRequest_DockerBuild)(nil),     // 3: google.cloud.run.v2.SubmitBuildRequest.DockerBuild
	(*SubmitBuildRequest_BuildpacksBuild)(nil), // 4: google.cloud.run.v2.SubmitBuildRequest.BuildpacksBuild
	nil,                             // 5: google.cloud.run.v2.SubmitBuildRequest.BuildpacksBuild.EnvironmentVariablesEntry
	(*longrunningpb.Operation)(nil), // 6: google.longrunning.Operation
}
var file_google_cloud_run_v2_build_proto_depIdxs = []int32{
	2, // 0: google.cloud.run.v2.SubmitBuildRequest.storage_source:type_name -> google.cloud.run.v2.StorageSource
	4, // 1: google.cloud.run.v2.SubmitBuildRequest.buildpack_build:type_name -> google.cloud.run.v2.SubmitBuildRequest.BuildpacksBuild
	3, // 2: google.cloud.run.v2.SubmitBuildRequest.docker_build:type_name -> google.cloud.run.v2.SubmitBuildRequest.DockerBuild
	6, // 3: google.cloud.run.v2.SubmitBuildResponse.build_operation:type_name -> google.longrunning.Operation
	5, // 4: google.cloud.run.v2.SubmitBuildRequest.BuildpacksBuild.environment_variables:type_name -> google.cloud.run.v2.SubmitBuildRequest.BuildpacksBuild.EnvironmentVariablesEntry
	0, // 5: google.cloud.run.v2.Builds.SubmitBuild:input_type -> google.cloud.run.v2.SubmitBuildRequest
	1, // 6: google.cloud.run.v2.Builds.SubmitBuild:output_type -> google.cloud.run.v2.SubmitBuildResponse
	6, // [6:7] is the sub-list for method output_type
	5, // [5:6] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_google_cloud_run_v2_build_proto_init() }
func file_google_cloud_run_v2_build_proto_init() {
	if File_google_cloud_run_v2_build_proto != nil {
		return
	}
	file_google_cloud_run_v2_build_proto_msgTypes[0].OneofWrappers = []any{
		(*SubmitBuildRequest_StorageSource)(nil),
		(*SubmitBuildRequest_BuildpackBuild)(nil),
		(*SubmitBuildRequest_DockerBuild_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_run_v2_build_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_run_v2_build_proto_goTypes,
		DependencyIndexes: file_google_cloud_run_v2_build_proto_depIdxs,
		MessageInfos:      file_google_cloud_run_v2_build_proto_msgTypes,
	}.Build()
	File_google_cloud_run_v2_build_proto = out.File
	file_google_cloud_run_v2_build_proto_rawDesc = nil
	file_google_cloud_run_v2_build_proto_goTypes = nil
	file_google_cloud_run_v2_build_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// BuildsClient is the client API for Builds service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BuildsClient interface {
	// Submits a build in a given project.
	SubmitBuild(ctx context.Context, in *SubmitBuildRequest, opts ...grpc.CallOption) (*SubmitBuildResponse, error)
}

type buildsClient struct {
	cc grpc.ClientConnInterface
}

func NewBuildsClient(cc grpc.ClientConnInterface) BuildsClient {
	return &buildsClient{cc}
}

func (c *buildsClient) SubmitBuild(ctx context.Context, in *SubmitBuildRequest, opts ...grpc.CallOption) (*SubmitBuildResponse, error) {
	out := new(SubmitBuildResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.run.v2.Builds/SubmitBuild", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BuildsServer is the server API for Builds service.
type BuildsServer interface {
	// Submits a build in a given project.
	SubmitBuild(context.Context, *SubmitBuildRequest) (*SubmitBuildResponse, error)
}

// UnimplementedBuildsServer can be embedded to have forward compatible implementations.
type UnimplementedBuildsServer struct {
}

func (*UnimplementedBuildsServer) SubmitBuild(context.Context, *SubmitBuildRequest) (*SubmitBuildResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SubmitBuild not implemented")
}

func RegisterBuildsServer(s *grpc.Server, srv BuildsServer) {
	s.RegisterService(&_Builds_serviceDesc, srv)
}

func _Builds_SubmitBuild_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SubmitBuildRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BuildsServer).SubmitBuild(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.run.v2.Builds/SubmitBuild",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BuildsServer).SubmitBuild(ctx, req.(*SubmitBuildRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Builds_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.run.v2.Builds",
	HandlerType: (*BuildsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SubmitBuild",
			Handler:    _Builds_SubmitBuild_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/run/v2/build.proto",
}
