// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/dialogflow/v2beta1/sip_trunk.proto

package dialogflowpb

import (
	context "context"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The state of Sip Trunk connection.
type Connection_State int32

const (
	// SIP Trunk connection state is Not specified.
	Connection_STATE_UNSPECIFIED Connection_State = 0
	// SIP Trunk connection is connected.
	Connection_CONNECTED Connection_State = 1
	// SIP Trunk connection is disconnected.
	Connection_DISCONNECTED Connection_State = 2
	// SIP Trunk connection has authentication error.
	Connection_AUTHENTICATION_FAILED Connection_State = 3
	// SIP Trunk connection is keepalive.
	Connection_KEEPALIVE Connection_State = 4
)

// Enum value maps for Connection_State.
var (
	Connection_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CONNECTED",
		2: "DISCONNECTED",
		3: "AUTHENTICATION_FAILED",
		4: "KEEPALIVE",
	}
	Connection_State_value = map[string]int32{
		"STATE_UNSPECIFIED":     0,
		"CONNECTED":             1,
		"DISCONNECTED":          2,
		"AUTHENTICATION_FAILED": 3,
		"KEEPALIVE":             4,
	}
)

func (x Connection_State) Enum() *Connection_State {
	p := new(Connection_State)
	*p = x
	return p
}

func (x Connection_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Connection_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_enumTypes[0].Descriptor()
}

func (Connection_State) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_enumTypes[0]
}

func (x Connection_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Connection_State.Descriptor instead.
func (Connection_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_rawDescGZIP(), []int{7, 0}
}

// The state of Sip Trunk certificate authentication.
type Connection_CertificateState int32

const (
	// Certificate state is not specified.
	Connection_CERTIFICATE_STATE_UNSPECIFIED Connection_CertificateState = 0
	// Certificate is valid.
	Connection_CERTIFICATE_VALID Connection_CertificateState = 1
	// Catch all for any error not specified.
	Connection_CERTIFICATE_INVALID Connection_CertificateState = 2
	// Certificate leaf node has expired.
	Connection_CERTIFICATE_EXPIRED Connection_CertificateState = 3
	// There is no hostname defined to authenticate in SipTrunkingServer.
	Connection_CERTIFICATE_HOSTNAME_NOT_FOUND Connection_CertificateState = 4
	// No path found from the leaf certificate to any root.
	Connection_CERTIFICATE_UNAUTHENTICATED Connection_CertificateState = 5
	// Trust store does not exist.
	Connection_CERTIFICATE_TRUST_STORE_NOT_FOUND Connection_CertificateState = 6
	// Hostname has invalid format.
	Connection_CERTIFICATE_HOSTNAME_INVALID_FORMAT Connection_CertificateState = 7
	// Certificate has exhausted its quota.
	Connection_CERTIFICATE_QUOTA_EXCEEDED Connection_CertificateState = 8
)

// Enum value maps for Connection_CertificateState.
var (
	Connection_CertificateState_name = map[int32]string{
		0: "CERTIFICATE_STATE_UNSPECIFIED",
		1: "CERTIFICATE_VALID",
		2: "CERTIFICATE_INVALID",
		3: "CERTIFICATE_EXPIRED",
		4: "CERTIFICATE_HOSTNAME_NOT_FOUND",
		5: "CERTIFICATE_UNAUTHENTICATED",
		6: "CERTIFICATE_TRUST_STORE_NOT_FOUND",
		7: "CERTIFICATE_HOSTNAME_INVALID_FORMAT",
		8: "CERTIFICATE_QUOTA_EXCEEDED",
	}
	Connection_CertificateState_value = map[string]int32{
		"CERTIFICATE_STATE_UNSPECIFIED":       0,
		"CERTIFICATE_VALID":                   1,
		"CERTIFICATE_INVALID":                 2,
		"CERTIFICATE_EXPIRED":                 3,
		"CERTIFICATE_HOSTNAME_NOT_FOUND":      4,
		"CERTIFICATE_UNAUTHENTICATED":         5,
		"CERTIFICATE_TRUST_STORE_NOT_FOUND":   6,
		"CERTIFICATE_HOSTNAME_INVALID_FORMAT": 7,
		"CERTIFICATE_QUOTA_EXCEEDED":          8,
	}
)

func (x Connection_CertificateState) Enum() *Connection_CertificateState {
	p := new(Connection_CertificateState)
	*p = x
	return p
}

func (x Connection_CertificateState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Connection_CertificateState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_enumTypes[1].Descriptor()
}

func (Connection_CertificateState) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_enumTypes[1]
}

func (x Connection_CertificateState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Connection_CertificateState.Descriptor instead.
func (Connection_CertificateState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_rawDescGZIP(), []int{7, 1}
}

// The request message for
// [SipTrunks.CreateSipTrunk][google.cloud.dialogflow.v2beta1.SipTrunks.CreateSipTrunk].
type CreateSipTrunkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location to create a SIP trunk for.
	// Format: `projects/<Project ID>/locations/<Location ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The SIP trunk to create.
	SipTrunk *SipTrunk `protobuf:"bytes,2,opt,name=sip_trunk,json=sipTrunk,proto3" json:"sip_trunk,omitempty"`
}

func (x *CreateSipTrunkRequest) Reset() {
	*x = CreateSipTrunkRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateSipTrunkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSipTrunkRequest) ProtoMessage() {}

func (x *CreateSipTrunkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSipTrunkRequest.ProtoReflect.Descriptor instead.
func (*CreateSipTrunkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_rawDescGZIP(), []int{0}
}

func (x *CreateSipTrunkRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSipTrunkRequest) GetSipTrunk() *SipTrunk {
	if x != nil {
		return x.SipTrunk
	}
	return nil
}

// The request message for
// [SipTrunks.DeleteSipTrunk][google.cloud.dialogflow.v2beta1.SipTrunks.DeleteSipTrunk].
type DeleteSipTrunkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the SIP trunk to delete.
	// Format: `projects/<Project ID>/locations/<Location ID>/sipTrunks/<SipTrunk
	// ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSipTrunkRequest) Reset() {
	*x = DeleteSipTrunkRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteSipTrunkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSipTrunkRequest) ProtoMessage() {}

func (x *DeleteSipTrunkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSipTrunkRequest.ProtoReflect.Descriptor instead.
func (*DeleteSipTrunkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_rawDescGZIP(), []int{1}
}

func (x *DeleteSipTrunkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [SipTrunks.ListSipTrunks][google.cloud.dialogflow.v2beta1.SipTrunks.ListSipTrunks].
type ListSipTrunksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location to list SIP trunks from.
	// Format: `projects/<Project ID>/locations/<Location ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return in a single page. By
	// default 100 and at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSipTrunksRequest) Reset() {
	*x = ListSipTrunksRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSipTrunksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSipTrunksRequest) ProtoMessage() {}

func (x *ListSipTrunksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSipTrunksRequest.ProtoReflect.Descriptor instead.
func (*ListSipTrunksRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_rawDescGZIP(), []int{2}
}

func (x *ListSipTrunksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSipTrunksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSipTrunksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for
// [SipTrunks.ListSipTrunks][google.cloud.dialogflow.v2beta1.SipTrunks.ListSipTrunks].
type ListSipTrunksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of SIP trunks.
	SipTrunks []*SipTrunk `protobuf:"bytes,1,rep,name=sip_trunks,json=sipTrunks,proto3" json:"sip_trunks,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSipTrunksResponse) Reset() {
	*x = ListSipTrunksResponse{}
	mi := &file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSipTrunksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSipTrunksResponse) ProtoMessage() {}

func (x *ListSipTrunksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSipTrunksResponse.ProtoReflect.Descriptor instead.
func (*ListSipTrunksResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_rawDescGZIP(), []int{3}
}

func (x *ListSipTrunksResponse) GetSipTrunks() []*SipTrunk {
	if x != nil {
		return x.SipTrunks
	}
	return nil
}

func (x *ListSipTrunksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for
// [SipTrunks.GetSipTrunk][google.cloud.dialogflow.v2beta1.SipTrunks.GetSipTrunk].
type GetSipTrunkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the SIP trunk to delete.
	// Format: `projects/<Project ID>/locations/<Location ID>/sipTrunks/<SipTrunk
	// ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSipTrunkRequest) Reset() {
	*x = GetSipTrunkRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSipTrunkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSipTrunkRequest) ProtoMessage() {}

func (x *GetSipTrunkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSipTrunkRequest.ProtoReflect.Descriptor instead.
func (*GetSipTrunkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_rawDescGZIP(), []int{4}
}

func (x *GetSipTrunkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [SipTrunks.UpdateSipTrunk][google.cloud.dialogflow.v2beta1.SipTrunks.UpdateSipTrunk].
type UpdateSipTrunkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The SipTrunk to update.
	SipTrunk *SipTrunk `protobuf:"bytes,1,opt,name=sip_trunk,json=sipTrunk,proto3" json:"sip_trunk,omitempty"`
	// Optional. The mask to control which fields get updated. If the mask is not
	// present, all fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSipTrunkRequest) Reset() {
	*x = UpdateSipTrunkRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateSipTrunkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSipTrunkRequest) ProtoMessage() {}

func (x *UpdateSipTrunkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSipTrunkRequest.ProtoReflect.Descriptor instead.
func (*UpdateSipTrunkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateSipTrunkRequest) GetSipTrunk() *SipTrunk {
	if x != nil {
		return x.SipTrunk
	}
	return nil
}

func (x *UpdateSipTrunkRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// SipTrunk is the resource that represents a SIP trunk to connect to Google
// Telephony platform SIP trunking service.
type SipTrunk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The unique identifier of the SIP trunk.
	// Format: `projects/<Project ID>/locations/<Location ID>/sipTrunks/<SipTrunk
	// ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The expected hostnames in the peer certificate from partner that
	// is used for TLS authentication.
	ExpectedHostname []string `protobuf:"bytes,2,rep,name=expected_hostname,json=expectedHostname,proto3" json:"expected_hostname,omitempty"`
	// Output only. Connections of the SIP trunk.
	Connections []*Connection `protobuf:"bytes,3,rep,name=connections,proto3" json:"connections,omitempty"`
	// Optional. Human readable alias for this trunk.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *SipTrunk) Reset() {
	*x = SipTrunk{}
	mi := &file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SipTrunk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SipTrunk) ProtoMessage() {}

func (x *SipTrunk) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SipTrunk.ProtoReflect.Descriptor instead.
func (*SipTrunk) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_rawDescGZIP(), []int{6}
}

func (x *SipTrunk) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SipTrunk) GetExpectedHostname() []string {
	if x != nil {
		return x.ExpectedHostname
	}
	return nil
}

func (x *SipTrunk) GetConnections() []*Connection {
	if x != nil {
		return x.Connections
	}
	return nil
}

func (x *SipTrunk) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// Represents a connection for SIP Trunk.
type Connection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The unique identifier of the SIP Trunk connection.
	ConnectionId string `protobuf:"bytes,1,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
	// Output only. State of the connection.
	State Connection_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.dialogflow.v2beta1.Connection_State" json:"state,omitempty"`
	// Output only. When the connection status changed.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3,oneof" json:"update_time,omitempty"`
	// Output only. The error details for the connection. Only populated when
	// authentication errors occur.
	ErrorDetails *Connection_ErrorDetails `protobuf:"bytes,4,opt,name=error_details,json=errorDetails,proto3,oneof" json:"error_details,omitempty"`
}

func (x *Connection) Reset() {
	*x = Connection{}
	mi := &file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Connection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Connection) ProtoMessage() {}

func (x *Connection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Connection.ProtoReflect.Descriptor instead.
func (*Connection) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_rawDescGZIP(), []int{7}
}

func (x *Connection) GetConnectionId() string {
	if x != nil {
		return x.ConnectionId
	}
	return ""
}

func (x *Connection) GetState() Connection_State {
	if x != nil {
		return x.State
	}
	return Connection_STATE_UNSPECIFIED
}

func (x *Connection) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Connection) GetErrorDetails() *Connection_ErrorDetails {
	if x != nil {
		return x.ErrorDetails
	}
	return nil
}

// The error details of Sip Trunk connection authentication.
type Connection_ErrorDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The status of the certificate authentication.
	CertificateState *Connection_CertificateState `protobuf:"varint,1,opt,name=certificate_state,json=certificateState,proto3,enum=google.cloud.dialogflow.v2beta1.Connection_CertificateState,oneof" json:"certificate_state,omitempty"`
	// The error message provided from SIP trunking auth service
	ErrorMessage *string `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3,oneof" json:"error_message,omitempty"`
}

func (x *Connection_ErrorDetails) Reset() {
	*x = Connection_ErrorDetails{}
	mi := &file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Connection_ErrorDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Connection_ErrorDetails) ProtoMessage() {}

func (x *Connection_ErrorDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Connection_ErrorDetails.ProtoReflect.Descriptor instead.
func (*Connection_ErrorDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_rawDescGZIP(), []int{7, 0}
}

func (x *Connection_ErrorDetails) GetCertificateState() Connection_CertificateState {
	if x != nil && x.CertificateState != nil {
		return *x.CertificateState
	}
	return Connection_CERTIFICATE_STATE_UNSPECIFIED
}

func (x *Connection_ErrorDetails) GetErrorMessage() string {
	if x != nil && x.ErrorMessage != nil {
		return *x.ErrorMessage
	}
	return ""
}

var File_google_cloud_dialogflow_v2beta1_sip_trunk_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x73, 0x69, 0x70, 0x5f, 0x74, 0x72, 0x75, 0x6e, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa8, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x53, 0x69, 0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x12, 0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x53, 0x69, 0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x4b, 0x0a, 0x09, 0x73, 0x69, 0x70, 0x5f, 0x74, 0x72, 0x75, 0x6e, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x69, 0x70, 0x54, 0x72, 0x75, 0x6e,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x73, 0x69, 0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b,
	0x22, 0x57, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x69, 0x70, 0x54, 0x72, 0x75,
	0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a,
	0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x69, 0x70, 0x54, 0x72,
	0x75, 0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa0, 0x01, 0x0a, 0x14, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x69, 0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x12, 0x22, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x69, 0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x89, 0x01, 0x0a,
	0x15, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x69, 0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x0a, 0x73, 0x69, 0x70, 0x5f, 0x74, 0x72,
	0x75, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x69, 0x70,
	0x54, 0x72, 0x75, 0x6e, 0x6b, 0x52, 0x09, 0x73, 0x69, 0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x54, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x53,
	0x69, 0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x69, 0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa6,
	0x01, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x69, 0x70, 0x54, 0x72, 0x75, 0x6e,
	0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x09, 0x73, 0x69, 0x70, 0x5f,
	0x74, 0x72, 0x75, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x69,
	0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x73, 0x69, 0x70,
	0x54, 0x72, 0x75, 0x6e, 0x6b, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xcd, 0x02, 0x0a, 0x08, 0x53, 0x69, 0x70, 0x54,
	0x72, 0x75, 0x6e, 0x6b, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x30, 0x0a,
	0x11, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x65,
	0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x48, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x52, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x3a, 0x7a, 0xea, 0x41, 0x77,
	0x0a, 0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x69, 0x70, 0x54,
	0x72, 0x75, 0x6e, 0x6b, 0x12, 0x3c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x69,
	0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x73, 0x2f, 0x7b, 0x73, 0x69, 0x70, 0x74, 0x72, 0x75, 0x6e,
	0x6b, 0x7d, 0x2a, 0x09, 0x73, 0x69, 0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x73, 0x32, 0x08, 0x73,
	0x69, 0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x22, 0xcf, 0x07, 0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x12, 0x4c, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x45,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x67, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x64,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x0c, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x88, 0x01, 0x01, 0x1a, 0xd5,
	0x01, 0x0a, 0x0c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12,
	0x73, 0x0a, 0x11, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52,
	0x10, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x0c, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x88, 0x01, 0x01, 0x42, 0x14,
	0x0a, 0x12, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x69, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43,
	0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x4e, 0x4e,
	0x45, 0x43, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x19, 0x0a, 0x15, 0x41, 0x55, 0x54, 0x48, 0x45,
	0x4e, 0x54, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44,
	0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x4b, 0x45, 0x45, 0x50, 0x41, 0x4c, 0x49, 0x56, 0x45, 0x10,
	0x04, 0x22, 0xb3, 0x02, 0x0a, 0x10, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x21, 0x0a, 0x1d, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46,
	0x49, 0x43, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x45, 0x52,
	0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x5f, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x01,
	0x12, 0x17, 0x0a, 0x13, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x5f,
	0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x43, 0x45, 0x52,
	0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x5f, 0x45, 0x58, 0x50, 0x49, 0x52, 0x45, 0x44,
	0x10, 0x03, 0x12, 0x22, 0x0a, 0x1e, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54,
	0x45, 0x5f, 0x48, 0x4f, 0x53, 0x54, 0x4e, 0x41, 0x4d, 0x45, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46,
	0x4f, 0x55, 0x4e, 0x44, 0x10, 0x04, 0x12, 0x1f, 0x0a, 0x1b, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46,
	0x49, 0x43, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x41, 0x55, 0x54, 0x48, 0x45, 0x4e, 0x54, 0x49,
	0x43, 0x41, 0x54, 0x45, 0x44, 0x10, 0x05, 0x12, 0x25, 0x0a, 0x21, 0x43, 0x45, 0x52, 0x54, 0x49,
	0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x52, 0x55, 0x53, 0x54, 0x5f, 0x53, 0x54, 0x4f,
	0x52, 0x45, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x06, 0x12, 0x27,
	0x0a, 0x23, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x5f, 0x48, 0x4f,
	0x53, 0x54, 0x4e, 0x41, 0x4d, 0x45, 0x5f, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x46,
	0x4f, 0x52, 0x4d, 0x41, 0x54, 0x10, 0x07, 0x12, 0x1e, 0x0a, 0x1a, 0x43, 0x45, 0x52, 0x54, 0x49,
	0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x5f, 0x51, 0x55, 0x4f, 0x54, 0x41, 0x5f, 0x45, 0x58, 0x43,
	0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x08, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x32, 0xd3, 0x08, 0x0a, 0x09, 0x53, 0x69,
	0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x73, 0x12, 0xcd, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x53, 0x69, 0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x53, 0x69, 0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x69, 0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x22, 0x58, 0xda,
	0x41, 0x10, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x69, 0x70, 0x5f, 0x74, 0x72, 0x75,
	0x6e, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x3a, 0x09, 0x73, 0x69, 0x70, 0x5f, 0x74, 0x72,
	0x75, 0x6e, 0x6b, 0x22, 0x32, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x69,
	0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x73, 0x12, 0xa3, 0x01, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x53, 0x69, 0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x53, 0x69, 0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x41, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x2a, 0x32, 0x2f, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x69, 0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc3, 0x01,
	0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x69, 0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x73, 0x12,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x69, 0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x69, 0x70,
	0x54, 0x72, 0x75, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x43,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12,
	0x32, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x69, 0x70, 0x54, 0x72, 0x75,
	0x6e, 0x6b, 0x73, 0x12, 0xb0, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x53, 0x69, 0x70, 0x54, 0x72,
	0x75, 0x6e, 0x6b, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x69, 0x70, 0x54, 0x72, 0x75, 0x6e,
	0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x69, 0x70, 0x54, 0x72,
	0x75, 0x6e, 0x6b, 0x22, 0x41, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x70, 0x54, 0x72, 0x75,
	0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xdc, 0x01, 0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x53, 0x69, 0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x53, 0x69, 0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x53, 0x69, 0x70, 0x54, 0x72, 0x75, 0x6e, 0x6b, 0x22, 0x67, 0xda, 0x41,
	0x15, 0x73, 0x69, 0x70, 0x5f, 0x74, 0x72, 0x75, 0x6e, 0x6b, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x3a, 0x09, 0x73, 0x69,
	0x70, 0x5f, 0x74, 0x72, 0x75, 0x6e, 0x6b, 0x32, 0x3c, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x73, 0x69, 0x70, 0x5f, 0x74, 0x72, 0x75, 0x6e, 0x6b, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x70, 0x54, 0x72, 0x75, 0x6e,
	0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x78, 0xca, 0x41, 0x19, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x59, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x61, 0x75, 0x74, 0x68, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x42,
	0xa2, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x0d, 0x53, 0x69, 0x70, 0x54, 0x72, 0x75, 0x6e,
	0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x70, 0x62,
	0x3b, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x70, 0x62, 0xa2, 0x02, 0x02,
	0x44, 0x46, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x56, 0x32, 0x42,
	0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_rawDescData = file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_rawDesc
)

func file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_rawDescData
}

var file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_goTypes = []any{
	(Connection_State)(0),            // 0: google.cloud.dialogflow.v2beta1.Connection.State
	(Connection_CertificateState)(0), // 1: google.cloud.dialogflow.v2beta1.Connection.CertificateState
	(*CreateSipTrunkRequest)(nil),    // 2: google.cloud.dialogflow.v2beta1.CreateSipTrunkRequest
	(*DeleteSipTrunkRequest)(nil),    // 3: google.cloud.dialogflow.v2beta1.DeleteSipTrunkRequest
	(*ListSipTrunksRequest)(nil),     // 4: google.cloud.dialogflow.v2beta1.ListSipTrunksRequest
	(*ListSipTrunksResponse)(nil),    // 5: google.cloud.dialogflow.v2beta1.ListSipTrunksResponse
	(*GetSipTrunkRequest)(nil),       // 6: google.cloud.dialogflow.v2beta1.GetSipTrunkRequest
	(*UpdateSipTrunkRequest)(nil),    // 7: google.cloud.dialogflow.v2beta1.UpdateSipTrunkRequest
	(*SipTrunk)(nil),                 // 8: google.cloud.dialogflow.v2beta1.SipTrunk
	(*Connection)(nil),               // 9: google.cloud.dialogflow.v2beta1.Connection
	(*Connection_ErrorDetails)(nil),  // 10: google.cloud.dialogflow.v2beta1.Connection.ErrorDetails
	(*fieldmaskpb.FieldMask)(nil),    // 11: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),    // 12: google.protobuf.Timestamp
	(*emptypb.Empty)(nil),            // 13: google.protobuf.Empty
}
var file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_depIdxs = []int32{
	8,  // 0: google.cloud.dialogflow.v2beta1.CreateSipTrunkRequest.sip_trunk:type_name -> google.cloud.dialogflow.v2beta1.SipTrunk
	8,  // 1: google.cloud.dialogflow.v2beta1.ListSipTrunksResponse.sip_trunks:type_name -> google.cloud.dialogflow.v2beta1.SipTrunk
	8,  // 2: google.cloud.dialogflow.v2beta1.UpdateSipTrunkRequest.sip_trunk:type_name -> google.cloud.dialogflow.v2beta1.SipTrunk
	11, // 3: google.cloud.dialogflow.v2beta1.UpdateSipTrunkRequest.update_mask:type_name -> google.protobuf.FieldMask
	9,  // 4: google.cloud.dialogflow.v2beta1.SipTrunk.connections:type_name -> google.cloud.dialogflow.v2beta1.Connection
	0,  // 5: google.cloud.dialogflow.v2beta1.Connection.state:type_name -> google.cloud.dialogflow.v2beta1.Connection.State
	12, // 6: google.cloud.dialogflow.v2beta1.Connection.update_time:type_name -> google.protobuf.Timestamp
	10, // 7: google.cloud.dialogflow.v2beta1.Connection.error_details:type_name -> google.cloud.dialogflow.v2beta1.Connection.ErrorDetails
	1,  // 8: google.cloud.dialogflow.v2beta1.Connection.ErrorDetails.certificate_state:type_name -> google.cloud.dialogflow.v2beta1.Connection.CertificateState
	2,  // 9: google.cloud.dialogflow.v2beta1.SipTrunks.CreateSipTrunk:input_type -> google.cloud.dialogflow.v2beta1.CreateSipTrunkRequest
	3,  // 10: google.cloud.dialogflow.v2beta1.SipTrunks.DeleteSipTrunk:input_type -> google.cloud.dialogflow.v2beta1.DeleteSipTrunkRequest
	4,  // 11: google.cloud.dialogflow.v2beta1.SipTrunks.ListSipTrunks:input_type -> google.cloud.dialogflow.v2beta1.ListSipTrunksRequest
	6,  // 12: google.cloud.dialogflow.v2beta1.SipTrunks.GetSipTrunk:input_type -> google.cloud.dialogflow.v2beta1.GetSipTrunkRequest
	7,  // 13: google.cloud.dialogflow.v2beta1.SipTrunks.UpdateSipTrunk:input_type -> google.cloud.dialogflow.v2beta1.UpdateSipTrunkRequest
	8,  // 14: google.cloud.dialogflow.v2beta1.SipTrunks.CreateSipTrunk:output_type -> google.cloud.dialogflow.v2beta1.SipTrunk
	13, // 15: google.cloud.dialogflow.v2beta1.SipTrunks.DeleteSipTrunk:output_type -> google.protobuf.Empty
	5,  // 16: google.cloud.dialogflow.v2beta1.SipTrunks.ListSipTrunks:output_type -> google.cloud.dialogflow.v2beta1.ListSipTrunksResponse
	8,  // 17: google.cloud.dialogflow.v2beta1.SipTrunks.GetSipTrunk:output_type -> google.cloud.dialogflow.v2beta1.SipTrunk
	8,  // 18: google.cloud.dialogflow.v2beta1.SipTrunks.UpdateSipTrunk:output_type -> google.cloud.dialogflow.v2beta1.SipTrunk
	14, // [14:19] is the sub-list for method output_type
	9,  // [9:14] is the sub-list for method input_type
	9,  // [9:9] is the sub-list for extension type_name
	9,  // [9:9] is the sub-list for extension extendee
	0,  // [0:9] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_init() }
func file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_init() {
	if File_google_cloud_dialogflow_v2beta1_sip_trunk_proto != nil {
		return
	}
	file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_msgTypes[7].OneofWrappers = []any{}
	file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_msgTypes[8].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_v2beta1_sip_trunk_proto = out.File
	file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_rawDesc = nil
	file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_goTypes = nil
	file_google_cloud_dialogflow_v2beta1_sip_trunk_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SipTrunksClient is the client API for SipTrunks service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SipTrunksClient interface {
	// Creates a SipTrunk for a specified location.
	CreateSipTrunk(ctx context.Context, in *CreateSipTrunkRequest, opts ...grpc.CallOption) (*SipTrunk, error)
	// Deletes a specified SipTrunk.
	DeleteSipTrunk(ctx context.Context, in *DeleteSipTrunkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns a list of SipTrunks in the specified location.
	ListSipTrunks(ctx context.Context, in *ListSipTrunksRequest, opts ...grpc.CallOption) (*ListSipTrunksResponse, error)
	// Retrieves the specified SipTrunk.
	GetSipTrunk(ctx context.Context, in *GetSipTrunkRequest, opts ...grpc.CallOption) (*SipTrunk, error)
	// Updates the specified SipTrunk.
	UpdateSipTrunk(ctx context.Context, in *UpdateSipTrunkRequest, opts ...grpc.CallOption) (*SipTrunk, error)
}

type sipTrunksClient struct {
	cc grpc.ClientConnInterface
}

func NewSipTrunksClient(cc grpc.ClientConnInterface) SipTrunksClient {
	return &sipTrunksClient{cc}
}

func (c *sipTrunksClient) CreateSipTrunk(ctx context.Context, in *CreateSipTrunkRequest, opts ...grpc.CallOption) (*SipTrunk, error) {
	out := new(SipTrunk)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.SipTrunks/CreateSipTrunk", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sipTrunksClient) DeleteSipTrunk(ctx context.Context, in *DeleteSipTrunkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.SipTrunks/DeleteSipTrunk", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sipTrunksClient) ListSipTrunks(ctx context.Context, in *ListSipTrunksRequest, opts ...grpc.CallOption) (*ListSipTrunksResponse, error) {
	out := new(ListSipTrunksResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.SipTrunks/ListSipTrunks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sipTrunksClient) GetSipTrunk(ctx context.Context, in *GetSipTrunkRequest, opts ...grpc.CallOption) (*SipTrunk, error) {
	out := new(SipTrunk)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.SipTrunks/GetSipTrunk", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sipTrunksClient) UpdateSipTrunk(ctx context.Context, in *UpdateSipTrunkRequest, opts ...grpc.CallOption) (*SipTrunk, error) {
	out := new(SipTrunk)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.SipTrunks/UpdateSipTrunk", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SipTrunksServer is the server API for SipTrunks service.
type SipTrunksServer interface {
	// Creates a SipTrunk for a specified location.
	CreateSipTrunk(context.Context, *CreateSipTrunkRequest) (*SipTrunk, error)
	// Deletes a specified SipTrunk.
	DeleteSipTrunk(context.Context, *DeleteSipTrunkRequest) (*emptypb.Empty, error)
	// Returns a list of SipTrunks in the specified location.
	ListSipTrunks(context.Context, *ListSipTrunksRequest) (*ListSipTrunksResponse, error)
	// Retrieves the specified SipTrunk.
	GetSipTrunk(context.Context, *GetSipTrunkRequest) (*SipTrunk, error)
	// Updates the specified SipTrunk.
	UpdateSipTrunk(context.Context, *UpdateSipTrunkRequest) (*SipTrunk, error)
}

// UnimplementedSipTrunksServer can be embedded to have forward compatible implementations.
type UnimplementedSipTrunksServer struct {
}

func (*UnimplementedSipTrunksServer) CreateSipTrunk(context.Context, *CreateSipTrunkRequest) (*SipTrunk, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSipTrunk not implemented")
}
func (*UnimplementedSipTrunksServer) DeleteSipTrunk(context.Context, *DeleteSipTrunkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSipTrunk not implemented")
}
func (*UnimplementedSipTrunksServer) ListSipTrunks(context.Context, *ListSipTrunksRequest) (*ListSipTrunksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSipTrunks not implemented")
}
func (*UnimplementedSipTrunksServer) GetSipTrunk(context.Context, *GetSipTrunkRequest) (*SipTrunk, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSipTrunk not implemented")
}
func (*UnimplementedSipTrunksServer) UpdateSipTrunk(context.Context, *UpdateSipTrunkRequest) (*SipTrunk, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSipTrunk not implemented")
}

func RegisterSipTrunksServer(s *grpc.Server, srv SipTrunksServer) {
	s.RegisterService(&_SipTrunks_serviceDesc, srv)
}

func _SipTrunks_CreateSipTrunk_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSipTrunkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SipTrunksServer).CreateSipTrunk(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.SipTrunks/CreateSipTrunk",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SipTrunksServer).CreateSipTrunk(ctx, req.(*CreateSipTrunkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SipTrunks_DeleteSipTrunk_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSipTrunkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SipTrunksServer).DeleteSipTrunk(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.SipTrunks/DeleteSipTrunk",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SipTrunksServer).DeleteSipTrunk(ctx, req.(*DeleteSipTrunkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SipTrunks_ListSipTrunks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSipTrunksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SipTrunksServer).ListSipTrunks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.SipTrunks/ListSipTrunks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SipTrunksServer).ListSipTrunks(ctx, req.(*ListSipTrunksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SipTrunks_GetSipTrunk_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSipTrunkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SipTrunksServer).GetSipTrunk(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.SipTrunks/GetSipTrunk",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SipTrunksServer).GetSipTrunk(ctx, req.(*GetSipTrunkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SipTrunks_UpdateSipTrunk_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSipTrunkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SipTrunksServer).UpdateSipTrunk(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.SipTrunks/UpdateSipTrunk",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SipTrunksServer).UpdateSipTrunk(ctx, req.(*UpdateSipTrunkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SipTrunks_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2beta1.SipTrunks",
	HandlerType: (*SipTrunksServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSipTrunk",
			Handler:    _SipTrunks_CreateSipTrunk_Handler,
		},
		{
			MethodName: "DeleteSipTrunk",
			Handler:    _SipTrunks_DeleteSipTrunk_Handler,
		},
		{
			MethodName: "ListSipTrunks",
			Handler:    _SipTrunks_ListSipTrunks_Handler,
		},
		{
			MethodName: "GetSipTrunk",
			Handler:    _SipTrunks_GetSipTrunk_Handler,
		},
		{
			MethodName: "UpdateSipTrunk",
			Handler:    _SipTrunks_UpdateSipTrunk_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2beta1/sip_trunk.proto",
}
