package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPlayInfo invokes the vod.GetPlayInfo API synchronously
// api document: https://help.aliyun.com/api/vod/getplayinfo.html
func (client *Client) GetPlayInfo(request *GetPlayInfoRequest) (response *GetPlayInfoResponse, err error) {
	response = CreateGetPlayInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetPlayInfoWithChan invokes the vod.GetPlayInfo API asynchronously
// api document: https://help.aliyun.com/api/vod/getplayinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetPlayInfoWithChan(request *GetPlayInfoRequest) (<-chan *GetPlayInfoResponse, <-chan error) {
	responseChan := make(chan *GetPlayInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPlayInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPlayInfoWithCallback invokes the vod.GetPlayInfo API asynchronously
// api document: https://help.aliyun.com/api/vod/getplayinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetPlayInfoWithCallback(request *GetPlayInfoRequest, callback func(response *GetPlayInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPlayInfoResponse
		var err error
		defer close(result)
		response, err = client.GetPlayInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPlayInfoRequest is the request struct for api GetPlayInfo
type GetPlayInfoRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	StreamType           string           `position:"Query" name:"StreamType"`
	Formats              string           `position:"Query" name:"Formats"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	Channel              string           `position:"Query" name:"Channel"`
	VideoId              string           `position:"Query" name:"VideoId"`
	PlayerVersion        string           `position:"Query" name:"PlayerVersion"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResultType           string           `position:"Query" name:"ResultType"`
	Rand                 string           `position:"Query" name:"Rand"`
	ReAuthInfo           string           `position:"Query" name:"ReAuthInfo"`
	PlayConfig           string           `position:"Query" name:"PlayConfig"`
	OutputType           string           `position:"Query" name:"OutputType"`
	Definition           string           `position:"Query" name:"Definition"`
	AuthTimeout          requests.Integer `position:"Query" name:"AuthTimeout"`
	AuthInfo             string           `position:"Query" name:"AuthInfo"`
}

// GetPlayInfoResponse is the response struct for api GetPlayInfo
type GetPlayInfoResponse struct {
	*responses.BaseResponse
	RequestId    string                    `json:"RequestId" xml:"RequestId"`
	VideoBase    VideoBase                 `json:"VideoBase" xml:"VideoBase"`
	PlayInfoList PlayInfoListInGetPlayInfo `json:"PlayInfoList" xml:"PlayInfoList"`
}

// CreateGetPlayInfoRequest creates a request to invoke GetPlayInfo API
func CreateGetPlayInfoRequest() (request *GetPlayInfoRequest) {
	request = &GetPlayInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "GetPlayInfo", "vod", "openAPI")
	return
}

// CreateGetPlayInfoResponse creates a response to parse from GetPlayInfo response
func CreateGetPlayInfoResponse() (response *GetPlayInfoResponse) {
	response = &GetPlayInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
