package ons

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OnsConsumerResetOffset invokes the ons.OnsConsumerResetOffset API synchronously
// api document: https://help.aliyun.com/api/ons/onsconsumerresetoffset.html
func (client *Client) OnsConsumerResetOffset(request *OnsConsumerResetOffsetRequest) (response *OnsConsumerResetOffsetResponse, err error) {
	response = CreateOnsConsumerResetOffsetResponse()
	err = client.DoAction(request, response)
	return
}

// OnsConsumerResetOffsetWithChan invokes the ons.OnsConsumerResetOffset API asynchronously
// api document: https://help.aliyun.com/api/ons/onsconsumerresetoffset.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OnsConsumerResetOffsetWithChan(request *OnsConsumerResetOffsetRequest) (<-chan *OnsConsumerResetOffsetResponse, <-chan error) {
	responseChan := make(chan *OnsConsumerResetOffsetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OnsConsumerResetOffset(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OnsConsumerResetOffsetWithCallback invokes the ons.OnsConsumerResetOffset API asynchronously
// api document: https://help.aliyun.com/api/ons/onsconsumerresetoffset.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OnsConsumerResetOffsetWithCallback(request *OnsConsumerResetOffsetRequest, callback func(response *OnsConsumerResetOffsetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OnsConsumerResetOffsetResponse
		var err error
		defer close(result)
		response, err = client.OnsConsumerResetOffset(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OnsConsumerResetOffsetRequest is the request struct for api OnsConsumerResetOffset
type OnsConsumerResetOffsetRequest struct {
	*requests.RpcRequest
	PreventCache   requests.Integer `position:"Query" name:"PreventCache"`
	InstanceId     string           `position:"Query" name:"InstanceId"`
	GroupId        string           `position:"Query" name:"GroupId"`
	Topic          string           `position:"Query" name:"Topic"`
	ResetTimestamp requests.Integer `position:"Query" name:"ResetTimestamp"`
	Type           requests.Integer `position:"Query" name:"Type"`
}

// OnsConsumerResetOffsetResponse is the response struct for api OnsConsumerResetOffset
type OnsConsumerResetOffsetResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	HelpUrl   string `json:"HelpUrl" xml:"HelpUrl"`
}

// CreateOnsConsumerResetOffsetRequest creates a request to invoke OnsConsumerResetOffset API
func CreateOnsConsumerResetOffsetRequest() (request *OnsConsumerResetOffsetRequest) {
	request = &OnsConsumerResetOffsetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ons", "2019-02-14", "OnsConsumerResetOffset", "ons", "openAPI")
	return
}

// CreateOnsConsumerResetOffsetResponse creates a response to parse from OnsConsumerResetOffset response
func CreateOnsConsumerResetOffsetResponse() (response *OnsConsumerResetOffsetResponse) {
	response = &OnsConsumerResetOffsetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
