package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryMediaList invokes the mts.QueryMediaList API synchronously
// api document: https://help.aliyun.com/api/mts/querymedialist.html
func (client *Client) QueryMediaList(request *QueryMediaListRequest) (response *QueryMediaListResponse, err error) {
	response = CreateQueryMediaListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryMediaListWithChan invokes the mts.QueryMediaList API asynchronously
// api document: https://help.aliyun.com/api/mts/querymedialist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryMediaListWithChan(request *QueryMediaListRequest) (<-chan *QueryMediaListResponse, <-chan error) {
	responseChan := make(chan *QueryMediaListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryMediaList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryMediaListWithCallback invokes the mts.QueryMediaList API asynchronously
// api document: https://help.aliyun.com/api/mts/querymedialist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryMediaListWithCallback(request *QueryMediaListRequest, callback func(response *QueryMediaListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryMediaListResponse
		var err error
		defer close(result)
		response, err = client.QueryMediaList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryMediaListRequest is the request struct for api QueryMediaList
type QueryMediaListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	IncludeSummaryList   requests.Boolean `position:"Query" name:"IncludeSummaryList"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	IncludeSnapshotList  requests.Boolean `position:"Query" name:"IncludeSnapshotList"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	MediaIds             string           `position:"Query" name:"MediaIds"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	IncludePlayList      requests.Boolean `position:"Query" name:"IncludePlayList"`
	IncludeMediaInfo     requests.Boolean `position:"Query" name:"IncludeMediaInfo"`
}

// QueryMediaListResponse is the response struct for api QueryMediaList
type QueryMediaListResponse struct {
	*responses.BaseResponse
	RequestId        string                    `json:"RequestId" xml:"RequestId"`
	NonExistMediaIds NonExistMediaIds          `json:"NonExistMediaIds" xml:"NonExistMediaIds"`
	MediaList        MediaListInQueryMediaList `json:"MediaList" xml:"MediaList"`
}

// CreateQueryMediaListRequest creates a request to invoke QueryMediaList API
func CreateQueryMediaListRequest() (request *QueryMediaListRequest) {
	request = &QueryMediaListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "QueryMediaList", "mts", "openAPI")
	return
}

// CreateQueryMediaListResponse creates a response to parse from QueryMediaList response
func CreateQueryMediaListResponse() (response *QueryMediaListResponse) {
	response = &QueryMediaListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
