package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartMultipleStreamMixService invokes the live.StartMultipleStreamMixService API synchronously
// api document: https://help.aliyun.com/api/live/startmultiplestreammixservice.html
func (client *Client) StartMultipleStreamMixService(request *StartMultipleStreamMixServiceRequest) (response *StartMultipleStreamMixServiceResponse, err error) {
	response = CreateStartMultipleStreamMixServiceResponse()
	err = client.DoAction(request, response)
	return
}

// StartMultipleStreamMixServiceWithChan invokes the live.StartMultipleStreamMixService API asynchronously
// api document: https://help.aliyun.com/api/live/startmultiplestreammixservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StartMultipleStreamMixServiceWithChan(request *StartMultipleStreamMixServiceRequest) (<-chan *StartMultipleStreamMixServiceResponse, <-chan error) {
	responseChan := make(chan *StartMultipleStreamMixServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartMultipleStreamMixService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartMultipleStreamMixServiceWithCallback invokes the live.StartMultipleStreamMixService API asynchronously
// api document: https://help.aliyun.com/api/live/startmultiplestreammixservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StartMultipleStreamMixServiceWithCallback(request *StartMultipleStreamMixServiceRequest, callback func(response *StartMultipleStreamMixServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartMultipleStreamMixServiceResponse
		var err error
		defer close(result)
		response, err = client.StartMultipleStreamMixService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartMultipleStreamMixServiceRequest is the request struct for api StartMultipleStreamMixService
type StartMultipleStreamMixServiceRequest struct {
	*requests.RpcRequest
	AppName       string           `position:"Query" name:"AppName"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	DomainName    string           `position:"Query" name:"DomainName"`
	MixTemplate   string           `position:"Query" name:"MixTemplate"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	StreamName    string           `position:"Query" name:"StreamName"`
}

// StartMultipleStreamMixServiceResponse is the response struct for api StartMultipleStreamMixService
type StartMultipleStreamMixServiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStartMultipleStreamMixServiceRequest creates a request to invoke StartMultipleStreamMixService API
func CreateStartMultipleStreamMixServiceRequest() (request *StartMultipleStreamMixServiceRequest) {
	request = &StartMultipleStreamMixServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "StartMultipleStreamMixService", "live", "openAPI")
	return
}

// CreateStartMultipleStreamMixServiceResponse creates a response to parse from StartMultipleStreamMixService response
func CreateStartMultipleStreamMixServiceResponse() (response *StartMultipleStreamMixServiceResponse) {
	response = &StartMultipleStreamMixServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
