package industry_brain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAsyncServiceResult invokes the industry_brain.GetAsyncServiceResult API synchronously
// api document: https://help.aliyun.com/api/industry-brain/getasyncserviceresult.html
func (client *Client) GetAsyncServiceResult(request *GetAsyncServiceResultRequest) (response *GetAsyncServiceResultResponse, err error) {
	response = CreateGetAsyncServiceResultResponse()
	err = client.DoAction(request, response)
	return
}

// GetAsyncServiceResultWithChan invokes the industry_brain.GetAsyncServiceResult API asynchronously
// api document: https://help.aliyun.com/api/industry-brain/getasyncserviceresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetAsyncServiceResultWithChan(request *GetAsyncServiceResultRequest) (<-chan *GetAsyncServiceResultResponse, <-chan error) {
	responseChan := make(chan *GetAsyncServiceResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAsyncServiceResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAsyncServiceResultWithCallback invokes the industry_brain.GetAsyncServiceResult API asynchronously
// api document: https://help.aliyun.com/api/industry-brain/getasyncserviceresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetAsyncServiceResultWithCallback(request *GetAsyncServiceResultRequest, callback func(response *GetAsyncServiceResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAsyncServiceResultResponse
		var err error
		defer close(result)
		response, err = client.GetAsyncServiceResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAsyncServiceResultRequest is the request struct for api GetAsyncServiceResult
type GetAsyncServiceResultRequest struct {
	*requests.RpcRequest
	TaskId string `position:"Query" name:"TaskId"`
}

// GetAsyncServiceResultResponse is the response struct for api GetAsyncServiceResult
type GetAsyncServiceResultResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateGetAsyncServiceResultRequest creates a request to invoke GetAsyncServiceResult API
func CreateGetAsyncServiceResultRequest() (request *GetAsyncServiceResultRequest) {
	request = &GetAsyncServiceResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("industry-brain", "2018-07-12", "GetAsyncServiceResult", "", "")
	return
}

// CreateGetAsyncServiceResultResponse creates a response to parse from GetAsyncServiceResult response
func CreateGetAsyncServiceResultResponse() (response *GetAsyncServiceResultResponse) {
	response = &GetAsyncServiceResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
