package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTagJob invokes the imm.CreateTagJob API synchronously
// api document: https://help.aliyun.com/api/imm/createtagjob.html
func (client *Client) CreateTagJob(request *CreateTagJobRequest) (response *CreateTagJobResponse, err error) {
	response = CreateCreateTagJobResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTagJobWithChan invokes the imm.CreateTagJob API asynchronously
// api document: https://help.aliyun.com/api/imm/createtagjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateTagJobWithChan(request *CreateTagJobRequest) (<-chan *CreateTagJobResponse, <-chan error) {
	responseChan := make(chan *CreateTagJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTagJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTagJobWithCallback invokes the imm.CreateTagJob API asynchronously
// api document: https://help.aliyun.com/api/imm/createtagjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateTagJobWithCallback(request *CreateTagJobRequest, callback func(response *CreateTagJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTagJobResponse
		var err error
		defer close(result)
		response, err = client.CreateTagJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTagJobRequest is the request struct for api CreateTagJob
type CreateTagJobRequest struct {
	*requests.RpcRequest
	NotifyTopicName string `position:"Query" name:"NotifyTopicName"`
	NotifyEndpoint  string `position:"Query" name:"NotifyEndpoint"`
	Project         string `position:"Query" name:"Project"`
	ExternalID      string `position:"Query" name:"ExternalID"`
	SrcUri          string `position:"Query" name:"SrcUri"`
}

// CreateTagJobResponse is the response struct for api CreateTagJob
type CreateTagJobResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	JobId      string `json:"JobId" xml:"JobId"`
	SetId      string `json:"SetId" xml:"SetId"`
	SrcUri     string `json:"SrcUri" xml:"SrcUri"`
	Status     string `json:"Status" xml:"Status"`
	Percent    int    `json:"Percent" xml:"Percent"`
	CreateTime string `json:"CreateTime" xml:"CreateTime"`
	FinishTime string `json:"FinishTime" xml:"FinishTime"`
}

// CreateCreateTagJobRequest creates a request to invoke CreateTagJob API
func CreateCreateTagJobRequest() (request *CreateTagJobRequest) {
	request = &CreateTagJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "CreateTagJob", "imm", "openAPI")
	return
}

// CreateCreateTagJobResponse creates a response to parse from CreateTagJob response
func CreateCreateTagJobResponse() (response *CreateTagJobResponse) {
	response = &CreateTagJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
