package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddGroups invokes the green.AddGroups API synchronously
// api document: https://help.aliyun.com/api/green/addgroups.html
func (client *Client) AddGroups(request *AddGroupsRequest) (response *AddGroupsResponse, err error) {
	response = CreateAddGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// AddGroupsWithChan invokes the green.AddGroups API asynchronously
// api document: https://help.aliyun.com/api/green/addgroups.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddGroupsWithChan(request *AddGroupsRequest) (<-chan *AddGroupsResponse, <-chan error) {
	responseChan := make(chan *AddGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddGroupsWithCallback invokes the green.AddGroups API asynchronously
// api document: https://help.aliyun.com/api/green/addgroups.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddGroupsWithCallback(request *AddGroupsRequest, callback func(response *AddGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddGroupsResponse
		var err error
		defer close(result)
		response, err = client.AddGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddGroupsRequest is the request struct for api AddGroups
type AddGroupsRequest struct {
	*requests.RoaRequest
	ClientInfo string `position:"Query" name:"ClientInfo"`
}

// AddGroupsResponse is the response struct for api AddGroups
type AddGroupsResponse struct {
	*responses.BaseResponse
}

// CreateAddGroupsRequest creates a request to invoke AddGroups API
func CreateAddGroupsRequest() (request *AddGroupsRequest) {
	request = &AddGroupsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2018-05-09", "AddGroups", "/green/sface/person/groups/add", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddGroupsResponse creates a response to parse from AddGroups response
func CreateAddGroupsResponse() (response *AddGroupsResponse) {
	response = &AddGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
