package finmall

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SignResultNotify invokes the finmall.SignResultNotify API synchronously
// api document: https://help.aliyun.com/api/finmall/signresultnotify.html
func (client *Client) SignResultNotify(request *SignResultNotifyRequest) (response *SignResultNotifyResponse, err error) {
	response = CreateSignResultNotifyResponse()
	err = client.DoAction(request, response)
	return
}

// SignResultNotifyWithChan invokes the finmall.SignResultNotify API asynchronously
// api document: https://help.aliyun.com/api/finmall/signresultnotify.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SignResultNotifyWithChan(request *SignResultNotifyRequest) (<-chan *SignResultNotifyResponse, <-chan error) {
	responseChan := make(chan *SignResultNotifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SignResultNotify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SignResultNotifyWithCallback invokes the finmall.SignResultNotify API asynchronously
// api document: https://help.aliyun.com/api/finmall/signresultnotify.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SignResultNotifyWithCallback(request *SignResultNotifyRequest, callback func(response *SignResultNotifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SignResultNotifyResponse
		var err error
		defer close(result)
		response, err = client.SignResultNotify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SignResultNotifyRequest is the request struct for api SignResultNotify
type SignResultNotifyRequest struct {
	*requests.RpcRequest
	DocId         string           `position:"Query" name:"DocId"`
	DocContent    string           `position:"Body" name:"DocContent"`
	Sign          string           `position:"Query" name:"Sign"`
	ResultCode    requests.Integer `position:"Query" name:"ResultCode"`
	Time          requests.Integer `position:"Query" name:"Time"`
	TransactionId string           `position:"Query" name:"TransactionId"`
	ResultDesc    string           `position:"Query" name:"ResultDesc"`
}

// SignResultNotifyResponse is the response struct for api SignResultNotify
type SignResultNotifyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateSignResultNotifyRequest creates a request to invoke SignResultNotify API
func CreateSignResultNotifyRequest() (request *SignResultNotifyRequest) {
	request = &SignResultNotifyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("finmall", "2018-07-23", "SignResultNotify", "finmall", "openAPI")
	return
}

// CreateSignResultNotifyResponse creates a response to parse from SignResultNotify response
func CreateSignResultNotifyResponse() (response *SignResultNotifyResponse) {
	response = &SignResultNotifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
