package finmall

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetProductList invokes the finmall.GetProductList API synchronously
// api document: https://help.aliyun.com/api/finmall/getproductlist.html
func (client *Client) GetProductList(request *GetProductListRequest) (response *GetProductListResponse, err error) {
	response = CreateGetProductListResponse()
	err = client.DoAction(request, response)
	return
}

// GetProductListWithChan invokes the finmall.GetProductList API asynchronously
// api document: https://help.aliyun.com/api/finmall/getproductlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetProductListWithChan(request *GetProductListRequest) (<-chan *GetProductListResponse, <-chan error) {
	responseChan := make(chan *GetProductListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetProductList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetProductListWithCallback invokes the finmall.GetProductList API asynchronously
// api document: https://help.aliyun.com/api/finmall/getproductlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetProductListWithCallback(request *GetProductListRequest, callback func(response *GetProductListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetProductListResponse
		var err error
		defer close(result)
		response, err = client.GetProductList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetProductListRequest is the request struct for api GetProductList
type GetProductListRequest struct {
	*requests.RpcRequest
	CreditId    string `position:"Query" name:"CreditId"`
	FundPartyId string `position:"Query" name:"FundPartyId"`
	UserId      string `position:"Query" name:"UserId"`
}

// GetProductListResponse is the response struct for api GetProductList
type GetProductListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetProductListRequest creates a request to invoke GetProductList API
func CreateGetProductListRequest() (request *GetProductListRequest) {
	request = &GetProductListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("finmall", "2018-07-23", "GetProductList", "finmall", "openAPI")
	return
}

// CreateGetProductListResponse creates a response to parse from GetProductList response
func CreateGetProductListResponse() (response *GetProductListResponse) {
	response = &GetProductListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
