package finmall

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetLoanAgreement invokes the finmall.GetLoanAgreement API synchronously
// api document: https://help.aliyun.com/api/finmall/getloanagreement.html
func (client *Client) GetLoanAgreement(request *GetLoanAgreementRequest) (response *GetLoanAgreementResponse, err error) {
	response = CreateGetLoanAgreementResponse()
	err = client.DoAction(request, response)
	return
}

// GetLoanAgreementWithChan invokes the finmall.GetLoanAgreement API asynchronously
// api document: https://help.aliyun.com/api/finmall/getloanagreement.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetLoanAgreementWithChan(request *GetLoanAgreementRequest) (<-chan *GetLoanAgreementResponse, <-chan error) {
	responseChan := make(chan *GetLoanAgreementResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetLoanAgreement(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetLoanAgreementWithCallback invokes the finmall.GetLoanAgreement API asynchronously
// api document: https://help.aliyun.com/api/finmall/getloanagreement.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetLoanAgreementWithCallback(request *GetLoanAgreementRequest, callback func(response *GetLoanAgreementResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetLoanAgreementResponse
		var err error
		defer close(result)
		response, err = client.GetLoanAgreement(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetLoanAgreementRequest is the request struct for api GetLoanAgreement
type GetLoanAgreementRequest struct {
	*requests.RpcRequest
	CreditId    string `position:"Query" name:"CreditId"`
	FundPartyId string `position:"Query" name:"FundPartyId"`
	ReturnUrl   string `position:"Query" name:"ReturnUrl"`
	UserId      string `position:"Query" name:"UserId"`
}

// GetLoanAgreementResponse is the response struct for api GetLoanAgreement
type GetLoanAgreementResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetLoanAgreementRequest creates a request to invoke GetLoanAgreement API
func CreateGetLoanAgreementRequest() (request *GetLoanAgreementRequest) {
	request = &GetLoanAgreementRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("finmall", "2018-07-23", "GetLoanAgreement", "finmall", "openAPI")
	return
}

// CreateGetLoanAgreementResponse creates a response to parse from GetLoanAgreement response
func CreateGetLoanAgreementResponse() (response *GetLoanAgreementResponse) {
	response = &GetLoanAgreementResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
