package finmall

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddTrialRecord invokes the finmall.AddTrialRecord API synchronously
// api document: https://help.aliyun.com/api/finmall/addtrialrecord.html
func (client *Client) AddTrialRecord(request *AddTrialRecordRequest) (response *AddTrialRecordResponse, err error) {
	response = CreateAddTrialRecordResponse()
	err = client.DoAction(request, response)
	return
}

// AddTrialRecordWithChan invokes the finmall.AddTrialRecord API asynchronously
// api document: https://help.aliyun.com/api/finmall/addtrialrecord.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddTrialRecordWithChan(request *AddTrialRecordRequest) (<-chan *AddTrialRecordResponse, <-chan error) {
	responseChan := make(chan *AddTrialRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddTrialRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddTrialRecordWithCallback invokes the finmall.AddTrialRecord API asynchronously
// api document: https://help.aliyun.com/api/finmall/addtrialrecord.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddTrialRecordWithCallback(request *AddTrialRecordRequest, callback func(response *AddTrialRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddTrialRecordResponse
		var err error
		defer close(result)
		response, err = client.AddTrialRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddTrialRecordRequest is the request struct for api AddTrialRecord
type AddTrialRecordRequest struct {
	*requests.RpcRequest
	Note                string `position:"Query" name:"Note"`
	EnterpriseEmail     string `position:"Query" name:"EnterpriseEmail"`
	ContractPhoneNumber string `position:"Query" name:"ContractPhoneNumber"`
	ContractName        string `position:"Query" name:"ContractName"`
	Channel             string `position:"Query" name:"Channel"`
	EnterpriseName      string `position:"Query" name:"EnterpriseName"`
	UserId              string `position:"Query" name:"UserId"`
	Products            string `position:"Query" name:"Products"`
	Budget              string `position:"Query" name:"Budget"`
}

// AddTrialRecordResponse is the response struct for api AddTrialRecord
type AddTrialRecordResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateAddTrialRecordRequest creates a request to invoke AddTrialRecord API
func CreateAddTrialRecordRequest() (request *AddTrialRecordRequest) {
	request = &AddTrialRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("finmall", "2018-07-23", "AddTrialRecord", "finmall", "openAPI")
	return
}

// CreateAddTrialRecordResponse creates a response to parse from AddTrialRecord response
func CreateAddTrialRecordResponse() (response *AddTrialRecordResponse) {
	response = &AddTrialRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
