package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScalingActivity invokes the emr.DescribeScalingActivity API synchronously
// api document: https://help.aliyun.com/api/emr/describescalingactivity.html
func (client *Client) DescribeScalingActivity(request *DescribeScalingActivityRequest) (response *DescribeScalingActivityResponse, err error) {
	response = CreateDescribeScalingActivityResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScalingActivityWithChan invokes the emr.DescribeScalingActivity API asynchronously
// api document: https://help.aliyun.com/api/emr/describescalingactivity.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScalingActivityWithChan(request *DescribeScalingActivityRequest) (<-chan *DescribeScalingActivityResponse, <-chan error) {
	responseChan := make(chan *DescribeScalingActivityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScalingActivity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScalingActivityWithCallback invokes the emr.DescribeScalingActivity API asynchronously
// api document: https://help.aliyun.com/api/emr/describescalingactivity.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScalingActivityWithCallback(request *DescribeScalingActivityRequest, callback func(response *DescribeScalingActivityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScalingActivityResponse
		var err error
		defer close(result)
		response, err = client.DescribeScalingActivity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScalingActivityRequest is the request struct for api DescribeScalingActivity
type DescribeScalingActivityRequest struct {
	*requests.RpcRequest
	ResourceOwnerId   requests.Integer `position:"Query" name:"ResourceOwnerId"`
	HostGroupId       string           `position:"Query" name:"HostGroupId"`
	ClusterId         string           `position:"Query" name:"ClusterId"`
	ScalingActivityId string           `position:"Query" name:"ScalingActivityId"`
}

// DescribeScalingActivityResponse is the response struct for api DescribeScalingActivity
type DescribeScalingActivityResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	BizId         string `json:"BizId" xml:"BizId"`
	StartTime     int    `json:"StartTime" xml:"StartTime"`
	EndTime       int    `json:"EndTime" xml:"EndTime"`
	InstanceIds   string `json:"InstanceIds" xml:"InstanceIds"`
	TotalCapacity int    `json:"TotalCapacity" xml:"TotalCapacity"`
	Cause         string `json:"Cause" xml:"Cause"`
	Description   string `json:"Description" xml:"Description"`
	Status        string `json:"Status" xml:"Status"`
	Transition    string `json:"Transition" xml:"Transition"`
	ScalingRuleId string `json:"ScalingRuleId" xml:"ScalingRuleId"`
	ExpectNum     int    `json:"ExpectNum" xml:"ExpectNum"`
}

// CreateDescribeScalingActivityRequest creates a request to invoke DescribeScalingActivity API
func CreateDescribeScalingActivityRequest() (request *DescribeScalingActivityRequest) {
	request = &DescribeScalingActivityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeScalingActivity", "emr", "openAPI")
	return
}

// CreateDescribeScalingActivityResponse creates a response to parse from DescribeScalingActivity response
func CreateDescribeScalingActivityResponse() (response *DescribeScalingActivityResponse) {
	response = &DescribeScalingActivityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
