package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InvokeShellCommand invokes the ehpc.InvokeShellCommand API synchronously
// api document: https://help.aliyun.com/api/ehpc/invokeshellcommand.html
func (client *Client) InvokeShellCommand(request *InvokeShellCommandRequest) (response *InvokeShellCommandResponse, err error) {
	response = CreateInvokeShellCommandResponse()
	err = client.DoAction(request, response)
	return
}

// InvokeShellCommandWithChan invokes the ehpc.InvokeShellCommand API asynchronously
// api document: https://help.aliyun.com/api/ehpc/invokeshellcommand.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) InvokeShellCommandWithChan(request *InvokeShellCommandRequest) (<-chan *InvokeShellCommandResponse, <-chan error) {
	responseChan := make(chan *InvokeShellCommandResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InvokeShellCommand(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InvokeShellCommandWithCallback invokes the ehpc.InvokeShellCommand API asynchronously
// api document: https://help.aliyun.com/api/ehpc/invokeshellcommand.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) InvokeShellCommandWithCallback(request *InvokeShellCommandRequest, callback func(response *InvokeShellCommandResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InvokeShellCommandResponse
		var err error
		defer close(result)
		response, err = client.InvokeShellCommand(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InvokeShellCommandRequest is the request struct for api InvokeShellCommand
type InvokeShellCommandRequest struct {
	*requests.RpcRequest
	Instance   *[]InvokeShellCommandInstance `position:"Query" name:"Instance"  type:"Repeated"`
	WorkingDir string                        `position:"Query" name:"WorkingDir"`
	ClusterId  string                        `position:"Query" name:"ClusterId"`
	Command    string                        `position:"Query" name:"Command"`
	Timeout    requests.Integer              `position:"Query" name:"Timeout"`
}

// InvokeShellCommandInstance is a repeated param struct in InvokeShellCommandRequest
type InvokeShellCommandInstance struct {
	Id string `name:"Id"`
}

// InvokeShellCommandResponse is the response struct for api InvokeShellCommand
type InvokeShellCommandResponse struct {
	*responses.BaseResponse
	RequestId   string                          `json:"RequestId" xml:"RequestId"`
	CommandId   string                          `json:"CommandId" xml:"CommandId"`
	InstanceIds InstanceIdsInInvokeShellCommand `json:"InstanceIds" xml:"InstanceIds"`
}

// CreateInvokeShellCommandRequest creates a request to invoke InvokeShellCommand API
func CreateInvokeShellCommandRequest() (request *InvokeShellCommandRequest) {
	request = &InvokeShellCommandRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "InvokeShellCommand", "ehs", "openAPI")
	return
}

// CreateInvokeShellCommandResponse creates a response to parse from InvokeShellCommand response
func CreateInvokeShellCommandResponse() (response *InvokeShellCommandResponse) {
	response = &InvokeShellCommandResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
