package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCloudMetricProfiling invokes the ehpc.GetCloudMetricProfiling API synchronously
// api document: https://help.aliyun.com/api/ehpc/getcloudmetricprofiling.html
func (client *Client) GetCloudMetricProfiling(request *GetCloudMetricProfilingRequest) (response *GetCloudMetricProfilingResponse, err error) {
	response = CreateGetCloudMetricProfilingResponse()
	err = client.DoAction(request, response)
	return
}

// GetCloudMetricProfilingWithChan invokes the ehpc.GetCloudMetricProfiling API asynchronously
// api document: https://help.aliyun.com/api/ehpc/getcloudmetricprofiling.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetCloudMetricProfilingWithChan(request *GetCloudMetricProfilingRequest) (<-chan *GetCloudMetricProfilingResponse, <-chan error) {
	responseChan := make(chan *GetCloudMetricProfilingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCloudMetricProfiling(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCloudMetricProfilingWithCallback invokes the ehpc.GetCloudMetricProfiling API asynchronously
// api document: https://help.aliyun.com/api/ehpc/getcloudmetricprofiling.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetCloudMetricProfilingWithCallback(request *GetCloudMetricProfilingRequest, callback func(response *GetCloudMetricProfilingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCloudMetricProfilingResponse
		var err error
		defer close(result)
		response, err = client.GetCloudMetricProfiling(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCloudMetricProfilingRequest is the request struct for api GetCloudMetricProfiling
type GetCloudMetricProfilingRequest struct {
	*requests.RpcRequest
	ProfilingId string `position:"Query" name:"ProfilingId"`
	ClusterId   string `position:"Query" name:"ClusterId"`
}

// GetCloudMetricProfilingResponse is the response struct for api GetCloudMetricProfiling
type GetCloudMetricProfilingResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	SvgUrls   SvgUrls `json:"SvgUrls" xml:"SvgUrls"`
}

// CreateGetCloudMetricProfilingRequest creates a request to invoke GetCloudMetricProfiling API
func CreateGetCloudMetricProfilingRequest() (request *GetCloudMetricProfilingRequest) {
	request = &GetCloudMetricProfilingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "GetCloudMetricProfiling", "ehs", "openAPI")
	return
}

// CreateGetCloudMetricProfilingResponse creates a response to parse from GetCloudMetricProfiling response
func CreateGetCloudMetricProfilingResponse() (response *GetCloudMetricProfilingResponse) {
	response = &GetCloudMetricProfilingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
