package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSnapshotMonitorData invokes the ecs.DescribeSnapshotMonitorData API synchronously
// api document: https://help.aliyun.com/api/ecs/describesnapshotmonitordata.html
func (client *Client) DescribeSnapshotMonitorData(request *DescribeSnapshotMonitorDataRequest) (response *DescribeSnapshotMonitorDataResponse, err error) {
	response = CreateDescribeSnapshotMonitorDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSnapshotMonitorDataWithChan invokes the ecs.DescribeSnapshotMonitorData API asynchronously
// api document: https://help.aliyun.com/api/ecs/describesnapshotmonitordata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSnapshotMonitorDataWithChan(request *DescribeSnapshotMonitorDataRequest) (<-chan *DescribeSnapshotMonitorDataResponse, <-chan error) {
	responseChan := make(chan *DescribeSnapshotMonitorDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSnapshotMonitorData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSnapshotMonitorDataWithCallback invokes the ecs.DescribeSnapshotMonitorData API asynchronously
// api document: https://help.aliyun.com/api/ecs/describesnapshotmonitordata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSnapshotMonitorDataWithCallback(request *DescribeSnapshotMonitorDataRequest, callback func(response *DescribeSnapshotMonitorDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSnapshotMonitorDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeSnapshotMonitorData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSnapshotMonitorDataRequest is the request struct for api DescribeSnapshotMonitorData
type DescribeSnapshotMonitorDataRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Period               requests.Integer `position:"Query" name:"Period"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	EndTime              string           `position:"Query" name:"EndTime"`
	StartTime            string           `position:"Query" name:"StartTime"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeSnapshotMonitorDataResponse is the response struct for api DescribeSnapshotMonitorData
type DescribeSnapshotMonitorDataResponse struct {
	*responses.BaseResponse
	RequestId   string                                   `json:"RequestId" xml:"RequestId"`
	MonitorData MonitorDataInDescribeSnapshotMonitorData `json:"MonitorData" xml:"MonitorData"`
}

// CreateDescribeSnapshotMonitorDataRequest creates a request to invoke DescribeSnapshotMonitorData API
func CreateDescribeSnapshotMonitorDataRequest() (request *DescribeSnapshotMonitorDataRequest) {
	request = &DescribeSnapshotMonitorDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DescribeSnapshotMonitorData", "ecs", "openAPI")
	return
}

// CreateDescribeSnapshotMonitorDataResponse creates a response to parse from DescribeSnapshotMonitorData response
func CreateDescribeSnapshotMonitorDataResponse() (response *DescribeSnapshotMonitorDataResponse) {
	response = &DescribeSnapshotMonitorDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
