//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package dts

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSubscriptionObjectModifyStatus invokes the dts.DescribeSubscriptionObjectModifyStatus API synchronously
// api document: https://help.aliyun.com/api/dts/describesubscriptionobjectmodifystatus.html
func (client *Client) DescribeSubscriptionObjectModifyStatus(request *DescribeSubscriptionObjectModifyStatusRequest) (response *DescribeSubscriptionObjectModifyStatusResponse, err error) {
	response = CreateDescribeSubscriptionObjectModifyStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSubscriptionObjectModifyStatusWithChan invokes the dts.DescribeSubscriptionObjectModifyStatus API asynchronously
// api document: https://help.aliyun.com/api/dts/describesubscriptionobjectmodifystatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSubscriptionObjectModifyStatusWithChan(request *DescribeSubscriptionObjectModifyStatusRequest) (<-chan *DescribeSubscriptionObjectModifyStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeSubscriptionObjectModifyStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSubscriptionObjectModifyStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSubscriptionObjectModifyStatusWithCallback invokes the dts.DescribeSubscriptionObjectModifyStatus API asynchronously
// api document: https://help.aliyun.com/api/dts/describesubscriptionobjectmodifystatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSubscriptionObjectModifyStatusWithCallback(request *DescribeSubscriptionObjectModifyStatusRequest, callback func(response *DescribeSubscriptionObjectModifyStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSubscriptionObjectModifyStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeSubscriptionObjectModifyStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSubscriptionObjectModifyStatusRequest is the request struct for api DescribeSubscriptionObjectModifyStatus
type DescribeSubscriptionObjectModifyStatusRequest struct {
	*requests.RpcRequest
	SubscriptionInstanceId string `position:"Query" name:"SubscriptionInstanceId"`
	ClientToken            string `position:"Query" name:"ClientToken"`
	OwnerId                string `position:"Query" name:"OwnerId"`
}

// DescribeSubscriptionObjectModifyStatusResponse is the response struct for api DescribeSubscriptionObjectModifyStatus
type DescribeSubscriptionObjectModifyStatusResponse struct {
	*responses.BaseResponse
	RequestId string                                        `json:"RequestId" xml:"RequestId"`
	Status    string                                        `json:"Status" xml:"Status"`
	Percent   string                                        `json:"Percent" xml:"Percent"`
	Detail    DescribeSubscriptionObjectModifyStatusDetail0 `json:"Detail" xml:"Detail"`
}

type DescribeSubscriptionObjectModifyStatusDetail0 struct {
	CheckItem []DescribeSubscriptionObjectModifyStatusCheckItem1 `json:"CheckItem" xml:"CheckItem"`
}

type DescribeSubscriptionObjectModifyStatusCheckItem1 struct {
	ItemName     string `json:"ItemName" xml:"ItemName"`
	CheckStatus  string `json:"CheckStatus" xml:"CheckStatus"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RepairMethod string `json:"RepairMethod" xml:"RepairMethod"`
}

// CreateDescribeSubscriptionObjectModifyStatusRequest creates a request to invoke DescribeSubscriptionObjectModifyStatus API
func CreateDescribeSubscriptionObjectModifyStatusRequest() (request *DescribeSubscriptionObjectModifyStatusRequest) {
	request = &DescribeSubscriptionObjectModifyStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2018-08-01", "DescribeSubscriptionObjectModifyStatus", "dts", "openAPI")
	return
}

// CreateDescribeSubscriptionObjectModifyStatusResponse creates a response to parse from DescribeSubscriptionObjectModifyStatus response
func CreateDescribeSubscriptionObjectModifyStatusResponse() (response *DescribeSubscriptionObjectModifyStatusResponse) {
	response = &DescribeSubscriptionObjectModifyStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
