package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryInstanceInfoByConn invokes the drds.QueryInstanceInfoByConn API synchronously
// api document: https://help.aliyun.com/api/drds/queryinstanceinfobyconn.html
func (client *Client) QueryInstanceInfoByConn(request *QueryInstanceInfoByConnRequest) (response *QueryInstanceInfoByConnResponse, err error) {
	response = CreateQueryInstanceInfoByConnResponse()
	err = client.DoAction(request, response)
	return
}

// QueryInstanceInfoByConnWithChan invokes the drds.QueryInstanceInfoByConn API asynchronously
// api document: https://help.aliyun.com/api/drds/queryinstanceinfobyconn.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryInstanceInfoByConnWithChan(request *QueryInstanceInfoByConnRequest) (<-chan *QueryInstanceInfoByConnResponse, <-chan error) {
	responseChan := make(chan *QueryInstanceInfoByConnResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryInstanceInfoByConn(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryInstanceInfoByConnWithCallback invokes the drds.QueryInstanceInfoByConn API asynchronously
// api document: https://help.aliyun.com/api/drds/queryinstanceinfobyconn.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryInstanceInfoByConnWithCallback(request *QueryInstanceInfoByConnRequest, callback func(response *QueryInstanceInfoByConnResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryInstanceInfoByConnResponse
		var err error
		defer close(result)
		response, err = client.QueryInstanceInfoByConn(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryInstanceInfoByConnRequest is the request struct for api QueryInstanceInfoByConn
type QueryInstanceInfoByConnRequest struct {
	*requests.RpcRequest
	Port     requests.Integer `position:"Query" name:"Port"`
	Host     string           `position:"Query" name:"Host"`
	UserName string           `position:"Query" name:"UserName"`
}

// QueryInstanceInfoByConnResponse is the response struct for api QueryInstanceInfoByConn
type QueryInstanceInfoByConnResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQueryInstanceInfoByConnRequest creates a request to invoke QueryInstanceInfoByConn API
func CreateQueryInstanceInfoByConnRequest() (request *QueryInstanceInfoByConnRequest) {
	request = &QueryInstanceInfoByConnRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2017-10-16", "QueryInstanceInfoByConn", "", "")
	return
}

// CreateQueryInstanceInfoByConnResponse creates a response to parse from QueryInstanceInfoByConn response
func CreateQueryInstanceInfoByConnResponse() (response *QueryInstanceInfoByConnResponse) {
	response = &QueryInstanceInfoByConnResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
