package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDrdsAccount invokes the drds.CreateDrdsAccount API synchronously
// api document: https://help.aliyun.com/api/drds/createdrdsaccount.html
func (client *Client) CreateDrdsAccount(request *CreateDrdsAccountRequest) (response *CreateDrdsAccountResponse, err error) {
	response = CreateCreateDrdsAccountResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDrdsAccountWithChan invokes the drds.CreateDrdsAccount API asynchronously
// api document: https://help.aliyun.com/api/drds/createdrdsaccount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateDrdsAccountWithChan(request *CreateDrdsAccountRequest) (<-chan *CreateDrdsAccountResponse, <-chan error) {
	responseChan := make(chan *CreateDrdsAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDrdsAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDrdsAccountWithCallback invokes the drds.CreateDrdsAccount API asynchronously
// api document: https://help.aliyun.com/api/drds/createdrdsaccount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateDrdsAccountWithCallback(request *CreateDrdsAccountRequest, callback func(response *CreateDrdsAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDrdsAccountResponse
		var err error
		defer close(result)
		response, err = client.CreateDrdsAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDrdsAccountRequest is the request struct for api CreateDrdsAccount
type CreateDrdsAccountRequest struct {
	*requests.RpcRequest
	Password       string `position:"Query" name:"Password"`
	DbName         string `position:"Query" name:"DbName"`
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
	UserName       string `position:"Query" name:"UserName"`
}

// CreateDrdsAccountResponse is the response struct for api CreateDrdsAccount
type CreateDrdsAccountResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateCreateDrdsAccountRequest creates a request to invoke CreateDrdsAccount API
func CreateCreateDrdsAccountRequest() (request *CreateDrdsAccountRequest) {
	request = &CreateDrdsAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2017-10-16", "CreateDrdsAccount", "", "")
	return
}

// CreateCreateDrdsAccountResponse creates a response to parse from CreateDrdsAccount response
func CreateCreateDrdsAccountResponse() (response *CreateDrdsAccountResponse) {
	response = &CreateDrdsAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
