package dm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckReplyToMailAddress invokes the dm.CheckReplyToMailAddress API synchronously
// api document: https://help.aliyun.com/api/dm/checkreplytomailaddress.html
func (client *Client) CheckReplyToMailAddress(request *CheckReplyToMailAddressRequest) (response *CheckReplyToMailAddressResponse, err error) {
	response = CreateCheckReplyToMailAddressResponse()
	err = client.DoAction(request, response)
	return
}

// CheckReplyToMailAddressWithChan invokes the dm.CheckReplyToMailAddress API asynchronously
// api document: https://help.aliyun.com/api/dm/checkreplytomailaddress.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckReplyToMailAddressWithChan(request *CheckReplyToMailAddressRequest) (<-chan *CheckReplyToMailAddressResponse, <-chan error) {
	responseChan := make(chan *CheckReplyToMailAddressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckReplyToMailAddress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckReplyToMailAddressWithCallback invokes the dm.CheckReplyToMailAddress API asynchronously
// api document: https://help.aliyun.com/api/dm/checkreplytomailaddress.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckReplyToMailAddressWithCallback(request *CheckReplyToMailAddressRequest, callback func(response *CheckReplyToMailAddressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckReplyToMailAddressResponse
		var err error
		defer close(result)
		response, err = client.CheckReplyToMailAddress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckReplyToMailAddressRequest is the request struct for api CheckReplyToMailAddress
type CheckReplyToMailAddressRequest struct {
	*requests.RpcRequest
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Lang                 string           `position:"Query" name:"Lang"`
	Region               string           `position:"Query" name:"Region"`
	MailAddressId        requests.Integer `position:"Query" name:"MailAddressId"`
}

// CheckReplyToMailAddressResponse is the response struct for api CheckReplyToMailAddress
type CheckReplyToMailAddressResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCheckReplyToMailAddressRequest creates a request to invoke CheckReplyToMailAddress API
func CreateCheckReplyToMailAddressRequest() (request *CheckReplyToMailAddressRequest) {
	request = &CheckReplyToMailAddressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dm", "2015-11-23", "CheckReplyToMailAddress", "", "")
	return
}

// CreateCheckReplyToMailAddressResponse creates a response to parse from CheckReplyToMailAddress response
func CreateCheckReplyToMailAddressResponse() (response *CheckReplyToMailAddressResponse) {
	response = &CheckReplyToMailAddressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
