package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClusterEndpoints invokes the cs.DescribeClusterEndpoints API synchronously
// api document: https://help.aliyun.com/api/cs/describeclusterendpoints.html
func (client *Client) DescribeClusterEndpoints(request *DescribeClusterEndpointsRequest) (response *DescribeClusterEndpointsResponse, err error) {
	response = CreateDescribeClusterEndpointsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeClusterEndpointsWithChan invokes the cs.DescribeClusterEndpoints API asynchronously
// api document: https://help.aliyun.com/api/cs/describeclusterendpoints.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeClusterEndpointsWithChan(request *DescribeClusterEndpointsRequest) (<-chan *DescribeClusterEndpointsResponse, <-chan error) {
	responseChan := make(chan *DescribeClusterEndpointsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClusterEndpoints(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClusterEndpointsWithCallback invokes the cs.DescribeClusterEndpoints API asynchronously
// api document: https://help.aliyun.com/api/cs/describeclusterendpoints.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeClusterEndpointsWithCallback(request *DescribeClusterEndpointsRequest, callback func(response *DescribeClusterEndpointsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClusterEndpointsResponse
		var err error
		defer close(result)
		response, err = client.DescribeClusterEndpoints(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClusterEndpointsRequest is the request struct for api DescribeClusterEndpoints
type DescribeClusterEndpointsRequest struct {
	*requests.RoaRequest
	ClusterId string `position:"Path" name:"ClusterId"`
}

// DescribeClusterEndpointsResponse is the response struct for api DescribeClusterEndpoints
type DescribeClusterEndpointsResponse struct {
	*responses.BaseResponse
}

// CreateDescribeClusterEndpointsRequest creates a request to invoke DescribeClusterEndpoints API
func CreateDescribeClusterEndpointsRequest() (request *DescribeClusterEndpointsRequest) {
	request = &DescribeClusterEndpointsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "DescribeClusterEndpoints", "/clusters/[ClusterId]/endpoints", "cs", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeClusterEndpointsResponse creates a response to parse from DescribeClusterEndpoints response
func CreateDescribeClusterEndpointsResponse() (response *DescribeClusterEndpointsResponse) {
	response = &DescribeClusterEndpointsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
